import os
from typing import List, Tuple, Dict, Optional

from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QHeaderView
from qgis.PyQt import uic

from landsklim.lk.regressor_factory import RegressorDefinition
from landsklim.lk.utils import LandsklimUtils
from landsklim.lk.regressor import Regressor
from landsklim.ui.utils import LandsklimTableModelRegressors, LandsklimTableColumnType
from landsklim.ui.landsklim_dialog import LandsklimDialog


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'view_regressors.ui'))


class ViewRegressors(LandsklimDialog, FORM_CLASS):
    """
    Represents the regressors dialog
    """
    def __init__(self, regressors: List[Regressor], parent=None):
        """Constructor."""
        self.__regressors: List[Regressor] = regressors
        super(ViewRegressors, self).__init__(parent)
        self.setModal(True)

    def init_ui(self):
        """
        Init UI components
        """
        dem_shape = LandsklimUtils.raster_to_array(self._instance.get_landsklim_project().get_dem().qgis_layer()).shape
        max_window_allowed = int(min(dem_shape)/2)
        table_model: LandsklimTableModelRegressors = LandsklimTableModelRegressors(data=self.regressors_to_regressor_definitions(self.__regressors), max_window_size=max_window_allowed)
        self.table_variables.setModel(table_model)
        self.table_variables.horizontalHeader().setSectionResizeMode(0, QHeaderView.ResizeToContents)


    def get_explicatives_variables(self) -> List[RegressorDefinition]:
        return self.table_variables.model().get_explicative_variables()

    def input_are_valid(self) -> Tuple[bool, List[str]]:
        """
        Check if user inputs are valid
        """
        errors = []
        is_ok = True
        return is_ok, errors