import os
import subprocess
import platform
import sys

from typing import List

from qgis.gui import QgsMessageBarItem
from qgis.core import QgsMessageLog, Qgis, QgsProject, QgsExpressionContextUtils, QgsRasterLayer, QgsVectorLayer, \
    QgsLayerTree, QgsLayerTreeLayer, QgsLayerTreeGroup, QgsApplication


class LandsklimDependencyLoader:

    @staticmethod
    def _load_dependency(dependency_name: str, dependency_module_name: str, dependency_versions: List[str]) -> bool:
        import importlib
        succeeded = False
        try:
            module = importlib.import_module(dependency_module_name)
            QgsMessageLog.logMessage("{0} successfully imported ({1})".format(dependency_module_name, module), level=Qgis.Info)
            succeeded = True
        except ModuleNotFoundError:
            import pip._internal as pip
            import site

            # TODO: Check possible conflict if other plugins uses an other version of scikit-learn
            QgsMessageLog.logMessage("{0} not found. Installing {0}".format(dependency_name), level=Qgis.Info)
            python_version = platform.python_version_tuple()
            module_version = dependency_versions[0] if python_version[0] == '3' and python_version[1] == '7' else dependency_versions[1]
            shell = True if os.name == 'posix' else False

            # print(subprocess.run(["python3", '-m', 'ensurepip'], check=True))
            print(subprocess.run(
                [sys.executable, '-m', 'pip', 'install', '--user', "{0}=={1}".format(dependency_name, module_version)],
                check=True))
            print(subprocess.run([sys.executable, '-m', 'pip', 'show', dependency_name], check=True))

            # If the module is the first package installed, site-package directory was not imported at startup, so add it to path
            user_site = site.getusersitepackages()
            if user_site not in sys.path:
                sys.path.append(user_site)

            try:
                module = importlib.import_module(dependency_module_name)
                QgsMessageLog.logMessage("{0} successfully installed".format(dependency_module_name), level=Qgis.Info)
                succeeded = True
            except ModuleNotFoundError:
                QgsMessageLog.logMessage("{0} installation failed".format(dependency_module_name), level=Qgis.Info)  # TODO: Set as error ?
        return succeeded

    @staticmethod
    def load_dependencies():
        print("[load_dependencies]")
        # { "module name to install" : ["module import name", "version for python 3.7", "version for python > 3.7"]
        modules = {"scikit-learn": ["sklearn", "0.19.2", "1.2.2"], "pandas": ["pandas", "1.1.3", "2.0.3"], "pykrige": ["pykrige", "1.7.0", "1.7.1"]}
        for module_name, module_info in modules.items():
            print("[load dependency]", module_name)
            success = LandsklimDependencyLoader._load_dependency(module_name, module_info[0], module_info[1:])
            print("[success]", success)
        import sklearn
        import pandas as pd
        import pykrige
