from PyQt5.QtGui import QIcon
from qgis.core import QgsProcessingProvider

from landsklim.processing.algorithm_altitude import AltitudeProcessingAlgorithm
from landsklim.processing.algorithm_average_interpolations import AverageInterpolationsProcessingAlgorithm
from landsklim.processing.algorithm_average_rasters_by_groups import AverageRastersByGroupsAlgorithm
from landsklim.processing.algorithm_batch_analysis import BatchLocalAnalysesAlgorithm
from landsklim.processing.algorithm_radiation import RadiationProcessingAlgorithm
from landsklim.processing.algorithm_smoothing import SmoothingProcessingAlgorithm
from landsklim.processing.algorithm_slope import SlopeProcessingAlgorithm
from landsklim.processing.algorithm_orientation import OrientationProcessingAlgorithm
from landsklim.processing.algorithm_sine import SineProcessingAlgorithm
from landsklim.processing.algorithm_cosine import CosineProcessingAlgorithm
from landsklim.processing.algorithm_roughness import RoughnessProcessingAlgorithm
from landsklim.processing.algorithm_encasement import EncasementProcessingAlgorithm
from landsklim.processing.algorithm_rows import RowsProcessingAlgorithm
from landsklim.processing.algorithm_cols import ColsProcessingAlgorithm
from landsklim.processing.algorithm_crest_thalweg import CrestThalwegProcessingAlgorithm
from landsklim.processing.algorithm_ampl import AmplitudeProcessingAlgorithm
from landsklim.processing.algorithm_interpolation import InterpolationRasterProcessingAlgorithm, InterpolationVectorProcessingAlgorithm
from landsklim.processing.algorithm_moran_i import MoranIProcessingAlgorithm
from landsklim.processing.algorithm_kriging import KrigingProcessingAlgorithm
from landsklim.processing.algorithm_polygons import PolygonsProcessingAlgorithm
from landsklim.processing.algorithm_distance import DistanceRasterProcessingAlgorithm, DistanceVectorProcessingAlgorithm
from landsklim.processing.algorithm_influence import InfluenceProcessingAlgorithm


class LandsklimProvider(QgsProcessingProvider):

    def loadAlgorithms(self):
        self.addAlgorithm(SmoothingProcessingAlgorithm())
        self.addAlgorithm(AltitudeProcessingAlgorithm())
        self.addAlgorithm(SlopeProcessingAlgorithm())
        self.addAlgorithm(OrientationProcessingAlgorithm())
        self.addAlgorithm(SineProcessingAlgorithm())
        self.addAlgorithm(CosineProcessingAlgorithm())
        self.addAlgorithm(RoughnessProcessingAlgorithm())
        self.addAlgorithm(RadiationProcessingAlgorithm())
        self.addAlgorithm(EncasementProcessingAlgorithm())
        self.addAlgorithm(CrestThalwegProcessingAlgorithm())
        self.addAlgorithm(AmplitudeProcessingAlgorithm())
        self.addAlgorithm(RowsProcessingAlgorithm())
        self.addAlgorithm(ColsProcessingAlgorithm())
        self.addAlgorithm(InterpolationRasterProcessingAlgorithm())
        self.addAlgorithm(InterpolationVectorProcessingAlgorithm())
        self.addAlgorithm(MoranIProcessingAlgorithm())
        self.addAlgorithm(KrigingProcessingAlgorithm())
        self.addAlgorithm(PolygonsProcessingAlgorithm())
        self.addAlgorithm(DistanceVectorProcessingAlgorithm())
        self.addAlgorithm(DistanceRasterProcessingAlgorithm())
        self.addAlgorithm(InfluenceProcessingAlgorithm())
        self.addAlgorithm(AverageInterpolationsProcessingAlgorithm())
        self.addAlgorithm(AverageRastersByGroupsAlgorithm())
        self.addAlgorithm(BatchLocalAnalysesAlgorithm())

    def id(self) -> str:
        return 'landsklim'

    def name(self) -> str:
        return self.tr('Landsklim')

    def icon(self) -> QIcon:
        return QIcon(':/plugins/landsklim/icon.png')
