from typing import List
import os

from qgis.core import QgsRasterLayer, QgsProject
from qgis import processing

from landsklim.lk.regressor import Regressor
from landsklim.lk.landsklim_constants import LAYER_TYPE_PATH, LandsklimLayerType
from landsklim.lk.regressor_orientation import RegressorOrientation
from landsklim.processing.algorithm_cosine import CosineProcessingAlgorithm


class RegressorCosine(Regressor):

    def __init__(self, windows: int, polynomial_degree: int):
        super().__init__(windows, polynomial_degree, [])

    @staticmethod
    def class_name() -> str:
        return "REGRESSOR_COSINE"

    @staticmethod
    def min_window() -> int:
        return 3

    def prefix(self) -> str:
        return "cosin"

    def name(self) -> str:
        return Regressor.tr("Cosine")

    def compute(self, source_raster: QgsRasterLayer):
        raster_path, exists = self._create_path()

        project_path = self.project_path()

        if not exists:
            from landsklim.lk.regressor_factory import RegressorFactory
            source_orientation = RegressorFactory.get_regressor(RegressorOrientation.class_name(), self.get_windows(), 1).get_path()
            params = {
                'INPUT': source_raster,
                CosineProcessingAlgorithm.INPUT_ORIENTATION: source_orientation,
                'INPUT_WINDOW': self.get_windows(),
                'INPUT_CUSTOM_NO_DATA': None,
                'ADDITIONAL_VARIABLES_FOLDER': os.path.join(project_path, LAYER_TYPE_PATH[LandsklimLayerType.AdditionalLayer]),
                'OUTPUT': raster_path
            }
            processing.run("landsklim:cosine", params)
