from typing import List
import os
import numpy as np

from qgis.core import QgsApplication
from qgis.core import QgsRasterLayer
from qgis.core import QgsProject

from landsklim.lk.regressor import Regressor


class RegressorCols(Regressor):

    @staticmethod
    def class_name() -> str:
        return "REGRESSOR_COLS"

    @staticmethod
    def min_window() -> int:
        return 1

    def __init__(self, windows: int, polynomial_degree: int):
        super().__init__(windows, polynomial_degree)

    def prefix(self) -> str:
        return "cols"

    def name(self) -> str:
        return Regressor.tr("Column")

    def compute(self, source_raster: QgsRasterLayer):
        from qgis import processing

        raster_path, exists = self._create_path()

        if not exists:
            params = {
                'INPUT': source_raster,
                'INPUT_WINDOW': self.get_windows(),
                'INPUT_CUSTOM_NO_DATA': None,
                'OUTPUT': raster_path
            }
            processing.run("landsklim:cols", params)

