# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Landlab Algorithm Provider
                                 A QGIS plugin
 Earth Surface Dynamics modeling algorithms
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-25
        copyright            : (C) 2025 by Lucas Amion
        email                : lamion@dcc.uchile.cl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Lucas Amion'
__date__ = '2025-07-25'
__copyright__ = '(C) 2025 by Lucas Amion'


import os
import sys
import inspect

from qgis.core import QgsApplication, QgsSettings
from .landlab_provider import LandlabProvider


cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
  sys.path.insert(0, cmd_folder)


class LandlabPlugin:

    def __init__(self, iface):
      self.provider = None

    def initProcessing(self):
      """Init Processing provider for QGIS >= 3.8."""
      self.provider = LandlabProvider()
      QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
      # Change settings to add the plugin to toolbar
      settings = QgsSettings()
      
      setting = "Processing/Configuration/BUTTON_landlab_algorithm_provider:stream_power_eroder"
      if not settings.contains(setting):
        settings.setValue(setting, True)

      setting = "Processing/Configuration/MENU_landlab_algorithm_provider:stream_power_eroder"
      if not settings.contains(setting):
        settings.setValue(setting, "&Plugins/Landlab Algorithm Provider")

      setting = "Processing/Configuration/BUTTON_landlab_algorithm_provider:sink_filler"
      if not settings.contains(setting):
        settings.setValue(setting, True)

      setting = "Processing/Configuration/MENU_landlab_algorithm_provider:sink_filler"
      if not settings.contains(setting):
        settings.setValue(setting, "&Plugins/Landlab Algorithm Provider")

      self.initProcessing()

    def unload(self):
      QgsApplication.processingRegistry().removeProvider(self.provider)
