# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LandFill_Site_Selection
                                 A QGIS plugin
 LANDFILL SITE SELECTION
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-02-28
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Emre
        email                : Emre
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# import * ifadesi tüm modüllere ve sınıflara erişimi sağlar

import os,sys,time
import os.path
import ogr,gdal

from qgis.PyQt import uic,QtGui,QtWidgets,QtCore
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,QVariant,Qt
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtGui import QIcon,QColor
from qgis.PyQt.QtWidgets import *   
from qgis.PyQt.QtWidgets import (QAction, QFileDialog,QTabWidget,QProgressBar,
                                 QMessageBox,QDialog,QSpinBox, QApplication, QLabel,
                                 QMainWindow, QWidget, QTabBar,QTableWidget,QTableWidgetItem)


from qgis import processing
from qgis.utils import iface
from qgis.core import *             
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingException,
                       QgsProcessingOutputNumber,
                       QgsProcessingParameterDistance,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterVectorDestination,
                       QgsProcessingParameterRasterDestination)

from qgis.core import (
    QgsRasterLayer,
    QgsProject,
    QgsPointXY,
    QgsRaster,
    QgsRasterShader,
    QgsColorRampShader,
    QgsSingleBandPseudoColorRenderer,
    QgsSingleBandColorDataRenderer,
    QgsSingleBandGrayRenderer,
)

# import * ifadesi kütüphane içindeki tüm modüllere ve sınıflara erişimi sağlar
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .LandFill_Site_Selection_dialog import LandFill_Site_SelectionDialog
import os.path
import ogr,gdal

class LandFill_Site_Selection:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LandFill_Site_Selection_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&LANDFILL SITE SELECTION')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.shapefilePath = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('LandFill_Site_Selection', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/LandFill_Site_Selection/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&LANDFILL SITE SELECTION'),
                action)
            self.iface.removeToolBarIcon(action)
    #=======================================================================================================================
    #==========================================INTRODUCTION=================================================================
    #========================================================================================================================            
    def open_folder():

        Reclassify = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'Reclassify')
        BufferFile = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'Buffer')
        MergeDifference = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'MergeDifference')
        RasterizeProximity = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'RasterizeProximity')
        RasterizeProximity_Masked = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'RasterizeProximity_Masked')
        LandFill_Site_Selection = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection')
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop')
        
        for file in os.scandir(desktop):
            if file.name == "LandFill_Site_Selection":
                break
        if file.name != "LandFill_Site_Selection":
            os.mkdir(LandFill_Site_Selection)

        if os.sep=="\\":
            LandFill_Site_Selection=LandFill_Site_Selection.replace("\\","/")
            desktop=desktop.replace("\\","/")

        for file in os.scandir(LandFill_Site_Selection):
            if file.name == "Buffer":
                break
        if file.name != "Buffer":
            os.mkdir(BufferFile)

        if os.sep=="\\":
            BufferFile=BufferFile.replace("\\","/")
            LandFill_Site_Selection=LandFill_Site_Selection.replace("\\","/")

        for file in os.scandir(LandFill_Site_Selection):
            if file.name == "Reclassify":
                break
        if file.name != "Reclassify":
            os.mkdir(Reclassify)

        if os.sep=="\\":
            Reclassify=Reclassify.replace("\\","/")
            LandFill_Site_Selection=LandFill_Site_Selection.replace("\\","/")

        for file in os.scandir(LandFill_Site_Selection):
            if file.name == "RasterizeProximity":
                break
        if file.name != "RasterizeProximity":
            os.mkdir(RasterizeProximity)

        if os.sep=="\\":
            RasterizeProximity=RasterizeProximity.replace("\\","/")
            LandFill_Site_Selection=LandFill_Site_Selection.replace("\\","/")
            
        for file in os.scandir(LandFill_Site_Selection):
            if file.name == "RasterizeProximity_Masked":
                break
        if file.name != "RasterizeProximity_Masked":
            os.mkdir(RasterizeProximity_Masked)

        if os.sep=="\\":
            RasterizeProximity_Masked=RasterizeProximity_Masked.replace("\\","/")
            LandFill_Site_Selection=LandFill_Site_Selection.replace("\\","/")

        for file in os.scandir(LandFill_Site_Selection):
            if file.name == "MergeDifference":
                break
        if file.name != "MergeDifference":
            os.mkdir(MergeDifference)

        if os.sep=="\\":
            MergeDifference=MergeDifference.replace("\\","/")
            LandFill_Site_Selection=LandFill_Site_Selection.replace("\\","/")
    open_folder()
               
    def vector_sec(self):
        shapefilePath, _ = QFileDialog.getOpenFileName(self.dlg,
            "Select a vector file", "", "ESRI Shapefiles(*.shp *.SHP);; GeoJSON(*.GEOJSON *.geojson);; Geography Markup Language(* .GML)")

        if not shapefilePath:
            QMessageBox.critical(self.dlg, "Error", "No vector data selected!")
            return

        self.shapefilePath = shapefilePath
        self.shp = ogr.Open(self.shapefilePath)
        if not self.shp:
            QMessageBox.critical(self.dlg, "Error", "Unable to load the shapefile!")
            return

        self.layer = self.shp.GetLayer(0)
        if not self.layer:
            QMessageBox.critical(self.dlg, "Error", "Unable to load the layer!")
            return

        self.name = self.layer.GetName()
        self.layer.GetName()
        self.layerDef = self.layer.GetLayerDefn()
        
        point_geometry_types = [ogr.wkbPoint, ogr.wkbPoint25D, ogr.wkbMultiPoint, ogr.wkbMultiPoint25D]

        if self.layerDef.GetGeomType() not in point_geometry_types:
            self.vlayer = QgsVectorLayer(self.shapefilePath, self.name, "ogr")
            QgsProject.instance().addMapLayer(self.vlayer)

        else:
            QMessageBox.critical(self.dlg, "Error", "The selected layer should have a non-point geometry!")                
                       
    def raster_sec(self):
        self.rasterfilePath, _ = QFileDialog.getOpenFileName(self.dlg,
            "Select a raster file", "", "TIFF File(*.tiff *.tif);; ADF File(*.adf)")

        if not self.rasterfilePath:
            QMessageBox.critical(self.dlg, "Error", "No raster file selected!")
            return

        self.tif = gdal.Open(self.rasterfilePath)
        self.rname = self.rasterfilePath.split("/")
        self.rname = self.rname[-1]
        self.rname2 = self.rname.split(".")
        self.rname2 = self.rname2[0]

        if self.rname2 != "":
            self.rlayer = QgsRasterLayer(self.rasterfilePath, self.rname2, "gdal")
            QgsProject.instance().addMapLayer(self.rlayer)

        else:
            pass

    def other_sec(self):
        shapefilePath2, _ = QFileDialog.getOpenFileName(self.dlg,
            "Shapefile dosyasını seciniz", "", "ESRI Shapefiles(*.shp *.SHP);; GeoJSON(*.GEOJSON *.geojson);; Geography Markup Language(* .GML)")

        if not shapefilePath2:
            QMessageBox.critical(self.dlg, "Error", "No vector data selected!")
            return

        self.shapefilePath2 = shapefilePath2
        self.shp = ogr.Open(self.shapefilePath2)
        if not self.shp:
            QMessageBox.critical(self.dlg, "Error", "Unable to load the shapefile!")
            return

        self.layer = self.shp.GetLayer(0)
        if not self.layer:
            QMessageBox.critical(self.dlg, "Error", "Unable to load the layer!")
            return

        self.name = self.layer.GetName()
        self.layer.GetName()
        self.layerDef = self.layer.GetLayerDefn()
        
        point_geometry_types = [ogr.wkbPoint, ogr.wkbPoint25D, ogr.wkbMultiPoint, ogr.wkbMultiPoint25D]

        if self.layerDef.GetGeomType() not in point_geometry_types:
            self.olayer = QgsVectorLayer(self.shapefilePath2, self.name, "ogr")
            QgsProject.instance().addMapLayer(self.olayer)

        else:
            QMessageBox.critical(self.dlg, "Error", "The selected layer should have a non-point geometry!")
                
    #===========================================================================================================================        
    def Buffer_control(self):
        # Önce veri seçip seçmediğinizi kontrol edin
        if self.shapefilePath:
            # Veri seçildi, Buffer işlemine devam edin
            self.Buffer()
        else:
            # Veri seçilmedi, kullanıcıyı uyarın
            QMessageBox.warning(self.dlg, "Warning", "Please select data before running the Buffer operation.")

    def Buffer(self):
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'Buffer',self.buffer_isim)
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("native:buffer", {'INPUT':self.shapefilePath,'DISTANCE':self.buffer_distance,'SEGMENTS':5,\
                                         'END_CAP_STYLE':0,'JOIN_STYLE':0,'MITER_LIMIT':2,'DISSOLVE':False,'OUTPUT':desktop})
        
    def Buffer_distance1(self):
        self.buffer_distance=self.dlg.doubleSpinBox_2.value()
    def Buffer_distance2(self):
        self.buffer_distance=self.dlg.doubleSpinBox_3.value()
    def Buffer_distance3(self):
        self.buffer_distance=self.dlg.doubleSpinBox_4.value()
    def Buffer_distance4(self):
        self.buffer_distance=self.dlg.doubleSpinBox_5.value()
    def Buffer_distance5(self):
        self.buffer_distance=self.dlg.doubleSpinBox_6.value()
    def Buffer_distance6(self):
        self.buffer_distance=self.dlg.doubleSpinBox_7.value()
    def Buffer_distance7(self):
        self.buffer_distance=self.dlg.doubleSpinBox_8.value()
    def Buffer_distance8(self):
        self.buffer_distance=self.dlg.doubleSpinBox_9.value()
        
    def Buffer_name1(self):
        self.buffer_isim=str("Faults_Buffer.shp")
    def Buffer_name2(self):
        self.buffer_isim=str("Drainages_Buffer.shp")
    def Buffer_name3(self):
        self.buffer_isim=str("Roads_Buffer.shp")
    def Buffer_name4(self):
        self.buffer_isim=str("Airports_Buffer.shp")
    def Buffer_name5(self):
        self.buffer_isim=str("ProtectedArea_Buffer.shp")
    def Buffer_name6(self):
        self.buffer_isim=str("Settlements_Buffer.shp")
    def Buffer_name7(self):
        self.buffer_isim=str("Surface_Water_Buffer.shp")
    def Buffer_name8(self):
        self.buffer_isim=str("Surface_River_Buffer.shp")

    #===========================================================================================================================
    def Merge_control(self):
        # Create a list to check checkBox_1 to checkBox_10
        checkboxes = [self.dlg.checkBox_1, self.dlg.checkBox_2, self.dlg.checkBox_3, self.dlg.checkBox_4, self.dlg.checkBox_5, self.dlg.checkBox_6, self.dlg.checkBox_7, self.dlg.checkBox_8, self.dlg.checkBox_9, self.dlg.checkBox_10]

        # Check if all boxes are selected
        all_checked = all(checkbox.isChecked() for checkbox in checkboxes)

        if all_checked:
            # CheckBoxes selected, continue the process
            self.Merge()
        else:
            # CheckBoxes are not selected, warn the user
            QMessageBox.warning(self.dlg, "Warning", "If you are sure of all data, please check all checkboxes before merging.")
        
    def Merge(self):
        # to avoid getting an error message;
        # OBJECTID field in layer XXX has different data type than in other layers (Integer instead of Real)Execution failed
        
        self.Merge1_2 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge1_2.shp")
        self.Merge3_4 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge3_4.shp") 
        self.Merge5_6 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge5_6.shp")
        self.Merge7_8 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge7_8.shp")
        self.Merge1_2_3_4 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge1_2_3_4.shp")
        self.Merge5_6_7_8 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge5_6_7_8.shp")
        self.Merge    = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Merge.shp")
        
        self.Buffer_1 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Faults_Buffer.shp")
        self.Buffer_2 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Drainages_Buffer.shp")
        self.Buffer_3 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Roads_Buffer.shp")
        self.Buffer_4 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Airports_Buffer.shp")
        self.Buffer_5 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"ProtectedArea_Buffer.shp")
        self.Buffer_6 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Settlements_Buffer.shp")
        self.Buffer_7 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Surface_Water_Buffer.shp")
        self.Buffer_8 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Buffer',"Surface_River_Buffer.shp")
             
        if os.sep=="\\":
            self.Merge1_2=self.Merge1_2.replace("\\","/")
            self.Merge3_4=self.Merge3_4.replace("\\","/")
            self.Merge5_6=self.Merge5_6.replace("\\","/")
            self.Merge7_8=self.Merge7_8.replace("\\","/") 
        else:
            pass

        processing.run("native:union", {'INPUT':self.Buffer_1,'OVERLAY':self.Buffer_2,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge1_2})
        processing.run("native:union", {'INPUT':self.Buffer_3,'OVERLAY':self.Buffer_4,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge3_4})
        processing.run("native:union", {'INPUT':self.Buffer_5,'OVERLAY':self.Buffer_6,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge5_6})
        processing.run("native:union", {'INPUT':self.Buffer_7,'OVERLAY':self.Buffer_8,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge7_8})

        processing.run("native:union", {'INPUT':self.Merge1_2,'OVERLAY':self.Merge3_4,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge1_2_3_4})
        processing.run("native:union", {'INPUT':self.Merge5_6,'OVERLAY':self.Merge7_8,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge5_6_7_8})
             
        processing.run("native:union", {'INPUT':self.Merge1_2_3_4,'OVERLAY':self.Merge5_6_7_8,'OVERLAY_FIELDS_PREFIX':'','OUTPUT':self.Merge})       

        #self.Merge_layer = iface.addVectorLayer(self.Merge, '','ogr' )
        #if not self.Merge_layer:
           #self.dlg.textEdit_2.setText("Layer failed to load!")

    #===========================================================================================================================        
    def Merge2(self):
        pass
        #processing.runAndLoadResults("native:mergevectorlayers", {'LAYERS':['PC','lima'],'CRS':None,'OUTPUT':'TEMPORARY_OUTPUT'})
    #===========================================================================================================================
    def Difference0(self):
        self.Difference0 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference0.shp")
        if os.sep=="\\":
            self.Difference0=self.Difference0.replace("\\","/")
        else:
            pass     
        processing.run("native:difference", {'INPUT':self.shapefilePath,'OVERLAY':self.shapefilePath2,'OUTPUT':self.Difference0})
        
    def Difference1(self):
        self.Difference1 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference1.shp")
        if os.sep=="\\":
            self.Difference1=self.Difference1.replace("\\","/")
        else:
            pass     
        processing.run("native:difference", {'INPUT':self.Difference0,'OVERLAY':self.Buffer_1,'OUTPUT':self.Difference1})
        
    def Difference2(self):
        self.Difference2 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference2.shp")        
        if os.sep=="\\":
            self.Difference2=self.Difference2.replace("\\","/")
        else:
            pass     
        processing.run("native:difference", {'INPUT':self.Difference1,'OVERLAY':self.Buffer_2,'OUTPUT':self.Difference2})
        
    def Difference3(self):
        self.Difference3 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference3.shp")        
        if os.sep=="\\":
            self.Difference3=self.Difference3.replace("\\","/")
        else:
            pass        
        processing.run("native:difference", {'INPUT':self.Difference2,'OVERLAY':self.Buffer_3,'OUTPUT':self.Difference3})
        
    def Difference4(self):
        self.Difference4 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference4.shp")        
        if os.sep=="\\":
            self.Difference4=self.Difference4.replace("\\","/")
        else:
            pass        
        processing.run("native:difference", {'INPUT':self.Difference3,'OVERLAY':self.Buffer_4,'OUTPUT':self.Difference4})

    def Difference5(self):
        self.Difference5 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference5.shp")        
        if os.sep=="\\":
            self.Difference5=self.Difference5.replace("\\","/")
        else:
            pass        
        processing.run("native:difference", {'INPUT':self.Difference4,'OVERLAY':self.Buffer_5,'OUTPUT':self.Difference5})
        
    def Difference6(self):
        self.Difference6 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference6.shp")        
        if os.sep=="\\":
            self.Difference6=self.Difference6.replace("\\","/")
        else:
            pass        
        processing.run("native:difference", {'INPUT':self.Difference5,'OVERLAY':self.Buffer_6,'OUTPUT':self.Difference6})

    def Difference7(self):
        self.Difference7 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','MergeDifference',"Difference7.shp")        
        if os.sep=="\\":
            self.Difference7=self.Difference7.replace("\\","/")
        else:
            pass        
        processing.run("native:difference", {'INPUT':self.Difference6,'OVERLAY':self.Buffer_7,'OUTPUT':self.Difference7})

    def Difference8(self):
        self.Difference = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', "Difference.shp")
        
        if os.sep=="\\":
            self.Difference=self.Difference.replace("\\","/")
        else:
            pass        
        processing.run("native:difference", {'INPUT':self.Difference7,'OVERLAY':self.Buffer_8,'OUTPUT':self.Difference})

        self.Difference_layer = iface.addVectorLayer(self.Difference, '','ogr' )
        if not self.Difference_layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")
        
    def Extent(self):
        extent_layer = iface.activeLayer()
        extent_layer = extent_layer.extent().toString()
        extent_layer = extent_layer.replace(":",",")
        self.bol     = extent_layer.split(",")         
        self.bol_3   = ""

        for i in range(len(self.bol)):
            self.bol[i]=self.bol[i][:-12]
            self.bol_3 += self.bol[i]
            self.bol_3 += ","

        self.dlg.lineEdit_7.setText(str(self.bol[0]))  #x_min
        self.dlg.lineEdit_5.setText(str(self.bol[1]))  #y_min
        self.dlg.lineEdit_6.setText(str(self.bol[2]))  #x_max
        self.dlg.lineEdit_8.setText(str(self.bol[3]))  #y_max

        self.StudyExtent = extent_layer 
    #========================================================================================================================   
    #==========================================EVALUATION CRITERIA===========================================================
    #========================================================================================================================        
    def Raster_statistic(self):
        rLayer=iface.activeLayer()
        stats=rLayer.dataProvider().bandStatistics(1, QgsRasterBandStats.All)
        minimum = stats.minimumValue
        maximum = stats.maximumValue


        fnc = QgsColorRampShader()
        fnc.setColorRampType(QgsColorRampShader.Interpolated)

        rliste = [QgsColorRampShader.ColorRampItem(minimum, QColor(0, 255, 0)),\
                  QgsColorRampShader.ColorRampItem(maximum, QColor(255, 255, 0))]

        fnc.setColorRampItemList(rliste)

        shader = QgsRasterShader()
        shader.setRasterShaderFunction(fnc)

        renderer = QgsSingleBandPseudoColorRenderer(rLayer.dataProvider(), 1, shader)
        rLayer.setRenderer(renderer)

    def toolBox(self,current_index):
        if self.dlg.toolBox.currentIndex() == 1:     
            self.dlg.textEdit_2.setText("Changes the spatial resolution of a raster dataset and aggregates values ​​in new pixel sizes.\
                                         Please make sure to enter the resolution you will use in the project")


    #===========================================================================================================================
    def Resample_WaterLevel(self):
        y_max=self.dlg.lineEdit_8.text()
        y_max=float(y_max)
        y_min=self.dlg.lineEdit_5.text()
        y_min=float(y_min)
        x_max=self.dlg.lineEdit_6.text()
        x_max=float(x_max)        
        x_min=self.dlg.lineEdit_7.text()
        x_min=float(x_min)

        extent=str(x_min)+','+str(x_max)+','+str(y_min)+','+str(y_max)
        pixel_size=self.dlg.doubleSpinBox_1.value()

        self.resample_WaterLevel = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity','WaterLevel.tiff')
        self.masked_WaterLevel = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked','WaterLevel.tiff')
        if os.sep=="\\":
            self.resample_WaterLevel=self.resample_WaterLevel.replace("\\","/")
        else:
             pass

        processing.run("gdal:warpreproject", {'INPUT':self.WaterLevel_girdi_katmanı,'SOURCE_':None,'TARGET_CRS':None,\
                                              'RESAMPLING':0,'NODATA':0,'TARGET_RESOLUTION':pixel_size,'OPTIONS':'','DATA_TYPE':0,\
                                              'TARGET_EXTENT':extent,'TARGET_EXTENT_CRS':None,'MULTITHREADING':False,'EXTRA':'',\
                                              'OUTPUT':self.resample_WaterLevel})
        
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':self.resample_WaterLevel,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.masked_WaterLevel})        
        
        self.WaterLevel_path = os.path.join(QgsProject.instance().homePath(),\
        "WaterLevel",\
        self.masked_dem )

        layer = iface.addRasterLayer(self.WaterLevel_path, 'WaterLevel.tiff','gdal' )
        if not layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")
           
        self.dlg.textEdit_2.setText("This process takes some time")

    def WaterLevel_comboBoxes(self):
        self.dlg.comboBox_4.clear()
        iface.mapCanvas().refreshAllLayers()
        
        self.dlg.comboBox_4.insertItem(0,"Seçiniz")
        for layer in QgsProject.instance().mapLayers().values():
            self.dlg.comboBox_4.addItems([layer.name()])
            self.dlg.comboBox_4.itemText(0)

        self.dlg.comboBox_4.currentIndexChanged['int'].connect(self.comboBox_4)

    def comboBox_4(self,current_index):
        if (current_index!=0):
            WaterLevel_girdi_katmanı=self.dlg.comboBox_4.itemText(current_index)
        self.WaterLevel_girdi_katmanı=WaterLevel_girdi_katmanı
            
    #===========================================================================================================================
    def Resample_DEM(self):
        y_max=self.dlg.lineEdit_8.text()
        y_max=float(y_max)
        y_min=self.dlg.lineEdit_5.text()
        y_min=float(y_min)
        x_max=self.dlg.lineEdit_6.text()
        x_max=float(x_max)        
        x_min=self.dlg.lineEdit_7.text()
        x_min=float(x_min)

        extent=str(x_min)+','+str(x_max)+','+str(y_min)+','+str(y_max)
        pixel_size=self.dlg.doubleSpinBox_1.value()

        self.resample_dem = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity','Elevation.tiff')
        self.masked_dem = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked','Elevation.tiff')
        if os.sep=="\\":
            self.resample_dem=self.resample_dem.replace("\\","/")
        else:
             pass

        processing.run("gdal:warpreproject", {'INPUT':self.AspectandSlope_girdi_katmanı,'SOURCE_':None,'TARGET_CRS':None,\
                                              'RESAMPLING':0,'NODATA':0,'TARGET_RESOLUTION':pixel_size,'OPTIONS':'','DATA_TYPE':0,\
                                              'TARGET_EXTENT':extent,'TARGET_EXTENT_CRS':None,'MULTITHREADING':False,'EXTRA':'',\
                                              'OUTPUT':self.resample_dem})
        
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':self.resample_dem,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.masked_dem})        
        
        self.DEM_path = os.path.join(QgsProject.instance().homePath(),\
        "DEM",\
        self.masked_dem )

        layer = iface.addRasterLayer(self.DEM_path, 'Elevation.tiff','gdal' )
        if not layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")
           
        self.dlg.textEdit_2.setText("This process takes some time")
        
    #===========================================================================================================================
    def Aspect(self):
        output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked','aspect.tiff')
        if os.sep=="\\":
            output=output.replace("\\","/")
        else:
            pass
                
        processing.run("gdal:aspect", {'INPUT':self.masked_dem,'BAND':1,'TRIG_ANGLE':False,\
        'ZERO_FLAT':False,'COMPUTE_EDGES':False,'ZEVENBERGEN':False,'OPTIONS':'','EXTRA':'','OUTPUT':output})

        self.aspect_path = os.path.join(QgsProject.instance().homePath(),\
        "aspected",\
        output)

        layer = iface.addRasterLayer(self.aspect_path, 'aspect.tiff','gdal' )
        if not layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")

        self.AspectandSlope_info = "Aspect and Slope operation has been completed, you can find the files of the operation in the LandFill folder on your desktop."
        self.dlg.textEdit_2.setPlainText(self.AspectandSlope_info)
        
    def Aspect_statistic(self):
        rLayer=iface.activeLayer()
        stats=rLayer.dataProvider().bandStatistics(1, QgsRasterBandStats.All)
        #minimum = stats.minimumValue
        #maximum = stats.maximumValue

        Flat=-1
        North=22.5
        NE=67.5
        East=112.5
        SE=157.5
        South=202.5
        SW=247.5
        West=292.5
        NW=337.5
        North2=360

        fnc = QgsColorRampShader()
        fnc.setColorRampType(QgsColorRampShader.Interpolated)

        rliste = [QgsColorRampShader.ColorRampItem(North, QColor(255, 255, 0), "North         (0-22.5)"),\
                  QgsColorRampShader.ColorRampItem(NE,    QColor(210, 200, 30), "NorthEast  (22.5-67.5)"),\
                  QgsColorRampShader.ColorRampItem(East,  QColor(180, 150, 60), "East            (67.5-112.5)"),\
                  QgsColorRampShader.ColorRampItem(SE,    QColor(150, 100, 90), "SouthEast  (112.5-157.5)"),\
                  QgsColorRampShader.ColorRampItem(South, QColor(120, 50, 120), "South         (157.5-202.5)"),\
                  QgsColorRampShader.ColorRampItem(SW,    QColor(90, 0, 150), "SouthWest (202.5-247.5)"),\
                  QgsColorRampShader.ColorRampItem(West,  QColor(60, 180, 180), "West           (247.5-292.5)"),\
                  QgsColorRampShader.ColorRampItem(NW,    QColor(30, 90, 210), "NorthWest (292.5-337.5)"),\
                  QgsColorRampShader.ColorRampItem(North2,QColor(0, 0, 255), "North          (337.5-360)")]

        fnc.setColorRampItemList(rliste)

        shader = QgsRasterShader()
        shader.setRasterShaderFunction(fnc)

        renderer = QgsSingleBandPseudoColorRenderer(rLayer.dataProvider(), 1, shader)
        rLayer.setRenderer(renderer)

    def AspectandSlope_comboBoxes(self):
        self.dlg.comboBox_3.clear()
        iface.mapCanvas().refreshAllLayers()
        
        self.dlg.comboBox_3.insertItem(0,"Seçiniz")
        for layer in QgsProject.instance().mapLayers().values():
            self.dlg.comboBox_3.addItems([layer.name()])
            self.dlg.comboBox_3.itemText(0)

        self.dlg.comboBox_3.currentIndexChanged['int'].connect(self.comboBox_3)

    def comboBox_3(self,current_index):
        if (current_index!=0):
            AspectandSlope_girdi_katmanı=self.dlg.comboBox_3.itemText(current_index)
        self.AspectandSlope_girdi_katmanı=AspectandSlope_girdi_katmanı

    #===========================================================================================================================
    def Slope(self):        
        output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked','slope.tiff')
        if os.sep=="\\":
            output=output.replace("\\","/")
        else:
            pass
        
        processing.run("gdal:slope", {'INPUT':self.masked_dem,'BAND':1,'SCALE':1,'AS_PERCENT':False,\
        'COMPUTE_EDGES':False,'ZEVENBERGEN':False,'OPTIONS':'','EXTRA':'','OUTPUT':output})

        self.slope_path = os.path.join(QgsProject.instance().homePath(),\
        "sloped",\
        output)

        layer = iface.addRasterLayer(self.slope_path, 'slope.tiff','gdal' )
        if not layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")
           
    #===========================================================================================================================        
    def Land_Use_Rasterize(self):
        y_max=self.dlg.lineEdit_8.text()
        y_max=float(y_max)
        y_min=self.dlg.lineEdit_5.text()
        y_min=float(y_min)
        x_max=self.dlg.lineEdit_6.text()
        x_max=float(x_max)        
        x_min=self.dlg.lineEdit_7.text()
        x_min=float(x_min)

        vertical=self.dlg.doubleSpinBox_1.value()
        horizantal=self.dlg.doubleSpinBox_1.value()

        extent=str(x_min)+','+str(x_max)+','+str(y_min)+','+str(y_max)

        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity','Land_Use.tiff')
        masked = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked','Land_Use.tiff')
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
            masked=masked.replace("\\","/")
        else:
            pass
                        
        field=str(self.field_katmani)
        Input=str(self.shapefilePath)
        
        processing.run("gdal:rasterize", {'INPUT':Input,'FIELD':field,'BURN':0,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,\
        'EXTENT':extent,'NODATA':0,'OPTIONS':'','DATA_TYPE':4,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':desktop})

        processing.run("gdal:cliprasterbymasklayer", {'INPUT':desktop,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':masked})

        self.LandUse_path = os.path.join(QgsProject.instance().homePath(),\
        "Land_Use",\
        masked)

        layer = iface.addRasterLayer(self.LandUse_path, 'Land_Use.tiff','gdal' )
        if not layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")
        
    def Raster_comboBoxes(self):        
        self.dlg.comboBox_7.clear()
        iface.mapCanvas().refreshAllLayers()
        
        self.dlg.comboBox_7.insertItem(0,"Seçiniz")
        for layer in QgsProject.instance().mapLayers().values():
            self.dlg.comboBox_7.addItems([layer.name()])
            self.dlg.comboBox_7.itemText(0)

        for field_name in layer.fields().names():
            self.dlg.comboBox_6.addItems([field_name])

        self.dlg.comboBox_7.currentIndexChanged['int'].connect(self.comboBox_7)
        self.dlg.comboBox_6.currentIndexChanged['int'].connect(self.comboBox_6)

    def comboBox_7(self,current_index):        
        if (current_index!=0):
            rstrgirdi_katmanı=self.dlg.comboBox_7.itemText(current_index)
        self.rstrgirdi_katmanı=rstrgirdi_katmanı

        layer = QgsProject.instance().mapLayersByName(self.rstrgirdi_katmanı)[0]
        iface.setActiveLayer(layer)
        
        self.dlg.comboBox_6.clear()
        layer_att=iface.activeLayer()
        
        for field_name in layer_att.fields().names():
            self.dlg.comboBox_6.addItems([field_name]) 
        
    def comboBox_6(self,current_index):       
        field_katmani=self.dlg.comboBox_6.itemText(current_index)
        self.field_katmani=field_katmani
        self.current_index=current_index

    #===========================================================================================================================        
    def Permeability_Rasterize(self):
        y_max=self.dlg.lineEdit_8.text()
        y_max=float(y_max)
        y_min=self.dlg.lineEdit_5.text()
        y_min=float(y_min)
        x_max=self.dlg.lineEdit_6.text()
        x_max=float(x_max)        
        x_min=self.dlg.lineEdit_7.text()
        x_min=float(x_min)

        vertical=self.dlg.doubleSpinBox_1.value()
        horizantal=self.dlg.doubleSpinBox_1.value()

        extent=str(x_min)+','+str(x_max)+','+str(y_min)+','+str(y_max)

        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity','Permeability.tiff')
        masked = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked','Permeability.tiff')
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
                        
        field=str(self.field_katmani)
        Input=str(self.shapefilePath)
        
        processing.run("gdal:rasterize", {'INPUT':Input,'FIELD':"Permeability_N",'BURN':0,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,\
        'EXTENT':extent,'NODATA':0,'OPTIONS':'','DATA_TYPE':4,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':desktop})

        processing.run("gdal:cliprasterbymasklayer", {'INPUT':desktop,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':masked})
        
        self.Permeability_path = os.path.join(QgsProject.instance().homePath(),\
        "Permeability",\
        masked)

        layer = iface.addRasterLayer(self.Permeability_path, 'Permeability.tiff','gdal' )
        if not layer:
           self.dlg.textEdit_2.setText("Layer failed to load!")
        
    def Permeability_comboBoxes(self):
        self.dlg.comboBox_11.clear()
        iface.mapCanvas().refreshAllLayers()
        
        self.dlg.comboBox_11.insertItem(0,"Seçiniz")
        for layer in QgsProject.instance().mapLayers().values():
            self.dlg.comboBox_11.addItems([layer.name()])
            self.dlg.comboBox_11.itemText(0)

        for field_name in layer.fields().names():
            self.dlg.comboBox_10.addItems([field_name])

        self.dlg.comboBox_11.currentIndexChanged['int'].connect(self.comboBox_11)
        self.dlg.comboBox_10.currentIndexChanged['int'].connect(self.comboBox_10)

    def comboBox_11(self,current_index):        
        if (current_index!=0):
            rstrgirdi_katmanı=self.dlg.comboBox_11.itemText(current_index)
        self.rstrgirdi_katmanı=rstrgirdi_katmanı

        layer = QgsProject.instance().mapLayersByName(self.rstrgirdi_katmanı)[0]
        iface.setActiveLayer(layer)
        
        self.dlg.comboBox_10.clear()
        layer_att=iface.activeLayer()
        
        for field_name in layer_att.fields().names():
            self.dlg.comboBox_10.addItems([field_name]) 
        
    def comboBox_10(self,current_index):        
        field_katmani=self.dlg.comboBox_10.itemText(current_index)
        self.field_katmani=field_katmani
        
        self.current_index2=current_index
        self.dlg.textEdit_2.setText(str(self.current_index2))

    def Add_Permeability_No(self):
        att=[]
        uniq_att=[]
        uniq_att2=[]
        uniq_int=[]
        uniq_int2=[]

        layer=iface.activeLayer()
        features=layer.getFeatures()
        for f in features:
            att.append(f.attributes()[self.current_index2])

        for i in att:
            if i not in uniq_att:
                uniq_att.append(i)

        for i in range(len(uniq_att)):
            uniq_att2.append(uniq_att[i]+str(i))

        for i in att:
            for j in uniq_att2:
                if i==j[0:-1]:
                    uniq_int.append(j[-1])

        for i in uniq_int:
            i=int(i)
            i += 1
            uniq_int2.append(i)
      

        layer_provider=layer.dataProvider()
        layer_provider.addAttributes([QgsField("Permeability_N",QVariant.Int)])
        layer.updateFields()

        features=layer.getFeatures()
        for f in features:
            id=f.id()
            deger=uniq_int2[id]
            deger_index=len(f.attributes())-1
            attr_value={deger_index:deger}
            layer_provider.changeAttributeValues({id:attr_value})
        layer.commitChanges()          
        
    #========================================================================================================================
    #==========================================EVALUATION CRITERIA 2=========================================================
    #========================================================================================================================               
    def FROM_Distance_Rasterize(self):

        y_max=self.dlg.lineEdit_8.text()
        y_max=float(y_max)
        y_min=self.dlg.lineEdit_5.text()
        y_min=float(y_min)
        x_max=self.dlg.lineEdit_6.text()
        x_max=float(x_max)        
        x_min=self.dlg.lineEdit_7.text()
        x_min=float(x_min)        

        vertical=self.dlg.doubleSpinBox_1.value()
        horizantal=self.dlg.doubleSpinBox_1.value()
        
        extent=str(x_min)+','+str(x_max)+','+str(y_min)+','+str(y_max)

        #1
        self.Rasterize_Faults = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Faults.tiff")
        if os.sep=="\\":
            self.Rasterize_Faults=self.Rasterize_Faults.replace("\\","/")
        else:
            pass        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_1,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Faults})
        
        #2
        self.Rasterize_Drainages = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Drainages.tiff")
        if os.sep=="\\":
            self.Rasterize_Drainages=self.Rasterize_Drainages.replace("\\","/")
        else:
            pass        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_2,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Drainages})        

        #3
        self.Rasterize_Roads = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Roads.tiff")
        if os.sep=="\\":
            self.Rasterize_Roads=self.Rasterize_Roads.replace("\\","/")
        else:
            pass        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_3,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Roads})
        
        #4
        self.Rasterize_Airports = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Airports.tiff")
        if os.sep=="\\":
            self.Rasterize_Airports=self.Rasterize_Airports.replace("\\","/")
        else:
            pass
        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_4,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Airports})

        #5
        self.Rasterize_ProtectedArea = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"ProtectedArea.tiff")
        if os.sep=="\\":
            self.Rasterize_ProtectedArea=self.Rasterize_ProtectedArea.replace("\\","/")
        else:
            pass        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_5,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_ProtectedArea})
        
        #6
        self.Rasterize_Settlements = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Settlements.tiff")
        if os.sep=="\\":
            self.Rasterize_Settlements=self.Rasterize_Settlements.replace("\\","/")
        else:
            pass        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_6,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Settlements})
        

        #7
        self.Rasterize_Surface_Water = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Surface_Water.tiff")
        if os.sep=="\\":
            self.Rasterize_Surface_Water=self.Rasterize_Surface_Water.replace("\\","/")
        else:
            pass       
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_7,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Surface_Water})

        #8
        self.Rasterize_Surface_River = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity',"Surface_River.tiff")
        if os.sep=="\\":
            self.Rasterize_Surface_River=self.Rasterize_Surface_River.replace("\\","/")
        else:
            pass        
        processing.run("gdal:rasterize", {'INPUT':self.Buffer_8,\
        'FIELD':'','BURN':1,'UNITS':1,'WIDTH':horizantal,'HEIGHT':vertical,'EXTENT':extent,\
        'NODATA':0,'OPTIONS':'','DATA_TYPE':5,'INIT':None,'INVERT':False,'EXTRA':'','OUTPUT':self.Rasterize_Surface_River})

    #===========================================================================================================================       
    def FROM_Distance_Proximity(self):
        #1
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Faults.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass        
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Faults,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})
        
        #2
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Drainages.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Drainages,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})

        #3
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Roads.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Roads,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})

        #4
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Airports.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Airports,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})

        #5
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_ProtectedArea.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_ProtectedArea,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})

        #6
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Settlements.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Settlements,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})
        
        #7
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Surface_Water.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Surface_Water,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})

        #8
        desktop = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Surface_River.tiff")
        if os.sep=="\\":
            desktop=desktop.replace("\\","/")
        else:
            pass
        processing.run("gdal:proximity", {'INPUT':self.Rasterize_Surface_River,'BAND':1,'VALUES':'',\
        'UNITS':0,'MAX_DISTANCE':None,'REPLACE':None,'NODATA':0,'OPTIONS':'','EXTRA':'','DATA_TYPE':4,'OUTPUT':desktop})
    #===========================================================================================================================       
    def FROM_Distance_Proximity_Masked(self):
        #1
        Input1 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Faults.tiff")
        self.output1 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Faults.tiff")
        if os.sep=="\\":
            Input1=Input1.replace("\\","/")
            self.output1=self.output1.replace("\\","/")
        else:
            pass        
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input1,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output1})
        
        #2
        Input2 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Drainages.tiff")
        self.output2 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Drainages.tiff")
        if os.sep=="\\":
            Input2=Input2.replace("\\","/")
            self.output2=self.output2.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input2,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output2})

        #3
        Input3 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Roads.tiff")
        self.output3 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Roads.tiff")
        if os.sep=="\\":
            Input3=Input3.replace("\\","/")
            self.output3=self.output3.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input3,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output3})
        
        #4
        Input4 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Airports.tiff")
        self.output4 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Airports.tiff")
        if os.sep=="\\":
            Input4=Input4.replace("\\","/")
            self.output4=self.output4.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input4,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output4})

        #5
        Input5 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_ProtectedArea.tiff")
        self.output5 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_ProtectedArea.tiff")        
        if os.sep=="\\":
            Input5=Input5.replace("\\","/")
            self.output5=self.output5.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input5,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output5})
        
        #6
        Input6 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Settlements.tiff")
        self.output6 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Settlements.tiff")
        if os.sep=="\\":
            Input6=Input6.replace("\\","/")
            self.output6=self.output6.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input6,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output6})
                
        #7
        Input7 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Surface_Water.tiff")
        self.output7 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Surface_Water.tiff")
        if os.sep=="\\":
            Input7=Input7.replace("\\","/")
            self.output7=self.output7.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input7,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output7})
        
        #8
        Input8 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity', "Proximity_Surface_River.tiff")
        self.output8 = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Surface_River.tiff")
        if os.sep=="\\":
            Input8=Input8.replace("\\","/")
            self.output8=self.output8.replace("\\","/")
        else:
            pass
        processing.run("gdal:cliprasterbymasklayer", {'INPUT':Input8,'MASK':self.Difference,'SOURCE_CRS':None,\
        'TARGET_CRS':None,'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
        'SET_RESOLUTION':False,'X_RESOLUTION':None,'Y_RESOLUTION':None,'MULTITHREADING':False,'OPTIONS':'',\
        'DATA_TYPE':0,'EXTRA':'','OUTPUT':self.output8})
        
    #===========================================================================================================================     
    #def AddMasked_Layers(self):
        #QgsProject.instance().removeAllMapLayers()
        #iface.addRasterLayer(self.slope_path, 'slope.tiff','gdal' )
        #iface.addRasterLayer(self.aspect_path, 'aspect.tiff','gdal' )
        #iface.addRasterLayer(self.DEM_path, 'Elevation.tiff','gdal' )
        #iface.addRasterLayer(self.Permeability_path, 'Permeability.tiff','gdal' )
        #iface.addRasterLayer(self.LandUse_path, 'Land_Use.tiff','gdal' )
        #iface.addRasterLayer(self.output6, "Proximity_Settlements.tiff",'gdal' )
        #iface.addRasterLayer(self.output5, "Proximity_ProtectedArea.tiff",'gdal' )
        #iface.addRasterLayer(self.output4, "Proximity_Airports.tiff",'gdal' )
        #iface.addRasterLayer(self.output7, "Proximity_Surface_Water.tiff",'gdal' )
        #iface.addRasterLayer(self.output8, "Proximity_Surface_River.tiff",'gdal' )
        #iface.addRasterLayer(self.output3, "Proximity_Roads.tiff",'gdal' )
        #iface.addRasterLayer(self.output2, "Proximity_Drainages.tiff",'gdal' )
        #iface.addRasterLayer(self.output1, "Reclass_Faults.tiff",'gdal' )
        
    #===========================================================================================================================
    def Reclassify_Faults(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Faults.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Faults.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Faults.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Faults.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")
            
    def Reclassify_Drainages(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Drainages.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Drainages.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Drainages.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Drainages.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Roads(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Roads.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Roads.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Roads.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Roads.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Airports(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Airports.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Airports.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Airports.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Airports.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_ProtectedArea(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_ProtectedArea.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_ProtectedArea.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_ProtectedArea.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_ProtectedArea.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Settlements(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Settlements.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Settlements.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Settlements.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Settlements.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Surface_Water(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Surface_Water.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Surface_Water.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Surface_Water.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Surface_Water.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Surface_River(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Proximity_Surface_River.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Surface_River.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Surface_River.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Surface_River.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Land_Use(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Land_Use.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Land_Use.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Land_Use.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Land_Use.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Permeability(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Permeability.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Permeability.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Permeability.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Permeability.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_WaterLevel(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "WaterLevel.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_WaterLevel.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_WaterLevel.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_WaterLevel.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Elevation(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "Elevation.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_Elevation.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_Elevation.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_Elevation.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Aspect(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "aspect.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_aspect.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_aspect.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_aspect.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")

    def Reclassify_Slope(self):
        Input = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','RasterizeProximity_Masked', "slope.tiff")
        Output = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection','Reclassify', "Reclass_slope.tiff")
                
        processing.run("native:reclassifybytable", {'INPUT_RASTER':Input,\
        'RASTER_BAND':1,'TABLE':self.table,'NO_DATA':-1,'RANGE_BOUNDARIES':0,\
        'NODATA_FOR_MISSING':False,'DATA_TYPE':5,'OUTPUT':Output})

        reclassify_path = os.path.join(QgsProject.instance().homePath(),\
        "Reclass_slope.tiff",Output)
                   
        layer = iface.addRasterLayer(reclassify_path, "Reclass_slope.tiff",'gdal' )
        if not layer:
            self.dlg.textEdit_2.setText("Layer failed to load!")
           
    def table_data(self):
        
        # self.dlg.tableWidget.rowCount()                         --> int
        # self.dlg.tableWidget.columnCount()                      --> int

        # deger = self.dlg.tableWidget.item(a,b)                  --> sonucu nesne döndürür bu yüzden .text() ile değeri almak gerekir.
        # deger.text()                                            --> (a,b) bu hücredeki değeri verir.

        # self.dlg.tableWidget.currentRow()                       --> toplam dolu satır sayısını gösteriyor.
        # self.dlg.tableWidget.currentColumn()                    --> toplam dolu sütun sayısını gösteriyor.

        row=0
        column=0
        
        self.table=[]
        self.table_str=""
        deger = self.dlg.tableWidget.item(row,column)       
        
        for i in range((self.dlg.tableWidget.currentRow()+1)*3):
            if row <= self.dlg.tableWidget.currentRow():
                deger = self.dlg.tableWidget.item(row,column)
                self.table.append(deger.text())
                #self.table += deger.text()
                column += 1
            if column == 3:
                row += 1
                column = 0
        
        for i in range(len(self.table)):
            self.table_str += self.table[i]
            self.table_str += ","
            
        self.TABLE=str("[")+self.table_str[:-1]+str("]")

    def add_row(self):
        self.rowCount=self.dlg.tableWidget.rowCount()  
        self.dlg.tableWidget.insertRow(self.rowCount)
    def remove_row(self):
        if self.rowCount > 0:
            self.dlg.tableWidget.removeRow(self.rowCount-1)
    def Refresh(self):
        self.dlg.tableWidget.clearContents()        

        # Extent
        self.extent_layer = QgsProject.instance().mapLayersByName(self.reclassifiedgirdi_katmanı)[0]
        self.extent_layer = self.extent_layer.extent().toString()
        self.extent_layer=self.extent_layer.replace(":",",")
        self.bol=self.extent_layer.split(",")        
        self.bol_8=""

        for i in range(len(self.bol)):
            self.bol[i]=self.bol[i][:-12]
            self.bol_8 += self.bol[i]
            self.bol_8 += ","

        self.dlg.lineEdit_7.setText(str(self.bol[0]))  #x_min
        self.dlg.lineEdit_5.setText(str(self.bol[1]))  #y_min
        self.dlg.lineEdit_6.setText(str(self.bol[2]))  #x_max
        self.dlg.lineEdit_8.setText(str(self.bol[3]))  #y_max
    #===========================================================================================================================
    def Total(self):
        total = int(self.dlg.lineEdit_48.text())+int(self.dlg.lineEdit_49.text())+int(self.dlg.lineEdit_50.text())+\
                int(self.dlg.lineEdit_51.text())+int(self.dlg.lineEdit_52.text())+int(self.dlg.lineEdit_53.text())+\
                int(self.dlg.lineEdit_54.text())+int(self.dlg.lineEdit_55.text())+int(self.dlg.lineEdit_56.text())+\
                int(self.dlg.lineEdit_57.text())+int(self.dlg.lineEdit_58.text())+int(self.dlg.lineEdit_59.text())+\
                int(self.dlg.lineEdit_60.text())+int(self.dlg.lineEdit_61.text())

        total = str(total)
        self.dlg.lineEdit_62.setText(total)
    #===========================================================================================================================
    def Raster_Calculater(self):

        OutputPath = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection')
        ReclassifyPath = os.path.join(os.path.expanduser('~'), 'Desktop', 'LandFill_Site_Selection', 'Reclassify')
        New_path = OutputPath + "/" + 'SumOfWeight.tiff'
        SumOfWeight = OutputPath + "/" + 'SumOfWeight :).tiff'
        
        if os.sep=="\\":
            ReclassifyPath=ReclassifyPath.replace("\\","/")
        else:
            pass

        if os.sep=="\\":
            OutputPath=OutputPath.replace("\\","/")
        else:
            pass
        
        entries = []

        Re1 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Faults.tiff",        're1')
        Re2 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Drainages.tiff",     're2')
        Re3 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Roads.tiff",         're3')
        Re4 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Surface_Water.tiff", 're4')
        Re5 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Surface_River.tiff", 're5')
        Re6 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Airports.tiff",      're6')
        Re7 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_ProtectedArea.tiff", 're7')
        Re8 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Settlements.tiff",   're8')
        Re9 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Land_Use.tiff",      're9')
        Re10 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Permeability.tiff", 're10')
        Re11 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_Elevation.tiff",    're11')
        Re12 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_aspect.tiff",       're12')
        Re13 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_slope.tiff",        're13')
        Re14 = QgsRasterLayer(ReclassifyPath + '/' + "Reclass_slope.tiff",        're14')
        
        re1 = QgsRasterCalculatorEntry()
        re1.ref = 'Re1@1'
        re1.raster = Re1
        re1.bandNumber = 1
        entries.append(re1)

        re2 = QgsRasterCalculatorEntry()
        re2.ref = 'Re2@1'
        re2.raster = Re2
        re2.bandNumber = 1
        entries.append(re2)

        re3 = QgsRasterCalculatorEntry()
        re3.ref = 'Re3@1'
        re3.raster = Re3
        re3.bandNumber = 1
        entries.append(re3)

        re4 = QgsRasterCalculatorEntry()
        re4.ref = 'Re4@1'
        re4.raster = Re4
        re4.bandNumber = 1
        entries.append(re4)

        re5 = QgsRasterCalculatorEntry()
        re5.ref = 'Re5@1'
        re5.raster = Re5
        re5.bandNumber = 1
        entries.append(re5)

        re6 = QgsRasterCalculatorEntry()
        re6.ref = 'Re6@1'
        re6.raster = Re6
        re6.bandNumber = 1
        entries.append(re6)

        re7 = QgsRasterCalculatorEntry()
        re7.ref = 'Re7@1'
        re7.raster = Re7
        re7.bandNumber = 1
        entries.append(re7)

        re8 = QgsRasterCalculatorEntry()
        re8.ref = 'Re8@1'
        re8.raster = Re8
        re8.bandNumber = 1
        entries.append(re8)

        re9 = QgsRasterCalculatorEntry()
        re9.ref = 'Re9@1'
        re9.raster = Re9
        re9.bandNumber = 1
        entries.append(re9)

        re10 = QgsRasterCalculatorEntry()
        re10.ref = 'Re10@1'
        re10.raster = Re10
        re10.bandNumber = 1
        entries.append(re10)

        re11 = QgsRasterCalculatorEntry()
        re11.ref = 'Re11@1'
        re11.raster = Re11
        re11.bandNumber = 1
        entries.append(re11)

        re12 = QgsRasterCalculatorEntry()
        re12.ref = 'Re12@1'
        re12.raster = Re12
        re12.bandNumber = 1
        entries.append(re12)

        re13 = QgsRasterCalculatorEntry()
        re13.ref = 'Re13@1'
        re13.raster = Re13
        re13.bandNumber = 1
        entries.append(re13)

        re14 = QgsRasterCalculatorEntry()
        re14.ref = 'Re14@1'
        re14.raster = Re14
        re14.bandNumber = 1
        entries.append(re14)
        
        #math = '"slope@1" * 2 + ' + '+"DEM@1" * 2'
        #math = 'slope@1'+'*'+'2'

        #math = ('ReDEM@1' + '*' + self.dlg.lineEdit_48.text()) + '+' + ('ReGHI@1' + '*' + self.dlg.lineEdit_49.text()) + '+' + \
        #math = ('ReAspected@1' + '*' + self.dlg.lineEdit_50.text()) + '+' + ('ReSloped@1' + '*' + self.dlg.lineEdit_51.text())

        #('Re5@1' + '*' + self.dlg.lineEdit_52.text()) + '+' + ('Re6@1' + '*' + self.dlg.lineEdit_53.text()) + '+' + \
        #('Re7@1' + '*' + self.dlg.lineEdit_54.text()) + '+' + ('Re8@1' + '*' + self.dlg.lineEdit_55.text())

        math = ('Re1@1' + '*' + self.dlg.lineEdit_48.text()) + '+' + ('Re2@1' + '*' + self.dlg.lineEdit_49.text()) + '+' + \
               ('Re3@1' + '*' + self.dlg.lineEdit_50.text()) + '+' + ('Re4@1' + '*' + self.dlg.lineEdit_51.text()) + '+' + \
               ('Re5@1' + '*' + self.dlg.lineEdit_52.text()) + '+' + ('Re6@1' + '*' + self.dlg.lineEdit_53.text()) + '+' + \
               ('Re7@1' + '*' + self.dlg.lineEdit_54.text()) + '+' + ('Re8@1' + '*' + self.dlg.lineEdit_55.text()) + '+' + \
               ('Re9@1' + '*' + self.dlg.lineEdit_56.text()) + '+' + ('Re10@1' + '*' + self.dlg.lineEdit_57.text()) + '+' + \
               ('Re11@1' + '*' + self.dlg.lineEdit_58.text()) + '+' + ('Re12@1' + '*' + self.dlg.lineEdit_59.text()) + '+' + \
               ('Re13@1' + '*' + self.dlg.lineEdit_60.text()) + '+' + ('Re14@1' + '*' + self.dlg.lineEdit_61.text()) 
        
        #cal = QgsRasterCalculator(math, 
                                #new_path, 
                                #'GTiff', 
                                #ReAspected.extent(), 
                                #ReAspected.width(), 
                                #ReAspected.height(), 
                                #entries )
        
        cal = QgsRasterCalculator(math, 
                                New_path, 
                                'GTiff', 
                                Re1.extent(), 
                                Re1.width(), 
                                Re1.height(), 
                                entries )

        cal.processCalculation()
        
        #processing.run("gdal:cliprasterbymasklayer", {'INPUT':New_path,'MASK':self.Difference,'SOURCE_CRS':None,'TARGET_CRS':None,\
                                                      #'NODATA':None,'ALPHA_BAND':False,'CROP_TO_CUTLINE':True,'KEEP_RESOLUTION':False,\
                                                      #'SET_RESOLUTION':False,'X_RESOLUTION':self.dlg.doubleSpinBox_1.value(),\
                                                      #'Y_RESOLUTION':self.dlg.doubleSpinBox_1.value(),'MULTITHREADING':False,\
                                                      #'OPTIONS':'','DATA_TYPE':0,'EXTRA':'','OUTPUT':SumOfWeight})
        iface.addRasterLayer(New_path)
        
    def info(self):
        if self.dlg.toolButton_4.clicked:
            self.dlg.textEdit_2.setText("Buffer Done!")
        if self.dlg.toolButton_14.clicked:
            self.dlg.textEdit_2.setText("If your selected Permeability layer feature is string data, the plugin reproduces integer feature data")
                 

    #===========================================================================================================================

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = LandFill_Site_SelectionDialog()
            
            #Introduction
            self.dlg.textEdit_1.setEnabled(False)
            self.dlg.textEdit_1.setText("Dear Users;\n\nBelow are the plugin process steps designed to perform LandFill Site Selection  analysis given. You can find the files of your processes in the LandFill_Site_Selection folder on your Desktop.\
                                         \n\nYou can perform your suitable site selection analysis by following all project steps. \
                                         \n\nTo get started, firstly enter your project resolution value in the field below.\n\n\n\n\n\n\n\n\n\n\n\n\nGood Luck..")

            #ToolBox
            self.dlg.toolBox.setCurrentIndex(0)

            #Buffer
            self.dlg.toolButton_4.clicked.connect(self.Buffer_name1)
            self.dlg.toolButton_5.clicked.connect(self.Buffer_name2)
            self.dlg.toolButton_6.clicked.connect(self.Buffer_name3)
            self.dlg.toolButton_7.clicked.connect(self.Buffer_name4)
            self.dlg.toolButton_8.clicked.connect(self.Buffer_name5)
            self.dlg.toolButton_10.clicked.connect(self.Buffer_name6)
            self.dlg.toolButton_13.clicked.connect(self.Buffer_name7)
            self.dlg.toolButton_15.clicked.connect(self.Buffer_name8)

            self.dlg.toolButton_4.clicked.connect(self.Buffer_distance1)
            self.dlg.toolButton_5.clicked.connect(self.Buffer_distance2)
            self.dlg.toolButton_6.clicked.connect(self.Buffer_distance3)
            self.dlg.toolButton_7.clicked.connect(self.Buffer_distance4)
            self.dlg.toolButton_8.clicked.connect(self.Buffer_distance5)
            self.dlg.toolButton_10.clicked.connect(self.Buffer_distance6)
            self.dlg.toolButton_13.clicked.connect(self.Buffer_distance7)
            self.dlg.toolButton_15.clicked.connect(self.Buffer_distance8)

            self.dlg.toolButton_4.clicked.connect(self.vector_sec)
            self.dlg.toolButton_5.clicked.connect(self.vector_sec)
            self.dlg.toolButton_6.clicked.connect(self.vector_sec)
            self.dlg.toolButton_7.clicked.connect(self.vector_sec)
            self.dlg.toolButton_8.clicked.connect(self.vector_sec)
            self.dlg.toolButton_10.clicked.connect(self.vector_sec)
            self.dlg.toolButton_13.clicked.connect(self.vector_sec)
            self.dlg.toolButton_15.clicked.connect(self.vector_sec)

            self.dlg.toolButton_4.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_5.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_6.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_7.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_8.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_10.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_13.clicked.connect(self.Buffer_control)
            self.dlg.toolButton_15.clicked.connect(self.Buffer_control)

            #Merge
            self.dlg.Merge_pushButton.clicked.connect(self.Merge_control)

            #Difference
            self.dlg.toolButton.clicked.connect(self.vector_sec)
            self.dlg.toolButton_9.clicked.connect(self.other_sec)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference0)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference1)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference2)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference3)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference4)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference5)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference6)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference7)
            self.dlg.Erase_pushButton.clicked.connect(self.Difference8)

            #Extent
            self.dlg.toolButton.clicked.connect(self.Extent)
            
            #Elevation Aspect and Slope
            self.dlg.textEdit_2.setEnabled(False)
            self.dlg.toolButton_2.clicked.connect(self.raster_sec)
            self.dlg.toolButton_2.clicked.connect(self.AspectandSlope_comboBoxes)
            self.dlg.AspectandSlopeRun_pushButton.clicked.connect(self.Resample_DEM)
            self.dlg.AspectandSlopeRun_pushButton.clicked.connect(self.Aspect)
            self.dlg.AspectandSlopeRun_pushButton.clicked.connect(self.Aspect_statistic)
            self.dlg.AspectandSlopeRun_pushButton.clicked.connect(self.Slope)

            #FROM_Distance_Rasterize                                        
            self.dlg.Raster_pushButton.clicked.connect(self.FROM_Distance_Rasterize)
            self.dlg.Raster_pushButton.clicked.connect(self.FROM_Distance_Proximity)
            self.dlg.Raster_pushButton.clicked.connect(self.FROM_Distance_Proximity_Masked)
         
            #Land_Use_Rasterize
            self.dlg.toolButton_11.clicked.connect(self.vector_sec)
            self.dlg.toolButton_11.clicked.connect(self.Raster_comboBoxes)
            self.dlg.Raster_pushButton_2.clicked.connect(self.Land_Use_Rasterize)

            #Permeability_Rasterize
            self.dlg.toolButton_14.clicked.connect(self.vector_sec)
            self.dlg.toolButton_14.clicked.connect(self.Permeability_comboBoxes)
            self.dlg.toolButton_14.clicked.connect(self.info)
            self.dlg.Raster_pushButton_5.clicked.connect(self.Add_Permeability_No)
            self.dlg.Raster_pushButton_5.clicked.connect(self.Permeability_Rasterize)

            #Ground Water Level
            self.dlg.textEdit_2.setEnabled(False)
            self.dlg.toolButton_3.clicked.connect(self.raster_sec)
            self.dlg.toolButton_3.clicked.connect(self.WaterLevel_comboBoxes)
            self.dlg.Raster_pushButton_6.clicked.connect(self.Resample_WaterLevel)

            #Reclassify
            self.dlg.pushButton.clicked.connect(self.add_row)
            self.dlg.pushButton_2.clicked.connect(self.remove_row)
            self.dlg.Refresh_Table.clicked.connect(self.Refresh)
            
            self.dlg.Reclassify_pushButton.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton.clicked.connect(self.Reclassify_Faults)

            self.dlg.Reclassify_pushButton_2.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_2.clicked.connect(self.Reclassify_Drainages)

            self.dlg.Reclassify_pushButton_4.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_4.clicked.connect(self.Reclassify_Roads)

            self.dlg.Reclassify_pushButton_5.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_5.clicked.connect(self.Reclassify_Airports)

            self.dlg.Reclassify_pushButton_6.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_6.clicked.connect(self.Reclassify_ProtectedArea)

            self.dlg.Reclassify_pushButton_8.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_8.clicked.connect(self.Reclassify_Settlements)

            self.dlg.Reclassify_pushButton_7.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_7.clicked.connect(self.Reclassify_Surface_Water)

            self.dlg.Reclassify_pushButton_3.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_3.clicked.connect(self.Reclassify_Surface_River)

            self.dlg.Reclassify_pushButton_9.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_9.clicked.connect(self.Reclassify_Land_Use)

            self.dlg.Reclassify_pushButton_10.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_10.clicked.connect(self.Reclassify_Permeability)

            self.dlg.Reclassify_pushButton_14.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_14.clicked.connect(self.Reclassify_WaterLevel)

            self.dlg.Reclassify_pushButton_13.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_13.clicked.connect(self.Reclassify_Elevation)

            self.dlg.Reclassify_pushButton_12.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_12.clicked.connect(self.Reclassify_Aspect)

            self.dlg.Reclassify_pushButton_11.clicked.connect(self.table_data)
            self.dlg.Reclassify_pushButton_11.clicked.connect(self.Reclassify_Slope)
              
            #Raster_Calculater
            self.dlg.RasterCalc_pushButton_2.clicked.connect(self.Total)
            self.dlg.RasterCalc_pushButton_2.clicked.connect(self.Raster_Calculater)

            
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
