# -*- coding: utf-8 -*-

"""
/***************************************************************************
 LandCoverDownloader
                                 A QGIS plugin
 Downloads Sentinel-2 Land Cover Data from Esri's Living Atlas
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2026-01-11
        copyright            : (C) 2026 by CustomCartographix
        email                : john@customcartographix.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This script contains the provider code for the land cover             *
 *   downloader processing plugin.                                         *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'CustomCartographix'
__date__ = '2026-01-11'
__copyright__ = '(C) 2026 by CustomCartographix'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .land_cover_downloader_algorithm import (DownloadFromLatLng,
                                              DownloadFromPoint,
                                              DownloadFromAoi)
from qgis.PyQt.QtGui import QIcon
from os import path


class LandCoverDownloaderProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(DownloadFromLatLng())
        self.addAlgorithm(DownloadFromPoint())
        self.addAlgorithm(DownloadFromAoi())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider.
        """
        return 'LandCoverDownloader'

    def name(self):
        """
        Returns the provider name.
        """
        return self.tr('Land Cover Downloader')

    def icon(self):
        """
        Returns icon.
        """
        return QIcon(path.dirname(__file__) + "/resources/land_cover_logo_svg.svg")

    def longName(self):
        """
        Returns a longer version of the provider name.
        """
        return self.name()
