# -*- coding: utf-8 -*-
"""

0 Info
1 Warning
2 Critical
3 Success
iface.messageBar().pushMessage("Ooops", "The plugin is not working as it should", level=Qgis.Critical, duration=3)

# 131.08, -13.51
# 145.12, -37.91

/***************************************************************************
 landXMLEtcToDB
                                 A QGIS plugin
 Loads LandXML and Vector Themes to Databases
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-12-27
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Roger Merritt / Spatial Tapestry
        email                : roger@SpatialTapesry.com.au
 ***************************************************************************/

/***************************************************************************
#
# Copyright
# Spatial Tapestry
# All rights reserved
#
# This program is released under the terms of the included 
# LICENSE file for more information.
#
 ***************************************************************************/

# An "illegal" identifier has to be quoted in Postgres (and SQL).
# The function format() has a special place holder for identifiers and will return a quoted identifier
# if anything is non-standard:
# So select format('%I', 'foo') returns foo.
# But select format('%I', 'foo bar') returns "foo bar"

Some Postgres code to get started with (PGADMIN4):
CREATE DATABASE gisdb WITH OWNER = postgres ENCODING = 'UTF8' TABLESPACE = pg_default CONNECTION LIMIT = 300;
CREATE ROLE rogermsu LOGIN PASSWORD 'rogermsu' SUPERUSER INHERIT CREATEDB CREATEROLE NOREPLICATION;
CREATE SCHEMA testdata AUTHORIZATION rogermsu;

Some Oracle code to get started with (SQL Developer)
Note: With Oracle each user has their own schema
Enter user-name: system
Enter password:
Last Successful login time: Wed Jan 10 2024 14:33:56 +08:00
Connected to:
Oracle Database 21c Express Edition Release 21.0.0.0.0 - Production
Version 21.3.0.0.0
SQL> create user drrog identified by drrog;
create user drrog identified by drrog
            *
ERROR at line 1:
ORA-65096: invalid common user or role name
SQL> alter session set "_ORACLE_SCRIPT"=true;
Session altered.
SQL> create user drrog identified by drrog;
User created.
SQL>
-- USER SQL
CREATE USER "drrog" IDENTIFIED BY "drrog"  ;
-- ROLES
GRANT "CONNECT" TO "DRROG" ;
GRANT "DBA" TO "DRROG" ;
-- SYSTEM PRIVILEGES
GRANT ALTER ANY TABLE TO "DRROG" ;
GRANT DROP ANY TABLE TO "DRROG" ;
GRANT INSERT ANY TABLE TO "DRROG" ;
GRANT CREATE ANY TABLE TO "DRROG" ;



pip install -U psycopg2
pip install -U oracledb
pip install -U pyodbc
https://docs.devart.com/odbc/sqlserver/using_odbc_driver.htm
sudo apt-get install odbcinst1debian2 libodbc1 odbcinst unixodbc
https://www.devart.com/odbc/sqlserver/download.html
https://docs.devart.com/odbc/sqlserver/configuring_odbc_dsn_on_linux.htm
grant permissions to the user


On Windows:
PYTHONPATH
C:\Program Files\QGIS 3.34.1\apps\qgis\python;C:\Program Files\QGIS 3.34.1\apps\qgis\python\plugins;C:\Program Files\QGIS 3.34.1\apps\Qt5\plugins;C:\Program Files\QGIS 3.34.1\share\gdal;


 """
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon, QStandardItem
from qgis.PyQt.QtWidgets import QAction

#from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
#from PyQt5.QtGui import *



# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .landXMLEtc_dialog import landXMLEtcDialog
from . import LandXml
from . import LandXmlDialog
from . import landXML2DB

import os
import os.path

import datetime
import math 

from qgis.core import *
from qgis.gui import *
from qgis.utils import *

import psycopg2
connPGS: psycopg2
import oracledb
connORA: oracledb
import pyodbc
connDEV: pyodbc

shiftVectVectName: str = "stt_vectorvector"
shiftVectVectLayer: QgsVectorLayer
g3g = list()

myGBL = {}

class landXMLEtc:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'landXMLEtc_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&landXMLtoDBEtc_Free')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('landXMLtoDBEtc_Free', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/my_landXML_Dev/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'landXMLtoDBEtc_Free'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&landXMLtoDBEtc_Free'),
                action)
            self.iface.removeToolBarIcon(action)

    def c1c(self):
        try:
            f1f(self)
        except Exception as err:
            QMessageBox.information(None, "Failure", err, QMessageBox.Ok, QMessageBox.Ok)


    def k1k(self):
        # conn01 = psycopg2.connect("dbname=suppliers user=postgres password=postgres")
        x1x(self)
        try:
            sqlStr = "create table testtable(stid NUMBER Primary Key, firstname VARCHAR2(20) NOT NULL)"
            if myGBL['n2n'] == "PGS":
                connPGS = i2i(**myGBL)
                cursor = connPGS.cursor()
                cursor.execute(sqlStr.replace("NUMBER","INTEGER").replace("CHAR2","CHAR"))

                self.iface.messageBar().pushMessage("Success", myGBL['n2n'] + " create table called", level=Qgis.Success, duration=5)


            if myGBL['n2n'] == "ORA":
                connORA = j2j(**myGBL)
                cursor = connORA.cursor()
                cursor.execute(sqlStr)
                self.iface.messageBar().pushMessage("Success", myGBL['n2n'] + " create table called", level=Qgis.Success, duration=5)

            if myGBL['n2n'] == "ORD":
                connDEV = k2k(**myGBL)
                cursor = connORA.cursor()
                cursor.execute(sqlStr)
                self.iface.messageBar().pushMessage("Success", myGBL['n2n'] + " create table called", level=Qgis.Success, duration=5)

            if myGBL['n2n'] == "MSS":
                connDEV = l2l(**myGBL)
                cursor = connDEV.cursor()
                cursor.execute(sqlStr)
                self.iface.messageBar().pushMessage("Success", myGBL['n2n'] + " create table called", level=Qgis.Success, duration=5)

            f1f(self)

            self.iface.messageBar().pushMessage("Success", myGBL['n2n'] + "_TestDB pressed", level=Qgis.Success, duration=5)
        except Exception as err:
            error_obj = err.args
            QMessageBox.information(None, "Failure " + str(error_obj), err, QMessageBox.Ok, QMessageBox.Ok)

    def a3a(self):
        try:
            n2n = myGBL['n2n']
            o2o = myGBL['o2o']
            if o2o == "Serv" or o2o == "Both":
                if myGBL['n2n'] == "PGS":
                    connPGS = i2i(**myGBL)
                if myGBL['n2n'] == "ORA":
                    connOra = j2j(**myGBL)
                if myGBL['n2n'] == "ORD":
                    connOrD = k2k(**myGBL)
                if myGBL['n2n'] == "MSS":
                    connDEV = l2l(**myGBL)
            t1t = os.path.expanduser( '~' ) + "/log._DeleteThemeReport"
            with open(t1t, 'w') as log_file:
                log_file.close
            with open(os.path.expanduser( '~' ) + "/sql._DeleteThemeReport", 'w') as delete_file:
                for o3o in iface.layerTreeView().selectedLayers():
                    svl:QgsVectorLayer
                    svl = o3o
                    svlname = svl.name().lower()
                    if o3o.type() == QgsMapLayer.VectorLayer:
                        layers = QgsProject.instance().mapLayers().values()
                        for layer in layers:
                            vl:QgsVectorLayer
                            vl = layer
                            vlname = vl.name().lower()
                            if layer.type() != QgsMapLayer.VectorLayer:
                                continue
                            elif vlname == svlname:
                                n3n = vl.name().lower().replace(".","_")
                                if n2n == "PGS":
                                    n3n = myGBL['PG_Schema'] + "." + n3n
                                sqlStr = "DROP TABLE " + n3n
                                if o2o == "File" or o2o == "Both":
                                    delete_file.write(sqlStr + ";" + '\n')
                                if o2o == "Serv" or o2o == "Both":
                                    if n2n == "PGS":
                                        e2e(sqlStr, connPGS, t1t)
                                    elif n2n == "ORA":
                                        f2f(sqlStr, connOra, t1t)
                                    elif n2n == "ORD":
                                        g2g(sqlStr, connOrD, t1t)
                                    elif n2n == "MSS":
                                        h2h(sqlStr, connDEV, t1t)
                delete_file.close

        except Exception as err:
            QMessageBox.information(None, "Failured to delete table", err, QMessageBox.Ok, QMessageBox.Ok)
            return False
       
    def b1b(self):
        try:
            with open(os.path.expanduser( '~' ) + "/log._ImportThemeReport", 'w') as report_file:
                report_file.close

            whatIsGoingOn("Selected Themes are:")
            for o3o in iface.layerTreeView().selectedLayers():
                svl:QgsVectorLayer
                svl = o3o
                svlname = svl.name().lower()
                whatIsGoingOn(svlname)
            whatIsGoingOn("End Selected Themes List\n")

            abc = self.dlg.a44.text().replace("("," ").replace(")"," ").replace(" million","000000").split(" ")
            whatIsGoingOn("Max Record Count per theme: " + abc[3])
            whatIsGoingOn("DB Type : " + myGBL['n2n'])
            whatIsGoingOn("Host:     " + self.dlg.PG_IPAddress.text())
            whatIsGoingOn("Database: " + self.dlg.PG_DBName.text())
            whatIsGoingOn("Port:     " + self.dlg.PG_Port.text())
            whatIsGoingOn("Schema:   " + self.dlg.a4x.text() + "\n")

            if self.dlg.toolBox_Choice.currentIndex() == 0 and self.dlg.a4j.isChecked:
                shiftVectVectLayer: QgsVectorLayer = myGBL['shiftVectVectLayer']
                numSV = e3e(self, shiftVectVectLayer, **myGBL)
                if numSV == 0:
                    QMessageBox.information(None, "Failure", "no ShiftVectors", QMessageBox.Ok, QMessageBox.Ok)
                    return False
            elif self.dlg.toolBox_Choice.currentIndex() == 1:
                print("Two Point Transformation")
            elif self.dlg.toolBox_Choice.currentIndex() == 2:
                print("Local Two Point Transformation")
            else:
                QMessageBox.information(None,shiftVectVectName, "was NOT Found!!!", QMessageBox.Ok, QMessageBox.Ok)
                return False

            for o3o in iface.layerTreeView().selectedLayers():
                svl:QgsVectorLayer
                svl = o3o
                svlname = svl.name().lower()

                if o3o.type() == QgsMapLayer.VectorLayer:
                    layers = QgsProject.instance().mapLayers().values()
                    gotit = False
                    for layer in layers: # + str(layer.parent()) + ", " 
                        vl:QgsVectorLayer
                        vl = layer
                        vlname = vl.name().lower()
                        if layer.type() != QgsMapLayer.VectorLayer:
                            # Ignore this layer as it's not a vector
                            continue
                        elif layer.featureCount() == 0:
                            # There are no features - skip
                            continue
                        elif vlname == svlname:
                            gotit = True
                            l1l(self, layer, **myGBL)

            wT = self.dlg.windowTitle()
            if "_Fr" in wT:
                QMessageBox.information(None,"Finished Processing...","Remember you can get an Unlimited Version at\nhttps://gismart.net/stores/spatialtapestry/", QMessageBox.Ok, QMessageBox.Ok)
            if "_Pa" in wT:
                QMessageBox.information(None,"Finished Processing...","Remember you can get this Source Code at\nhttps://gismart.net/stores/spatialtapestry/", QMessageBox.Ok, QMessageBox.Ok)

        except Exception as err:
            QMessageBox.information(None, "Failure loading theme", err, QMessageBox.Ok, QMessageBox.Ok)
            return False

    def i1i(self):
        myGBL.update({'n2n': "PGS"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/PGS_ST_Lxml.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)

    def j1j(self):
        myGBL.update({'n2n': "ORA"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/ORA_ST_Lxml.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)

    def d1d(self):
        myGBL.update({'n2n': "ORD"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/ORD_ST_Lxml.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)

    def n1n(self):
        myGBL.update({'n2n': "MSS"}) 
        myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/MSS_ST_Lxml.Config'}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        m1m(self)
    
    def w1w(self):
        if not self.dlg.v1v.isChecked() and not self.dlg.u1u.isChecked():
            self.dlg.v1v.setChecked(True)
            myGBL.update({'o2o': "File"}) 
        if self.dlg.v1v.isChecked() and not self.dlg.u1u.isChecked():
            myGBL.update({'o2o': "File"}) 
        elif not self.dlg.v1v.isChecked() and self.dlg.u1u.isChecked():
            myGBL.update({'o2o': "Serv"}) 
        elif self.dlg.v1v.isChecked() and self.dlg.u1u.isChecked():
            myGBL.update({'o2o': "Both"}) 
        self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
        self.dlg.h1h.setText("Process the QGIS Selected Themes to " + myGBL['o2o'])
        self.dlg.e1e.setText("Delete the QGIS Selected Themes from " + myGBL['o2o'])

    def _browseXmlFile(self):
        a56 = QFileDialog.getOpenFileName(None,str("Select LandXml file"), 
            str(os.path.expanduser( '~' ) ) + "/myData/LandXMLs",
            str("LandXml files (*.xml)"))[0]
        if a56:
            self.dlg.listWidget.clear()
            self.dlg.uXmlFile.setText(a56)
        a4q(self, a56)


    def a4i(self):
        enText = str(self.dlg.a58.text())
        #QMessageBox.information(None,"enText:", enText, QMessageBox.Ok, QMessageBox.Ok)
        if "," in enText:
            eNArr = enText.split(",")
            self.dlg.a59.setText(eNArr[1])
            self.dlg.a58.setText(eNArr[0])

    def a4l(self):
        if not a60(self):
            return
        a56 = str(self.dlg.uXmlFile.text())
        #homedir = os.path.dirname(a56)
        #settings = QSettings()
        #settings.setValue(LandXmlDialog.browsePathSetting,homedir)
        if not a56:
            QMessageBox.information(None,"LandXml error","You must specify a LandXml file to import", QMessageBox.Ok, QMessageBox.Ok)
            return
        if not os.path.exists(a56):
            QMessageBox.information(None,"LandXml error","WriteLXML, Cannot open " + a56, QMessageBox.Ok, QMessageBox.Ok)
            return

        if myGBL['n2n'] != "PGS":
            QMessageBox.information(None,"Database error","Postgres/PostGIS only at this time. ", QMessageBox.Ok, QMessageBox.Ok)
            return


        try:
            a55 = {}
            a55.update({'GoIt': "T"}) 
            if self.dlg.listWidget.currentRow() == -1:
                QMessageBox.information(None,"Warning!!!","You must select a Monument to proceed", QMessageBox.Ok, QMessageBox.Ok)
                return
            curText = self.dlg.listWidget.currentItem().text()
            curArr = curText.replace("[","").replace("]","").replace(" ","").split(",")
            a55.update({'FrE': curArr[1]}) 
            a55.update({'FrN': curArr[2]}) 
            a55.update({'ToE': self.dlg.a58.text()}) 
            a55.update({'ToN': self.dlg.a59.text()}) 
            a55.update({'Rot': self.dlg.a4r.text()}) 
            a55.update({'SFr': self.dlg.a4m.text()}) 

            a57 = str(self.dlg.mQgsProjectionSelectionWidget_LXMLXY.crs())
            a57 = a57.replace("<QgsCoordinateReferenceSystem: ","").replace(">","")
            if "invalid" in a57:
                QMessageBox.information(None,"a57 error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
                return
            if "invalid" in str(self.dlg.mQgsProjectionSelectionWidget_Table.crs()):
                QMessageBox.information(None,"l3l error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
                return
    
            myGBL.update({'a57': a57}) 

            a4d(self)
            data = LandXml.LandXml(a56, **a55)

            logFile = os.path.expanduser( '~' ) + "/lxml_" + str(data._SurveyHeader['name']) + ".sql"
            outSQL_file = open(logFile, 'w')
            errlogFile = logFile.replace(".sql", ".err")
            with open(errlogFile, 'w') as output_file:
                output_file.close()

            sqlList = landXML2DB._saveParcelLayer(self, data, **myGBL)
            i3i(self, sqlList, outSQL_file, errlogFile, **myGBL)
            sqlList = landXML2DB._saveMonuments(self, data, **myGBL)
            i3i(self, sqlList, outSQL_file, errlogFile, **myGBL)
            sqlList = landXML2DB._saveObsLayer(self, data, **myGBL)
            i3i(self, sqlList, outSQL_file, errlogFile, **myGBL)
            sqlList = landXML2DB._saveCGPoints(self, data, **myGBL)
            i3i(self, sqlList, outSQL_file, errlogFile, **myGBL)
        except:
            message = str(sys.exc_info()[1])
            QMessageBox.information(None,"LandXml error","Problem writing xml\n" + message, QMessageBox.Ok, QMessageBox.Ok)


    def a4e(self):
        try:
            create_Tables(self, **myGBL)
            self.iface.messageBar().pushMessage("Success", "Schema and Tables Created", level=Qgis.Success, duration=5)
        except Exception as err:
            QMessageBox.information(None,"Failure", err, QMessageBox.Ok, QMessageBox.Ok)

    def a4c(self):
        try:
            # Fetch the currently loaded layers
            rootTree = QgsProject.instance().layerTreeRoot()
            # dumpStr = rootTree.dump()
            rowNo = 0
            layers = QgsProject.instance().mapLayers().values() # QgsProject.instance().layerTreeRoot().children()
            a4p(NULL, -1, **myGBL)
            lyrData = "lyrData:" + '\n'
            for layer in layers: # + str(layer.parent()) + ", " 
                # lyrData = lyrData + str(layer.nodeType()) + ", "

                #if str(layer.nodeType()) != "0":
                if layer.type() != QgsMapLayer.VectorLayer:
                    # Ignore this layer as it's not a vector
                    continue
                elif layer.featureCount() == 0:
                    # There are no features - skip
                    continue
                else:
                    vl:QgsVectorLayer
                    vl = layer

                    lyrData = lyrData + "root level: " + str(layer.name()) + " " + str(vl.dataProvider().dataSourceUri()) + '\n'
                    rowNo = rowNo + 1
                    a4p(layer, rowNo, **myGBL)

            a56 = self.dlg.a4x.text() + '/' + self.dlg.a4x.text() + '.text'
            with open(a56, 'w') as output_file:
                output_file.write(lyrData)
                output_file.close()

            self.iface.messageBar().pushMessage("Success", "d2d pressed ", level=Qgis.Success, duration=5)

        except Exception as err:
            QMessageBox.information(None, "Failure", err, QMessageBox.Ok, QMessageBox.Ok)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False

            with open("log.WhatIsGoingOn", 'w') as outSQL_file:
                outSQL_file.write("Look here for a running report on what is happening inside this PlugIn\n")
            outSQL_file.close


            myGBL.update({'ConFileName': os.path.expanduser( '~' ) + '/PGS_ST_Lxml.Config'}) 
            self.dlg = landXMLEtcDialog()
            self.dlg.Btn_CreateSchemaEtc.clicked.connect(self.a4e)
            self.dlg.Btn_Populate_STT_ThemeData.clicked.connect(self.a4c)
            self.dlg.g1g.clicked.connect(self.c1c)
            self.dlg.h1h.clicked.connect(self.b1b)
            self.dlg.e1e.clicked.connect(self.a3a)
            self.dlg.a51.clicked.connect(self.i1i)
            self.dlg.c2c.clicked.connect(self.j1j)
            self.dlg.o1o.clicked.connect(self.d1d)
            self.dlg.m2m.clicked.connect(self.n1n)
            self.dlg.u1u.clicked.connect(self.w1w)
            self.dlg.v1v.clicked.connect(self.w1w)
            self.dlg.d2d.clicked.connect(self.k1k)
            self.dlg.a4u.clicked.connect(self._browseXmlFile)
            #self.dlg.Btn_MouseClick.clicked.connect(self.a4h)
            self.dlg.a58.textChanged.connect(self.a4i)
            self.dlg.Btn_Write2DB.clicked.connect(self.a4l)


            self.dlg.a51.setChecked(True)

            myGBL.update({'n2n': "PGS"}) 
            myGBL.update({'o2o': "Both"}) 
            self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
            self.dlg.h1h.setText("Process the QGIS Selected Themes to " + myGBL['o2o'])
            self.dlg.e1e.setText("Delete the QGIS Selected Themes from " + myGBL['o2o'])

        # show the dialog
        self.dlg.show()

        if os.path.exists(myGBL['ConFileName']):
            m1m(self)
    
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

def x1x(self):
    myGBL.update({'PG_IPAddress': self.dlg.PG_IPAddress.text()}) 
    myGBL.update({'PG_DBName': self.dlg.PG_DBName.text()}) 
    myGBL.update({'PG_Username': self.dlg.PG_Username.text()}) 
    myGBL.update({'PG_Password': self.dlg.PG_Password.text()}) 
    myGBL.update({'PG_Port': self.dlg.PG_Port.text()}) 
    myGBL.update({'PG_Schema': self.dlg.a4x.text()}) 


def m1m(self):
    try:
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers: # + str(layer.parent()) + ", " 
            vl:QgsVectorLayer
            vl = layer
            vlname = vl.name().lower()
            # report_file.write("Looking at Theme " + vlname + '\n')
            if layer.type() != QgsMapLayer.VectorLayer:
                # Ignore this layer as it's not a vector
                continue
            elif layer.featureCount() == 0:
                # There are no features - skip
                continue
            elif vlname == shiftVectVectName.lower():
                shiftVectVectLayer = layer
                self.dlg.a4j.setEnabled(True)
                self.dlg.a4j.setChecked(True)
                myGBL.update({'shiftVectVectLayer': shiftVectVectLayer}) 

        if os.path.exists(myGBL['ConFileName']):
            with open(myGBL['ConFileName'], 'r') as input_file:
                lines = input_file.readlines()
                
                if len(lines) > 0:
                    self.dlg.PG_IPAddress.setText(lines[0].replace('\n','').split('=')[1])
                if len(lines) > 1:
                    self.dlg.PG_DBName.setText(lines[1].replace('\n','').split('=')[1])
                if len(lines) > 2:
                    self.dlg.PG_Username.setText(lines[2].replace('\n','').split('=')[1])
                if len(lines) > 3:
                    self.dlg.PG_Password.setText(lines[3].replace('\n','').split('=')[1])
                if len(lines) > 4:
                    self.dlg.PG_Port.setText(lines[4].replace('\n','').split('=')[1])
                if len(lines) > 5:
                    self.dlg.a4x.setText(lines[5].replace('\n','').split('=')[1])

                x1x(self)
                
                if len(lines) > 6:
                    SRID_Table = lines[6].replace('\n','').split('=')[1]
                    self.dlg.mQgsProjectionSelectionWidget_Table.setCrs(QgsCoordinateReferenceSystem(SRID_Table))
                    myGBL.update({'l3l': SRID_Table}) 

                if len(lines) > 7:
                    myGBL.update({'n2n': lines[7].replace('\n','').split('=')[1]}) 
                if len(lines) > 8:
                    myGBL.update({'o2o': lines[8].replace('\n','').split('=')[1]}) 


                if myGBL['n2n'] == "PGS":
                    self.dlg.a51.setChecked(True)
                    self.dlg.a4x.setEnabled(True)
                if myGBL['n2n'] == "ORA":
                    self.dlg.c2c.setChecked(True)
                    self.dlg.a4x.setEnabled(False)
                if myGBL['n2n'] == "ORD":
                    self.dlg.o1o.setChecked(True)
                    self.dlg.a4x.setEnabled(False)
                if myGBL['n2n'] == "MSS":
                    self.dlg.m2m.setChecked(True)
                    self.dlg.a4x.setEnabled(True)
                if myGBL['o2o'] == "File":
                    self.dlg.v1v.setChecked(True)
                    self.dlg.u1u.setChecked(False)
                if myGBL['o2o'] == "Serv":
                    self.dlg.u1u.setChecked(True)
                    self.dlg.v1v.setChecked(False)
                if myGBL['o2o'] == "Both":
                    self.dlg.v1v.setChecked(True)
                    self.dlg.u1u.setChecked(True)
 

                if len(lines) > 9:
                    myGBL.update({'FromE': lines[9].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_FromE.setText(lines[9].replace('\n','').split('=')[1])
                if len(lines) > 10:
                    myGBL.update({'FromN': lines[10].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_FromN.setText(lines[10].replace('\n','').split('=')[1])
                if len(lines) > 11:
                    myGBL.update({'ToE': lines[11].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_ToE.setText(lines[11].replace('\n','').split('=')[1])
                if len(lines) > 12:
                    myGBL.update({'ToN': lines[12].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_ToN.setText(lines[12].replace('\n','').split('=')[1])
                if len(lines) > 13:
                    myGBL.update({'RotnDecDeg': lines[13].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_RotnDecDeg.setText(lines[13].replace('\n','').split('=')[1])
                if len(lines) > 14:
                    myGBL.update({'ScaleFactor': lines[14].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_ScaleFactor.setText(lines[14].replace('\n','').split('=')[1])


                if len(lines) > 15:
                    myGBL.update({'FromE_2': lines[15].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_FromE_2.setText(lines[15].replace('\n','').split('=')[1])
                if len(lines) > 16:
                    myGBL.update({'FromN_2': lines[16].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_FromN_2.setText(lines[16].replace('\n','').split('=')[1])
                if len(lines) > 17:
                    myGBL.update({'ToE_2': lines[17].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_ToE_2.setText(lines[17].replace('\n','').split('=')[1])
                if len(lines) > 18:
                    myGBL.update({'ToN_2': lines[18].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_ToN_2.setText(lines[18].replace('\n','').split('=')[1])
                if len(lines) > 19:
                    myGBL.update({'a4y': lines[19].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_a4y.setText(lines[19].replace('\n','').split('=')[1])
                if len(lines) > 20:
                    myGBL.update({'a4w': lines[20].replace('\n','').split('=')[1]}) 
                    self.dlg.tb_a4w.setText(lines[20].replace('\n','').split('=')[1])

                if len(lines) > 21:
                    SRID_Local = lines[21].replace('\n','').split('=')[1]
                    self.dlg.mQgsProjectionSelectionWidget_LclXY.setCrs(QgsCoordinateReferenceSystem(SRID_Local))
                    myGBL.update({'m3m': SRID_Local}) 

                if len(lines) > 22:
                    a56 = lines[22].replace('\n','').split('=')[1]
                    self.dlg.uXmlFile.setText(a56)
                    a4q(self, a56)

                if len(lines) > 23:
                    item2Select = QListWidgetItem(lines[23].replace('\n','').split('=')[1])
                    self.dlg.listWidget.setCurrentItem(item2Select)

                if len(lines) > 24:
                    self.dlg.a58.setText(lines[24].replace('\n','').split('=')[1])

                if len(lines) > 25:
                    self.dlg.a59.setText(lines[25].replace('\n','').split('=')[1])

                if len(lines) > 26:
                    self.dlg.a4r.setText(lines[26].replace('\n','').split('=')[1])

                if len(lines) > 27:
                    self.dlg.a4m.setText(lines[27].replace('\n','').split('=')[1])

                if len(lines) > 28:
                    a57 = lines[28].replace('\n','').split('=')[1]
                    self.dlg.mQgsProjectionSelectionWidget_LXMLXY.setCrs(QgsCoordinateReferenceSystem(a57))


            a53 = [("Point", QgsWkbTypes.PointGeometry, QgsWkbTypes.Point),
                ("LineString", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineString),
                ("Polygon", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.Polygon),
                ("MultiPoint", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPoint),
                ("MultiLineString", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineString),
                ("MultiPolygon", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygon),
                ("PointZ", QgsWkbTypes.PointGeometry, QgsWkbTypes.PointZ),
                ("LineStringZ", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineStringZ),
                ("PolygonZ", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PolygonZ),
                ("MultiPointZ", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPointZ),
                ("MultiLineStringZ", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineStringZ),
                ("MultiPolygonZ", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygonZ),
                ("PointM", QgsWkbTypes.PointGeometry, QgsWkbTypes.PointM),
                ("LineStringM", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineStringM),
                ("PolygonM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PolygonM),
                ("MultiPointM", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPointM),
                ("MultiLineStringM", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineStringM),
                ("MultiPolygonM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygonM),
                ("PointZM", QgsWkbTypes.PointGeometry, QgsWkbTypes.PointZM),
                ("LineStringZM", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineStringZM),
                ("PolygonZM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.PolygonZM),
                ("MultiPointZM", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPointZM),
                ("MultiLineStringZM", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineStringZM),
                ("MultiPolygonZM", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygonZM),
                ("Point25D", QgsWkbTypes.PointGeometry, QgsWkbTypes.Point25D),
                ("LineString25D", QgsWkbTypes.LineGeometry, QgsWkbTypes.LineString25D),
                ("Polygon25D", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.Polygon25D),
                ("MultiPoint25D", QgsWkbTypes.PointGeometry, QgsWkbTypes.MultiPoint25D),
                ("MultiLineString25D", QgsWkbTypes.LineGeometry, QgsWkbTypes.MultiLineString25D),
                ("MultiPolygon25D", QgsWkbTypes.PolygonGeometry, QgsWkbTypes.MultiPolygon25D),
                ("None", QgsWkbTypes.NullGeometry, QgsWkbTypes.NoGeometry)]
            myGBL.update({'a53': a53}) 

            self.dlg.a41.setText(myGBL['n2n'] + " and " + myGBL['o2o']) 
            self.dlg.h1h.setText("Process the QGIS Selected Themes to " + myGBL['o2o'])
            self.dlg.e1e.setText("Delete the QGIS Selected Themes from " + myGBL['o2o'])

            self.iface.messageBar().pushMessage("Config File Loaded:", str(myGBL['ConFileName']), level=Qgis.Success, duration=5)

            input_file.close()
            return True
        
    except Exception as err:
        QMessageBox.information(None,"Failure", err, QMessageBox.Ok, QMessageBox.Ok)
        return False


def StripOGCFeatType(OGCFeature: str):
    if OGCFeature == "":
        return OGCFeature
    OGCFeature = OGCFeature.upper()
    if "SRID" in OGCFeature:
      OGCFeature = OGCFeature.split(";")(1)
    if "GEOMETRYCOLLECTIONM" in OGCFeature:
        OGCFeature = OGCFeature.replace("GEOMETRYCOLLECTIONM", "")
    if "GEOMETRYCOLLECTION" in OGCFeature:
        OGCFeature = OGCFeature.replace("GEOMETRYCOLLECTION", "")
    if "GEOMETRY" in OGCFeature:
        OGCFeature = OGCFeature.replace("GEOMETRY", "")
    if "MULTIPOLYGONZ" in OGCFeature:
        OGCFeature = OGCFeature.replace("MULTIPOLYGONZ", "")
    if "MULTIPOLYGON" in OGCFeature:
        OGCFeature = OGCFeature.replace("MULTIPOLYGON", "")
    if "POLYGON" in OGCFeature:
        OGCFeature = OGCFeature.replace("POLYGON", "")
    if "MULTILINESTRINGM" in OGCFeature:
        OGCFeature = OGCFeature.replace("MULTILINESTRINGM", "")
    if "MULTILINESTRING" in OGCFeature:
        OGCFeature = OGCFeature.replace("MULTILINESTRING", "")
    if "LINESTRINGM" in OGCFeature:
        OGCFeature = OGCFeature.replace("LINESTRINGM", "")
    if "LINESTRING" in OGCFeature:
        OGCFeature = OGCFeature.replace("LINESTRING", "")
    if "MULTIPOINTM" in OGCFeature:
        OGCFeature = OGCFeature.replace("MULTIPOINTM", "")
    if "MULTIPOINT" in OGCFeature:
        OGCFeature = OGCFeature.replace("MULTIPOINT", "")
    if "POINTM" in OGCFeature:
        OGCFeature = OGCFeature.replace("POINTM", "")
    if "POINT" in OGCFeature:
        OGCFeature = OGCFeature.replace("POINT", "")
    if "NotApplicable" in OGCFeature:
        OGCFeature = OGCFeature.replace("NotApplicable", "")
    if "Z" in OGCFeature:
        OGCFeature = OGCFeature.replace("Z", "")
    if "NONE" in OGCFeature:
        OGCFeature = OGCFeature.replace("NONE", "")
    return OGCFeature.strip()

def e3e(self, f3f: QgsVectorLayer, **myGBL):
    g3g.clear()
    whatIsGoingOn("Started Reading In STT_VectorVector which has " + str(f3f.featureCount()) + " features...")
    fromCRS = f3f.sourceCrs()
    if "invalid" in str(fromCRS):
        QMessageBox.information(None,"localSRID error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
        return
    destCRS = QgsCoordinateReferenceSystem(myGBL['l3l'])
    if "invalid" in str(destCRS):
        QMessageBox.information(None,"l3l error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
        return
    ct = QgsCoordinateTransform(fromCRS, destCRS, QgsProject.instance())
    for f in f3f.getFeatures():
        geom = f.geometry()
        geom.transform(ct)
        # LINESTRING(145.237020396534 -38.1078514961058,145.237020677997 -38.1078515860001)
        newgeomStr = geom.asWkt().upper().replace(" (", "(").replace("LINESTRING(", "").replace(")", "").replace(", ", ",")
        eastNum = float(newgeomStr.split(" ")[0]) + 1000000
        eastStr = str(eastNum) + "000000000000000000000000000"
        eastStr = eastStr[4:24]
        g3g.append(eastStr + "|" + newgeomStr)
    g3g.sort()
    whatIsGoingOn("Finished Reading In STT_VectorVector")
    return len(g3g)


def c3c(x):
    eastNum = x + 1000000
    eastStr = str(eastNum) + "000000000000000000000000000"
    eastStr = eastStr[4:24]
    
    # Do a binary search to get to the start Longitude
    MinI = 1
    MaxI = len(g3g)
    if MaxI > 0:
        Found = 0
        while Found == 0:
            ThisI = int((MinI + MaxI) / 2)
            if eastStr > g3g[ThisI]:
                MinI = ThisI
            elif eastStr < g3g[ThisI]:
                MaxI = ThisI
            elif eastStr == g3g[ThisI]:
                Found = ThisI
            if MaxI - MinI <= 1:
                Found = MinI

        while g3g[Found - 1] > eastStr and Found > 1:
                Found = Found - 1
    return Found

def k3k(x, y, center_x, center_y):
    DiffE = x - center_x
    DiffN = y - center_y
    if abs(DiffN) > 0:
        Bear = math.atan(DiffE / DiffN)
        if DiffN < 0 or DiffE < 0.0:
            if DiffN < 0:
                Bear = Bear + math.pi
            else:
                Bear = Bear + 2 * math.pi
    elif DiffE > 0:
        Bear = math.pi / 2.0#
    else:
        Bear = math.pi * 1.5

    if Bear >= 2 * math.pi:
        Bear = Bear - 2 * math.pi
    return Bear

def d3d(xyStrSSV: str):
    myBear = k3k(float(xyStrSSV.split(" ")[0]), float(xyStrSSV.split(" ")[1]),float(myGBL['FromE']), float(myGBL['FromN']))
    p = [float(xyStrSSV.split(" ")[0]), float(xyStrSSV.split(" ")[1])]
    q = [float(myGBL['FromE']), float(myGBL['FromN'])]
    myDist = math.dist(p, q) *  float(myGBL['ScaleFactor'])
    myBearRad = math.radians(float(myBear) + float(myGBL['RotnDecDeg']))
    x = float(myGBL['ToE']) + math.sin(myBearRad) * float(myDist)
    y = float(myGBL['ToN']) + math.cos(myBearRad) * float(myDist)
    return str(x) + " " + str(y)

def b3b(xyStrSSV: str):
    myBear = k3k(float(xyStrSSV.split(" ")[0]), float(xyStrSSV.split(" ")[1]),float(myGBL['FromE_2']), float(myGBL['FromN_2']))
    p = [float(xyStrSSV.split(" ")[0]), float(xyStrSSV.split(" ")[1])]
    q = [float(myGBL['FromE_2']), float(myGBL['FromN_2'])]
    myDist = math.dist(p, q) *  float(myGBL['a4w'])
    myBearRad = math.radians(float(myBear) + float(myGBL['a4y']))
    x = float(myGBL['ToE_2']) + math.sin(myBearRad) * float(myDist)
    y = float(myGBL['ToN_2']) + math.cos(myBearRad) * float(myDist)
    return str(x) + " " + str(y)

def h3h(xyStrSSV: str):
    xCrd = float(xyStrSSV.split(" ")[0])
    yCrd = float(xyStrSSV.split(" ")[1])
    
    # So at latitude φ an angle of θ radians describes an arc of length M = R θ cos(φ).
    EarthRadius = 6367467.5
    cos_y = math.cos(yCrd / 180 * math.pi)
    # θ = M / (R cos(φ))
    q3q = 100 / (EarthRadius * cos_y) * 180 / math.pi
    r3r = 100 / EarthRadius * 180 / math.pi
    z3d = 0.01 / EarthRadius * 180 / math.pi
    lclSV = list()
    lclnum = 0
    loopnum = 0
    while lclnum < 10 and loopnum < 2:
        loopnum = loopnum + 1
        s3s = xCrd - q3q * loopnum
        t3t = s3s + q3q
        u3u = c3c(s3s)
        w3w = c3c(t3t)
        svPntr = u3u - 1

        while svPntr < w3w:
            svPntr = svPntr + 1
            SVect = g3g[svPntr]
            #  145.237020396534-145.237020396534 -38.1078514961058,145.237020677997 -38.1078515860001)
            geomStr = SVect.split("|")[1]
            fromXY = geomStr.split(",")[0]
            fromY = float(fromXY.split(" ")[1])
            diffX = fromY - yCrd
            if diffX < 0:
                diffX = -diffX
            if diffX < r3r:
                fromX = float(fromXY.split(" ")[0])
                p = [fromX, fromY]
                q = [xCrd, yCrd]
                distXY = math.dist(p, q) + 1000000
                x3x = str(distXY) + "000000000000000000000000000"
                x3x = x3x[4:24]
                lclSV.append(x3x + "|" + geomStr)            
        s3s = xCrd + q3q * loopnum
        t3t = s3s - q3q
        u3u = c3c(s3s)
        w3w = c3c(t3t)
        for x in range(u3u, w3w):
            geomStr = g3g[x].split("|")[1]
            fromXY = geomStr.split(",")[0]
            fromY = float(fromXY.split(" ")[1])
            diffX = fromY - yCrd
            if diffX < 0:
                diffX = -diffX
            if diffX < r3r:
                fromX = float(fromXY.split(" ")[0])
                p = [fromX, fromY]
                q = [xCrd, yCrd]
                distXY = math.dist(p, q) + 1000000
                x3x = str(distXY) + "000000000000000000000000000"
                x3x = x3x[4:24]
                lclSV.append(x3x + "|" + geomStr)            
    lclSV.sort()


    y3y = 0
    z3z = 0
    z3a = 0
    z3b = 0
    for x in range(len(lclSV)):
        if x < 10:
            geomStr = lclSV[x].split("|")[1]
            begXY = geomStr.split(",")[0]
            begX = float(begXY.split(" ")[0])
            begY = float(begXY.split(" ")[1])
            endXY = geomStr.split(",")[1]
            endX = float(endXY.split(" ")[0])
            endY = float(endXY.split(" ")[1])
            p = [begX, begY]
            q = [xCrd, yCrd]
            p3p = math.dist(p, q)
            if p3p < z3d / 10:
                return endXY
            p3p = p3p + z3d
            Variance = 1 / (p3p * p3p)
            y3y = y3y + ((endX - begX) / Variance)
            z3z = z3z + ((endY - begY) / Variance)
            z3a = z3a + (1 / Variance)
            z3b = z3b + 1
    if z3b == 0:
      return xyStrSSV
    aLng = xCrd + y3y / z3a
    aLat = yCrd + z3z / z3a
    return str(aLng) + " " + str(aLat)

def j3j(wktStr: str, routine2Call: int, LclFileName: str):
    try:
        # LINESTRING(145.237020396534 -38.1078514961058, 145.237020677997 -38.1078515860001)
        wktStr = wktStr.replace(", ",",")
        wktUpg = wktStr
        wktStr = StripOGCFeatType(wktStr)
        wktStr = wktStr.replace("),(", " ").replace("(", "").replace(")", "")
        wktStr = wktStr.replace("(", "").replace(")", "").replace(", ", ",")
        wktArr = wktStr.split(",")
        for x in range(len(wktArr)):
            curStr = wktArr[x]
            if routine2Call == 0:
                adjStr = h3h(curStr)
            elif routine2Call == 1:
                adjStr = d3d(curStr)
            elif routine2Call == 2:
                adjStr = b3b(curStr)

            wktUpg = wktUpg.replace("(" + curStr + ")", "(" + adjStr + ")")
            wktUpg = wktUpg.replace("(" + curStr + ",", "(" + adjStr + ",")
            wktUpg = wktUpg.replace("," + curStr + ")", "," + adjStr + ")")
            wktUpg = wktUpg.replace("," + curStr + ",", "," + adjStr + ",")
            wktUpg = wktUpg.replace("(" + curStr + " ", "(" + adjStr + " ") # 3D and M
            wktUpg = wktUpg.replace("," + curStr + " ", "," + adjStr + " ")
        return wktUpg
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(wktUpg)
        return False

def l1l(self, aLayer: QgsVectorLayer, **myGBL):

    f1f(self)

    vl:QgsVectorLayer
    vl = aLayer
    n3n = vl.name().lower().replace(".","_")

    whatIsGoingOn("Started on Vector Theme: " + n3n + " with " + str(vl.featureCount()) + " features...")

    if self.dlg.toolBox_Choice.currentIndex() == 0 and self.dlg.a4j.isChecked:
        n3n = n3n + "_rs"
    elif self.dlg.toolBox_Choice.currentIndex() == 1:
        n3n = n3n + "_tp"
    elif self.dlg.toolBox_Choice.currentIndex() == 2:
        n3n = n3n + "_ltp"
    themeSRID = str(vl.sourceCrs())
    themeSRID = themeSRID.replace("<QgsCoordinateReferenceSystem: ","").replace(">","").replace("EPSG:","")
    if "invalid" in themeSRID:
        QMessageBox.information(None,"themeSRID error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
        return

    l3l = myGBL['l3l'].replace("EPSG:","")
    n2n = myGBL['n2n']
    o2o = myGBL['o2o']
    SQLFileName = os.path.expanduser( '~' ) + "/" +  n2n + "_" + n3n + ".sql"
    myGBL.update({'LogFileName': os.path.expanduser( '~' ) + "/" +  n2n + "_" + n3n + ".txt"}) 

    with open(myGBL['LogFileName'], 'w') as log_file:
        log_file.write("All errors for: " + n2n + "_" + n3n)
        log_file.close

    #if o2o == "Serv" or o2o == "Both":
    if myGBL['n2n'] == "PGS":
        connPGS = i2i(**myGBL)

    if myGBL['n2n'] == "ORA":
        connOra = j2j(**myGBL)
        #connOra.autocommit = True

    if myGBL['n2n'] == "ORD":
        connOrD = k2k(**myGBL)
        #connOra.autocommit = True

    if myGBL['n2n'] == "MSS":
        connDEV = l2l(**myGBL)
        #connDEV.autocommit = True

    with open(SQLFileName, 'w') as outSQL_file:
        
        dateBeg = datetime.datetime.now()
        newTblName = n3n
        if n2n == "PGS":
            newTblName = myGBL['PG_Schema'] + "." + n3n
        if n2n == "MSS" and myGBL['PG_Schema'] != "":
            newTblName = myGBL['PG_Schema'] + "." + n3n

        line = "-- " + n3n + " has " + str(vl.featureCount()) + " features..." + '\n'
        outSQL_file.write(line)
        ncount = 0
        nullcount = 0
        ora2Long = 0
        sqlStr = ""
        insStr = ""
#create schema test123 AUTHORIZATION rogermsu;

        if n2n == "PGS":
            sqlStr = "create schema if not exists " + myGBL['PG_Schema'] + " AUTHORIZATION " + myGBL['PG_Username'] + ";" + '\n'
            sqlStr = sqlStr + "DROP TABLE IF EXISTS " + newTblName + ";" + '\n'
            sqlStr = sqlStr + "CREATE TABLE " + newTblName + "(" + '\n'
            sqlStr = sqlStr + "stid SERIAL NOT NULL," + '\n'
            insStr = "insert into " + newTblName + "(" # stid is allocated by PostGres
        elif n2n == "ORA" or n2n == "ORD":
            sqlStr = sqlStr + "CREATE TABLE " + newTblName + "(" + chr(141)
            sqlStr = sqlStr + "stid NUMBER Primary Key," + chr(141)
            insStr = "insert into " + newTblName + "(" # stid handled as 2nd column
        elif n2n == "MSS":
            sqlStr = "DROP TABLE IF EXISTS " + newTblName + ";" + '\n'
            sqlStr = sqlStr + "CREATE TABLE " + newTblName + "(" + '\n'
            sqlStr = sqlStr + "stid int IDENTITY(1,1) NOT NULL primary key," + '\n'
            insStr = "insert into " + newTblName + "("

        a52 = [field.name() for field in vl.fields()]
        line = ','.join(name for name in a52) + '\n'

        a53 = myGBL['a53']
        gType = "Not Found"
        for v in a53:
            if str(vl.wkbType()) == str(v[2]):
                gType = str(str(v[0]))

        if gType != "Not Found":
            if n2n == "PGS":
                sqlStr = sqlStr + "geom geometry(" + gType + "," + l3l + ")," + '\n'
                insStr = insStr + "geom,"
            elif n2n == "ORA" or n2n == "ORD":
                sqlStr = sqlStr + "geom MDSYS.SDO_GEOMETRY," + chr(141)
                insStr = insStr + "geom,stid,"
            elif n2n == "MSS":
                sqlStr = sqlStr + "geom geography," + '\n'
                insStr = insStr + "geom,"

        for field in vl.fields():

            lc_FldNm = field.name().lower()
            if n2n == "PGS":
                # An "illegal" identifier has to be quoted in Postgres (and SQL).
                # The function format() has a special place holder for identifiers and will return a quoted identifier
                # if anything is non-standard:
                # So select format('%I', 'foo') returns foo.
                # But select format('%I', 'foo bar') returns "foo bar"
                r2r = "select format('%I', '" + lc_FldNm + "')"
                r2r = r2r.replace("%",chr(135) + "%" + chr(135))
                r2r = r2r.replace(chr(135),"'||'")
                lc_FldNm = p1p(r2r, connPGS, myGBL['LogFileName'])

            if field.name().lower() == "stid":
                print("reserved field => Spatial Tapestry ID")
            elif field.typeName() == "Integer64":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " bigint," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " NUMBER(38)," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " bigint," + '\n'
            elif field.typeName() == "Integer32" or field.typeName() == "Integer":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " integer," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " NUMBER(38)," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " int," + '\n'
            elif field.typeName() == "Integer16":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " smallint," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " NUMBER(38)," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " smallint," + '\n'
            elif field.typeName() == "Boolean":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " boolean," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " boolean," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " boolean," + '\n'
            elif field.typeName() == "String":
                if n2n == "PGS": #  + 10 as I have found GPKG strings longer than the field.length
                    sqlStr = sqlStr + lc_FldNm + " varchar(" + str(field.length() + 10) + ")," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " varchar2(" + str(field.length() + 10) + ")," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " varchar(" + str(field.length() + 10) + ")," + '\n'
            elif field.typeName() == "Date":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " date," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " DATE," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " date," + '\n'
            elif field.typeName() == "DateTime":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " timestamp(0) without time zone," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " TIMESTAMP," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " datetime," + '\n'
            elif field.typeName() == "Real" or field.typeName() == "Float":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " real," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " BINARY_FLOAT," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " real," + '\n'
            elif field.typeName() == "Double" or field.typeName() == "Float32":
                if n2n == "PGS":
                    sqlStr = sqlStr + lc_FldNm + " double precision," + '\n'
                elif n2n == "ORA" or n2n == "ORD":
                    sqlStr = sqlStr + lc_FldNm + " BINARY_DOUBLE," + chr(141)
                elif n2n == "MSS":
                    sqlStr = sqlStr + lc_FldNm + " float," + '\n'
            else:
                sqlStr = sqlStr + lc_FldNm + " typeName not handled " + field.typeName() + '\n'

            insStr = insStr + lc_FldNm + ","

        if n2n == "ORA" or n2n == "ORD":
            sqlStr = sqlStr + ")"
            sqlStr = sqlStr.replace("," + chr(141) + ")", ")").replace(chr(141), "")
        else:
            sqlStr = sqlStr + ");"
            sqlStr = sqlStr.replace("," + '\n' + ")", ")")
        if o2o == "File" or o2o == "Both":
            outSQL_file.write(sqlStr.replace(chr(140),";").replace(chr(141),'\n') + '\n')
        insStr = insStr + ") values "
        insStr = insStr.replace(",)", ")")
        if o2o == "Serv" or o2o == "Both":
            if n2n == "PGS":
                e2e(sqlStr, connPGS, myGBL['LogFileName'])
            elif n2n == "ORA":
                # f2f(sqlStr.replace(chr(141),"") + chr(140) + '\n' + "commit" + chr(140) + '\n', connOra, myGBL['LogFileName'])
                f2f("DROP TABLE " + newTblName, connOra, myGBL['LogFileName'])
                f2f(sqlStr, connOra, myGBL['LogFileName'])
                f2f("commit", connOra, myGBL['LogFileName'])
            elif n2n == "ORD":
                g2g("DROP TABLE " + newTblName, connOrD, myGBL['LogFileName'])
                g2g(sqlStr, connOrD, myGBL['LogFileName'])
                g2g("commit", connOrD, myGBL['LogFileName'])
            elif n2n == "MSS":
                # h2h("create schema " + myGBL['PG_Schema'] + " AUTHORIZATION " + myGBL['PG_Username'] + ";", connDEV, myGBL['LogFileName'])
                h2h(sqlStr, connDEV, myGBL['LogFileName'])

        t2t = ""
        fromCRS = vl.sourceCrs()
        if self.dlg.toolBox_Choice.currentIndex() == 2:
            fromCRS = QgsCoordinateReferenceSystem(myGBL['m3m'])
        if "invalid" in str(fromCRS):
            QMessageBox.information(None,"m3m error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
            return
        destCRS = QgsCoordinateReferenceSystem(myGBL['l3l'])
        if "invalid" in myGBL['l3l']:
            QMessageBox.information(None,"l3l error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
            return
        ct = QgsCoordinateTransform(fromCRS, destCRS, QgsProject.instance())

        whatIsGoingOn("QgsCoordinateTransform: From " + str(fromCRS).replace("<QgsCoordinateReferenceSystem: ","").replace(">","") + " To " + str(destCRS).replace("<QgsCoordinateReferenceSystem: ","").replace(">",""))

        abc = self.dlg.a44.text().replace("("," ").replace(")"," ").replace(" million","000000").split(" ")
        efg = float(abc[3])
        for f in vl.getFeatures():
            ncount = ncount + 1
            if ncount == 1 or ncount == 10 or ncount == 100 or ncount == 500 or str(ncount).endswith("000"):
                whatIsGoingOn(newTblName + ": " +str(ncount) + "/" + str(vl.featureCount()))
            if ncount <= efg:
                geom = f.geometry()
                if self.dlg.toolBox_Choice.currentIndex() != 2:
                    geom.transform(ct)
                geom_asWkt = geom.asWkt()

                if geom_asWkt == "":
                    geom_asWkt = "NULL"
                    nullcount = nullcount + 1
                if self.dlg.toolBox_Choice.currentIndex() == 0 and self.dlg.a4j.isChecked:
                    geom_asWkt = j3j(geom_asWkt, 0, myGBL['LogFileName'])
                elif self.dlg.toolBox_Choice.currentIndex() == 1:
                    geom_asWkt = j3j(geom_asWkt, 1, myGBL['LogFileName'])
                elif self.dlg.toolBox_Choice.currentIndex() == 2:
                    geom_asWkt = j3j(geom_asWkt, 2, myGBL['LogFileName'])
                    featT = QgsFeature()
                    featT.setGeometry( QgsGeometry.fromWkt(geom_asWkt))
                    geomT = featT.geometry()
                    geomT.transform(ct)
                    geom_asWkt = geomT.asWkt()

                geoStr = "NULL"
                if n2n == "ORA" or n2n == "ORD":
                    geoStr = "NULL," + str(ncount)
                # print (geom.asWkb())
                # geomTyp = geom.wkbType()
                didBind = False
                if (n2n == "ORA" or n2n == "ORD") and len(geom_asWkt) > 4000:
                    # too long for Oracle's varchar2 client side (4000 chars) so use server side binding (327?? chars)
                    if len(geom_asWkt) > 32700:
                        ora2Long = ora2Long + 1
                    didBind = True
                    o2o = "/" + chr(141)
                    o2o = o2o + "declare" + chr(141)
                    o2o = o2o + " v_sql varchar2(" + str(len(geom_asWkt) + len(newTblName) + 150) + ")" + chr(140) + chr(141)
                    o2o = o2o + " v_clob clob" + chr(140) + chr(141)
                    o2o = o2o + "begin" + chr(141)
                    o2o = o2o + "  v_clob := CAST('" + geom_asWkt + "' as clob)" + chr(140) + chr(141)
                    o2o = o2o + "  v_sql := 'insert into " + newTblName + " (stid,geom) values(:id,sdo_util.from_wktgeometry(:clob))'" + chr(140) + chr(141)
                    o2o = o2o + "  execute immediate v_sql" + chr(141)
                    o2o = o2o + "  using " + str(ncount) + ", v_clob" + chr(140) + chr(141)
                    o2o = o2o + "  commit" + chr(140) + chr(141)
                    o2o = o2o + "end" + chr(140) + chr(141)
                    o2o = o2o + "/" + chr(141)

                    if o2o == "File" or o2o == "Both":
                        outSQL_file.write(o2o.replace(chr(140),";").replace(chr(141),'\n'))
                    if o2o == "Serv" or o2o == "Both":
                        if n2n == "ORA":
                            f2f(o2o.replace(chr(140)," ").replace(chr(141)," "), connOra, myGBL['LogFileName'])
                        if n2n == "ORD":
                            g2g(o2o.replace(chr(140)," ").replace(chr(141)," "), connOrD, myGBL['LogFileName'])

                    s2s = "update " + newTblName + " set " + chr(141)
                    for field in vl.fields():
                        lc_FldNm = field.name().lower()
                        if str(f[field.name()]) == "NULL":
                            nullComment = "do not update"
                        elif field.typeName() == "Integer64":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer32" or field.typeName() == "Integer":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer16":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Boolean":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "String":
                            # specChar = "( ) - & @ * $ | % "
                            r2r = str(f[field.name()]).replace("'","''").replace(chr(34),chr(134))
                            r2r = r2r.replace("(",chr(135) + "(" + chr(135))
                            r2r = r2r.replace(")",chr(135) + ")" + chr(135))
                            r2r = r2r.replace("-",chr(135) + "-" + chr(135))
                            r2r = r2r.replace(".",chr(135) + "." + chr(135))
                            r2r = r2r.replace("&",chr(135) + "&" + chr(135))
                            r2r = r2r.replace("@",chr(135) + "@" + chr(135))
                            r2r = r2r.replace("*",chr(135) + "*" + chr(135))
                            r2r = r2r.replace("$",chr(135) + "$" + chr(135))
                            r2r = r2r.replace("|",chr(135) + "|" + chr(135))
                            r2r = r2r.replace("%",chr(135) + "%" + chr(135))
                            r2r = r2r.replace(chr(135),"'||'")
                            r2r = r2r.replace(chr(134),"'||'" + chr(34) + "'||'")
                            if len(r2r) > field.length():
                                r2r = r2r[0: field.length()]
                            s2s = s2s + lc_FldNm + "='" + r2r + "',"
                        elif field.typeName() == "Date":
                            DATETIME_FORMAT = 'yyyy-MM-dd'
                            qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDate","")
                            qd8 = qd8.replace(", ", "/").replace("(","").replace(")","")
                            s2s = s2s + lc_FldNm + "=" + "TO_DATE('" + qd8 + "', 'YYYY/MM/DD'),"
                        elif field.typeName() == "DateTime":
                            DATETIME_FORMAT = 'yyyy-MM-dd HH:mm:ss'
                            qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDateTime(","").replace(")","")
                            qd8 = qd8.replace(", ", "-")
                            qd8Arr = qd8.split("-")
                            # TO_DATE('2008-11-18 14:13:59', 'YYYY-MM-DD HH24:Mi:SS')
                            qd8 = qd8Arr[0] + "-" + qd8Arr[1] + "-" + qd8Arr[2]
                            if len(qd8Arr) > 3:
                                qd8 = qd8 + " " + qd8Arr[3]
                            else:
                                qd8 = qd8 + " 0"
                            if len(qd8Arr) > 4:
                                qd8 = qd8 + ":" + qd8Arr[4]
                            else:
                                qd8 = qd8 + ":0"
                            if len(qd8Arr) > 5:
                                qd8 = qd8 + ":" + qd8Arr[5]
                            else:
                                qd8 = qd8 + ":0"
                            s2s = s2s + lc_FldNm + "=" + "TO_DATE('" + qd8 + "', 'YYYY-MM-DD HH24:Mi:SS'),"                            
                        elif field.typeName() == "Real" or field.typeName() == "Float":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                        elif field.typeName() == "Double" or field.typeName() == "Float32":
                            s2s = s2s + lc_FldNm + "=" + str(f[field.name()]) + ","
                
                    s2s = s2s + ") where stid=" + str(ncount)
                    s2s = s2s.replace(",)", "")
                    if o2o == "File" or o2o == "Both":
                        outSQL_file.write(s2s + ";" + '\n')
                    if o2o == "Serv" or o2o == "Both":
                        if n2n == "ORA":
                            f2f(s2s, connOra, myGBL['LogFileName'])
                            f2f("commit", connOra, myGBL['LogFileName'])
                        if n2n == "ORD":
                            g2g(s2s, connOrD, myGBL['LogFileName'])
                            g2g("commit", connOrD, myGBL['LogFileName'])

                elif geom_asWkt != "" and geom_asWkt != "NULL":
                    if n2n == "PGS":
                        geoStr = "st_setSRID(ST_GeomFromText('" + geom_asWkt + "')," + l3l + ")"
                    elif n2n == "ORA" or n2n == "ORD":
                        geoStr = "SDO_UTIL.FROM_WKTGEOMETRY('" + geom_asWkt + "')," + str(ncount)
                    elif n2n == "MSS":
                        geoStr = "geography::STGeomFromText('" + geom_asWkt + "'," + l3l + ")"
    
                if didBind == False:
                    t2t = t2t + "(" + geoStr + ","
                    for field in vl.fields():
                        if field.typeName() == "Integer64":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer32" or field.typeName() == "Integer":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Integer16":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Boolean":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "String":
                            if n2n == "ORA" or n2n == "ORD":
                            # specChar = "( ) - & @ * $ | % "
                                r2r = str(f[field.name()]).replace("'","''").replace(chr(34),chr(134))
                                r2r = r2r.replace("(",chr(135) + "(" + chr(135))
                                r2r = r2r.replace(")",chr(135) + ")" + chr(135))
                                r2r = r2r.replace("-",chr(135) + "-" + chr(135))
                                r2r = r2r.replace(".",chr(135) + "." + chr(135))
                                r2r = r2r.replace("&",chr(135) + "&" + chr(135))
                                r2r = r2r.replace("@",chr(135) + "@" + chr(135))
                                r2r = r2r.replace("*",chr(135) + "*" + chr(135))
                                r2r = r2r.replace("$",chr(135) + "$" + chr(135))
                                r2r = r2r.replace("|",chr(135) + "|" + chr(135))
                                r2r = r2r.replace("%",chr(135) + "%" + chr(135))
                                r2r = r2r.replace(chr(135),"'||'")
                                r2r = r2r.replace(chr(134),"'||'" + chr(34) + "'||'")
                                if len(r2r) > field.length():
                                    r2r = r2r[0: field.length()]
                                t2t = t2t + "'" + r2r + "',"
                            else:
                                curStr = str(f[field.name()]).replace("'","''")
                                if len(curStr) > field.length():
                                    curStr = curStr[0: field.length()]
                                t2t = t2t + "'" + curStr + "',"
                        elif field.typeName() == "Date":
                            # t2t = t2t + "'" + format_date(f[field.name()],DATETIME_FORMAT) + "',"
                            DATETIME_FORMAT = 'yyyy-MM-dd'
                            # QgsExpression('format_date(f[field.name()], DATETIME_FORMAT)').evaluate(ctx)
                            # 'PyQt5.QtCore.QDate(1999, 10, 1)'
                            if str(f[field.name()]) == "NULL":
                                t2t = t2t + "NULL,"
                            else:
                                qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDate","")
                                if n2n == "PGS" or n2n == "MSS":
                                    qd8 = qd8.replace(", ", "-")
                                    if n2n == "MSS":
                                        qd8 = qd8.replace("(", "").replace(")", "")
                                    t2t = t2t + "'" + qd8 + "',"
                                elif n2n == "ORA" or n2n == "ORD":
                                    qd8 = qd8.replace(", ", "/").replace("(","").replace(")","")
                                    t2t = t2t + "TO_DATE('" + qd8 + "', 'YYYY/MM/DD'),"                            
                        elif field.typeName() == "DateTime":
                            # buildtime:QgsDateTimeFieldFormatter
                            DATETIME_FORMAT = 'yyyy-MM-dd HH:mm:ss'
                            # t2t = t2t + "'" + format_date(f[field.name()],DATETIME_FORMAT) + "',"
                            if str(f[field.name()]) == "NULL":
                                t2t = t2t + "NULL,"
                            else:
                                # PyQt5.QtCore.QDateTime(2020, 8, 28, 12, 39, 52, 360)
                                # t2t = t2t + str(f[field.name()]) + ","
                                # "yyyy/mm/dd HH:mm:ss"
                                qd8 = str(f[field.name()]).replace("PyQt5.QtCore.QDateTime(","").replace(")","")
                                qd8 = qd8.replace(", ", "-")
                                qd8Arr = qd8.split("-")
                                if n2n == "PGS" or n2n == "MSS":
                                    qd8 = qd8Arr[0] + "-" + qd8Arr[1] + "-" + qd8Arr[2]
                                    if len(qd8Arr) > 3:
                                        qd8 = qd8 + " " + qd8Arr[3]
                                    if len(qd8Arr) > 4:
                                        qd8 = qd8 + ":" + qd8Arr[4]
                                    if len(qd8Arr) > 5:
                                        qd8 = qd8 + ":" + qd8Arr[5]
                                    if len(qd8Arr) > 6:
                                        qd8 = qd8 + "." + qd8Arr[6]
                                    t2t = t2t + "'" + qd8 + "',"

                                elif n2n == "ORA" or n2n == "ORD":
                                    # TO_DATE('2008-11-18 14:13:59', 'YYYY-MM-DD HH24:Mi:SS')
                                    qd8 = qd8Arr[0] + "-" + qd8Arr[1] + "-" + qd8Arr[2]
                                    if len(qd8Arr) > 3:
                                        qd8 = qd8 + " " + qd8Arr[3]
                                    else:
                                        qd8 = qd8 + " 0"
                                    if len(qd8Arr) > 4:
                                        qd8 = qd8 + ":" + qd8Arr[4]
                                    else:
                                        qd8 = qd8 + ":0"
                                    if len(qd8Arr) > 5:
                                        qd8 = qd8 + ":" + qd8Arr[5]
                                    else:
                                        qd8 = qd8 + ":0"
                                    t2t = t2t + "TO_DATE('" + qd8 + "', 'YYYY-MM-DD HH24:Mi:SS'),"                            

                        elif field.typeName() == "Real" or field.typeName() == "Float":
                            t2t = t2t + str(f[field.name()]) + ","
                        elif field.typeName() == "Double" or field.typeName() == "Float32":
                            t2t = t2t + str(f[field.name()]) + ","
                        else:
                            t2t = t2t + "new field type:" + field.typeName() 
                
                    t2t = t2t + ")"
                    # Finished looping through the fields of the current feature/record

                    # do we save these records??? Depends, lol
                    if n2n == "PGS":
                        # format up a set of records once it is big enough
                        if len(t2t) > 50000:
                            t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(st_setSRID", ")," + '\n' + "(st_setSRID")
                            t2t = t2t.replace(")(st_transform", ")," + '\n' + "(st_transform")
                            t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                            if o2o == "File" or o2o == "Both":
                                outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                            if o2o == "Serv" or o2o == "Both":
                                e2e(insStr + t2t, connPGS, myGBL['LogFileName'])
                            t2t = ""
                    elif n2n == "ORA" or n2n == "ORD":
                        # could not sort out how to insert multiple records per insert
                        if len(t2t) > 0:
                            t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(SDO_UTIL", ")," + '\n' + "(SDO_UTIL")
                            t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                            if o2o == "File" or o2o == "Both":
                                outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                            if o2o == "Serv" or o2o == "Both":
                                if n2n == "ORA":
                                    f2f(insStr + t2t.replace('\n',""), connOra, myGBL['LogFileName'])
                                if n2n == "ORD":
                                    g2g(insStr + t2t.replace('\n',"") + ";", connOrD, myGBL['LogFileName'])
                            t2t = ""
                    elif n2n == "MSS":
                        # could not sort out how to insert multiple records per insert
                        if len(t2t) > 0:
                            t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(geography", ")," + '\n' + "(geography")
                            t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                            if o2o == "File" or o2o == "Both":
                                outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                            if o2o == "Serv" or o2o == "Both":
                                h2h(insStr + t2t, connDEV, myGBL['LogFileName'])
                        t2t = ""


        # last group of records
        if n2n == "PGS":
            if len(t2t) > 0:
                t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(st_setSRID", ")," + '\n' + "(st_setSRID")
                t2t = t2t.replace(")(st_transform", ")," + '\n' + "(st_transform")
                t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                if o2o == "File" or o2o == "Both":
                    outSQL_file.write(insStr + '\n' + t2t + '\n')
                if o2o == "Serv" or o2o == "Both":
                    e2e(insStr + t2t, connPGS, myGBL['LogFileName'])
            t2t = ""
        elif n2n == "ORA" or n2n == "ORD":
            if len(t2t) > 0:
                t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(SDO_UTIL", ")," + '\n' + "(SDO_UTIL")
                t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                if o2o == "File" or o2o == "Both":
                    outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                if o2o == "Serv" or o2o == "Both":
                    if n2n == "ORA":
                        f2f(insStr + t2t, connOra, myGBL['LogFileName'])
                        f2f("commit", connOra, myGBL['LogFileName'])
                    if n2n == "ORD":
                        g2g(insStr + t2t, connOrD, myGBL['LogFileName'])
                        g2g("commit", connOrD, myGBL['LogFileName'])
                t2t = ""
        elif n2n == "MSS":
            if len(t2t) > 0:
                t2t = t2t.replace(",)", ")").replace("'NULL'", "NULL").replace(")(geography", ")," + '\n' + "(geography")
                t2t = t2t.replace(")(NULL", ")," + '\n' + "(NULL")
                if o2o == "File" or o2o == "Both":
                    outSQL_file.write(insStr + '\n' + t2t + ";" + '\n')
                if o2o == "Serv" or o2o == "Both":
                    h2h(insStr + t2t, myGBL['LogFileName'])
                t2t = ""

        if n2n == "PGS":
            pgsSQL = "CREATE INDEX " + newTblName.replace(".","_") + "_spidx ON " + newTblName 
            pgsSQL = pgsSQL +" USING gist(geom);" + '\n'
            if o2o == "File" or o2o == "Both":
                outSQL_file.write(";" + '\n' + pgsSQL + '\n')
            if o2o == "Serv" or o2o == "Both":
                e2e(pgsSQL + ";", connPGS, myGBL['LogFileName'])

        if n2n == "ORA" or n2n == "ORD":
            oraSQL = "UPDATE " + newTblName + " T SET T.geom.SDO_SRID = " + themeSRID
            oraSQL = oraSQL +" WHERE T.geom IS NOT NULL"

            if o2o == "File" or o2o == "Both":
                outSQL_file.write(";" + '\n' + oraSQL + ";" + '\n' + "commit;" + '\n')
            if o2o == "Serv" or o2o == "Both":
                if n2n == "ORA":
                    f2f(oraSQL, connOra, myGBL['LogFileName'])
                    f2f("commit", connOra, myGBL['LogFileName'])
                if n2n == "ORD":
                    g2g(oraSQL, connOrD, myGBL['LogFileName'])
                    g2g("commit", connOrD, myGBL['LogFileName'])

            oraSQL = oraSQL + "-- CREATE INDEX " + newTblName.replace(".","_") + "_spidx ON " + newTblName + " (geom)"
            oraSQL = oraSQL + " INDEXTYPE IS MDSYS.SPATIAL_INDEX_V2"

            if o2o == "File" or o2o == "Both":
                outSQL_file.write(";" + '\n' + oraSQL + ";" + '\n' + "commit;" + '\n')
            if o2o == "Serv" or o2o == "Both":
                if n2n == "ORA":
                    f2f(oraSQL, connOra, myGBL['LogFileName'])
                    f2f("commit", connOra, myGBL['LogFileName'])
                if n2n == "ORD":
                    g2g(oraSQL, connOrD, myGBL['LogFileName'])
                    g2g("commit", connOrD, myGBL['LogFileName'])

        if n2n == "MSS":
            mssSQL = "CREATE SPATIAL INDEX " + newTblName.replace(".","_") + "_geom_spidx ON " + newTblName + "(geom);" + '\n'
            if o2o == "File" or o2o == "Both":
                outSQL_file.write(mssSQL + '\n')
            if o2o == "Serv" or o2o == "Both":
                h2h(mssSQL + ";", connDEV, myGBL['LogFileName'])

        with open(os.path.expanduser( '~' ) + "/log._ImportThemeReport", 'a') as ImpLog_file:
            line = "-- " + newTblName + " has " + str(vl.featureCount()) + " features, with " + str(ncount) + " processed."
            ImpLog_file.write(line + '\n')

            if o2o == "Serv" or o2o == "Both":
                retCount = "?"
                if n2n == "PGS":
                    retCount = p1p("select count(*) from " + newTblName, connPGS, myGBL['LogFileName'])

                if n2n == "ORA":
                    retCount = q1q("select count(*) from " + newTblName, connOra, myGBL['LogFileName'])
                    if ora2Long > 0:
                        line = "-- *** Warning: " + newTblName + " has " + str(ora2Long) + " features that were not loaded as their geometries were too long (Over 32700 Characters)."
                        ImpLog_file.write(line + '\n')

                if n2n == "ORD":
                    retCount = r1r("select count(*) from " + newTblName, connOrD, myGBL['LogFileName'])
                    if ora2Long > 0:
                        line = "-- *** Warning: " + newTblName + " has " + str(ora2Long) + " features that were not loaded as their geometries were too long (Over 32700 Characters)."
                        ImpLog_file.write(line + '\n')

                if n2n == "MSS":
                    retCount = s1s("select count(*) from " + newTblName, connDEV, myGBL['LogFileName'])

                if retCount == "None":
                    ImpLog_file.write("An error occured getting Count(*) from " + newTblName + '\n')
                else:
                    line = "-- " + newTblName + " has " + retCount + " features saved."
                    line = line.replace("(","").replace(",)","") 
                    ImpLog_file.write(line + '\n')

            dateEnd = datetime.datetime.now()
            diffDate = (dateEnd - dateBeg).total_seconds()
            line = "Started at: " + str(dateBeg) + " and Finished at: " + str(dateEnd)
            ImpLog_file.write(line + '\n')
            if diffDate > 1:
                line = "Approx Records/Second: " + str(int(vl.featureCount() / diffDate))
                ImpLog_file.write(line + '\n')

            log_file.close
            ImpLog_file.close
            if o2o == "Serv":
                outSQL_file.close
                os.remove(SQLFileName)

        newText = n3n + ": " + str(nullcount) + "\n"
        oldText = self.dlg.textEdit.toPlainText()
        if nullcount > 0:
            #QMessageBox.information(None,"Warning, NULL Geometries Found!", newText, QMessageBox.Ok, QMessageBox.Ok)
            whatIsGoingOn(newText)
            self.dlg.textEdit.setPlainText(newText + oldText)
        else:
            self.dlg.textEdit.setPlainText(oldText + newText)
        whatIsGoingOn("Output file written at " + SQLFileName)
        self.iface.messageBar().pushMessage("Success", "Output file written at " + SQLFileName, level=Qgis.Success, duration=5)

    return None


def e2e(sql2Run: str, connPGS: psycopg2, LclFileName: str):
    try:
        cursor = connPGS.cursor()
        cursor.execute(sql2Run)
        connPGS.commit() 
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def p1p(sql2Run: str, connPGS: psycopg2, LclFileName: str):
    a = y1y(sql2Run, connPGS, LclFileName)
    return str(a[0][0]) if a else "None"

def y1y(sql2Run: str, connPGS: psycopg2, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connPGS.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, psycopg2.DatabaseError) as error:
        with open(LclFileName, 'a') as log_file:
            log_file.write(sql2Run + '\n')
            log_file.write(str(type(error)) + '\n')
            error_obj = error.args
            log_file.write(str(error_obj) + '\n')
            log_file.close
    #finally:
    #    if connPGS is not None:
    #        connPGS.close()
    return retArr

def f2f(sql2Run: str, connORA: oracledb, LclFileName: str):
    try:

        cursor = connORA.cursor()
        if "drop table" in sql2Run.lower():
            with cursor.suppress(Exception):
                cursor.execute(sql2Run)
            return True

        if chr(140) in sql2Run:
            sqlArr = sql2Run.replace(chr(140),"").split('\n')
            for aSQL in sqlArr:
                cursor.execute(aSQL)
        else:
            cursor.execute(sql2Run)
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def q1q(sql2Run: str, connORA: oracledb, LclFileName: str):
    a = z1z(sql2Run, connORA, LclFileName)
    return str(a[0][0]) if a else "None"

def z1z(sql2Run: str, connORA: oracledb, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connORA.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, oracledb.DatabaseError) as error:
        with open(LclFileName, 'a') as log_file:
            log_file.write(sql2Run + '\n')
            log_file.write(str(type(error)) + '\n')
            error_obj = error.args
            log_file.write(str(error_obj) + '\n')
            log_file.close
    #finally:
    #    if connORA is not None:
    #        connORA.close()
    return retArr

def g2g(sql2Run: str, connORD: pyodbc, LclFileName: str):
    try:
        cursor = connORD.cursor()
        if "drop table" in sql2Run.lower():
            with cursor.suppress(Exception):
                cursor.execute(sql2Run)
            return True

        if chr(140) in sql2Run:
            sqlArr = sql2Run.replace(chr(140),"").split('\n')
            for aSQL in sqlArr:
                if len(aSQL) > 5:
                    cursor.execute(aSQL)
        else:
            cursor.execute(sql2Run)
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def r1r(sql2Run: str, connORD: pyodbc, LclFileName: str):
    a = a2a(sql2Run, connORD, LclFileName)
    return str(a[0][0]) if a else "None"

def a2a(sql2Run: str, connORD: pyodbc, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connORD.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, oracledb.DatabaseError) as error:
        with open(LclFileName, 'a') as log_file:
            log_file.write(sql2Run + '\n')
            log_file.write(str(type(error)) + '\n')
            error_obj = error.args
            log_file.write(str(error_obj) + '\n')
            log_file.close
    #finally:
    #    if connORD is not None:
    #        connORD.close()
    return retArr

def h2h(sql2Run: str, MSSconn: pyodbc, LclFileName: str):
    try:
        cursor = MSSconn.cursor()
        cursor.execute(sql2Run)
        MSSconn.commit() 
        return True
    except Exception as error:
        whatIsGoingOn("Oops! An exception has occured: " + str(error) + ", Exception TYPE: " + str(type(error)))
        whatIsGoingOn(str(error.args))
        whatIsGoingOn(sql2Run)
        return False

def s1s(sql2Run: str, connDEV: pyodbc, LclFileName: str):
    a = b2b(sql2Run, connDEV, LclFileName)
    return str(a[0][0]) if a else "None"

def b2b(sql2Run: str, connDEV: pyodbc, LclFileName: str):
    # Querying data using fetchone() method
    retArr = []
    try:
        cur = connDEV.cursor()
        cur.execute(sql2Run)
        #print("The number of rows: ", cur.rowcount)
        row = cur.fetchone()

        while row is not None:
            # print(row)
            retArr.append(row)
            row = cur.fetchone()

        cur.close()
        return retArr
    except (Exception, pyodbc.DatabaseError) as error:
        with open(LclFileName, 'a') as log_file:
            log_file.write(sql2Run + '\n')
            log_file.write(str(type(error)) + '\n')
            error_obj = error.args
            log_file.write(str(error_obj) + '\n')
            log_file.close
    #finally:
    #    if connDEV is not None:
    #        connDEV.close()
    return retArr


def i2i(**myGBL):
    return psycopg2.connect(
        host=myGBL['PG_IPAddress'],
        database=myGBL['PG_DBName'],
        user=myGBL['PG_Username'],
        password=myGBL['PG_Password'],
        port=myGBL['PG_Port'])
    # connPGS.autocommit = True
    

def j2j(**myGBL):
    params = oracledb.ConnectParams(host=myGBL['PG_IPAddress'], port=myGBL['PG_Port'], service_name=myGBL['PG_DBName'])
    return oracledb.connect(user=myGBL['PG_Username'], password=myGBL['PG_Password'], params=params)
    
def k2k(**myGBL):
    p2p = "DRIVER={Devart ODBC Driver for Oracle};Direct=True;Host=myServer;Service Name=myServiceName;UserID=myUsername;Port=myPort;Password=myPassword"
    p2p = p2p.replace("myServer", myGBL['PG_IPAddress'])
    p2p = p2p.replace("myServiceName", myGBL['PG_DBName'])
    p2p = p2p.replace("myPort", myGBL['PG_Port'])
    p2p = p2p.replace("myUsername", myGBL['PG_Username'])
    p2p = p2p.replace("myPassword", myGBL['PG_Password'])
    return pyodbc.connect(p2p)

def l2l(**myGBL):
    p2p = "DRIVER={Devart ODBC Driver for SQL Server};Server=myserver;Database=mydatabase;Port=myport;User ID=myuserid;Password=mypassword"
    p2p = p2p.replace("myserver", myGBL['PG_IPAddress'])
    p2p = p2p.replace("mydatabase", myGBL['PG_DBName'])
    p2p = p2p.replace("myport", myGBL['PG_Port'])
    p2p = p2p.replace("myuserid", myGBL['PG_Username'])
    p2p = p2p.replace("mypassword", myGBL['PG_Password'])
    return pyodbc.connect(p2p)

def f1f(self):
    x1x(self)
    try:
        with open(myGBL['ConFileName'], 'w') as conf_file:
            line = 'host=' + self.dlg.PG_IPAddress.text() + '\n'
            line = line + 'database=' + self.dlg.PG_DBName.text() + '\n'
            line = line + 'user=' + self.dlg.PG_Username.text() + '\n'
            line = line + 'password=' + self.dlg.PG_Password.text() + '\n'
            line = line + 'port=' + self.dlg.PG_Port.text() + '\n'
            line = line + 'schemaname=' + self.dlg.a4x.text() + '\n'
            l3l = str(self.dlg.mQgsProjectionSelectionWidget_Table.crs())
            l3l = l3l.replace("<QgsCoordinateReferenceSystem: ","").replace(">","")
            line = line + 'l3l=' + l3l + '\n'
            line = line + 'n2n=' + myGBL['n2n'] + '\n'
            line = line + 'o2o=' + myGBL['o2o'] + '\n'
            line = line + 'FromE=' + self.dlg.tb_FromE.text() + '\n'
            line = line + 'FromN=' + self.dlg.tb_FromN.text() + '\n'
            line = line + 'ToE=' + self.dlg.tb_ToE.text() + '\n'
            line = line + 'ToN=' + self.dlg.tb_ToN.text() + '\n'
            line = line + 'RotnDecDeg=' + self.dlg.tb_RotnDecDeg.text() + '\n'
            line = line + 'ScaleFactor=' + self.dlg.tb_ScaleFactor.text() + '\n'
            line = line + 'FromE_2=' + self.dlg.tb_FromE_2.text() + '\n'
            line = line + 'FromN_2=' + self.dlg.tb_FromN_2.text() + '\n'
            line = line + 'ToE_2=' + self.dlg.tb_ToE_2.text() + '\n'
            line = line + 'ToN_2=' + self.dlg.tb_ToN_2.text() + '\n'
            line = line + 'a4y=' + self.dlg.tb_a4y.text() + '\n'
            line = line + 'a4w=' + self.dlg.tb_a4w.text() + '\n'
            localSRID = str(self.dlg.mQgsProjectionSelectionWidget_LclXY.crs())
            localSRID = localSRID.replace("<QgsCoordinateReferenceSystem: ","").replace(">","")
            line = line + 'localSRID=' + localSRID + '\n'
            line = line + 'LxmlFile=' + self.dlg.uXmlFile.text() + '\n'
            if self.dlg.listWidget.currentRow() >= 0:
                line = line + 'LxmlMonu=' + self.dlg.listWidget.currentItem().text() + '\n'
            else:
                line = line + 'LxmlMonu=\n'
            line = line + 'ToE_3=' + self.dlg.a58.text() + '\n'
            line = line + 'ToN_3=' + self.dlg.a59.text() + '\n'
            line = line + 'RotnDecDeg_3=' + self.dlg.a4r.text() + '\n'
            line = line + 'ScaleFactor_3=' + self.dlg.a4m.text() + '\n'
            a57 = str(self.dlg.mQgsProjectionSelectionWidget_LXMLXY.crs())
            a57 = a57.replace("<QgsCoordinateReferenceSystem: ","").replace(">","")
            line = line + 'a57=' + a57 + '\n'

            conf_file.write(line)
            conf_file.close()

        self.iface.messageBar().pushMessage("Success", "Output file written at " + myGBL['ConFileName'], level=Qgis.Success, duration=5)

    except Exception as err:
        QMessageBox.information(None, "Failure", err, QMessageBox.Ok, QMessageBox.Ok)

def create_Tables(self, **myGBL):
    a4z = ["dest_landbase.sql",
                   "dest_point.sql",
                   "srce_landbase.sql",
                   "srce_point.sql",
                   "stt_csbbdysections.sql",
                   "stt_dp_cgpoint.sql",
                   "stt_dp_easement.sql",
                   "stt_dp_feature.sql",
                   "stt_dp_monument.sql",
                   "stt_dp_parcel.sql",
                   "stt_dp_surveyline.sql", 
                   "stt_error_log.sql",
                   "stt_paatwarequest.sql",
                   "stt_plandata.sql",
                   "stt_probfeats.sql",
                   "stt_shift_vect_request.sql",
                   "stt_straighlines.sql",
                   "stt_superblock_dst.sql",
                   "stt_superblock_src.sql",
                   "stt_themedata.sql",
                   "stt_twa_xover.sql",
                   "stt_vectorcgpoint.sql",
                   "stt_vectorpositionequ.sql",
                   "stt_vectorraster.sql",
                   "stt_vectorvector.sql",
                   "stt_vv_import_probs.sql",
                   "stt_tempworkarea.sql"]
 
    o2o = myGBL['o2o']
    if o2o == "Serv" or o2o == "Both":
        connPGS = i2i(**myGBL)
    myGBL.update({'LogFileName': os.path.expanduser( '~' ) + "/Creating_Schema_and_tables.txt"}) 
    a54 = plugin_paths[0] 
    wT = self.dlg.windowTitle()
    if "_DE" in wT:
        a54 = a54 + "/my_landXML_Dev"
    if "_Fr" in wT:
        a54 = a54 + "/landXMLtoDB_Free"
    if "_Pa" in wT:
        a54 = a54 + "/landXMLtoDB_Paid"
    if "_Fu" in wT:
        a54 = a54 + "/landXMLtoDB_Full"
    a54 = a54 + "/stt_sql/"
    e2e("create schema if not exists " + myGBL['PG_Schema'], connPGS, myGBL['LogFileName'])

    for a56 in a4z:
        with open(a54 + a56, 'r') as input_file:
            lines = input_file.readlines()

        if "xxSchemaxx" not in str(lines):
            QMessageBox.information(None, "SQL File is missing Schema:", "xxSchemaxx\n" + a54 + "\n" + a56, QMessageBox.Ok, QMessageBox.Ok)
        sqlStr = str(lines).replace("xxSchemaxx", myGBL['PG_Schema']).replace('\\n', '\n').replace('\\t', '\t')
        sqlStr = sqlStr.replace("', '","").replace("', \"","").replace("\", '","").replace("\", \"","")
        sqlStr = sqlStr.replace("OIDS = TRUE","OIDS = FALSE")
        sqlStr = sqlStr.replace(",xxxx)","," + myGBL['l3l'].replace("EPSG:","") + ")")
        sqlStr = sqlStr[2:-2]

        e2e(sqlStr, connPGS, myGBL['LogFileName'])
        input_file.close

    print ("done")
    return None


def a4p(aLayer: QgsVectorLayer, rowNo: int, **myGBL):
    
  try:

    if rowNo < 0:
      sqlstr = "Delete from " + myGBL['PG_Schema'] + ".stt_themedata"
      e2e(sqlstr, connPGS, myGBL['LogFileName'])

    else:
      vl:QgsVectorLayer
      vl = aLayer

      sqlstr = "Insert into " + myGBL['PG_Schema'] + ".stt_themedata ("
      sqlstr = sqlstr + "rowno,gpkg_sql,IPAddress,DatabaseName,schemaname,UserName,UserPassword,DBPort,ThemeName,ThemeUidCol,ConnectionType,OrigGeomFldName,AdjGeomFldName,GeometryType,use_st_overlaps,"
      sqlstr = sqlstr + "ScaledObject,RigidObject,Adjustable,ReportStats,SnapToSnapToThemes,IsATargetSnapTheme,MaintainStraightLines,straightenthelines,StraightLineTolCM,themetype,"
      sqlstr = sqlstr + "srceschemaname,srcethemename,srcethemeuidcol,srceoriggeomfldname)"
      sqlstr = sqlstr + " values (" 

      valstr = "rowno,'gpkg_sql','IPAddress','DatabaseName','schemaname','UserName','UserPassword','DBPort','ThemeName','ThemeUidCol','ConnectionType','OrigGeomFldName','AdjGeomFldName','GeometryType',"
      valstr = valstr + "use_st_overlaps,ScaledObject,RigidObject,Adjustable,ReportStats,SnapToSnapToThemes,IsATargetSnapTheme,MaintainStraightLines,straightenthelines,StraightLineTolCM,'themetype',"
      valstr = valstr + "'srceschemaname','srcethemename','srcethemeuidcol','srceoriggeomfldname')"
      
      valstr = valstr.replace("rowno", str(rowNo))
      # lstr = valstr.replace("gpkg_sql", str(rowNo)) # file:///home/roger/casey/Infrastructure.gpkg
      valstr = valstr.replace("gpkg_sql", str(vl.name()))
      
      # valstr = valstr.replace("srceschemaname", str(vl.storageType()))
      # valstr = valstr.replace("srceschemaname", str(vl.dataProvider().dataSourceUri()))
      
      vlSourse = str(vl.source())
      if "|" in vlSourse:
        vlSourse=vlSourse.split("|")[0]
      valstr = valstr.replace("srceschemaname", vlSourse)
      valstr = valstr.replace("srcethemename", str(vl.name()))

      valstr = valstr.replace("IPAddress", myGBL['PG_IPAddress'])
      valstr = valstr.replace("DatabaseName", myGBL['PG_DBName'])
      valstr = valstr.replace("schemaname", myGBL['PG_Schema'])
      valstr = valstr.replace("UserName", myGBL['PG_Username'])
      valstr = valstr.replace("UserPassword", myGBL['PG_Password'])
      valstr = valstr.replace("DBPort", myGBL['PG_Port'])
      valstr = valstr.replace("ThemeName", str(vl.name()).replace('.','_'))
      valstr = valstr.replace("ConnectionType", 'PGS')
      valstr = valstr.replace("ThemeUidCol", "gid")
      valstr = valstr.replace("ConnectionType", "GPKG")
      valstr = valstr.replace("OrigGeomFldName", "geom_orig")
      valstr = valstr.replace("AdjGeomFldName", "geom_adj")
      valstr = valstr.replace("use_st_overlaps", "False")
      valstr = valstr.replace("ScaledObject", "False")
      valstr = valstr.replace("RigidObject", "False")
      valstr = valstr.replace("Adjustable", "True")
      valstr = valstr.replace("ReportStats", "True")
      valstr = valstr.replace("SnapToSnapToThemes", "False")
      valstr = valstr.replace("IsATargetSnapTheme", "False")
      valstr = valstr.replace("MaintainStraightLines", "False")
      valstr = valstr.replace("straightenthelines", "False")
      valstr = valstr.replace("StraightLineTolCM", "5")
      
      vlname = vl.name().lower()
      if vlname == "srce_landbase":
        themeType = "srce_landbase"
      elif vlname == "dest_landbase":
        themeType = "dest_landbase"
      elif vlname == "srce_lb":
        themeType = "srce_landbase"
      elif vlname == "dest_lb":
        themeType = "dest_landbase"
      elif "srce_lb" in vlname:
        themeType = "srce_landbase"
      elif "dest_lb" in vlname:
        themeType = "dest_landbase"
      else:
        themeType = "sd_layer"
      
      valstr = valstr.replace("themetype", themeType)

      #  pk_field_names = [field.name() for field in prov.primaryKeyAttributes()]

      prov = vl.dataProvider()
      field_names = [field.name() for field in prov.fields()]
      valstr = valstr.replace("srcethemeuidcol", str(field_names[0]))
      valstr = valstr.replace("srceoriggeomfldname", "geom")

      a53 = myGBL['a53']

      gType = str(vl.wkbType()) + ": Not Found"
      for v in a53:
        # gType = valstr.replace("GeometryType", str(v[2]))
        if str(vl.wkbType()) == str(v[2]):
          gType = str(vl.wkbType()) + ": " + str(v[0])
  
      valstr = valstr.replace("GeometryType", gType)
      e2e(sqlstr + valstr, connPGS, myGBL['LogFileName'])


  except Exception as error:
    print ("Oops! An exception has occured:", error)
    print ("Exception TYPE:", type(error))
    with open("./log.a4p", 'w') as output_file:
      output_file.write("Oops! An exception has occured: " + str(error) + '\n')
      output_file.write("Exception TYPE: " + str(type(error)) + '\n')
      output_file.write(sqlstr + '\n')
      output_file.write(valstr + '\n')
      output_file.close()
    
    return False

def a4v(self, pointTool):
    try:
        print(pointTool.x(), pointTool.y())
        self.dlg.a58.setText(pointTool.x())
        self.dlg.a59.setText(pointTool.y())
    except AttributeError:
        pass

def a4d(self):
    try:
        for vl in QgsProject.instance().mapLayers().values():
            myDProv = vl.dataProvider()
            myDStor = myDProv.storageType()
            if vl.type() == QgsMapLayer.VectorLayer:
                if "Memory" in myDStor:
                    QgsProject.instance().removeMapLayer(vl.id())
                    
    except Exception as err:
        QMessageBox.information(None, "Failured to delete table", err, QMessageBox.Ok, QMessageBox.Ok)
        return False

def a4q(self, a56):
    if a56 == "":
        return
    elif not os.path.exists(a56):
        QMessageBox.information(None,"LandXml error","IniLoad, Cannot open " + a56, QMessageBox.Ok, QMessageBox.Ok)
        return
    try:
        a55 = {}
        a55.update({'GoIt': "F"}) 
        a4d(self)
        data = LandXml.LandXml(a56, **a55)
        LandXmlDialog.a4g(self, data)
        LandXmlDialog.a4o(self, data)
        LandXmlDialog.a4s(self, data)
        count = 0
        for mark in data.monuments():
            item = str(mark.name() + ", " + str(mark.point().coords()))
            count = count + 1
            self.dlg.listWidget.insertItem(count, item)
        if count == 0:
            for cgPnt in data._points:
                item = str(cgPnt.id() + ", " + str(cgPnt.coords()))
                count = count + 1
                self.dlg.listWidget.insertItem(count, item)
                
    except:
        message = str(sys.exc_info()[1])
        QMessageBox.information(None,"LandXml error","Problem auto-loading xml\n" + message, QMessageBox.Ok, QMessageBox.Ok)

def i3i(self, sqlList, outSQL_file, errFileName, **myGBL):
    o2o = myGBL['o2o']
    if o2o == "Serv" or o2o == "Both":
        connPGS = i2i(**myGBL)
        for sqlStr in sqlList:
            e2e(sqlStr, connPGS, errFileName)

    if o2o == "File" or o2o == "Both":
        for sqlStr in sqlList:
            outSQL_file.write(sqlStr.replace(chr(140),";").replace(chr(141),'\n') + '\n')

def whatIsGoingOn(aStr):
    with open("log.WhatIsGoingOn", 'a') as outSQL_file:
        aDate = datetime.datetime.now().strftime(" %Y %B %d, %I:%M%p ")
        #'10:36AM on July 23, 2010'
        outSQL_file.write(aDate + ": " + aStr + "\n")
    outSQL_file.close

def a60(self):
    a56 = str(self.dlg.uXmlFile.text())
    if not a56:
        QMessageBox.information(None,"LandXml error","You must specify a LandXml file to import", QMessageBox.Ok, QMessageBox.Ok)
        return False
    if not os.path.exists(a56):
        QMessageBox.information(None,"LandXml error","TransLXML, Cannot open " + a56, QMessageBox.Ok, QMessageBox.Ok)
        return False

    try:
        a55 = {}
        a55.update({'GoIt': "T"}) 
        if self.dlg.listWidget.currentRow() == -1:
            QMessageBox.information(None,"Warning!!!","You must select a Monument to proceed", QMessageBox.Ok, QMessageBox.Ok)
            return
        curText = self.dlg.listWidget.currentItem().text()
        curArr = curText.replace("[","").replace("]","").replace(" ","").split(",")
        a55.update({'FrE': curArr[1]}) 
        a55.update({'FrN': curArr[2]}) 
        a55.update({'ToE': self.dlg.a58.text()}) 
        a55.update({'ToN': self.dlg.a59.text()}) 
        a55.update({'Rot': self.dlg.a4r.text()}) 
        a55.update({'SFr': self.dlg.a4m.text()}) 

        a57 = str(self.dlg.mQgsProjectionSelectionWidget_LXMLXY.crs())
        a57 = a57.replace("<QgsCoordinateReferenceSystem: ","").replace(">","")
        if "invalid" in a57:
            QMessageBox.information(None,"a57 error","CRS NOT set", QMessageBox.Ok, QMessageBox.Ok)
            return

        myGBL.update({'a57': a57}) 

        a4d(self)
        data = LandXml.LandXml(a56, **a55)
        LandXmlDialog.a4g(self, data)
        LandXmlDialog.a4o(self, data)
        LandXmlDialog.a4s(self, data)
        return True
    except:
        message = str(sys.exc_info()[1])
        QMessageBox.information(None,"LandXml error","Problem transforming xml\n" + message, QMessageBox.Ok, QMessageBox.Ok)
        return False

def a4h(self):
    # a reference to our map canvas
    canvas = iface.mapCanvas()
    # this QGIS tool emits as QgsPoint after each click on the map canvas
    pointTool = QgsMapToolEmitPoint(canvas)
    pointTool.canvasClicked.connect(a4v)
    canvas.setMapTool(pointTool)
    a4v(self, pointTool)
