# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DataDefinedLabelImporterDialog
                                 A QGIS plugin
 Helps you to import Labeldata, stored in an auxiliary Layer from another Project.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-05-10
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Tobias
        email                : heitob903@outlook.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.core import QgsProject, QgsMapLayer
from qgis.utils import iface
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import  QVBoxLayout, QTreeWidgetItem, QDialogButtonBox

from label_importer.gui.layers_to_copy_widget import LayerToCopyWidget

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), r"../ui/label_importer_dialog_base.ui")
    )

class DataDefinedLabelImporterDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(DataDefinedLabelImporterDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        self.LayerToCopyWidget = LayerToCopyWidget()
        self.iface = iface
        self.setupUi(self)
        self.setupGui()

    def setupGui(self):
        '''load the gui
        deactivate the ok-button
        poplulate the widget'''
        self.ok_button = self.buttonBox.button(QDialogButtonBox.Ok)
        self.updateFields()
        self.deactivateOkButton()
        self.progressBar.setValue(0)
        group_box_layout = QVBoxLayout()
        self.sourceLayerBox.setLayout(group_box_layout)
        self.sourceLayerBox.layout().addWidget(self.LayerToCopyWidget)
        self.projectFile.setFilter("QGIS Project Files (*.qgz)")
        self.projectFile.fileChanged.connect(self.layerBoxUserMessage)
        self.projectFile.fileChanged.connect(lambda file_path: self.setUpLayerBox(file_path))
        self.projectFile.fileChanged.connect(self.deactivateOkButton)
        self.LayerToCopyWidget.treeWidget.currentItemChanged.connect(self.validateInputs)
        self.targetLayer.layerChanged.connect(self.updateFields)

    def layerBoxUserMessage(self):
        self.LayerToCopyWidget.treeWidget.addTopLevelItem(QTreeWidgetItem(["Loading layers... This process may take several seconds."]))

    def deactivateOkButton(self):
        '''deactivate the button box to prevent the process from being executed'''
        self.ok_button.setEnabled(False)

    def setUpLayerBox(self, file_path):
        '''populate combobox with layers that have auxiliary storage'''  
        self.ok_button.setEnabled(False)
        self.project = QgsProject()
        self.project.read(file_path)

        # delete user message
        self.LayerToCopyWidget.treeWidget.clear()
        layers = self.project.mapLayers().values()
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                if not layer.auxiliaryLayer() is None :
                    item = QTreeWidgetItem([layer.name()])
                    item.setData(0, 1, layer.id() )
                    self.LayerToCopyWidget.treeWidget.addTopLevelItem(item)

    def validateInputs(self):
        ''' Check if all required fields have values'''
        #if self.projectFile.fileChanged:
        self.ok_button.setEnabled(True)

    def updateFields(self):
        '''update layer fields when new layer is selected'''
        selected_layer = self.targetLayer.currentLayer()
        if selected_layer:
            self.targetIdField.setLayer(selected_layer)
        else:
            self.targetIdField.clear()

