# 実データ分析レポート: 公図XMLの構造と座標系

分析日: 2026-02-11

---

## 分析対象

| ディレクトリ | 市区町村コード | 市区町村名 | XMLファイル数 |
|-------------|--------------|-----------|-------------|
| data/A | 22306 | 賀茂郡西伊豆町 | 44 |
| data/B | 22305 | 賀茂郡松崎町 | 62 |
| data/C | 22304 | 賀茂郡南伊豆町 | 84 |

データベース: `data/kozu_data.sqlite` （松崎町62ファイル分をインポート済み）

---

## 1. XMLの属性構造

### 筆（`<筆>`要素）に含まれる属性

```xml
<筆 id="H000000001">
    <大字コード>022</大字コード>
    <丁目コード>000</丁目コード>
    <小字コード>0000</小字コード>
    <予備コード>00</予備コード>
    <大字名>雲見</大字名>
    <地番>1906-3</地番>
    <形状 idref="F000000001"/>
    <座標値種別>図上測量</座標値種別>
</筆>
```

**面積フィールドは存在しない。**
DBの `area_sqm` はパーサがポリゴンジオメトリから計算した値であり、
任意座標系データでは座標空間上のオブジェクトサイズ（単位なし）である。

### 座標値種別

| 値 | 意味 | 座標系 |
|----|------|--------|
| 図上測量 | 任意座標系（紙面mm） | SRID不定 |
| 測量成果 | 公共座標系（JGD2011） | EPSG:6676 等 |

---

## 2. 座標系の分布

### 松崎町（DB分析: 53,818筆）

| 座標値種別 | XML数 | 筆数 |
|-----------|------|------|
| 図上測量（任意座標系） | 52 | 48,430 |
| 測量成果（公共座標系） | 10 | 5,387 |

### 3市町村のXML座標系分布

| 市町村 | 任意座標 | 公共座標 |
|--------|---------|---------|
| 西伊豆町 (A) | 39 | 5 |
| 松崎町 (B) | 52 | 10 |
| 南伊豆町 (C) | 81 | 3 |

---

## 3. 公共座標系と任意座標系の共通地番分析

### 核心的な問い

> 同一大字内で公共座標系と任意座標系のXMLに共通する地番が存在し、
> 幾何学的アンカーとして座標変換に使用できるか？

### 結果

| 市町村 | 共存大字数 | 共通地番（全体） | 共通数字地番 |
|--------|----------|----------------|------------|
| 松崎町 (B) | 12 | 47件 | **0件** |
| 西伊豆町 (A) | 3 | 132件 | **23件**（田子のみ） |
| 南伊豆町 (C) | 3 | 2件 | **0件** |

### 共通地番の内訳（松崎町）

全47件が以下の特殊地番のみ：

| 種別 | 件数 |
|------|------|
| 道（道路） | 36 |
| 水（河川） | 8 |
| 筆界未定地 | 2 |
| 無地番 | 1 |

面積比は0.005〜24.8と大きく乖離しており、同一地番名でも物理的に異なる区間を指す。

### 西伊豆町・田子の23件について

田子の公共座標XMLは「図有」（地籍調査済み）であり、旧図の任意座標データと
地籍調査後の公共座標データが重複したもの。同一筆の座標変換前後ではなく、
異なる時期の測量結果であるため、幾何学的アンカーとしての信頼性は低い。

### 結論

**公共座標系と任意座標系の間に、座標変換のアンカーとして使える
共通ポイントは実質ゼロである。**

現行プラグインの `matching_algorithm.py` → `spatial_fitting.py` →
チェーンポジショニングのパイプラインは、「共通地番で座標系を橋渡しする」
ことを前提に設計されているが、このデータにはその前提が成立しない。

---

## 4. 縮尺情報の発見

### 図郭（`<図郭>`要素）の構造

```xml
<図郭>
    <地図番号>雲見151A</地図番号>
    <縮尺分母>1000</縮尺分母>
    <方位不明フラグ>false</方位不明フラグ>
    <左下座標>
        <zmn:X>127.670</zmn:X>
        <zmn:Y>4986.641</zmn:Y>
    </左下座標>
    <左上座標>...</左上座標>
    <右下座標>...</右下座標>
    <右上座標>...</右上座標>
    <地図種類>土地改良所在図</地図種類>
    <地図分類>地図に準ずる図面</地図分類>
    <地図材質>P-F</地図材質>
    <筆参照 idref="H000000001"/>
    <筆参照 idref="H000000002"/>
    ...
</図郭>
```

### 座標単位の特定

図郭の4隅座標から用紙サイズを逆算した結果：

| 縮尺 | 図郭座標幅 | 図郭座標高 | 幅/分母 | 高/分母 |
|------|----------|----------|--------|--------|
| 1:600 | 327.0 | 270.0 | 0.5450 | 0.4500 |
| 1:1000 | 545.0 | 450.0 | 0.5450 | 0.4500 |
| 1:1200 | 654.0 | 540.0 | 0.5450 | 0.4500 |
| 1:2500 | 1362.5 | 1125.0 | 0.5450 | 0.4500 |
| 1:3000 | 1635.0 | 1350.0 | 0.5450 | 0.4500 |

**座標値/縮尺分母 = 一定（0.545, 0.450）**

**結論: 座標単位 = mm（紙面上）、用紙サイズ 545mm × 450mm 全縮尺共通**

### 面積変換公式

```
実面積(m²) = ポリゴン面積(座標空間) × (縮尺分母 / 1000)²
```

| 縮尺 | 変換係数 |
|------|---------|
| 1:500 | 0.25 |
| 1:600 | 0.36 |
| 1:1000 | 1.00 |
| 1:1200 | 1.44 |
| 1:2500 | 6.25 |
| 1:3000 | 9.00 |

### 縮尺情報の網羅性（松崎町 任意座標52XML）

| 区分 | XML数 | 割合 |
|------|------|------|
| 明示的縮尺あり | 45 | 87% |
| 明示的縮尺なし（図郭から逆算可能） | 7 | 13% |
| 複数縮尺混在 | 0 | 0% |

**1XML = 1縮尺が保証されている。**

明示的縮尺ありの全45件で、図郭寸法からの逆算値と完全一致を確認済み。

### 縮尺なし7件の性質

全件が「旧土地台帳附属地図」（和-洋紙、手書き図面）。
`<縮尺分母>`タグが存在しないが、図郭の座標寸法は327×270（逆算=600）で統一。
デジタイズ時のスキャン枠サイズを反映している可能性があり、
原図の実縮尺が1:600であることの保証はないが、蓋然性は高い。

---

## 5. 異縮尺混在の歪み問題

### 同一大字内の異縮尺XML

松崎町22大字中、**11大字で複数の縮尺が混在**している。

| 大字 | 混在する縮尺 |
|------|------------|
| 雲見 | 600, 1000 |
| 石部 | 600, 1000, 3000 |
| 門野 | 500, 600, 1000, 3000 |
| 岩科北側 | 600, 3000 |
| 岩科南側 | 600, 3000 |
| 那賀 | 600, 1200 |
| 峰輪 | 600, 3000 |
| 池代 | 600, 2500 |
| 大澤 | 600, 3000 |
| 吉田 | 500, 600 |
| 船田 | 500, 600 |

### 異縮尺XMLの共通数字地番

異縮尺XML間での共通数字地番は極めて少数：

- 那賀（1:1200 vs 1:600）: 4件（29-2, 86-3, 86-4, 88-3）
- 門野（1:500 vs 1:600）: 1件（35-2）
- その他: 0件

共通地番が存在する場合も、推定実面積が2〜10倍乖離しており、
異なる時期の測量結果であることを示す。

### 歪みの定量的影響

異なる縮尺のXMLを座標空間のまま結合表示した場合：

```
歪み係数 = (縮尺A / 縮尺B)²

例: 1:1200 と 1:600 を混在表示
  → 1:1200図の筆は面積が (1200/600)² = 4.0倍で表示される
  → 辺の長さは 1200/600 = 2.0倍
```

### 対処方針

**1XML = 1縮尺が保証されている**ため、XML単位で表示すれば歪みは発生しない。

プレビューUIはXMLファイル単位の選択を基本とし、
複数XMLの同時表示時には縮尺の相違を警告する。

---

## 6. デジタル庁変換仕様との関係

引用（デジタル庁公開文書）：
> - 地図XMLのデータから、筆のポリゴンデータおよびアドレス・ベース・レジストリの
>   整備に必要な属性のみ抽出・出力します。基準点、筆界点、筆界線は出力しません。
> - 公共座標系のデータは、座標値を経度・緯度（JGD2011）に換算します。
>   属性として代表点座標を追加します。
> - 任意座標系のデータは、座標値の換算はしません。

本分析で使用したデータは法務局オリジナルXML（筆界点・筆界線含む）であるが、
デジタル庁変換後のデータでも筆のポリゴンと属性は保持されるため、
本分析の座標系・縮尺に関する結論はそのまま適用可能。

---

## 7. 設計への影響まとめ

### 廃止すべき機能

| モジュール | 理由 |
|-----------|------|
| transform/matching_algorithm.py | 共通地番によるアンカーが実データに存在しない |
| transform/spatial_fitting.py | チェーンポジショニングの前提が不成立 |
| transform/xml_joiner.py | 異縮尺結合による歪みリスク |
| transform/helmert_transform.py | アンカーなしでは変換不可 |
| transform/tps_transform.py | 同上 |
| transform/leveling.py | 統合処理自体を廃止 |
| core/integration_engine.py | 同上 |
| ui/integration_panel.py | 同上 |
| ui/export_panel.py | 同上 |
| ui/transform_panel.py | 同上 |

### 活用すべき発見

| 発見 | 活用方法 |
|------|---------|
| 座標単位=mm（紙面） | 面積推定公式の根拠 |
| 縮尺分母が図郭に存在 | 筆→図郭→縮尺の紐付けで推定実面積を算出 |
| 1XML=1縮尺 | XML単位表示で歪み回避を保証 |
| 図郭寸法による縮尺逆算 | 明示縮尺なしファイルへのフォールバック |
| 筆参照による図郭-筆紐付け | 筆単位での正確な縮尺適用 |

### 新設計のプレビューUI選択構造

```
大字選択 → XMLファイル一覧（縮尺・筆数表示）→ 選択XMLの公図表示
```

推定実面積は地番ラベルに付与可能。
メインウィンドウとの連携は地番ベースの属性照合で実現。

---

## 付録: データベース現状

| テーブル | レコード数 |
|---------|----------|
| t_xml_meta | 62 |
| t_fude_poly | 53,818 |
| t_fude_edge | 0 |
| t_transform_log | 0 |

t_xml_meta の oaza_name が全件空（空間結合未実施）。
t_fude_poly の oaza_name は XML内の `<大字名>` から取得済み。
