# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Korekurver
                                 A QGIS plugin
 Med Kørekurver kan der vises kørekurver på et kort.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-02
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Nordiq Group
        email                : stb@nordiq-group.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import sys
import processing
from qgis.utils import iface 
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon,QColor
from qgis.PyQt.QtWidgets import (QDialog,
                                 QAction,
                                 QMenu,
                                 QWidget,
                                 QTreeView,
                                 QAbstractItemView,
                                 QDialogButtonBox,
                                 QLineEdit,
                                 QTextEdit,
                                 QSpinBox,
                                 QDoubleSpinBox,
                                 QCheckBox,
                                 QComboBox,
                                 QDateTimeEdit,
                                 QDateEdit,
                                 QTimeEdit,
                                 QLayout,
                                 QHeaderView,
                                 QVBoxLayout,
                                 QHBoxLayout,
                                 QLabel)

from qgis.core import (Qgis,
                       QgsMessageLog,
                       QgsGeometry,
                       QgsProject,
                       QgsRendererCategory,
                       QgsFeatureRequest,
                       QgsProviderRegistry,
                       QgsDataSourceUri,
                       QgsExpressionContextUtils,
                       QgsVectorLayer,
                       QgsSymbol,
                       QgsCategorizedSymbolRenderer,
                       QgsLineSymbol,
                       QgsAbstractDatabaseProviderConnection,
                       QgsApplication
)

from qgis.gui import QgsFileWidget, QgsCheckableComboBox, QgsMessageBar



from qgis.PyQt.QtWidgets import (
    QSizePolicy,
    QPushButton,
    QDialog,
    QGridLayout,
    QDialogButtonBox,
)

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .korekurver_dockwidget import KorekurverDockWidget
import os.path


class Korekurver:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Korekurver_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Korekurver')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'Korekurver')
        self.toolbar.setObjectName(u'Korekurver')

        #print "** INITIALIZING Korekurver"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Korekurver', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/korekurver/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Korekurver'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING Korekurver"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD Korekurver"

        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Korekurver'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------


    def run(self):
        """Run method that loads and starts the plugin"""
      
        if not self.pluginIsActive:
            self.pluginIsActive = True

            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = self.dockwidget = KorekurverDockWidget()
                sd = self.dockwidget 
                sd.pushButton_placere.clicked.connect(self.placement)
                sd.pushButton.clicked.connect(self.slet)
                sd.pushButton_stoppe.clicked.connect(self.stoppe)
                sd.pushButton_visAlle.clicked.connect(self.vis)
                sd.pushButton_skjulAlle.clicked.connect(self.skjul)
                sd.toolButton_move.clicked.connect(self.move)
                sd.toolButton_rotate.clicked.connect(self.rotate)
                sd.pushButton_info.clicked.connect(self.open)
                sd.comboBox.currentIndexChanged.connect(self.dir33)
            
            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
    
    def dir33(self):
        sd = self.dockwidget 
        text = str(sd.comboBox.currentText())
        if text == "Bus - 12m":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.isChecked(True)
            sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Bus - 12m, S-kurve":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(False)
            sd.checkBox_60.setChecked(False)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(False)
            sd.checkBox_100.setChecked(False)
            sd.checkBox_120.setChecked(False)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(False)
            sd.checkBox_160.setChecked(False)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(False)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(False)
            sd.checkBox_60.setEnabled(False)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(False)
            sd.checkBox_100.setEnabled(False)
            sd.checkBox_120.setEnabled(False)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(False)
            sd.checkBox_160.setEnabled(False)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(False)
            sd.checkBox_200.setEnabled(False)
        elif text == "Bus - 13.7m":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Bus - 13.7m, S-kurve":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(False)
            sd.checkBox_60.setChecked(False)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(False)
            sd.checkBox_100.setChecked(False)
            sd.checkBox_120.setChecked(False)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(False)
            sd.checkBox_160.setChecked(False)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(False)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(False)
            sd.checkBox_60.setEnabled(False)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(False)
            sd.checkBox_100.setEnabled(False)
            sd.checkBox_120.setEnabled(False)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(False)
            sd.checkBox_160.setEnabled(False)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(False)
            sd.checkBox_200.setEnabled(False)
        elif text == "Bus - 15m":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Bus - 15m, S-kurve":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(False)
            sd.checkBox_60.setChecked(False)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(False)
            sd.checkBox_100.setChecked(False)
            sd.checkBox_120.setChecked(False)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(False)
            sd.checkBox_160.setChecked(False)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(False)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(False)
            sd.checkBox_60.setEnabled(False)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(False)
            sd.checkBox_100.setEnabled(False)
            sd.checkBox_120.setEnabled(False)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(False)
            sd.checkBox_160.setEnabled(False)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(False)
            sd.checkBox_200.setEnabled(False)
        elif text == "Bus - 25m":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Bus - 25m, S-kurve":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(False)
            sd.checkBox_60.setChecked(False)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(False)
            sd.checkBox_100.setChecked(False)
            sd.checkBox_120.setChecked(False)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(False)
            sd.checkBox_160.setChecked(False)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(False)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(False)
            sd.checkBox_60.setEnabled(False)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(False)
            sd.checkBox_100.setEnabled(False)
            sd.checkBox_120.setEnabled(False)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(False)
            sd.checkBox_160.setEnabled(False)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(False)
            sd.checkBox_200.setEnabled(False)
        elif text == "Lastvogn":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Modulvogntog":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(True)
            sd.checkBox_40.setChecked(False)
            sd.checkBox_60.setChecked(False)
            sd.checkBox_67.setChecked(True)
            sd.checkBox_80.setChecked(False)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(False)
            sd.checkBox_133.setChecked(True)
            sd.checkBox_140.setChecked(False)
            sd.checkBox_160.setChecked(False)
            sd.checkBox_167.setChecked(True)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(True)
            sd.checkBox_40.setEnabled(False)
            sd.checkBox_60.setEnabled(False)
            sd.checkBox_67.setEnabled(True)
            sd.checkBox_80.setEnabled(False)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(False)
            sd.checkBox_133.setEnabled(True)
            sd.checkBox_140.setEnabled(False)
            sd.checkBox_160.setEnabled(False)
            sd.checkBox_167.setEnabled(True)
            sd.checkBox_180.setEnabled(False)
            sd.checkBox_200.setEnabled(False)
        elif text == "Person- og varevogn":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Påhængsvogntog":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Renovationskøretøj":
            if sd.radioButton_A.isChecked() == True:
                sd.radioButton_B.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        elif text == "Specialkøretøj":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(False)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(False)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(False)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(False)
            sd.checkBox_200.setEnabled(False)
        elif text == "Sættevogntog":
            if sd.radioButton_A.isChecked() == False:
                sd.radioButton_A.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(False)
            sd.checkBox_200.setChecked(False)
            #enabled
            sd.radioButton_A.setEnabled(True)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)
        else:
            if sd.radioButton_A.isChecked() == True:
                sd.radioButton_B.setChecked(True)
            sd.checkBox_33.setChecked(False)
            sd.checkBox_40.setChecked(True)
            sd.checkBox_60.setChecked(True)
            sd.checkBox_67.setChecked(False)
            sd.checkBox_80.setChecked(True)
            sd.checkBox_100.setChecked(True)
            sd.checkBox_120.setChecked(True)
            sd.checkBox_133.setChecked(False)
            sd.checkBox_140.setChecked(True)
            sd.checkBox_160.setChecked(True)
            sd.checkBox_167.setChecked(False)
            sd.checkBox_180.setChecked(True)
            sd.checkBox_200.setChecked(True)
            #enabled
            sd.radioButton_A.setEnabled(False)
            sd.radioButton_B.setEnabled(True)
            sd.checkBox_33.setEnabled(False)
            sd.checkBox_40.setEnabled(True)
            sd.checkBox_60.setEnabled(True)
            sd.checkBox_67.setEnabled(False)
            sd.checkBox_80.setEnabled(True)
            sd.checkBox_100.setEnabled(True)
            sd.checkBox_120.setEnabled(True)
            sd.checkBox_133.setEnabled(False)
            sd.checkBox_140.setEnabled(True)
            sd.checkBox_160.setEnabled(True)
            sd.checkBox_167.setEnabled(False)
            sd.checkBox_180.setEnabled(True)
            sd.checkBox_200.setEnabled(True)

    
    def vis(self):
        sd = self.dockwidget
        sd.checkBox_33.setChecked(True)
        sd.checkBox_40.setChecked(True)
        sd.checkBox_60.setChecked(True)
        sd.checkBox_67.setChecked(True)
        sd.checkBox_80.setChecked(True)
        sd.checkBox_100.setChecked(True)
        sd.checkBox_120.setChecked(True)
        sd.checkBox_133.setChecked(True)
        sd.checkBox_140.setChecked(True)
        sd.checkBox_160.setChecked(True)
        sd.checkBox_167.setChecked(True)
        sd.checkBox_180.setChecked(True)
        sd.checkBox_200.setChecked(True)

    def skjul(self):
        sd = self.dockwidget
        sd.checkBox_33.setChecked(False)
        sd.checkBox_40.setChecked(False)
        sd.checkBox_60.setChecked(False)
        sd.checkBox_67.setChecked(False)
        sd.checkBox_80.setChecked(False)
        sd.checkBox_100.setChecked(False)
        sd.checkBox_120.setChecked(False)
        sd.checkBox_133.setChecked(False)
        sd.checkBox_140.setChecked(False)
        sd.checkBox_160.setChecked(False)
        sd.checkBox_167.setChecked(False)
        sd.checkBox_180.setChecked(False)
        sd.checkBox_200.setChecked(False)


    def open(self):
        sd = self.dockwidget 
        sd.tabWidget.setCurrentIndex(1)

    def placement(self):
        for lr in QgsProject.instance().mapLayers().values(): 
            if lr.name() == "Kørekurver":
                QgsProject.instance().removeMapLayer(lr.id())
        self.iface.mapCanvas().refresh()
        path_pref =QgsApplication.qgisSettingsDirPath()
        path_kurver= path_pref + "python/plugins/korekurver/kurver/koerekurver.shp"
        #self.iface.addVectorLayer(self.path_kurver,"Kørekurver", "ogr")
        self.layer= QgsVectorLayer(path_kurver, "Kørekurver", "ogr")
        self.vehicle(self.layer)   
        self.direction(self.layer)    
        if self.dockwidget.radioButton_ja.isChecked() == True:
            self.affine(self.layer)
        self.transform(self.layer)
        self.setStyle(self.layer)
        #self.zoomIn(self.layer)



    def vehicle(self,layer):
        sd = self.dockwidget
        QgsProject.instance().addMapLayer(layer)
        global field_values
        text = str(sd.comboBox.currentText())
        field_name = "typeid" # specify your field
        #if sd.comboBox.count()== '0':
        if text == "Bus - 12m":
            field_values = '(4, 104)' # specify values for features that you want to retain
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(4)'
            else:
                 field_values = '(104)'
        elif text == "Bus - 12m, S-kurve":
            field_values = '(10)'
        elif text == "Bus - 13.7m":
            field_values = '(5, 105)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(5)'
            else:
                 field_values = '(105)'
        elif text == "Bus - 13.7m, S-kurve":
            field_values = '(11)'
        elif text == "Bus - 15m":
            field_values = '(6, 106)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(6)'
            else:
                 field_values = '(106)'
        elif text == "Bus - 15m, S-kurve":
            field_values = '(12)'
        elif text == "Bus - 25m":
            field_values = '(7, 107)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(7)'
            else:
                 field_values = '(107)'
        elif text == "Bus - 25m, S-kurve":
            field_values = '(13)'
        elif text == "Lastvogn":
            field_values = '(3, 103)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(3)'
            else:
                 field_values = '(103)'
        elif text == "Modulvogntog":
            field_values = '(14, 112)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(14)'
            else:
                 field_values = '(112)'
        elif text == "Person- og varevogn":
            field_values = '(1, 101)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(1)'
            else:
                 field_values = '(101)'
        elif text == "Påhængsvogntog":
            field_values = '(8, 108)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(8)'
            else:
                 field_values = '(108)'
        elif text == "Renovationskøretøj":
            field_values = '(2, 102)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(2)'
            else:
                 field_values = '(102)'
        elif text == "Specialkøretøj":
            field_values = '(111)'
        elif text == "Sættevogntog":
            field_values = '(9, 109)'
            if sd.radioButton_A.isChecked() == True:
                 field_values = '(9)'
            else:
                 field_values = '(109)'
        else:
            field_values = '(110)'
        expression = f'"{field_name}" in {field_values}'
        layer.selectByExpression(expression)
        new_layer = processing.run("native:saveselectedfeatures",{'INPUT':layer ,'OUTPUT':'TEMPORARY_OUTPUT'})["OUTPUT"]
        QgsProject.instance().addMapLayer(new_layer)
        QgsProject.instance().removeMapLayer(layer.id())
        for lyr in QgsProject.instance().mapLayers().values(): 
            if lyr.name() == "Selected features":
                lyr.setName('Kørekurver')
                self.layer= lyr


    def direction(self,layer):
        #if self.addCheckDB.isChecked():
            #self.addCheck.setChecked(False)
        sd = self.dockwidget
        cB33= sd.checkBox_33
        cB40= sd.checkBox_40
        cB60= sd.checkBox_60
        cB67= sd.checkBox_67
        cB80= sd.checkBox_80
        cB100= sd.checkBox_100
        cB120= sd.checkBox_120
        cB133= sd.checkBox_133
        cB140= sd.checkBox_140
        cB160= sd.checkBox_160
        cB167= sd.checkBox_167
        cB180= sd.checkBox_180
        cB200= sd.checkBox_200
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Kørekurver":
                field_name = "direction" # specify your field
                field_values = '(0)'
                expression = f'"{field_name}" in {field_values}'
                lyr.selectByExpression(expression)
                if cB33.isChecked() == True:
                    field_values1 = '(33)'
                    expression1 = f'"{field_name}" in {field_values1}'
                    lyr.selectByExpression(expression1, QgsVectorLayer.AddToSelection)
                if cB40.isChecked() == True:
                    field_values2 = '(40)'
                    expression2 = f'"{field_name}" in {field_values2}'
                    lyr.selectByExpression(expression2, QgsVectorLayer.AddToSelection)
                if cB60.isChecked() == True:
                    field_values3 = '(60)'
                    expression3 = f'"{field_name}" in {field_values3}'
                    lyr.selectByExpression(expression3, QgsVectorLayer.AddToSelection)
                if cB67.isChecked() == True:
                    field_values4 = '(67)'
                    expression4 = f'"{field_name}" in {field_values4}'
                    lyr.selectByExpression(expression4, QgsVectorLayer.AddToSelection)
                if cB80.isChecked() == True:
                    field_values5 = '(80)'
                    expression5 = f'"{field_name}" in {field_values5}'
                    lyr.selectByExpression(expression5, QgsVectorLayer.AddToSelection)
                if cB100.isChecked() == True:
                    field_values6 = '(100)'
                    expression6 = f'"{field_name}" in {field_values6}'
                    lyr.selectByExpression(expression6, QgsVectorLayer.AddToSelection)
                if cB120.isChecked() == True:
                    field_values7 = '(120)'
                    expression7 = f'"{field_name}" in {field_values7}'
                    lyr.selectByExpression(expression7, QgsVectorLayer.AddToSelection)
                if cB133.isChecked() == True:
                    field_values8 = '(133)'
                    expression8 = f'"{field_name}" in {field_values8}'
                    lyr.selectByExpression(expression8, QgsVectorLayer.AddToSelection)
                if cB140.isChecked() == True:
                    field_values9 = '(140)'
                    expression9 = f'"{field_name}" in {field_values9}'
                    lyr.selectByExpression(expression9, QgsVectorLayer.AddToSelection)
                if cB160.isChecked() == True:
                    field_values10 = '(160)'
                    expression10 = f'"{field_name}" in {field_values10}'
                    lyr.selectByExpression(expression10, QgsVectorLayer.AddToSelection)
                if cB167.isChecked() == True:
                    field_values11 = '(167)'
                    expression11 = f'"{field_name}" in {field_values11}'
                    lyr.selectByExpression(expression11, QgsVectorLayer.AddToSelection)
                if cB180.isChecked() == True:
                    field_values12 = '(180)'
                    expression12 = f'"{field_name}" in {field_values12}'
                    lyr.selectByExpression(expression12, QgsVectorLayer.AddToSelection)
                if cB200.isChecked() == True:
                    field_values13 = '(200)'
                    expression13 = f'"{field_name}" in {field_values13}'
                    lyr.selectByExpression(expression13, QgsVectorLayer.AddToSelection)
                new_layer = processing.run("native:saveselectedfeatures",{'INPUT':lyr ,'OUTPUT':'TEMPORARY_OUTPUT'})["OUTPUT"]
                QgsProject.instance().addMapLayer(new_layer)
        for lr in QgsProject.instance().mapLayers().values(): 
            if lr.name() == "Kørekurver":
                QgsProject.instance().removeMapLayer(lr.id())
            elif lr.name() == "Selected features":
                lr.setName('Kørekurver')
                self.layer= lr
        
        #Check Values                    
        # uniquevalues = []
        # uniqueprovider = self.layer.dataProvider()
        # fields = uniqueprovider.fields()
        # id = fields.indexFromName('direction')
        # uniquevalues = uniqueprovider.uniqueValues( id )
        # k=[]
        # for values in uniquevalues:
        #     if values != 0:
        #         k=1
        # if k !=1:
        #     iface.messageBar().pushMessage("Error", "Du skal vælge retning!", level=Qgis.Critical, duration=10)
           


    def affine(self,layer):
        processing.runAndLoadResults("native:affinetransform", {'INPUT': layer,'DELTA_X':0,'DELTA_Y':0,'DELTA_Z':0,'DELTA_M':0,'SCALE_X':-1,'SCALE_Y':1,'SCALE_Z':1,'SCALE_M':1,'ROTATION_Z':0,'OUTPUT':'TEMPORARY_OUTPUT'})      

    def transform(self,layer):
        for lyr in QgsProject.instance().mapLayers().values():  
            if lyr.name() == "Transformed":
                layer= lyr  
        self.canvas = self.iface.mapCanvas()
        e = self.iface.mapCanvas().extent()
        x_center=(e.xMaximum()+e.xMinimum())/2
        y_center=(e.yMaximum()+e.yMinimum())/2
        #center= [x_center,y_center]
        processing.runAndLoadResults("native:translategeometry", {'INPUT': layer,'DELTA_X':x_center-50,'DELTA_Y':y_center-40,'DELTA_Z':0,'DELTA_M':0,'OUTPUT':'TEMPORARY_OUTPUT'})
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Transformed":
                QgsProject.instance().removeMapLayer(lyr.id())
        for lyr in QgsProject.instance().mapLayers().values():  
            if lyr.name() == "Kørekurver":
                QgsProject.instance().removeMapLayer(lyr.id())  

    def zoomIn(self,layer):
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Kørekurver":
                extent = lyr.extent()
                self.canvas.setExtent(extent)
        #self.canvas.refresh()



    def setStyle(self,layer):
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Translated":
                layer= lyr
        lines = {'1': ('orange', 'dash', 'B-Linjer'),
                 '0':('red', 'simple','Hovedlinje')}
        categories = []
        for linestyle, (color, line_style, label) in lines.items():
            if line_style == 'dash':
                sym = QgsLineSymbol.createSimple({'line_style': 'dash'})
            else:
                sym = QgsSymbol.defaultSymbol(layer.geometryType())       
            sym.setColor(QColor(color))
            category = QgsRendererCategory(linestyle, sym, label)
            categories.append(category)
        renderer = QgsCategorizedSymbolRenderer('linetype', categories)
        layer.setRenderer(renderer)
        layer.setName('Kørekurver')


    def move(self):
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Kørekurver":   
                lyr.selectAll()
                lyr.startEditing()
                # Get all actions
                actions = iface.mainWindow().findChildren(QAction)

                # Check the action 
                action = [x for x in actions if x.objectName()=='mActionMoveFeature'][0]

                # Run the action
                action.trigger()

    def stoppe(self):   
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Kørekurver":
                lyr.commitChanges()
        #STOP EDITING AND ASKS
        self.iface.vectorLayerTools().stopEditing(lyr,False)
        lyr.removeSelection()

    def rotate(self):
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Kørekurver":   
                lyr.selectAll()
                lyr.startEditing()
                # Get all actions
                actions = iface.mainWindow().findChildren(QAction)

                # Check the action 
                action = [x for x in actions if x.objectName()=='mActionRotateFeature'][0]

                # Run the action
                action.trigger()

    def slet(self):
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == "Kørekurver":
                QgsProject.instance().removeMapLayer(lyr.id())
        self.iface.mapCanvas().refresh()