# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Kolba
                                 A QGIS plugin
 Plugin, which allows QGIS developers to test and share their job
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-02-22
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Pavel Pereverzev
        email                : pasha004@yandex.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from qgis._core import QgsApplication
from .resources import *

from .kolba_dockwidget import KolbaDockWidget
import os.path
import json 


folder_parent = QgsApplication.qgisSettingsDirPath()
kolba_dir = os.path.join(folder_parent, 'python', 'plugins', 'kolba') # advice by alex_deshev
cfg_folder = os.path.join(folder_parent, 'kolba_settings')
cfg_file = os.path.join(cfg_folder, 'kolba_cfg.json')


class kolba:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        # locale = QSettings().value('locale/userLocale')[0:2] # replaced with 'ru' by default due to errors 
        locale = 'ru'
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'kolba_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Kolba')
        self.toolbar = self.iface.addToolBar(u'kolba')
        self.toolbar.setObjectName(u'kolba')

        self.pluginIsActive = False
        self.dockwidget = None
        self.iface.kolba_plugin = {}


    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('kolba', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        checkable=False,
        enabled_flag=True,
        add_to_menu=False,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        action.setCheckable(checkable)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon_path = QIcon(os.path.join(self.plugin_dir, "icon.png"))
        self.iconAction = self.add_action(
            icon_path,
            text=self.tr(u'Kolba'),
            callback=self.run,
            checkable=True,
            parent=self.iface.mainWindow())
        if os.path.isfile(cfg_file):
            with open(cfg_file, 'r') as fp:
                data = json.load(fp)
                if data.get('plugin_is_opened', False):
                    self.iconAction.trigger()

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        self.dockwidget = None
        self.pluginIsActive = False
        self.iconAction.setChecked(False)


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Kolba'), action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar


    def run(self):
        if not self.pluginIsActive:
            self.pluginIsActive = True
            if self.dockwidget == None:
                self.dockwidget = KolbaDockWidget(None)
            self.dockwidget.setFloating(False)
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)
            self.iface.addDockWidget(Qt.DockWidgetArea.RightDockWidgetArea, self.dockwidget)
            self.iface.mainWindow().resizeDocks({self.dockwidget}, {600}, Qt.Orientation.Vertical)
    
        else:
            self.dockwidget.close()