# -*- coding: utf-8 -*-
"""
/***************************************************************************
 KartverketAdresse
                                 A QGIS plugin
 This plugin fetches coordinates for Norwegian addresses using the Kartverket open adress-API
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-10-28
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Morten Sickel
        email                : morten@sickel.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication,QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsProject, QgsPoint,QgsPointXY, QgsFeature, Qgis, QgsVectorLayer, QgsField, QgsGeometry, QgsMapLayerProxyModel,QgsCoordinateReferenceSystem
from PyQt5.QtWidgets import QLineEdit, QApplication, QWidget
from qgis.gui import  QgsMessageBar
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .kartverket_adresse_dialog import KartverketAdresseDialog
import os.path
import json
import urllib.request, urllib.parse

class KartverketAdresse:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'KartverketAdresse_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Kartverket adresse-API')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('KartverketAdresse', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToWebMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/kartverket_adresse/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Adresseoppslag'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginWebMenu(
                self.tr(u'&Kartverket adresse-API'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = KartverketAdresseDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # sending off a query to https://ws.geonorge.no/adresser/v1/#/default/get_sok
            # creating a new temporary data set and storing the data into that
            # TODO: Add more search fields
            # TODO: Add data to existing data set
            
            testurl="https://ws.geonorge.no/adresser/v1/sok?sok=Bedringens%20vei&fuzzy=false&utkoordsys=4258&treffPerSide=100&side=0&asciiKompatibel=true"
            treffPerSide = 1000
            soktekst = self.dlg.leSok.text()
            side = 0
            fuzzy = 'false'
            crs="EPSG:4258"
            sok = urllib.parse.quote(soktekst,safe='')
            worklayer = None
            pvd = None
            dataToFetch = True
            while dataToFetch:
                url=f"https://ws.geonorge.no/adresser/v1/sok?sok={sok}&fuzzy={fuzzy}&utkoordsys=4258&treffPerSide={treffPerSide}&side={side}&asciiKompatibel=true"
                jsondata = urllib.request.urlopen(url).read()
                dataset = json.loads(jsondata)
                metadata = dataset["metadata"]
                if metadata["totaltAntallTreff"] == 10000:
                    self.iface.messageBar().pushMessage("AdresseAPI - Advarsel", "10000 punkter blir hentet, kan være inkomplett", level=Qgis.Warning)
                if metadata["totaltAntallTreff"] == 0:
                    self.iface.messageBar().pushMessage("AdresseAPI - Advarsel", f"Fant ingen treff på '{soktekst}'", level=Qgis.Warning)
                    return(None)
                if worklayer is None:
                    worklayer = self.createlayer(crs,soktekst)
                    pvd = worklayer.dataProvider()
                adresser = dataset["adresser"]
                for adr in adresser:
                    reppoint = adr["representasjonspunkt"]
                    if reppoint["epsg"] != crs:
                        print(f"Feil crs: {reppoint['epsg']}")
                        continue
                    x=reppoint["lon"]
                    y=reppoint["lat"]
                    pnt=QgsPoint(x,y)
                    f = QgsFeature()
                    f.setGeometry(pnt)
                    f.setAttributes([adr['adressenavn'],adr['adressetekst'],adr['adressetilleggsnavn'],
                                     adr['adressekode'],adr['nummer'],adr['bokstav'],
                                     adr['kommunenummer'],adr['kommunenavn'],
                                     adr['gardsnummer'],adr['bruksnummer'],adr['festenummer'],adr['undernummer'],
                                     adr['objtype'],adr['poststed'],adr['postnummer'],adr['adressetekstutenadressetilleggsnavn']])
                    f=pvd.addFeatures([f])
                    pvd.forceReload()
                # Check if all data have been received
                if metadata["totaltAntallTreff"] > metadata["viserTil"]:
                    side += 1
                else:
                    dataToFetch = False

    
    def createlayer(self,crsstring,sok=''):
        # create layer to hold address information
        vl = QgsVectorLayer("Point", f"Adresseoppslag - {sok}", "memory")
        pr = vl.dataProvider()
        crs = QgsCoordinateReferenceSystem(crsstring)
        vl.setCrs(crs)
        pr.addAttributes([
            QgsField("adressenavn", QVariant.String),
            QgsField("adressetekst", QVariant.String),
            QgsField("adressetilleggsnavn", QVariant.String),
            QgsField("adressekode", QVariant.Int),
            QgsField("nummer", QVariant.Int),
            QgsField("bokstav", QVariant.String),
            QgsField("kommunenummer", QVariant.String),
            QgsField("kommunenavn", QVariant.String),
            QgsField("gardsnummer", QVariant.Int),
            QgsField("bruksnummer", QVariant.Int),
            QgsField("festenummer", QVariant.Int),
            QgsField("undernummer", QVariant.Int),
            QgsField("objtype", QVariant.String),
            QgsField("poststed", QVariant.String),
            QgsField("postnummer", QVariant.String),
            QgsField("adressetekstutenadressetilleggsnavn", QVariant.String)
            ])
        vl.updateFields() # tell the vector layer to fetch changes from the provider
        QgsProject.instance().addMapLayer(vl)
        return(vl)
    
    
