import os

from qgis.core import Qgis
from qgis.utils import iface
from qgis.gui import QgsMessageBar

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDialog, QSizePolicy


pluginPath = os.path.split(os.path.dirname(__file__))[0]

WIDGET, BASE = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "userconfigdialog.ui")
)


class UserConfigDialog(BASE, WIDGET):
    def __init__(self, existingConfigDict):
        super(QDialog, self).__init__(iface.mainWindow())
        self.setupUi(self)

        self.bar = QgsMessageBar()
        self.bar.setSizePolicy(QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.layout().addWidget(self.bar)

        self.buttonBox.accepted.connect(self.okClicked)
        self.buttonBox.rejected.connect(self.reject)
        self.txtUsername.setText(existingConfigDict.get("user.name"))
        self.txtEmail.setText(existingConfigDict.get("user.email"))

    def okClicked(self):
        self.username = self.txtUsername.text().strip()
        self.email = self.txtEmail.text().strip()
        if self.username and self.email:
            self.accept()
        else:
            self.bar.pushMessage(
                "", "Username and email must not be empty", Qgis.Warning, duration=5
            )
