

# Introduction

This processing module implements raster generalization by line integral convolution of the raster values along the surface gradient, as described in the PhD thesis [Automatic Swiss style rock depiction](https://doi.org/10.3929/ethz-b-000201368).

In the images below, hillshading is used to demonstrate the effect of this method: the original elevation raster is on the **left**, the generalized raster is on the **right**.

![img](./help/demo.jpg)


# Parameters

-   **Input raster:** Elevation raster.
-   **Integration length:** The main parameter, higher values correspond to increased abstraction of the terrain.
-   **Band number:** Number of the raster band, defaulting to 1.
-   **Z factor:** Elevation value scale, defaulting to 1. Must be greater than zero.
-   **Output raster:** Destination raster. Currently, only the GeoTiff file format is supported.

![img](./help/gui.png)

