

# Introduction

This processing module implements raster generalization by line integral convolution of the raster values along the surface gradient, as described in the PhD thesis [Automatic Swiss style rock depiction](https://doi.org/10.3929/ethz-b-000201368).

In the images below, hillshading is used to demonstrate the effect of this method: the original elevation raster is on the **left**, the generalized raster is on the **right**.

![img](./help/demo.jpg)


# Parameters

-   **Input raster:** Elevation raster.
-   **Integration length:** The main parameter, higher values correspond to increased abstraction of the terrain.
-   **Band number:** Number of the raster band, defaulting to 1.
-   **Z factor:** Elevation value scale, defaulting to 1. Must be greater than zero.
-   **Output raster:** Destination raster. Currently, only the GeoTiff file format is supported.

![img](./help/gui.png)


# The C extension module

The core of the algorithm is implemented in C and compiled as a shared library.
Binaries for Windows, Mac, and Linux are shipped with the plugin. If none of
these fit your platform, you need to compile the binaries by yourself.

See the **lib/src** folder for example Makefile projects. 
E.g., on Linux you would compile it using 

`make -f Makefile.Linux`

while on Windows you would run 

`make_win_msvc.bat`

if you are using the MS Visual C compiler, or, if using LLVM

`make_win_clang.bat`

The compiled module must reside in the **lib** folder in order to be found 
by the processing plugin.

