# -*- coding: utf-8 -*-
"""
/***************************************************************************
 JSONtoWaterbodiesforQGISDockWidget
                                 A QGIS plugin
 Creates linear and areal waterbody features from JSON.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-07-06
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Alexandra Crowe
        email                : anc284@psu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import json
from .waterbodies import *
import os,sys
import qgis

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal

from PyQt5.QtWidgets import QApplication, QMainWindow, QStyle, QFileDialog, QDialog, QMessageBox, QSizePolicy
from PyQt5.QtGui import QStandardItemModel, QStandardItem,  QDoubleValidator, QIntValidator
from PyQt5.QtCore import QVariant, QCoreApplication
from PyQt5.Qt import Qt

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'JSON_to_waterbodies_for_qgis_dockwidget_base.ui'))


class JSONtoWaterbodiesforQGISDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(JSONtoWaterbodiesforQGISDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        #setting instance variables
        self.nodesDict = {}
        self.waysDict = {}
        self.linearClasses = [stream, river, canal]
        self.areaClasses = [lake, pond, reservoir]
        self.fileFormat = "GPKG"

        #set icons for folder and exit buttons
        self.inputTB.setIcon(QCoreApplication.instance().style().standardIcon(QStyle.SP_DialogOpenButton))
        self.linearOutTB.setIcon(QCoreApplication.instance().style().standardIcon(QStyle.SP_DialogOpenButton))
        self.areaOutTB.setIcon(QCoreApplication.instance().style().standardIcon(QStyle.SP_DialogOpenButton))

        #connect signals
        self.inputTB.clicked.connect(self.selectInputFile)
        self.linearOutTB.clicked.connect(self.selectLineOutFile)
        self.areaOutTB.clicked.connect(self.selectAreaOutFile)
        self.executePB.clicked.connect(self.createFile)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def selectInputFile(self):
        fileName, _ = QFileDialog.getOpenFileName(self,"Select file", "","JSON (*.json)")
        if fileName:
            self.inputLE.setText(fileName)

    def selectLineOutFile(self):
        fileName, _ = QFileDialog.getSaveFileName(self,"Save new geopackage as", "","Geopackage (*.gpkg)")
        if fileName:
            self.linearOutLE.setText(fileName)

    def selectAreaOutFile(self):
        fileName, _ = QFileDialog.getSaveFileName(self,"Save new geopackage as", "","Geopackage (*.gpkg)")
        if fileName:
            self.areaOutLE.setText(fileName)

    def createFile(self):
        filename = self.inputLE.text()
        linearWaterbodiesFile = self.linearOutLE.text()
        arealWaterbodiesFile = self.areaOutLE.text()
        linearFeatures = []
        areaFeatures = []
        with open (filename, encoding = "utf8") as file:
            data = json.load(file)
        for element in data["elements"]:
            if element["type"] == "node":
                self.nodesDict[element["id"]] = element
            elif element["type"] == "way":
                self.waysDict[element["id"]] = element
        for wayID in self.waysDict:
            way = self.waysDict[wayID]
            for cl in self.linearClasses:
                result = cl.fromOSMWay(way,self.nodesDict)

                if result:
                    feature = result.toQgsFeature() # call toQgsFeature() to create a QgsFeature object from the waterbody object
                    linearFeatures.append(feature)
                else:
                    for ac in self.areaClasses:
                        result = ac.fromOSMWay(way, self.nodesDict)
                        if result:
                            feature = result.toQgsFeature()
                            areaFeatures.append(feature)

        linearWaterbody.savePolylineToFile(linearFeatures,linearWaterbodiesFile,self.fileFormat)
        arealWaterbody.savePolygonToFile(areaFeatures, arealWaterbodiesFile, self.fileFormat)
