# -*- coding: utf-8 -*-
"""
/***************************************************************************
 japanGeology3 
                                 A QGIS plugin
 japanGeology3
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-12
        git sha              : $Format:%H$
        copyright            : (C) 2023 by nirmal
        email                : joshi.nirmalraj@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# This plugin is inpired by japanElevaiton

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import *
from qgis.gui import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .japanGeology3_dialog import japanGeology3Dialog
import os.path
import os
import sys
import codecs
import urllib.request, urllib.error, urllib.parse
import json


class japanGeology3:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.dlg = japanGeology3Dialog()
        self.dlg.hide() 
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'japanGeology3_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&japanGeology3')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.menu = self.tr(u'&japanGeology3')
        self.toolbar = self.iface.addToolBar(u'japanGeology3')
        self.toolbar.setObjectName(u'japanGeology3')
        self.first_start = None
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('japanGeology3', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)
            self.toolbar.addAction(action) # to put tool bar in separate bar
            # self.iface.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/japanGeology3/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'japanGeology3'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&japanGeology3'),
                action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar

    def run(self):
        """Run method that performs all the real work"""

        self.toolClick = QgsMapToolClick(self.iface, self.canvas, self.dlg)
        self.canvas.setMapTool(self.toolClick)
# #get geology data
#get elevation data
def get_elevation(lat,lon):
    URL = "http://cyberjapandata2.gsi.go.jp/general/dem/scripts/getelevation.php?lon=" + str(lon) + "&lat=" + str(lat) +"&outtype=JSON"
    data_all = urllib.request.urlopen(URL)
    data = json.loads(data_all.read())
    elevationall = str(data['elevation'])+ u' m'
    data_all.close()
    return(elevationall)
# #get geology data
def get_geology(lat,lon):
    URL = "https://gbank.gsj.jp/seamless/v2/api/1.3/legend.json?point=" + str(lat) + "," + str(lon) #json output
    # print (URL)
    data_all = urllib.request.urlopen(URL)
    data = json.loads(data_all.read())
    # print(data)
    title = str(data['title'])
    symbol= str(data['symbol'])
    value= str(data['value'])
    formationAge_ja= str(data['formationAge_ja'])
    formationAge_en= str(data['formationAge_en'])
    group_ja= str(data['group_ja'])
    group_en= str(data['group_en'])
    lithology_ja= str(data['lithology_ja'])
    lithology_en= str(data['lithology_en'])
    output=[]
    output.append(symbol)
    output.append(group_en+" | "+lithology_en+" | "+formationAge_en)
    output.append(group_ja+" | "+lithology_ja+" | "+formationAge_ja)
    data_all.close()

    return(output)

class QgsMapToolClick(QgsMapTool):
    def __init__(self, iface, canvas, dlg):
        QgsMapTool.__init__(self, canvas)
        self.iface = iface
        self.canvas = canvas
        self.dlg = dlg

    def canvasPressEvent(self, mouseEvent):
            self.dlg.show()
            dPos = mouseEvent.pos()
            mPosBefore = self.toMapCoordinates(dPos)
            destcrs = self.iface.mapCanvas().mapSettings().destinationCrs()
            Tf = QgsCoordinateTransform(destcrs, QgsCoordinateReferenceSystem(4326), QgsProject.instance())
            mPos = Tf.transform(mPosBefore)
            lon = mPos.x()
            lat = mPos.y()
            elevationall = get_elevation(lat,lon)
            north=str(round(lat,5))
            south=str(round(lon,5))
            geo=get_geology(lat,lon)
            self.dlg.label.setText(elevationall)
            geoText="[N,E]=[ "+north+","+south+" ] \n EL="+str(elevationall)+" \n\n"+ geo[0]+"\n\n"+geo[1]+"\n"+geo[2]
            self.dlg.label_2.setText(str(geoText))
            self.dlg.show()

