# Japanese Area Unit - QGIS Plugin

A QGIS plugin for converting area values between metric units and traditional Japanese area units.

## Features

- Convert area values between metric and Japanese traditional units
- Get area from polygon layers (all features or individual feature)
- Add area labels to map in your preferred unit

### Supported Units

#### Metric Units
- Square Meters (㎡)
- Ares (a)
- Hectares (ha)

#### Japanese Traditional Units
- **Tsubo (坪)** - 3.305785 ㎡
- **Se (畝)** - 99.17355 ㎡ (30 tsubo)
- **Tan (反)** - 991.7355 ㎡ (10 se)
- **Cho (町)** - 9917.355 ㎡ (10 tan)

## Installation

### From QGIS Plugin Repository
1. Open QGIS
2. Go to `Plugins` > `Manage and Install Plugins...`
3. Search for "Japanese Area Unit"
4. Click `Install`

### From ZIP file
1. Download the plugin ZIP file from [Releases](https://github.com/akitaneko1127/japanese_area_unit/releases)
2. Open QGIS
3. Go to `Plugins` > `Manage and Install Plugins...`
4. Select `Install from ZIP`
5. Browse to the downloaded ZIP file and install

## Usage

### Manual Conversion
1. Click "日本面積単位" in the toolbar
2. Enter a value in the "Manual Input" section
3. Select the input unit
4. All conversion results are displayed automatically

### Get Area from Layer
1. Select a polygon layer from the dropdown
2. Choose "All Features" or a specific feature by ID
3. Click "Get Area" to calculate and convert

### Add Labels to Map
1. Select a polygon layer
2. Choose the unit for labels (e.g., 坪, 畝, 反, 町)
3. Click "Add Label" to display area labels on the map

## Unit Conversion Reference

| Unit | Square Meters | Tsubo |
|------|---------------|-------|
| 1 Tsubo (坪) | 3.305785 | 1 |
| 1 Se (畝) | 99.17355 | 30 |
| 1 Tan (反) | 991.7355 | 300 |
| 1 Cho (町) | 9917.355 | 3000 |
| 1 Hectare | 10000 | 3024.46 |

## Requirements

- QGIS 3.0 or later

## License

This plugin is licensed under the GNU General Public License v2 (GPLv2).

## Author

link-field

## Support

- GitHub: https://github.com/akitaneko1127/japanese_area_unit
- Issues: https://github.com/akitaneko1127/japanese_area_unit/issues
