# Japan Fude Polygon Loader

農林水産省が公開する筆ポリゴン（農地区画情報）データを簡単にダウンロード・読込できるQGISプラグイン。

## 機能

- **地域選択**: 都道府県→市区町村の階層選択UI
- **自動ダウンロード**: 筆ポリゴン公開サイトから自動取得
- **キャッシュ管理**: ダウンロード済みデータの再利用
- **自動読込**: 座標系（EPSG:6668）を自動設定してレイヤ追加
- **耕地種別色分け**: 田（水色）・畑（黄土色）を自動で色分け表示

## インストール

### QGISプラグインマネージャーから
1. QGIS メニュー → プラグイン → プラグインの管理とインストール
2. 「Japan Fude Polygon Loader」を検索
3. インストールをクリック

### 手動インストール
1. このリポジトリをダウンロード
2. japan_fude_polygon_loader フォルダを QGIS プラグインディレクトリにコピー
   - Windows: %APPDATA%/QGIS/QGIS3/profiles/default/python/plugins/
   - macOS: ~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/
   - Linux: ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
3. QGISを再起動し、プラグインマネージャーで有効化

## 使い方

1. ツールバーの「筆ポリゴン読込」ボタンをクリック
2. 都道府県を選択
3. 市区町村を選択（複数選択可）
4. 「ダウンロード・読込」をクリック
5. 自動でレイヤが追加され、耕地種別で色分け表示されます

## データ仕様

### 筆ポリゴン属性

| 属性名 | 説明 |
|--------|------|
| polygon_uuid | 筆ポリゴンの一意識別子 |
| land_type | 耕地種別コード（100=田, 200=畑） |
| issue_year | データ公開年度 |
| point_lng | 代表点経度 |
| point_lat | 代表点緯度 |

### 耕地種別の色分け

| コード | 名称 | 表示色 |
|--------|------|--------|
| 100 | 田 | 水色 (#7ecef4) |
| 200 | 畑 | 黄土色 (#f5d67a) |

### 座標系

- 測地系: JGD2011（日本測地系2011）
- EPSG: 6668（地理座標系）

## データソース

農林水産省「筆ポリゴン公開サイト」
- https://open.fude.maff.go.jp/

### 利用規約

- 複製、公衆送信、編集・加工等、自由に利用可能
- 商用利用可能
- 出典明記必要（「農林水産省『筆ポリゴンデータ（○○年度公開）』」）

## 動作環境

- QGIS 3.22以上（LTR推奨）
- Python 3.9以上
- インターネット接続（データダウンロード時）

## ライセンス

GPL-3.0

## 作者

Link Field
