# -*- coding: utf-8 -*-
"""
Japan Forest Tools - Main Plugin Module

Copyright (C) 2026 Link Field
License: GPL-3.0
"""

import os
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtCore import Qt, QSettings, QTranslator, QCoreApplication


class JapanForestTools:
    """Main plugin class for Japan Forest Tools."""

    def __init__(self, iface):
        """Initialize the plugin."""
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.actions = []
        self.menu = "&Japan Forest Tools"
        self.toolbar = self.iface.addToolBar("Japan Forest Tools")
        self.toolbar.setObjectName("JapanForestTools")
        self.toolbar.setToolButtonStyle(Qt.ToolButtonTextOnly)
        self.main_dialog = None

        # Initialize locale
        locale_setting = QSettings().value('locale/userLocale')
        if locale_setting:
            locale = locale_setting[0:2]
        else:
            locale = 'en'
        locale_path = os.path.join(self.plugin_dir, 'i18n', f'{locale}.qm')

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

    def tr(self, message):
        """Get the translation for a string."""
        return QCoreApplication.translate('JapanForestTools', message)

    def initGui(self):
        """Initialize the GUI elements."""
        self.action_main = QAction("森林データ取得", self.iface.mainWindow())
        self.action_main.triggered.connect(self.run)
        self.action_main.setStatusTip("森林関連オープンデータのダウンロード・読込")
        self.toolbar.addAction(self.action_main)
        self.iface.addPluginToMenu(self.menu, self.action_main)
        self.actions.append(self.action_main)

    def unload(self):
        """Remove the plugin menu items and toolbar."""
        for action in self.actions:
            self.iface.removePluginMenu(self.menu, action)
            self.iface.removeToolBarIcon(action)

        del self.toolbar

        if self.main_dialog:
            self.main_dialog.close()
            self.main_dialog = None

    def run(self):
        """Show the main dialog."""
        from .dialogs import MainDialog
        if self.main_dialog is None:
            self.main_dialog = MainDialog(self.iface, self.iface.mainWindow())
        self.main_dialog.show()
        self.main_dialog.raise_()
        self.main_dialog.activateWindow()
