# Japan CRS Selector

日本の平面直角座標系（第1〜19系）を自動判別し、プロジェクトCRSを簡単に設定できるQGISプラグイン。

## 機能

- **座標系自動判別**: マップキャンバスの中心座標または指定座標から最適な平面直角座標系を自動判別
- **測地系選択**: JGD2024、JGD2011、JGD2000に対応
- **プロジェクトCRS設定**: ワンクリックでプロジェクトCRSを設定
- **座標変換ツール**: 緯度経度⇔平面直角座標の相互変換
- **X/Y軸反転**: 公共測量座標（N=X, E=Y）とGIS座標（X=E, Y=N）の変換
- **座標系一覧**: 第1系〜第19系の原点・適用地域一覧表示

## インストール

### QGISプラグインマネージャーから
1. QGIS メニュー → プラグイン → プラグインの管理とインストール
2. 「Japan CRS Selector」を検索
3. インストールをクリック

### 手動インストール
1. このリポジトリをダウンロード
2. japan_crs_selector フォルダを QGIS プラグインディレクトリにコピー
   - Windows: %APPDATA%/QGIS/QGIS3/profiles/default/python/plugins/
   - macOS: ~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/
   - Linux: ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
3. QGISを再起動し、プラグインマネージャーで有効化

## 使い方

### 座標系選択
1. ツールバーの「座標系選択」ボタンをクリック
2. 緯度・経度を入力するか、「マップ中心を取得」をクリック
3. 「座標系を判別」をクリック
4. 測地系（JGD2024/JGD2011/JGD2000）を選択
5. 「プロジェクトCRSに設定」をクリック

### 座標変換
1. メニューから「Japan CRS Selector」→「座標変換ツール」を選択
2. 変換方向、座標系、測地系を選択
3. 座標値を入力して「変換」をクリック

## 対応座標系

| 系 | EPSG (JGD2011) | EPSG (JGD2000) | 主な適用地域 |
|----|----------------|----------------|-------------|
| I | 6669 | 2443 | 長崎県、鹿児島県西部 |
| II | 6670 | 2444 | 福岡県、佐賀県、熊本県、大分県、宮崎県、鹿児島県 |
| III | 6671 | 2445 | 山口県、島根県、広島県 |
| IV | 6672 | 2446 | 香川県、愛媛県、徳島県、高知県 |
| V | 6673 | 2447 | 兵庫県、鳥取県、岡山県 |
| VI | 6674 | 2448 | 京都府、大阪府、福井県、滋賀県、三重県、奈良県、和歌山県 |
| VII | 6675 | 2449 | 石川県、富山県、岐阜県、愛知県 |
| VIII | 6676 | 2450 | 新潟県、長野県、山梨県、静岡県 |
| IX | 6677 | 2451 | 東京都、福島県、栃木県、茨城県、埼玉県、千葉県、群馬県、神奈川県 |
| X | 6678 | 2452 | 青森県、秋田県、山形県、岩手県、宮城県 |
| XI | 6679 | 2453 | 北海道（西部） |
| XII | 6680 | 2454 | 北海道（中央部） |
| XIII | 6681 | 2455 | 北海道（東部） |
| XIV | 6682 | 2456 | 東京都（南鳥島） |
| XV | 6683 | 2457 | 沖縄県（那覇、久米島） |
| XVI | 6684 | 2458 | 沖縄県（石垣島、西表島） |
| XVII | 6685 | 2459 | 沖縄県（大東諸島） |
| XVIII | 6686 | 2460 | 東京都（沖ノ鳥島） |
| XIX | 6687 | 2461 | 東京都（小笠原諸島） |

## JGD2024について

JGD2024は2025年4月から施行された新しい測地系です。水平座標（緯度・経度）はJGD2011と同一であり、標高のみが変更されています。本プラグインではJGD2024選択時もJGD2011と同じEPSGコードを使用します。

## 動作環境

- QGIS 3.22以上（3.40.x LTR推奨）
- Python 3.9以上

## ライセンス

GPL-3.0

## 作者

Link Field
