# -*- coding: utf-8 -*-
"""
Japan CRS Selector - Core Module
座標系判別・変換処理のコアモジュール

This module provides the core functionality for:
- Zone master data management (ZoneMaster, ZoneInfo)
- Coordinate zone detection (ZoneDetector)
- Coordinate transformation (CoordinateConverter)
"""

from .zone_master import ZoneMaster, ZoneInfo
from .zone_detector import ZoneDetector
from .coordinate_converter import CoordinateConverter

__all__ = ["ZoneMaster", "ZoneInfo", "ZoneDetector", "CoordinateConverter"]
