# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ItalyInspireCadastreDownloaderDialog
                                 A QGIS plugin
 QGIS plugin for downloading cadastral data of cadastrals parcels and cadastral zoning in Italy.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-02-12
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Geoinnova SL / Patricio Soriano & Miquel Febrer
        email                : correo@geoinnova.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import requests
import zipfile

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtSvg import QSvgRenderer
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.utils import iface, Qgis
from qgis.core import QgsProject, QgsVectorLayer
import processing

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Italy_Inspire_Cadastre_Downloader_dialog_base.ui'))

BASE_URL = 'https://iicd.geoinnova.it'

class ItalyInspireCadastreDownloaderDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(ItalyInspireCadastreDownloaderDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        self.iface = iface
        self.msgBar = iface.messageBar()
        self.locale = QSettings().value('locale/userLocale')[0:2]
        print(self.locale)
        
        self.plugin_dir = os.path.dirname(__file__)
        
        self.lineEdit_path.clear()
        self.comboBox_region.clear()
        self.comboBox_province.clear()
        self.comboBox_municipality.clear()
        self.checkBox_addToMap.setChecked(1)
        
        # show the dialog
        self.progressBar.setValue(0)
        self.setWindowIcon(QIcon(os.path.join(self.plugin_dir,'icons','icon.png')))
        self.show()
        
        # pixmap = QPixmap(100, 50)
        pixmap = QPixmap(os.path.join(self.plugin_dir,'icons','geoinnova.png'))  # Cargar imagen PNG
        # pixmap_scaled = pixmap.scaledToWidth(50)
        self.label_svg.setMaximumWidth(225)
        self.label_svg.setMaximumHeight(67)
        self.label_svg.setPixmap(pixmap)
        self.label_svg.setScaledContents(True)  # Escalar la imagen para ajustarla
        self.comboBox_municipality.view().setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
               
        self.municipality_activated = False
        self.directory_activated = False
        
        self.pushButton_select_path.clicked.connect(self.select_output_folder)
        
        # Get data and load regions
        self.get_data()
        self.load_regions()
        
        # Conectar eventos
        self.comboBox_region.currentIndexChanged.connect(self.load_provinces)
        self.comboBox_province.currentIndexChanged.connect(self.load_municipalities)
        self.comboBox_municipality.currentIndexChanged.connect(self.restart_progressbar)
        self.pushButton_run.clicked.connect(self.download)
        self.comboBox_municipality.model().itemChanged.connect(self._lambda_manejar_opcion())
        
        self.text_all = self.tr("All")
        self.text_all_estado = False


    def _lambda_manejar_opcion(self):
        return lambda item: self.manejar_opcion_todos(self.comboBox_municipality, item)

    def select_output_folder(self) -> None:
        """Select output folder"""
        self.lineEdit_path.clear()
        folder = QFileDialog.getExistingDirectory(self, self.tr("Select folder"))
        self.lineEdit_path.setText(folder)
        if os.path.isdir(self.lineEdit_path.text()):
            self.directory_activated = True
            self.restart_progressbar()
        
    
    def make_request(self, endpoint, save_directory=None, file_name=None):
        """
        Realiza una solicitud GET a un endpoint de la API.

        :param endpoint: El endpoint de la API.
        :param save_directory: (Opcional) Carpeta donde guardar el archivo si es una descarga.
        :param file_name: (Opcional) Nombre del archivo sin la extensión.
        :return: Datos JSON o confirma la descarga del archivo.
        """
        url = f"{BASE_URL}{endpoint}"
        response = requests.get(url)

        if response.status_code == 200:
            if save_directory and file_name:
                os.makedirs(save_directory, exist_ok=True)
                complete_file_path = os.path.join(save_directory, f"{file_name}.zip")
                with open(complete_file_path, 'wb') as file:
                    file.write(response.content)
                return True
            else:
                return response.json()
        else:
            msg = self.tr(f"An error occurred while request data. Code error: ")
            self.msgBar.pushMessage(f'{msg} {response.status_code}', level=Qgis.Warning, duration=3)
            return None

        # Ejemplo de uso
        # Descargar un archivo
            
    def get_data(self):
        
        self.json_data = self.make_request('/all_municipalities')
        self.comboBox_region.clear()
        self.comboBox_province.clear()
        self.comboBox_municipality.clear()
        
        
    def load_regions(self):
        """Cargar todas las regiones en el ComboBox de regiones."""
        self.comboBox_region.clear()
        self.comboBox_region.addItem(self.tr("Select a region"), None)  # Opción por defecto
        for region in self.json_data.keys():
            self.comboBox_region.addItem(region, region)
            
        self.municipality_activated = False
        self.restart_progressbar()

    def load_provinces(self):
        """Cargar provincias basadas en la región seleccionada."""
        self.comboBox_province.clear()
        self.comboBox_municipality.clear()
        region = self.comboBox_region.currentData()

        if region and region in self.json_data:
            self.comboBox_province.addItem(self.tr("Select a province"), None)
            for province in self.json_data[region].keys():
                self.comboBox_province.addItem(province, province)
        
        self.municipality_activated = False
        self.restart_progressbar()

    def load_municipalities(self):
        """Cargar municipios basados en la provincia seleccionada."""
        # print("municipios activado")
        try:
            self.comboBox_municipality.model().itemChanged.disconnect(self._lambda_manejar_opcion)
            # print("desactivado municipios")
        except Exception as e:
            # print("Exception desactivado municipios:",e)
            pass
        
        # self.comboBox_municipality.setModel(QStandardItemModel())
        self.comboBox_municipality.clear()
        region = self.comboBox_region.currentData()
        province = self.comboBox_province.currentData()

        if region and province and province in self.json_data[region]:
            self.comboBox_municipality.addItem(self.text_all, self.text_all)
            # item_todos.setFlags(Qt.ItemIsEnabled | Qt.ItemIsUserCheckable | Qt.ItemIsSelectable| Qt.ItemIsEditable)
            
            for municipality in self.json_data[region][province]:
                self.comboBox_municipality.addItem(municipality, municipality)
                index = self.comboBox_municipality.count() - 1
                item = self.comboBox_municipality.model().item(index)

        try:
            self.comboBox_municipality.model().itemChanged.connect(self._lambda_manejar_opcion)
            # print("activado municipios")
        except Exception as e:
            # print("Exception activado municipios:",e)
            pass
        
        self.municipality_activated = True
        self.restart_progressbar()
        
    
    def manejar_opcion_todos(self, combo, changed_item):
        try:
            self.comboBox_municipality.model().itemChanged.disconnect(self._lambda_manejar_opcion)
            # print("desactivado opciones")
        except Exception as e:
            # print("Exception desactivado opciones:",e)
            pass
        model = combo.model()
        index_todos = 0  # "Todos" está en el índice 1

        item_todos = model.item(index_todos)
        if not item_todos:
            return

        if item_todos.checkState() == Qt.Checked and self.text_all_estado == False:
            # Se marcó "Todos" → desactivar el resto
            # print("Estaba desactivado y se ha activado1")
            self.text_all_estado = True
            for i in range(1, combo.count()):
                item = model.item(i)
                if item:
                    item.setCheckState(Qt.Checked)
                    item.setFlags(item.flags() & ~Qt.ItemIsEnabled)
 
                    
        elif item_todos.checkState() == Qt.Checked and self.text_all_estado == True:
            # print("Estaba activado y sigue activado2")
            changed_item.setCheckState(Qt.Checked)
            self.text_all_estado = True
            pass
        elif item_todos.checkState() == Qt.Unchecked and self.text_all_estado == False:
            # print("Estaba desactivado y sigue desactivado3")
            self.text_all_estado = False
            pass
            # Se desmarcó "Todos" → reactivar y deseleccionar el resto

                    
        elif item_todos.checkState() == Qt.Unchecked and self.text_all_estado == True:
            # print("Estaba activado y se ha desactivado4")
            self.text_all_estado = False
            # Se desmarcó "Todos" → reactivar y deseleccionar el resto
            for i in range(1, combo.count()):
                item = model.item(i)
                if item:
                    item.setCheckState(Qt.Unchecked)
                    item.setFlags(item.flags() | Qt.ItemIsEnabled | Qt.ItemIsSelectable | Qt.ItemIsUserCheckable)
                    
        
        try:
            self.comboBox_municipality.model().itemChanged.connect(self._lambda_manejar_opcion)
            # print("activado opciones")
        except Exception as e:
            # print("Exception activado opciones:",e)
            pass
    
    
    def restart_progressbar(self):
        self.progressBar.setValue(0)
        
    
    def unzip_file(self, zipfilename, folder_extract):
        
        try:
            if os.path.exists(zipfilename):
                with zipfile.ZipFile(zipfilename, "r") as z:
                    z.extractall(folder_extract)
        except:
            msg = self.tr("An error occurred while decompressing the file")
            self.msgBar.pushMessage(f'{msg}', level=Qgis.Warning, duration=3)
            return None
        
    def get_file_style(self, base_path, base_name):
        """
        Get style file by language
        """

        # Path alternatives
        style_en = os.path.join(base_path, f"{base_name}_en.qml")
        style_lan = os.path.join(base_path, f"{base_name}_{self.locale}.qml")
        style_base = os.path.join(base_path, f"{base_name}.qml")  # style base italiano

        # Selection
        if self.locale == "en" and os.path.exists(style_en):
            style_file = style_en
        elif os.path.exists(style_lan):
            style_file = style_lan
        else:
            style_file = style_base

        return style_file
        
        
    def add_style(self, layer):
        
        if "_map" in layer.name():
            layer.loadNamedStyle(os.path.join(self.plugin_dir,"styles","map.qml"))
        elif "_ple" in layer.name():
            # layer.loadNamedStyle(os.path.join(self.plugin_dir,"styles","ple.qml"))
            file_style = self.get_file_style(os.path.join(self.plugin_dir,"styles"),"ple")
            layer.loadNamedStyle(file_style)
        
    
    def add_layers(self, folder, group_name, ext):

        project = QgsProject.instance()
        tree_root = project.layerTreeRoot()
        layers_group = tree_root.addGroup(group_name)

        for file in os.listdir(folder):
            if file.endswith(ext):
                layer_path = os.path.join(folder, file)
                file_name = os.path.splitext(file)[0]
                gml_layer = QgsVectorLayer(layer_path, file_name, "ogr")
                project.addMapLayer(gml_layer, False)
                layers_group.addLayer(gml_layer)
                self.add_style(gml_layer)
                
    def export_to_extension(self, folder, ext_source, ext_target):
        for file in os.listdir(folder):
            if file.endswith(ext_source):
                layer_path_source = os.path.join(folder, file)
                layer_path_target = os.path.join(folder, file.replace(ext_source, ext_target))
                file_name = os.path.splitext(file)[0]
                
                processing.run("native:savefeatures", {'INPUT':layer_path_source,
                                                   'OUTPUT':layer_path_target,
                                                   'LAYER_NAME':file_name,
                                                   'DATASOURCE_OPTIONS':'',
                                                   'LAYER_OPTIONS':'',
                                                   'ACTION_ON_EXISTING_FILE':0})
    
    

    def download(self):
        
        region = self.comboBox_region.currentData()
        province = self.comboBox_province.currentData()
        municipalities = self.comboBox_municipality.checkedItems()  # Ahora es una lista
        folder = self.lineEdit_path.text()

        if not self.directory_activated:
            msg = self.tr("You must add a download folder")
            self.msgBar.pushMessage(f'{msg}', level=Qgis.Warning, duration=3)
            return None

        extension_file_add = ".gml"
        if self.checkBox_dwn_gpkg.isChecked():
            extension_file_add = ".gpkg"

        # Filtrar los municipios válidos
        valid_municipalities =  [m for m in municipalities if m not in ("", self.text_all)]

        if not valid_municipalities or not self.municipality_activated:
            msg = self.tr("You must select a municipality")
            self.msgBar.pushMessage(f'{msg}', level=Qgis.Warning, duration=3)
            return None
        
        total = len(valid_municipalities)
        self.progressBar.setValue(0)

        for idx, municipality in enumerate(valid_municipalities):
            file = os.path.join(folder, municipality + ".zip")
            folder_extract = os.path.splitext(file)[0]

            if os.path.isdir(folder_extract):
                msg = self.tr(f"The folder for {municipality} already exists")
                self.msgBar.pushMessage(f'{msg}', level=Qgis.Warning, duration=3)
                continue  # Saltar a siguiente municipio
            else:
                os.makedirs(folder_extract)

            self.make_request(f'/download/{region}/{province}/{municipality}', folder, municipality)
            # self.progressBar.setValue(25)

            self.unzip_file(file, folder_extract)
            os.remove(file)
            # self.progressBar.setValue(50)

            if self.checkBox_dwn_gpkg.isChecked():
                self.export_to_extension(folder_extract, ".gml", ".gpkg")

            msg = self.tr(f"Download for {municipality} completed")
            self.msgBar.pushMessage(f'{msg}', level=Qgis.Info, duration=2)

            if self.checkBox_addToMap.isChecked():
                self.add_layers(folder_extract, municipality, extension_file_add)
                
            progress = int((idx / total) * 100)
            self.progressBar.setValue(progress)

        self.progressBar.setValue(100)

    
    def check_form(self, option: int) -> None:
        """Message for fields without information"""

        messages = {
            1: self.tr('You must complete the data of the province and municipality and indicate the download route.'),
            2: self.tr('You must select at least one cadastral entity to download.')
        }

        QgsMessageLog.logMessage(messages[option], 'SICD',
                                 level=Qgis.Warning)

        self.msgBar.pushMessage(messages[option], level=Qgis.Warning, duration=3)
        
    
    def _close(self):
        self.close()
        
