import os

from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessingProvider

from .raster_to_obj_processing_algorithm import RasterToObjProcessingAlgorithm
from .point_layer_to_obj_processing_algorithm import PointLayerToObjProcessingAlgorithm


class Provider(QgsProcessingProvider):

    def loadAlgorithms(self, *args, **kwargs):
        self.addAlgorithm(RasterToObjProcessingAlgorithm())
        self.addAlgorithm(PointLayerToObjProcessingAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self, *args, **kwargs):
        """The ID of your plugin, used for identifying the provider.
        This string should be a unique, short, character only string,
        eg "qgis" or "gdal". This string should not be localised.
        """
        return 'Io3dPlugin'

    def name(self, *args, **kwargs):
        """The human friendly name of your plugin in Processing.
        This string should be as short as possible (e.g. "Lastools", not
        "Lastools version 1.0.1 64-bit") and localised.
        """
        return self.tr('3D IO Plugin')

    def icon(self):
        """Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        plugin_dir = os.path.dirname(__file__)
        print(plugin_dir)
        icon_fn = os.path.join(plugin_dir, 'img', 'icon_plugin.svg')
        icon = QIcon(icon_fn)
        return icon