from qgis.core import QgsApplication
from .provider import Provider
from .mesh.mesh_factory import MeshFactory

from .mesh.vertex import *


class Io3dPlugin():

    def __init__(self, iface):
        self.iface = iface
        self.version = '0.1.0'
        self.provider = None

        self.mesh_factory = MeshFactory()
        self.vertex = Vertex(0,0,0)


    def initProcessing(self):
        self.provider = Provider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)