import math

def make_numeric(value):
    # Attempts to get an int or float value or else returns None.
    if isinstance(value, int):
        return value
    elif isinstance(value, float):
        if math.isnan(value):
            return None 
        else:
            return value
    elif isinstance(value, str):
        try:
            return float(value)
        except ValueError:
            return None
    else:
        return None