class Vertex():

    def __init__(self, x, y, z, r=None, g=None, b=None):
        self.x = x
        self.y = y
        self.z = z
        self.r = r
        self.g = g
        self.b = b
    
    def __str__(self):
        if self.has_rgb():
            return f'Vertex[{self.x} {self.y} {self.z}, ({self.r},{self.g},{self.b})]'
        else:
            return f'Vertex[{self.x} {self.y} {self.z}]'
    
    def __eq__(self, v2):
        return self.x == v2.x and self.y == v2.y and self.z == v2.z

    def __hash__(self):
        return hash((self.x, self.y, self.z))

    def set_rgb(self, r, g, b):
        self.r = r
        self.g = g
        self.b = b

    def has_rgb(self):
        return self.r is not None and self.g is not None and self.b is not None


class VertexList(dict):

    def __init__(self):
        pass

    def __str__(self):
        return f'Vertices[{len(self)}]'

    def add_vertex(self, v):
        if v in self:
            return self[v]['id']
        else:
            i = len(self) + 1
            self[v] = {'id': i}
            return i
    
    def get_bounds(self):
        min_x = max_x = min_y = max_y = min_z = max_z = None
        if len(self) > 0:
            v = next(iter(self))
            min_x = max_x = v.x
            min_y = max_y = v.y
            min_z = max_z = v.z
            for v in self:
                min_x = min(min_x, v.x)
                min_y = min(min_y, v.y)
                min_z = min(min_z, v.z)
                max_x = max(max_x, v.x)
                max_y = max(max_y, v.y)
                max_z = max(max_z, v.z)
        return (min_x, min_y, min_z, max_x, max_y, max_z)
