# -*- coding: utf-8 -*-
"""
/***************************************************************************
 InterfaceCatchment
                                 A QGIS plugin
 description
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-09-13
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Ivan Majic
        email                : imajicos@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import (QSettings, QTranslator, qVersion, QCoreApplication,
                          QObject, QThread, pyqtRemoveInputHook, pyqtSignal,
                          QVariant)
from PyQt5.QtGui import QIcon, QDoubleValidator, QColor
from PyQt5.QtWidgets import QAction

from qgis.core import *
from qgis.gui import *

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .interface_catchment_dialog import InterfaceCatchmentDialog
import os.path
import processing
from osgeo import ogr, osr
from math import isnan

import time

# from .functions import read_runtime_parameters, worker

from .icworker import ICWorker

_translate = QtCore.QCoreApplication.translate

class InterfaceCatchment:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # self.project = QgsProject.instance()
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'InterfaceCatchment_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = InterfaceCatchmentDialog(parent=self.iface.mainWindow())

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Interface Catchment')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'InterfaceCatchment')
        self.toolbar.setObjectName(u'InterfaceCatchment')

##############################################################################
        # this is where i define that qgsmaplayercombobox should only
        # list line and polygon layers, and point layers in the second one
        vector_layers_filter = QgsMapLayerProxyModel.LineLayer | QgsMapLayerProxyModel.PolygonLayer
        self.dlg.mMapLayerComboBox.setFilters(vector_layers_filter)
        point_layers_filter = QgsMapLayerProxyModel.Filter(4)
        self.dlg.mMapLayerComboBox_2.setFilters(point_layers_filter)

        # this is where I define what the ok and cancel buttons do
        # self.dlg.button_box.accepted.connect(self.execute)
        # self.dlg.button_box.accepted.connect(self.task)
        self.dlg.button_box.accepted.connect(self.execute)
        self.dlg.button_box.rejected.connect(self.close_dialog)

        # this is where I connect the starting point layer combobox to
        # a read_point_coordinates function
        self.dlg.mMapLayerComboBox_2.layerChanged.connect(self.read_point_coordinates)

        # this is my line where I define that checkbox click should call a
        # function
        self.dlg.checkBox.stateChanged.connect(self.checkbox_on_change)
        self.dlg.checkBox_2.stateChanged.connect(self.checkbox2_on_change)

        # this is where I hide the warning message at first and then I can
        # always show it when needed
        self.dlg.label_8.hide()

        # this is where I set the validator for the lineedits from the gui that
        # will hold the coordinate values
        validator = QDoubleValidator(decimals=13, notation=0)
        self.dlg.lineEdit.setValidator(validator)
        self.dlg.lineEdit_2.setValidator(validator)

        # This is to enable selecting a starting point by clicking on the map
        self.canvas = self.iface.mapCanvas()
        self.clickTool = QgsMapToolEmitPoint(self.canvas)
        self.clickTool.canvasClicked.connect(self.read_click_coordinates)
        self.dlg.pushButton.clicked.connect(self.click_starting_point)


    def click_starting_point(self):
        self.current_map_tool = self.canvas.mapTool()
        self.canvas.setMapTool( self.clickTool )
        self.dlg.hide()

    def read_click_coordinates(self, point, button):
        self.dlg.label_8.hide()
        self.dlg.lineEdit.setText(str(point.x()))
        self.dlg.lineEdit_2.setText(str(point.y()))
        self.canvas.setMapTool( self.current_map_tool )
        self.dlg.mMapLayerComboBox_2.setCurrentIndex(-1)
        self.dlg.show()

    def close_dialog(self):
        """Method for closing the plugin dialog when button cancel is
        pressed"""
        self.dlg.close()

    def checkbox_on_change(self, signal):
        """A method that disables other options when checkBox_3 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the buffer distance spinbox
        is enabled, otherwise it's disabled."""
        if signal:
            self.dlg.checkBox_2.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox_2.isChecked():
            self.dlg.checkBox.setCheckState(QtCore.Qt.Checked)

    def checkbox2_on_change(self, signal):
        """A method that disables other options when checkBox_3 is clicked.
        It takes in a dialog and a signal that says if the changed state
        is True of False as parameters. If True, the buffer distance spinbox
        is enabled, otherwise it's disabled."""
        if signal:
            self.dlg.checkBox.setCheckState(QtCore.Qt.Unchecked)
        elif not self.dlg.checkBox.isChecked():
            self.dlg.checkBox_2.setCheckState(QtCore.Qt.Checked)

    # this is where I read out the coordinates of the chosen point and
    # write them into the x and y text boxes
    def read_point_coordinates(self, layer):
        """Method that takes in the point layer chosen by user, checks if there
        is only one point selected, reads its coordinates and writes them into
        the x and y text boxes. If there are multiple points in the point
        layer, and not one point selected, then raise the warning message and
        block the accept button."""
        self.dlg.label_8.hide()
        if not layer:
            pass
        elif layer.featureCount() == 0:
            # layer has 0 features, raise warning
            self.dlg.label_8.setText(
                _translate(
                    "interface_catchment_DialogBase",
                    "<html><head/><body><p align=\"center\"><span style=\" color:#ff0000;\">The selected starting point layer has 0 features!<br/>Please select a different starting point layer or insert the starting point coordinates.</span></p></body></html>"
                )
            )
            self.dlg.label_8.show()
        elif layer.featureCount() == 1:
            # layer has exactly 1 point feature, select this feature and
            # proceed using it as a starting point
            for feature in layer.getFeatures():
                geom = feature.geometry().asPoint()
                x = geom.x()
                y = geom.y()
                self.dlg.lineEdit.setText(str(x))
                self.dlg.lineEdit_2.setText(str(y))
        elif layer.selectedFeatureCount() == 1:
            # layer has more than 1 feature, but there is exactly 1 feature
            # selected which is going to be used as a starting point
            for feature in layer.getSelectedFeatures():
                geom = feature.geometry().asPoint()
                x = geom.x()
                y = geom.y()
                self.dlg.lineEdit.setText(str(x))
                self.dlg.lineEdit_2.setText(str(y))
        else:
            # layer has more than 1 features, and the number of selected
            # features is different than 1 - it is not clear which point is the
            # starting point... raise warning for user to select a starting
            # point from the layer
            self.dlg.label_8.setText(
                _translate(
                    "interface_catchment_DialogBase",
                    "<html><head/><body><p align=\"center\"><span style=\" color:#ff0000;\">The selected starting point layer has multiple features and the starting point is ambiguous!<br/>Please select 1 point from the starting point layer using the selection tool.</span></p></body></html>"
                )
            )
            self.dlg.label_8.show()

################################################################################

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('InterfaceCatchment', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/interfacecatchment/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Interface catchment'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Interface Catchment'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar


    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()

    def log(self, message: str, level=Qgis.Info):
        QgsMessageLog.logMessage(message, 'InterfaceCatchment', level=level)

    def showLayer(self, layer, params):
        added_layer = QgsProject.instance().addMapLayer(layer)
        color = params.get('color')
        width = params.get('width')
        if color:
            added_layer.renderer().symbol().setColor(QColor(color))
        if width:
            added_layer.renderer().symbol().setWidth(width)
        added_layer.triggerRepaint()
        self.iface.layerTreeView().refreshLayerSymbology(added_layer.id())
        # self.log('Added layer "%s" with color: %s, width: %s to the map.' %(layer.sourceName(),color,width))

    def styleLayer(self, added_layer, params):
        color = params.get('color')
        width = params.get('width')
        if color:
            added_layer.renderer().symbol().setColor(QColor(color))
        if width:
            added_layer.renderer().symbol().setWidth(width)
        added_layer.triggerRepaint()
        self.iface.layerTreeView().refreshLayerSymbology(added_layer.id())
        self.log('Added layer "%s" with color: %s, width: %s to the map.' %(added_layer.sourceName(),color,width))
    
    def update_task_number_label(self):
        active_tasks = QgsApplication.taskManager().activeTasks()
        ic_task_count = sum([1 for t in active_tasks if type(t)==ICWorker])
        if ic_task_count == 1:
            self.dlg.label_10.setText(
                'There is %s IC plugin task running in the background. Please wait!' %ic_task_count
            )
        elif ic_task_count == 0:
            self.dlg.label_10.setText('')
        elif ic_task_count > 1:
            self.dlg.label_10.setText(
                'There are %s IC plugin tasks running in the background. Please wait!' %ic_task_count
            )

    def delete_task_number_label(self):
       self.dlg.label_10.setText('')

    def execute(self):
        try:
            myworker = self.myworker = ICWorker(self, 'InterfaceCatchment plugin - %s m' %self.dlg.mQgsDoubleSpinBox.value())
            myworker.layerPrint.connect(self.showLayer)
            QgsApplication.taskManager().countActiveTasksChanged.connect(self.update_task_number_label)
            QgsApplication.taskManager().allTasksFinished.connect(self.delete_task_number_label)
            QgsApplication.taskManager().addTask(myworker)
        except Exception as e:
            self.log(str(e))