# -*- coding: utf-8 -*-
"""
/***************************************************************************
 InterfaceLocker
                                 A QGIS plugin
 Blocca/ripristina interfaccia QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-05-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by dr. geol. Faustino Cetraro
        email                : geol-faustino@libero.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .interface_locker_dialog import InterfaceLockerDialog
import os.path

from qgis.PyQt.QtWidgets import QMainWindow
from qgis.utils import iface
import os
import json
from qgis.PyQt.QtWidgets import QToolBar, QDockWidget

from PyQt5.QtCore import QByteArray

# Percorso alla cartella "setting" dentro "interface_locker"
# settings_dir = os.path.join(os.path.expanduser("~"), ".interface_locker")

# Usa lo stesso nome del file originario ma nel nuovo percorso
# SETTINGS_FILE = os.path.join(settings_dir, ".interface_locker.json")

# Cartella del plugin (dove si trova questo script)
plugin_dir = os.path.dirname(__file__)

# Percorso completo del file
SETTINGS_FILE = os.path.join(plugin_dir, ".interface_locker.json")

class InterfaceLocker:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(self.plugin_dir, 'i18n', f'nterface_locker_{locale}.qm')

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Interface Locker')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('InterfaceLocker', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Interface Locker'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Interface Locker'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = InterfaceLockerDialog()

            # Collega i pulsanti della finestra ai metodi
            self.dlg.btn_lock_interface.clicked.connect(self.save_interface_state)
            self.dlg.btn_restore_interface.clicked.connect(self.restore_interface_state)

        self.dlg.show()
        self.dlg.exec_()
      
    def save_interface_state(self):
        """Salva l'intero stato dell'interfaccia (toolbar, pannelli, layout)."""
        try:
            main_window = self.iface.mainWindow()
            state = main_window.saveState().toBase64().data().decode('utf-8')

            # Assicurati che la cartella esista
            os.makedirs(os.path.dirname(SETTINGS_FILE), exist_ok=True)

            with open(SETTINGS_FILE, 'w', encoding='utf-8') as f:
                json.dump({"gui_state": state}, f, ensure_ascii=False, indent=2)

            self.iface.messageBar().pushMessage("Interface Locker", "Interfaccia salvata (completa).", level=0)

        except Exception as e:
            self.iface.messageBar().pushCritical("Interface Locker", f"Errore salvataggio interfaccia: {e}")

        finally:
            self.dlg.close()

    def restore_interface_state(self):
        """Ripristina l'intero stato dell'interfaccia (toolbar, pannelli, layout)."""
        if not os.path.exists(SETTINGS_FILE):
            self.iface.messageBar().pushWarning("Interface Locker", "Nessuna configurazione salvata trovata.")
            return

        try:
            with open(SETTINGS_FILE, 'r', encoding='utf-8') as f:
                data = json.load(f)

            gui_state = data.get("gui_state")
            if gui_state:
                main_window = self.iface.mainWindow()
                restored = main_window.restoreState(QByteArray.fromBase64(gui_state.encode('utf-8')))
                if restored:
                    self.iface.messageBar().pushMessage("Interface Locker", "Interfaccia ripristinata (completa).", level=0)
                else:
                    self.iface.messageBar().pushWarning("Interface Locker", "Ripristino fallito: stato non valido.")

        except Exception as e:
            self.iface.messageBar().pushCritical("Interface Locker", f"Errore ripristino interfaccia: {e}")

        finally:
            self.dlg.close()
