from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class IntegratedNTLProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'integrated_ntl_modeling'

    def name(self):
        return self.tr('Integrated Nighttime Light Modeling')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.download_viirs_annual import DownloadVIIRSAnnual
        from .algorithms.nighttimelight_modeller import NighttimeLightModeller
        self.addAlgorithm(DownloadVIIRSAnnual())
        self.addAlgorithm(NighttimeLightModeller())
