# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Inkscape2Symbol
                                 A QGIS plugin
 Import SVG drawings created in Inkscape as symbols in QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-09-30
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Hennie Kotze
        email                : henniek@locat.co.za
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QUrl
from qgis.PyQt.QtGui import QIcon, QColor
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .inkscape2symbol_dialog import Inkscape2SymbolDialog
import os.path
from random import randint as randcol
from time import sleep as tsleep


class Inkscape2Symbol:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Inkscape2Symbol_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Inkscape2Symbol')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.svgMem = MemSVG()
        
        #-------------------------constants
    

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Inkscape2Symbol', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/inkscape2symbol/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Convert Inkscape SVG into symbol'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        self.outputFileSaved = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Inkscape2Symbol'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Inkscape2SymbolDialog()

        
        self.dlg.inputfile.fileChanged.connect(self.infileChangedAction)
        self.dlg.inputfile.setFilter("*.svg")#only display files with the .svg extension
        self.dlg.outputfolder.fileChanged.connect(self.outfileChangedAction)
        self.dlg.fillColour.colorChanged.connect(self.fillColAction)
        self.dlg.outlineColour.colorChanged.connect(self.outlineColAction)
        self.dlg.btnExportSVG.clicked.connect(self.writeSVG)
        self.dlg.cbNoOutline.toggled.connect(self.setNoOutline)
        self.dlg.btnReset.clicked.connect(self.resetAction)
        self.dlg.btnRandomize.clicked.connect(self.randomizeAction)
        #
        self.dlg.outputfolder.setStorageMode(3)#was QgsFileWidget.SaveFile
        #--set default colours (r, g, b, a)
        self.dlg.fillColour.setColor(QColor(220, 220, 220, 255))
        self.dlg.outlineColour.setColor(QColor(0, 0, 0, 255))
        
        #-- graphicsView SVG display
        
        #--svg in child widget
        self.inputFileSize = 0
        self.inputFileObjectCount = 0

        #=============================================show the dialog
        self.dlg.show()
        self.dlg.outputfolder.lineEdit().setValue("")
        self.dlg.webViewOutput.setHtml("")
        self.dlg.lblFileSize.setText("")
        # Run the dialog event loop
        result = self.dlg.exec_()
        
        # See if OK was pressed
        if result:
            #open the Inkscape-generated svg...
            self.recompileSvg()
    
        
    def recompileSvg(self):
        if not self.svgMem.data is None:
            #----read file and store content
            #svgcontent = self.readSVGFile(self.dlg.inputfile.filePath())
            #--cleanup
            svgcontent=self.svgMem.text
            if "i2s=" in svgcontent:
                #-----------------the svg has already run through the mill
                svg_parts = svgcontent.split("<")
                for svg_part in svg_parts:
                    if "fill:" in svg_part:
                        idxS = svg_part.find("fill:")
                        idxE = svg_part.find(";", idxS)
                        svgcontent=svgcontent.replace(svg_part[idxS:idxE],"fill:"+self.dlg.fillColour.color().name())
                    if "stroke:" in svg_part:
                        idxS = svg_part.find("stroke:")
                        idxE = svg_part.find(";", idxS)
                        svgcontent=svgcontent.replace(svg_part[idxS:idxE],"stroke:"+self.dlg.outlineColour.color().name())
                    if "stroke-width:" in svg_part:
                        idxS = svg_part.find("stroke-width:")
                        idxE = svg_part.find(";", idxS)
                        tempwidth = "0.0" if self.dlg.cbNoOutline.isChecked() else "0.2"
                        svgcontent=svgcontent.replace(svg_part[idxS:idxE],"stroke-width:"+tempwidth)
                    if "fill=" in svg_part:
                        idxS = svg_part.find("fill=")
                        idxE = svg_part.find("\"", idxS+6)
                        svgcontent=svgcontent.replace(svg_part[idxS:idxE+1],"fill=\"param(fill) "+self.dlg.fillColour.color().name()+"\"")
                    if "stroke=" in svg_part:
                        idxS = svg_part.find("stroke=")
                        idxE = svg_part.find("\"", idxS+8)
                        svgcontent=svgcontent.replace(svg_part[idxS:idxE+1],"stroke=\"param(outline) "+self.dlg.outlineColour.color().name()+"\"")
                    if "stroke-width=" in svg_part:
                        idxS = svg_part.find("stroke-width=")
                        idxE = svg_part.find("\"", idxS+14)
                        tempwidth = "0.0" if self.dlg.cbNoOutline.isChecked() else "0.2"
                        svgcontent=svgcontent.replace(svg_part[idxS:idxE+1],"stroke-width=\"param(outline-width) "+tempwidth+"\"")
                print(svgcontent)
                self.svgMem.setText(svgcontent)
                self.dlg.lblStatus.setText("Modified")
                return
            svgcontent = svgcontent.replace("\n"," ")
            while "  " in svgcontent:
                svgcontent=svgcontent.replace("  "," ")
            #print(svgcontent)
            #--extract width, height and viewBox from the <svg> tag
            new_svg_tag = '<svg i2s="yes" enable-background="new {2}" width="{0}" height="{1}" viewBox="{2}" xmlns="http://www.w3.org/2000/svg">*</svg>'
            new_style_attrib = 'style="opacity:1;fill:{0};fill-opacity:1;stroke:{1};stroke-width:{2};stroke-opacity:1" fill="param(fill) {0}" stroke="param(outline) {1}" stroke-width="param(outline-width) {2}"'
            if "<svg " in svgcontent:
                idxS = svgcontent.find("<svg ")
                idxE = svgcontent.find(">", idxS)
                svgtag = svgcontent[idxS:idxE]
                svg_attrib_vals = []
                svg_attribs = ["width=", "height=", "viewBox="]
                i=0
                while i < len(svg_attribs):
                    if svg_attribs[i] in svgtag:
                        idxS = svgtag.find(svg_attribs[i])
                        idxE = svgtag.find("\"", idxS+len(svg_attribs[i])+1)
                        svg_attrib_vals.append(svgtag[idxS+len(svg_attribs[i])+1:idxE])
                    i += 1
                new_svg_tag = new_svg_tag.format(svg_attrib_vals[0],svg_attrib_vals[1],svg_attrib_vals[2])
            #--grab the <g> tag
            gcontent = ""
            new_gcontent = ""
            gcontent_arr = []
            if "<g " in svgcontent:
                indexStart = svgcontent.find("<g ")
                indexEnd = svgcontent.find("</g>", indexStart)
                gcontent = svgcontent[indexStart:indexEnd+4]
                gcontent = gcontent.replace("><",">\n<")
                gcontent = gcontent.replace("> <",">\n<")
                #--break the <g> tag up into constituents
                #print(gcontent)
                gcontent_arr = gcontent.split("\n")
            if len(gcontent_arr) > 1:
                if "transform" in gcontent_arr[0]:
                    stemp = gcontent_arr[0]
                    idxS = stemp.find("transform")
                    idxE = stemp.find("\"", idxS+11)
                    gcontent_arr[0] = "<g {0}>".format(stemp[idxS:idxE+1])
                for s in gcontent_arr:
                    if "style=" in s:
                        idxS = s.find("style=\"") 
                        idxE = s.find("\"", idxS+7)
                        s1 = s[idxS:idxE+1]
                        s2 = s.replace(s1,new_style_attrib.format(self.dlg.fillColour.color().name(),self.dlg.outlineColour.color().name(),"0.2"))
                        new_gcontent += s2;
            new_svg = new_svg_tag.replace("*", gcontent_arr[0] + new_gcontent+"</g>")
            #perform final clean-up, remove references to inkscape and sodipodi
            while "inkscape" in new_svg:
                idxS = new_svg.find("inkscape")
                idxE = new_svg.find(" ",idxS)
                s1 = new_svg[idxS:idxE]
                new_svg = new_svg.replace(s1, "")
            while "sodipodi" in new_svg:
                idxS = new_svg.find("sodipodi")
                idxE = new_svg.find(" ",idxS)
                s1 = new_svg[idxS:idxE]
                new_svg = new_svg.replace(s1, "")
            new_svg.replace("</g></g>","</g>")#<------------fix me!
            self.svgMem.setText(new_svg)
            self.dlg.lblStatus.setText("Modified")
    
    def infileChangedAction(self):
        #self.dlg.lblFileSize.setText("0:.2g".format(os.path.getsize(self.dlg.inputfile.filePath())))
        try:
            if (os.path.isfile(self.dlg.inputfile.filePath())) and self.dlg.inputfile.filePath().endswith(".svg"):
                self.dlg.lblFileSize.setText("{:.2f}kB".format(os.path.getsize(self.dlg.inputfile.filePath())/1024))
                self.svgMem.setData(self.readSVGFile(self.dlg.inputfile.filePath()))
                svgcontent = self.svgMem.text
                if ("inkscape" in svgcontent) or ("xmlns:" in svgcontent):
                    self.dlg.webViewOriginal.load(QUrl('file://'+self.dlg.inputfile.filePath()))
                    self.dlg.fillColour.setColor(QColor(self.svgMem.fill_original))
                    self.dlg.outlineColour.setColor(QColor(self.svgMem.outline_original))
                    self.drawMemSVG()
                else:
                    self.dlg.webViewOriginal.setHtml("<span style='font-family:sans-serif;font-size:11px;'>Not recognized as a<br>supported SVG format</span>")
                    self.svgMem.clear()
                    self.drawMemSVG()
            else:
                self.dlg.webViewOriginal.setHtml("<span style='font-family:sans-serif;font-size:11px;'>No SVG file selected</span>")
                self.svgMem.clear()
                self.drawMemSVG()
                self.dlg.lblFileSize.setText("")
                pass 
        except Exception as ex:
            print(ex)
            return
    
    def outfileChangedAction(self):
        self.drawMemSVG()
    
    def outlineColAction(self):
        self.recompileSvg()
        self.outfileChangedAction()
    
    def fillColAction(self):
        self.recompileSvg()
        self.outfileChangedAction()
    
    def readSVGFile(self, filepath):
        inputsvg = open(filepath, 'rb')
        s = inputsvg.read()
        inputsvg.close()
        return s
    
    def writeSVG(self, filepath):
        if len(self.dlg.outputfolder.filePath()) > 0:
            #create a new output svg-format file
            outfolder = self.dlg.outputfolder.filePath()
            if not outfolder.endswith(".svg"):
                outfolder += ".svg"
            #write the output file
            #beware of permissions
            with open(outfolder, 'w') as outputsvg:
                outputsvg.write(self.svgMem.text)
            self.dlg.lblStatus.setText("Saved")
        else:
            self.dlg.lblStatus.setText("Not saved")
            return

    def drawMemSVG(self):
        if not self.svgMem.data is None:
            self.dlg.webViewOutput.setContent(self.svgMem.data,"image/svg+xml")
            self.dlg.lblStatus.setText("Modified")
        else:
            self.dlg.webViewOutput.setHtml("")
    
    def setNoOutline(self):
        if not self.svgMem.data is None:
            self.recompileSvg()
            self.drawMemSVG()
            
    def resetAction(self):
        if not self.svgMem.data is None:
            self.dlg.fillColour.setColor(QColor(self.svgMem.fill_original))
            self.dlg.outlineColour.setColor(QColor(self.svgMem.outline_original))
            self.recompileSvg()
            self.drawMemSVG()
            
    def randomizeAction(self):
        self.dlg.fillColour.setColor(QColor("#"+hex(randcol(0x1,0xffffff))[2:].zfill(6)))
        self.dlg.outlineColour.setColor(QColor("#"+hex(randcol(0x1,0xffffff))[2:].zfill(6)))
        if not self.svgMem.data is None:
            self.recompileSvg()
            self.drawMemSVG()
            
            
class MemSVG:
    
    def __init__(self):
        pass
    
    width = ""
    height = ""
    fill_original = ""
    fill = ""
    outline_original = ""
    outline = ""
    text = ""
    data = None
            
    def setData(self, d):
        self.data = d
        self.text = d.decode("utf-8")
        self.parse()
    
    def setText(self, t):
        self.text = t
        self.data = str.encode(t)
        self.parse()
    
    def clear(self):
        self.width = ""
        self.height = ""
        self.fill_original = ""
        self.fill = ""
        self.outline_original = ""
        self.outline = ""
        self.text = ""
        self.data = None
        
    def parse(self):
        if "fill:" in self.text:
            idxS = self.text.find("fill:")
            idxE = self.text.find(";",idxS)
            s = self.text[idxS+5:idxE]
            self.fill = s
            if self.fill_original is "":
                self.fill_original = self.fill
        if "stroke:" in self.text:
            idxS = self.text.find("stroke:")
            idxE = self.text.find(";",idxS)
            s = self.text[idxS+7:idxE]
            self.outline = s
            if self.outline_original is "":
                self.outline_original = self.outline
            