# coding=utf-8
"""Age related field groups.

Whilst age_field_group.py breaks down all ages, this grouping looks at
especially vulnerable field groups (infant, adult).
"""

from safe.definitions.fields import (
    under_5_ratio_field,
    over_60_ratio_field,
    under_5_count_field,
    over_60_count_field,
    under_5_displaced_count_field,
    over_60_displaced_count_field)
from safe.utilities.i18n import tr

__copyright__ = "Copyright 2017, The InaSAFE Project"
__license__ = "GPL version 3"
__email__ = "info@inasafe.org"
__revision__ = '$Format:%H$'

age_vulnerability_ratio_group = {
    'key': 'age_vulnerability_ratio_group',
    'name': tr('Age Vulnerability Ratio'),
    'description': tr(
        'Demographic breakdown to use for displaced population based on '
        'age. Vulnerability ratio groupings are used when there '
        'is a vector aggregation layer that contains detailed demographic '
        'information (as ratios) about the population living in each '
        'administrative or census area. These ratios are then applied to the '
        'count of displaced population per aggregation area to provide a more '
        'detailed break down of the number of people displaced in each '
        'age profile. Vulnerable segments of the population '
        'can include criteria like the number of infants, the number of '
        'elderly, the number of disabled people, and so on.'),
    'fields': [
        under_5_ratio_field,
        over_60_ratio_field,
    ],
    # Exclusive = False: able to put same layer's field to some fields
    # Exclusive = True: only able to put a layer's field to a field
    'exclusive': False,
    'notes': [],
    'constraints': {
        'sum': {
            'kwargs': {
                'max': 1
            },
            'message': tr(
                'The sum of age ratios should not more than 1.')
        }
    }
}
age_vulnerability_count_group = {
    'key': 'age_vulnerability_count_group',
    'name': tr('Age Vulnerability Count'),
    'description': tr(
        'Demographic breakdown to use for displaced population based on '
        'age. Vulnerability count groupings are used when there '
        'is a vector exposure layer that contains detailed demographic '
        'information (as counts) about the population living in each '
        'area. These counts are then used to calculate the ratio of '
        'vulnerable population sectors for each aggregation area. These are '
        'then used to produce a detailed break down of the number of '
        'displaced people in each age profile. Vulnerable segments '
        'of the population can include criteria like the number of infants, '
        'the number of elderly, the number of disabled people, and so on.'),
    'fields': [
        under_5_count_field,
        over_60_count_field,
    ],
    # Exclusive = False: able to put same layer's field to some fields
    # Exclusive = True: only able to put a layer's field to a field
    'exclusive': False,
    'notes': []
}
age_vulnerability_displaced_count_group = {
    'key': 'age_vulnerability_displaced_count_group',
    'name': tr('Age Vulnerability Displaced Count'),
    'header_name': tr('Age Vulnerability'),
    'description': tr(
        'Demographic breakdown to use for displaced population based on '
        'age. These data are presented in the report as the number '
        'of displaced people in each vulnerable age group. Age based '
        'vulnerable segments of the population can include criteria like '
        'the number of infants, the number of elderly people and so on.'),
    'fields': [
        under_5_displaced_count_field,
        over_60_displaced_count_field,
    ],
    # Exclusive = False: able to put same layer's field to some fields
    # Exclusive = True: only able to put a layer's field to a field
    'exclusive': False,
    'notes': []
}
