# coding=utf-8
"""Disability related field groups.

"""

from safe.definitions.fields import (
    disabled_ratio_field,
    disabled_count_field,
    disabled_displaced_count_field)
from safe.utilities.i18n import tr

__copyright__ = "Copyright 2017, The InaSAFE Project"
__license__ = "GPL version 3"
__email__ = "info@inasafe.org"
__revision__ = '$Format:%H$'

disability_vulnerability_ratio_group = {
    'key': 'disability_vulnerability_ratio_group',
    'name': tr('Disability Vulnerability Ratio'),
    'description': tr(
        'Demographic breakdown to use for displaced population based on '
        'disability vulnerability. Disability vulnerability ratio groupings '
        'are used when there is a vector aggregation layer that contains '
        'detailed demographic information (as ratios) about the disabled '
        'population living in each administrative or census area. These '
        'ratios are then applied to the count of displaced '
        'population per aggregation area to provide a more detailed break '
        'down of the number of disabled people displaced in each area.'),
    'fields': [
        disabled_ratio_field
    ],
    # Exclusive = False: able to put same layer's field to some fields
    # Exclusive = True: only able to put a layer's field to a field
    'exclusive': False,
    'notes': [],
    'constraints': {
        'sum': {
            'kwargs': {
                'max': 1
            },
            'message': tr(
                'The sum of vulnerability ratios should not more than 1.')
        }
    }
}
disability_vulnerability_count_group = {
    'key': 'disability_vulnerability_count_group',
    'name': tr('Disabled Vulnerability Count'),
    'description': tr(
        'Demographic breakdown to use for displaced population based on '
        'displacement vulnerability. Disabled count groupings are used when '
        'there is a vector exposure layer that contains detailed demographic '
        'information (as counts) about the population living in each '
        'area. These counts are then used to calculate the ratio of '
        'disabled people to the total population for each aggregation area. '
        'These are then used to produce a detailed break down of the number '
        'of displaced people in each area.'),
    'fields': [
        disabled_count_field
    ],
    # Exclusive = False: able to put same layer's field to some fields
    # Exclusive = True: only able to put a layer's field to a field
    'exclusive': False,
    'notes': []
}
disability_vulnerability_displaced_count_group = {
    'key': 'disability_vulnerability_displaced_count_group',
    'name': tr('Disability Vulnerability Displaced Count'),
    'header_name': tr('Disability Vulnerability'),
    'description': tr(
        'Demographic breakdown to use for displaced population based on '
        'disability. These data are presented in the report as the number '
        'of displaced disabled people.'),
    'fields': [
        disabled_displaced_count_field
    ],
    # Exclusive = False: able to put same layer's field to some fields
    # Exclusive = True: only able to put a layer's field to a field
    'exclusive': False,
    'notes': []
}
