# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QGisImajnetPluginDockWidget
                                 Imajnet QGIS plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-06-20
        git sha              : $Format:%H$
        copyright            : (C) 2018 by JC
        email                : jchesnel@imajing.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os


from PyQt5 import QtGui, QtWidgets, uic 
from PyQt5.QtCore import pyqtSignal, QUrl, QObject, QVariant, QSize
from PyQt5.Qt import QFileInfo, pyqtSlot, QStringListModel
from PyQt5.QtWebKitWidgets import  QWebPage, QWebInspector
from PyQt5.QtWebKit import QWebElement, QWebSettings
#from PyQt5.QtGui import QVBoxLayout, QShortcut, QKeySequence
from numpy import double
#from PySide import QtGui, QtCore, QtWebKit
from PyQt5.QtWidgets import QApplication, QSplitter, QVBoxLayout, QWidget

# Such a wild import is not good for performance but usefull for debug sometime
# from qgis import *
# from qgis.core import *

# Rather prefer this :
from qgis.core import QgsVectorLayer, QgsFeature, QgsGeometry, QgsPointXY, QgsProject, QgsField, QgsWkbTypes

import sys
import inspect
from .ImajnetUtils import ImajnetUtils
  

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'QGisImajnetPlugin_debugwindow_base.ui'))


class QGisImajnetPluginDebugWindow(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()
    vl = None
    m_view = None
    inspector = None
    
    def __init__(self, iface, webView, parent=None):
        """Constructor."""
        # !!!--------------- BEGIN : NEVER TOUCH THE FOLLOWING !!!
        super(QGisImajnetPluginDebugWindow, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
       # self.setupUi(self)
        # !!!--------------- END : NEVER TOUCH THE FOLLOWING !!!
        
        #----------------------- User part ---------------------------        
        self.iface = iface
        
        
        # -- instanciate the webview        
        #self.setWebSetting() # General web settings
  
        self.inspector = QWebInspector()
        

        
        self.setWidget(self.inspector)
        self.setMinimumSize(QSize(500, 500))
        
        if(webView is not None):
            self.setWebView(webView)
        #----------------------- End user part ---------------------------

    def setWebView(self, webView):
        ImajnetUtils.setupWebViewForDebug(webView)
        self.m_view = webView
        self.inspector.setPage(self.m_view.page())
        self.inspector.show()
           
    def setPage(self, page):
        self.m_view = None
        self.inspector.setPage(page)
        self.inspector.show()   
        
            
    def closeEvent(self, event):
        """
        Method call when closing the plugin
        """
        
        #self.DestroyLayer()
        
        # Mandatory for proper close 
        
        #we do not want to close the plugin when closing the debug window   
        #self.closingPlugin.emit()
        self.inspector.hide()
        self.inspector.setPage(None)
        self.inspector.destroy()
        
        event.accept()

         
