# -*- coding: utf-8 -*-

"""
/***************************************************************************
 illini_drainage_tools
                                 A QGIS plugin
 Performs Specific Draiange Related Tasks and Analysis on a Site
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-15
        copyright            : (C) 2022 by FALASY  Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY  Anamelechi'
__date__ = '2022-03-15'
__copyright__ = '(C) 2022 by FALASY  Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import inspect
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterFolderDestination
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterField

from qgis.core import QgsProcessingParameterVectorDestination
from qgis.core import QgsProcessingLayerPostProcessorInterface

import processing
import sys
import csv

from PyQt5 import QtWidgets
from qgis.PyQt.QtCore import QCoreApplication, QVariant

from qgis.core import *
from collections import Counter
import time
import numpy as np

class LidarThinningAnalysisAlgorithm(QgsProcessingAlgorithm):            
        
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
        
    def createInstance(self):
        return LidarThinningAnalysisAlgorithm()
        
    def name(self):
        return 'b. LiDARThAn'

    def displayName(self):
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr("""This Tool extracts a LiDAR DEM data using an input boundary layer and then performs specific DEM analysis on the Drainage Site.
        
        Workflow: 
        1. Select a LiDAR DEM Raster Layer and a Polygon Vector Layer
        2. Specify a Desired Pixel Size (feet)
        3. Save the output files (optional)
        4. Click on \"Run\"
        
        The script will gives out four outputs.         
                               
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.             
        """)    
        
    def helpUrl(self):
        return "https://publish.illinois.edu/illinoisdrainageguide/files/2022/06/PublicAccess.pdf"   
    
    
    def initAlgorithm(self, config=None):        
        self.addParameter(QgsProcessingParameterRasterLayer('IDT', 'Field LiDAR DEM', defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('VectorBound', 'Field Boundary', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('PixelSize', 'Desired Pixel Size (ft)', type=QgsProcessingParameterNumber.Double, maxValue=100.0, defaultValue=20))
        
        self.addParameter(QgsProcessingParameterRasterDestination('Resampled', 'Resampled Raster Layer', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('BoundaryProfiles', 'Boundary Points Profile', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('InnerPointProfiles', 'Inner Points Profile', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('MergePoints', 'All Generated Field Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
                                                   
    def processAlgorithm(self, parameters, context, feedback):
                                       
        # Clip Raster DEM Layer Out        
        clip_params = processing.run('sagang:cliprasterwithpolygon',
        {'INPUT': parameters['IDT'], 'POLYGONS': parameters['VectorBound'], 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1
        
        results_a = clip_params['OUTPUT']
                           
        # Resample Clipped Raster DEM      
        resam_params = processing.run('sagang:resampling',
        {'INPUT': results_a, 'SCALE_UP': 0, 'SCALE_DOWN': 0, 'TARGET_USER_SIZE': parameters['PixelSize'], 'TARGET_USER_FITS': 1, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #2                     
        
        results_b = resam_params['OUTPUT']

        # Convert SAGA to Giff File        
        trans_params = processing.run('gdal:translate', 
        {'INPUT': results_b, 'OUTPUT': parameters['Resampled']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #3
                      
        results_c = trans_params['OUTPUT']
        
        # Polygons to Lines        
        polylines_params = processing.run('native:polygonstolines', 
        {'INPUT': parameters['VectorBound'], 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True) #4                
        
        results_d = polylines_params['OUTPUT']
        
        # Generate Points Pixel Centroids along Boundary Line       
        pointsalong_params = processing.run('qgis:generatepointspixelcentroidsalongline', 
        {'INPUT_RASTER': parameters['IDT'], 'INPUT_VECTOR': results_d, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True) #5                
        
        results_e = pointsalong_params['OUTPUT']
        
        # Export Boundary Points Profile to CSV File        
        bound_params = processing.run('native:addxyfields', 
        {'INPUT': results_e, 'CRS': 'EPSG4326', 'OUTPUT': parameters['BoundaryProfiles']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #6
                
        results_f = bound_params['OUTPUT']
           
        # Convert Pixel Centroid Layer       
        cent_params = processing.run('qgis:pixelstopoints', 
        {'INPUT_RASTER': results_b, 'RASTER_BAND': 1, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True) #7                
        
        results_g = cent_params['OUTPUT']                 
                                                  
        # Export Inner Points Profile to CSV File        
        csv_params = processing.run('native:addxyfields', 
        {'INPUT': results_g, 'CRS': 'EPSG4326', 'OUTPUT': parameters['InnerPointProfiles']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #8
        
        results_h = csv_params['OUTPUT']           
                
        # Union of Line and Point Layers        
        union_params = processing.run('native:union', 
        {'INPUT': results_e, 'OVERLAY': results_g, 'OUTPUT': parameters['MergePoints']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #9             
         
        results_i = union_params['OUTPUT']
        
        global renamer_a       
        renamer_a = Renamer_1('New Thinned Raster Layer')
        context.layerToLoadOnCompletionDetails(results_c).setPostProcessor(renamer_a)
        
        global renamer_b       
        renamer_b = Renamer_2('Boundary Pixel Points')
        context.layerToLoadOnCompletionDetails(results_f).setPostProcessor(renamer_b)
        
        global renamer_c       
        renamer_c = Renamer_3('Inner Pixel Points')
        context.layerToLoadOnCompletionDetails(results_h).setPostProcessor(renamer_c)
        
        global renamer_d       
        renamer_d = Renamer_4('Merged Points Layer')
        context.layerToLoadOnCompletionDetails(results_i).setPostProcessor(renamer_d)
                
        return {'Resampled': results_c, 'BoundaryProfiles': results_f, 'InnerPointProfiles': results_h, 'MergePoints': results_i}

class Renamer_1(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_2(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_3(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_4(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)