# -*- coding: utf-8 -*-

"""
/***************************************************************************
 flow_&_ordering
                                 A QGIS plugin
 Flow and Ordering
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-06-13
        copyright            : (C) 2022 by FALASY  Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY  Anamelechi'
__date__ = '2022-06-13'
__copyright__ = '(C) 2022 by FALASY  Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os, math
import inspect
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterEnum
from PyQt5.QtCore import QVariant
from qgis.PyQt.QtCore import QVariant

from qgis.core import QgsVectorFileWriter, QgsApplication

import processing
import processing as st
import sys
import csv

from PyQt5 import QtWidgets
from qgis.PyQt.QtCore import QCoreApplication, QVariant
from PyQt5.QtCore import QVariant

from qgis.core import *
from collections import Counter
import time
import numpy as np
#import pandas as pd

class BuryAlgorithm(QgsProcessingAlgorithm):
    INPUT_LAYER = 'INPUT_LAYER'
    SEGMENT_KEY = 'SEGMENT_KEY'    
    DIST_KEY = 'DIST_KEY'    
    FIRST_KEY = ' FIRST_KEY'
    LAST_KEY = 'LAST_KEY'
    UPPER_KEY = 'UPPER_KEY'
    LOWER_KEY = 'LOWER_KEY'
    ABS_UPPER_KEY = 'ABS_UPPER_KEY'
    ABS_LOWER_KEY = 'ABS_LOWER_KEY'
    MAXI_SLOPE_KEY = 'MAXI_SLOPE_KEY'
    MINI_SLOPE_KEY = 'MINI_SLOPE_KEY'
    OFFSET_KEY = 'OFFSET_KEY'
    CONST_SLOPE_KEY = 'CONST_SLOPE_KEY'
    USE_CONST_KEY = 'USE_CONST_KEY'    
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return BuryAlgorithm()
        
    def name(self):        
        return 'j. Tile Burying System'

    def displayName(self):        
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):        
        return ''

    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr( """This tool is used to determine the elevation depths for burying the entire tile networks. 
        
        Workflow:         
        1. Select the "Retained Reference Fields" vector layer. This is a follow-up from "Routine I"
        2. Specify the respective burying parameters
        3. Make a decision based on the field terrain using the Constant Slope Option 
        4. Save the output file (optional)        
        5. Click on \"Run\"               
                
        The script will give out an output. 
                
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.
        """)   
        
    def helpUrl(self):
        return "https://publish.illinois.edu/illinoisdrainageguide/files/2022/06/PublicAccess.pdf"
        
        
    def initAlgorithm(self, config):
        self.addParameter(QgsProcessingParameterVectorLayer(self.INPUT_LAYER, self.tr('Tile Network: from Cumulative Flow Lengths'), [QgsProcessing.TypeVectorPoint, QgsProcessing.TypeVectorLine], defaultValue=None)) 
                
        self.addParameter(QgsProcessingParameterField(self.SEGMENT_KEY, self.tr("Burying Segments [BURY_ORDER]"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))
        self.addParameter(QgsProcessingParameterField(self.DIST_KEY, self.tr("Distance Between Points [LENGTH]"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))       
        
        self.addParameter(QgsProcessingParameterField(self.FIRST_KEY, self.tr("Start Surface Elevation [FIRST_ELEV]"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))
        self.addParameter(QgsProcessingParameterField(self.LAST_KEY, self.tr("End Surface Elevation [LAST_ELEV]"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))
        
        self.addParameter(QgsProcessingParameterNumber(self.UPPER_KEY, self.tr('Upper Tile Depth [ft]'), type=QgsProcessingParameterNumber.Double, maxValue=10.0, defaultValue=3.25))
        self.addParameter(QgsProcessingParameterNumber(self.LOWER_KEY, self.tr('Lower Tile Depth [ft]'), type=QgsProcessingParameterNumber.Double, maxValue=10.0, defaultValue=4.25))
        self.addParameter(QgsProcessingParameterNumber(self.ABS_UPPER_KEY, self.tr('Absolute Upper Tile Depth [ft]'), type=QgsProcessingParameterNumber.Double, maxValue=10.0, defaultValue=3.00))
        self.addParameter(QgsProcessingParameterNumber(self.ABS_LOWER_KEY, self.tr('Absolute Lower Tile Depth [ft]'), type=QgsProcessingParameterNumber.Double, maxValue=10.0, defaultValue=7.00))
        self.addParameter(QgsProcessingParameterNumber(self.MAXI_SLOPE_KEY, self.tr('Maximum Slope Depth [percentage]'), type=QgsProcessingParameterNumber.Double, maxValue=100.0, defaultValue=5.00))
        self.addParameter(QgsProcessingParameterNumber(self.MINI_SLOPE_KEY, self.tr('Minimum Slope Depth [percentage]'), type=QgsProcessingParameterNumber.Double, maxValue=100.0, defaultValue=0.10))
        self.addParameter(QgsProcessingParameterNumber(self.OFFSET_KEY, self.tr('Offset Depth [ft]'), type=QgsProcessingParameterNumber.Double, maxValue=10.0, defaultValue=0.00))
        
        self.addParameter(QgsProcessingParameterNumber(self.CONST_SLOPE_KEY, self.tr('Constant Slope Depth [percentage]'), type=QgsProcessingParameterNumber.Double, maxValue=100.0, defaultValue=0.50, optional = True))
        self.addParameter(QgsProcessingParameterBoolean(self.USE_CONST_KEY, self.tr('Include Constant Slope [For Flat Terrain Only]'), defaultValue=False))
                                     
        self.addParameter(QgsProcessingParameterFeatureSink(self.OUTPUT, self.tr('Buried Elevation Depths')))
        
                      
    def processAlgorithm(self, parameters, context, feedback):                
        
        source_layer = self.parameterAsVectorLayer(parameters, self.INPUT_LAYER, context)
        
        if source_layer is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        raw_fields = source_layer.fields() 
                            
        upper_depth = parameters[self.UPPER_KEY]
        lower_depth = parameters[self.LOWER_KEY]
        mid_depth = (upper_depth + lower_depth) / 2  # Mid-Depth Value, MD
        
        abs_upper = parameters[self.ABS_UPPER_KEY]
        abs_lower = parameters[self.ABS_LOWER_KEY]
        
        slope_mx = parameters[self.MAXI_SLOPE_KEY]
        max_slope = (slope_mx * 0.01)
        
        slope_mn = parameters[self.MINI_SLOPE_KEY]
        min_slope = (slope_mn * 0.01) 
        
        offset = parameters[self.OFFSET_KEY]
        
        const_slope = parameters[self.CONST_SLOPE_KEY]
        constant_slope = (const_slope * 0.01)
        
        const_key = parameters[self.USE_CONST_KEY]      
                    
        '''add new fields'''
        #define new fields
        out_fields = QgsFields()
        #append fields
        for field in raw_fields:
            out_fields.append(QgsField(field.name(), field.type()))       
        out_fields.append(QgsField('ElevDepth1', QVariant.String))
        out_fields.append(QgsField('BuryDepth1', QVariant.String))
        out_fields.append(QgsField('ElevDepth2', QVariant.String))
        out_fields.append(QgsField('BuryDepth2', QVariant.String))
        out_fields.append(QgsField('InSlope', QVariant.String))
        out_fields.append(QgsField('OutSlope', QVariant.String))        
                      
        '''Counter for the progress bar'''
        total = source_layer.featureCount()
        parts = 100/total
        
        # Get fields from source layer
        idx_segment = raw_fields.indexFromName(self.parameterAsString(parameters, self.SEGMENT_KEY, context))
        idx_first = raw_fields.indexFromName(self.parameterAsString(parameters, self.FIRST_KEY, context)) 
        idx_last = raw_fields.indexFromName(self.parameterAsString(parameters, self.LAST_KEY, context))
        idx_dist = raw_fields.indexFromName(self.parameterAsString(parameters, self.DIST_KEY, context))
     
        '''Counter for the progress bar'''                                            
        total = source_layer.featureCount()
        parts = 100/total
                                                                     
        '''load data from layer "raw_layer" '''
        feedback.setProgressText(self.tr("Loading network layer\n "))
        
        # Sort the features in the raw_layer based on the segment_id attribute        
        sorted_features = sorted(source_layer.getFeatures(), key=lambda f: int(f[idx_segment]))
                    
        # Starting the burying operation
        mid_depth = (upper_depth + lower_depth)/ 2  # MD Value        
                
        # New 6 listts calculated inside the code. All 6 lists are float numbers
        ra_lst = []
        rb_lst = []      
        fe = []
        le = []
        listed_slopes = []
        
        # Storing the visited values
        visited_values = {}
                     
        # Iterate over the sorted features and perform your calculations
        for i, feature in enumerate(sorted_features):
            # access the desired attribute values using the corresponding field index           
            first_elevy = feature.attribute(idx_first)            
            if not isinstance(first_elevy, (list, tuple)):
                first_elevy = [first_elevy]           
                        
            last_elevy = feature.attribute(idx_last)           
            if not isinstance(last_elevy, (list, tuple)):
                last_elevy = [last_elevy]                
            
            length_idy = feature.attribute(idx_dist)            
            if not isinstance(length_idy, (list, tuple)):
                length_idy = [length_idy]          

            calc_column = 'B' if last_elevy < first_elevy else 'A'
                      
            # Part A: This is done only for Row 1 Fields
            for first_elev, last_elev, length_id in zip(first_elevy, last_elevy, length_idy):
                if i == 0:                
                    if calc_column == 'B':
               
                        r_b1 = last_elev - mid_depth                
                        rb_lst.append(r_b1)
                        
                        ld = last_elev - r_b1
                        le.append(ld)
                        visited_values[last_elev] = r_b1                    
                    
                        mid_elev = first_elev - mid_depth                               
                      
                        tile_slopes = mid_elev - r_b1
                        abs_list = tile_slopes/length_id      
                       
                        fgs_list = abs_list                   
                          
                        if fgs_list > max_slope:
                            listed_slope = max_slope
                            listed_slopes.append(listed_slope)        
                        elif fgs_list < min_slope:
                            listed_slope = min_slope
                            listed_slopes.append(listed_slope)
                        else:
                            listed_slope = fgs_list
                            listed_slopes.append(listed_slope)                        
                                   
                        slope = abs_list 
                                                                                        
                        if slope > max_slope:
                            r_a1 = r_b1 + (length_id * max_slope)
                            if r_a1 > first_elev - abs_upper:
                                r_a1 = first_elev - abs_upper
                        elif slope < min_slope:
                            r_a1 = r_b1 + (length_id * min_slope)
                            if r_a1< first_elev - abs_lower:
                                r_a1 = first_elev - abs_lower 
                        else:
                            r_a1 = mid_elev
                           
                        ra_lst.append(r_a1)                        
                        fd = first_elev - r_a1
                        fe.append(fd)                        
                        visited_values[first_elev] = r_a1                                   
                    
                    else:                 
                        r_a1 = first_elev - mid_depth                
                        ra_lst.append(r_a1)
                        
                        fd = first_elev - r_a1
                        fe.append(fd)
                        
                        visited_values[first_elev] = r_a1                   
                        
                        mid_elev = last_elev - mid_depth

                        tile_slopes = mid_elev - r_a1 
                        abs_list = tile_slopes/length_id           
                   
                        fgs_list = abs_list                     
                                             
                        if fgs_list > max_slope:
                            listed_slope = max_slope
                            listed_slopes.append(listed_slope)        
                        elif fgs_list < min_slope:
                            listed_slope = min_slope
                            listed_slopes.append(listed_slope)
                        else:
                            listed_slope = fgs_list
                            listed_slopes.append(listed_slope)                   
                                       
                        slope = abs_list 
                                                                                           
                        if slope > max_slope:
                            r_b1 = r_a1 + (length_id * max_slope)
                            if r_b1 > last_elev - abs_upper:
                                r_b1 = last_elev - abs_upper
                        elif slope < min_slope:
                            r_b1 = r_a1 + (length_id * min_slope)
                            if r_b1< last_elev - abs_lower:
                                r_b1 = last_elev - abs_lower 
                        else:
                            r_b1 = mid_elev
                           
                        rb_lst.append(r_b1)
                        ld = last_elev - r_b1                    
                        le.append(ld)
                        visited_values[last_elev] = r_b1
                        
                # Use Constant Slope and overide other slope calculations   
                elif const_key is True:
                
                    if last_elev in visited_values:
                    
                        r_b1 = visited_values[last_elev]                                              
                        rb_lst.append(r_b1)
                        
                        ld = last_elev - r_b1
                        le.append(ld)
                        visited_values[last_elev] = r_b1
                      
                        if first_elev in visited_values:
                            r_a1 = visited_values[first_elev]
                            ra_lst.append(r_a1)
                            
                            fd = first_elev - r_a1
                            fe.append(fd)
                            visited_values[first_elev] = r_a1
                            
                        else:
                            mid_elev = first_elev - mid_depth                            
                            tile_slopes = mid_elev - r_b1
                            
                            fgs_list = constant_slope
                            r_a1 = first_elev + (length_id * constant_slope)
                            ra_lst.append(r_a1)
                            
                            listed_slope = constant_slope
                            listed_slopes.append(listed_slope)
                            
                            fd = first_elev - r_a1
                            fe.append(fd)
                            visited_values[first_elev] = r_a1
                            
                    else:
                        r_a1 = visited_values[first_elev]                                              
                        ra_lst.append(r_a1)
                        
                        fd = first_elev - r_a1
                        fe.append(fd)
                        visited_values[first_elev] = r_a1
                      
                        if last_elev in visited_values:
                            r_b1 = visited_values[last_elev]
                            rb_lst.append(r_b1)
                            
                            ld = last_elev - r_b1
                            le.append(ld)
                            visited_values[last_elev] = r_b1
                            
                        else:
                            mid_elev = last_elev - mid_depth                            
                            tile_slopes = mid_elev - r_b1
                            
                            fgs_list = constant_slope
                            r_b1 = last_elev + (length_id * constant_slope)
                            rb_lst.append(r_b1)
                            
                            listed_slope = constant_slope
                            listed_slopes.append(listed_slope)
                            
                            ld = last_elev - r_b1
                            le.append(ld)
                            visited_values[last_elev] = r_b1                                               
                      
                # Part B: This is done only for other Rows starting from rows 2 downwards                                         
                else:    
                    if last_elev in visited_values:
                    
                        r_b1 = visited_values[last_elev]                                              
                        rb_lst.append(r_b1)
                        
                        ld = last_elev - r_b1
                        le.append(ld)
                        visited_values[last_elev] = r_b1
                      
                        if first_elev in visited_values:
                            r_a1 = visited_values[first_elev]
                            ra_lst.append(r_a1)
                            
                            fd = first_elev - r_a1
                            fe.append(fd)
                            visited_values[first_elev] = r_a1
                                                        
                        else:        
                            mid_elev = first_elev - mid_depth
                            
                            tile_slopes = mid_elev - r_b1                    
                            abs_list = tile_slopes/length_id
                           
                            fgs_list = abs_list
                                                        
                            if fgs_list > max_slope:
                                listed_slope = max_slope
                                listed_slopes.append(listed_slope)        
                            elif fgs_list < min_slope:
                                listed_slope = min_slope
                                listed_slopes.append(listed_slope)
                            else:
                                listed_slope = fgs_list
                                listed_slopes.append(listed_slope)
                                                                       
                            slope = abs_list
                                                   
                            if slope > max_slope:
                                r_a1 = first_elev + (length_id * max_slope)
                                if r_a1 > first_elev - abs_upper:
                                    r_a1 = first_elev - abs_upper
                            elif slope < min_slope:
                                r_a1 = first_elev + (length_id * min_slope)
                                if r_a1 < first_elev - abs_lower:
                                    r_a1 = first_elev - abs_lower
                            else:                                                         
                                r_a1 = mid_elev
                                
                            ra_lst.append(r_a1)
                            fd = first_elev - r_a1
                            fe.append(fd)
                            visited_values[first_elev] = r_a1
                                              
                    else:                         
                        r_a1 = visited_values[first_elev]                    
                        ra_lst.append(r_a1)
                        
                        fd = first_elev - r_a1
                        fe.append(fd)
                        visited_values[first_elev] = r_a1 
                        
                        if last_elev in visited_values:
                            r_b1 = visited_values[last_elev]
                            rb_lst.append(r_b1)
                            
                            ld = last_elev - r_b1
                            le.append(ld)
                            visited_values[last_elev] = r_b1
                            
                        else:    
                            mid_elev = last_elev - mid_depth
                            
                            tile_slopes = mid_elev - r_a1                    
                            abs_list = tile_slopes/length_id 
                         
                            fgs_list = abs_list 
                              
                            if fgs_list > max_slope:
                                listed_slope = max_slope
                                listed_slopes.append(listed_slope)        
                            elif fgs_list < min_slope:
                                listed_slope = min_slope
                                listed_slopes.append(listed_slope)
                            else:
                                listed_slope = fgs_list
                                listed_slopes.append(listed_slope)
                           
                            slope = abs_list
                            
                            if slope > max_slope:
                                r_b1 = last_elev + (length_id * max_slope)
                                if r_b1 > last_elev - abs_upper:
                                    r_b1 = last_elev - abs_upper
                            elif slope < min_slope:
                                r_b1 = last_elev + (length_id * min_slope)
                                if r_b1 < last_elev - abs_lower:
                                    r_b1 = last_elev - abs_lower
                            else:                                                        
                                r_b1 = mid_elev
                                
                            rb_lst.append(r_b1)
                            ld = last_elev - r_b1
                            le.append(ld)                                
                            visited_values[last_elev] = r_b1
                                             
                fe2 = [abs(x) for x in fe]
                le2 = [abs(x) for x in le]
                              
            # Starting Part 3
            slopy_slopes = []
            # Using list comprehension to compute the buried slopes
            tile_slopes = [a - b for a, b in zip(ra_lst, rb_lst)]
            abs_list = [tile_slopes[i] / length_id for i in range(len(tile_slopes))]

            for num in abs_list:
                fgs_list = num    
                if fgs_list > max_slope:
                    listed_slope = max_slope
                    slopy_slopes.append(listed_slope)                
                elif fgs_list < min_slope:
                    listed_slope = min_slope
                    slopy_slopes.append(listed_slope)
                else:
                    listed_slope = fgs_list
                    slopy_slopes.append(listed_slope)   
                        
        feedback.setProgressText(self.tr("Extracting the values\n "))
        
        '''sink definition'''
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT, context, out_fields, source_layer.wkbType(), source_layer.sourceCrs())
        
        # Create a dictionary with the values from the six lists
        dict_values = {
            'ElevDepth1': [float(val) + offset if i == 0 else float(val) for i, val in enumerate(ra_lst)],
            'BuryDepth1': fe2,
            'ElevDepth2': [float(val) + offset if i == 0 else float(val) for i, val in enumerate(rb_lst)],
            'BuryDepth2': le2,
            'InSlope': listed_slopes,
            'OutSlope': slopy_slopes
        }        
                        
        # Get the length of sorted_features
        n_features = len(sorted_features)

        # Truncate or pad the lists to match the length of sorted_features
        for key in dict_values.keys():
            if len(dict_values[key]) < n_features:
                dict_values[key] += [None] * (n_features - len(dict_values[key]))
            elif len(dict_values[key]) > n_features:
                dict_values[key] = dict_values[key][:n_features]
                
        # Use zip to iterate over the features and the corresponding values from the six lists
        for feature, elev1, bury1, elev2, bury2, slope1, slope2 in zip(sorted_features, dict_values['ElevDepth1'], dict_values['BuryDepth1'], dict_values['ElevDepth2'], dict_values['BuryDepth2'], dict_values['InSlope'], dict_values['OutSlope']):
            # Stop the algorithm if cancel button has been clicked
            if feedback.isCanceled():
                break                
             
            # Add a feature in the sink                        
            outFt = QgsFeature(out_fields)            
            outFt.setGeometry(feature.geometry())            
            outFt.setAttributes(feature.attributes() + [None]*6)  # Expand array            

            # Set the attribute values for each feature
            outFt['ElevDepth1'] = elev1
            outFt['BuryDepth1'] = bury1
            outFt['ElevDepth2'] = elev2
            outFt['BuryDepth2'] = bury2
            outFt['InSlope'] = slope1
            outFt['OutSlope'] = slope2
                           
            #Add feature to sink
            sink.addFeature(outFt, QgsFeatureSink.FastInsert)               
                      
        return {self.OUTPUT: dest_id}        