# -*- coding: utf-8 -*-

"""
/***************************************************************************
 IlliniDrainageTools
                                 A QGIS plugin
 Performs Specific Draiange Related Tasks and Analysis on a Site
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-15
        copyright            : (C) 2022 by FALASY  Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY  Anamelechi'
__date__ = '2022-03-15'
__copyright__ = '(C) 2022 by FALASY  Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

# Stage 1
from qgis.core import QgsProcessingProvider

from .coordinates_algorithm import CoordinatesAlgorithm
from .lidar_thinning_analysis_algorithm import LidarThinningAnalysisAlgorithm
from .plotting_field_laylines_algorithm import PlottingFieldLaylinesAlgorithm
from .line_grid_algorithm import LineGridAlgorithm

# Stage 2
from .geometrically_fixed_algorithm import GeometricallyFixedAlgorithm
from .network_generator_algorithm import NetworkGeneratorAlgorithm
from .network_flow_ordering_algorithm import NetworkFlowOrderingAlgorithm
from .network_elevation_algorithm import NetworkElevationAlgorithm
from .flow_lengths_algorithm import FlowLengthsAlgorithm

# Stage 3
from .bury_algorithm import BuryAlgorithm
from .benefits_algorithm import BenefitsAlgorithm
from .price_estimates_algorithm import PriceEstimatesAlgorithm
from .readout_algorithm import ReadoutAlgorithm


# from .complex_mains_fix_algorithm import ComplexMainsFixAlgorithm
# from .fix_line_topology_algorithm import FixLineTopologyAlgorithm
# from .tile_statistics_algorithm import TileStatisticsAlgorithm
# from .flow_algorithm import FlowAlgorithm
# from .ordering_algorithm import OrderingAlgorithm
# from .elevation_algorithm import ElevationAlgorithm

import os
import inspect
from qgis.PyQt.QtGui import QIcon

pluginPath = os.path.dirname(__file__)


class IlliniDrainageToolsProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        
        self.addAlgorithm(CoordinatesAlgorithm())
        self.addAlgorithm(LidarThinningAnalysisAlgorithm())
        self.addAlgorithm(PlottingFieldLaylinesAlgorithm())
        self.addAlgorithm(LineGridAlgorithm())        
                       
        self.addAlgorithm(NetworkGeneratorAlgorithm())
        self.addAlgorithm(GeometricallyFixedAlgorithm()) 
        self.addAlgorithm(NetworkFlowOrderingAlgorithm())
        self.addAlgorithm(NetworkElevationAlgorithm())
        self.addAlgorithm(FlowLengthsAlgorithm())        
                
        self.addAlgorithm(BuryAlgorithm())        
        self.addAlgorithm(BenefitsAlgorithm())
        self.addAlgorithm(PriceEstimatesAlgorithm())
        self.addAlgorithm(ReadoutAlgorithm())
        
        # self.addAlgorithm(ComplexMainsFixAlgorithm())
        # self.addAlgorithm(FixLineTopologyAlgorithm())
        # self.addAlgorithm(TileStatisticsAlgorithm())
        # self.addAlgorithm(FlowAlgorithm())
        # self.addAlgorithm(OrderingAlgorithm())      
        # self.addAlgorithm(ElevationAlgorithm())        
           

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Illini Drainage Tools'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Illini Drainage Tools')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
