# -*- coding: utf-8 -*-

"""
/***************************************************************************
 flow_&_ordering
                                 A QGIS plugin
 Flow and Ordering
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-06-13
        copyright            : (C) 2022 by FALASY  Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY  Anamelechi'
__date__ = '2022-06-13'
__copyright__ = '(C) 2022 by FALASY  Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os, math
import inspect
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterVectorDestination

import processing
import sys
import csv

from PyQt5 import QtWidgets
from qgis.PyQt.QtCore import QCoreApplication, QVariant

from qgis.core import *
from collections import Counter
import time
import numpy as np

class NetworkFlowOrderingAlgorithm(QgsProcessingAlgorithm):
    INPUT_LAYER = 'INPUT_LAYER'
    FROM_FIELD_KEY = 'FROM_FIELD_KEY'
    TO_FIELD_KEY = 'TO_FIELD_KEY'
    LINE_FIELD_KEY = 'LINE_FIELD_KEY'    
    OUTPUT = 'OUTPUT'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return NetworkFlowOrderingAlgorithm()
        
    def name(self):        
        return 'g. Tile Network Ordering'

    def displayName(self):        
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):        
        return ''

    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr( """This tool uses the relationships between the line segments to determine the Strahler Order for topologically-sound connected tile networks. 
        
        Workflow:         
        1. Select a vector Line layer. This is a follow-up from "Routine F"
        2. Select the respective Field IDs that represents the attribute tables from the displayed line layer
        3. Save the output file (optional)         
        4. Click on \"Run\"               
                
        The script will give out an output. 
                
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.
        """)   
        
    def helpUrl(self):
        return "https://publish.illinois.edu/illinoisdrainageguide/files/2022/06/PublicAccess.pdf"
        
        
    def initAlgorithm(self, config):
        self.addParameter(QgsProcessingParameterVectorLayer(self.INPUT_LAYER, self.tr('Sound Tile Network: from Tile Flow-Path Generator'), [QgsProcessing.TypeVectorLine], defaultValue=None))                
        
        self.addParameter(QgsProcessingParameterField(self.FROM_FIELD_KEY, self.tr("Tile_From"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))
        
        self.addParameter(QgsProcessingParameterField(self.TO_FIELD_KEY, self.tr("Tile_To"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))              
        
        self.addParameter(QgsProcessingParameterVectorDestination(self.OUTPUT, self.tr('Tile Network Flow Ordering')))
                      
    def processAlgorithm(self, parameters, context, feedback):
        
        raw_layer = self.parameterAsVectorLayer(parameters, self.INPUT_LAYER, context)
        
        if raw_layer is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        raw_fields = raw_layer.fields()
        
        '''Counter for the progress bar'''
        total = raw_layer.featureCount()
        parts = 100/total

        '''names of fields from Tile Network'''        
        from_field = self.parameterAsString(parameters, self.FROM_FIELD_KEY, context)
        to_field = self.parameterAsString(parameters, self.TO_FIELD_KEY, context)
        #line_field = self.parameterAsString(parameters, self.LINE_FIELD_KEY, context)
        
        '''field index for id,next segment, previous segment'''
        idx_from = raw_layer.fields().indexFromName(from_field) 
        idx_to = raw_layer.fields().indexFromName(to_field)
        #idx_line = raw_layer.fields().indexFromName(line_field)
        
        '''add new fields'''
        #define new fields
        out_fields = QgsFields()
        #append fields
        for field in raw_fields:
            out_fields.append(QgsField(field.name(), field.type()))
        out_fields.append(QgsField('FLOW_LINE', QVariant.String))
        out_fields.append(QgsField('TILE_FLOW', QVariant.String))
        out_fields.append(QgsField('BURY_ORDER', QVariant.String))
        out_fields.append(QgsField('SIZING_ID', QVariant.String))
        out_fields.append(QgsField('FLOW_ORDER', QVariant.String))
        out_fields.append(QgsField('TILE_ORDER', QVariant.String))
        
        '''load data from layer "raw_layer" '''
        feedback.setProgressText(self.tr("Loading network layer\n "))        
        
        ab_map = {}
        for feature in raw_layer.getFeatures():
            ab_to = feature[idx_to]
            ab_from = feature[idx_from]
            
            if ab_to not in ab_map:
                ab_map[ab_to] = [ab_from]
            else:
                ab_map[ab_to].append(ab_from)
        
        feedback.setProgressText(self.tr("Data loaded \n Calculating network flow ordering \n"))
        
        result1 = []
        intermediate_cache = ['Out']

        while len(result1) < total:
            intermediate_cache2 = []
            for begin in intermediate_cache:
                try:
                    for item in ab_map[begin]:
                        result1.append(item)
                        intermediate_cache2.append(item)
                except:
                    pass
            intermediate_cache = intermediate_cache2
        
        order_results = {}

        def calculate_order(n):
            if n in order_results:
                return order_results[n]
            result = None
            if n not in ab_map:
                result = 1
            elif len(ab_map[n]) == 1:
                result = calculate_order(ab_map[n][0])  # inherit order of the single source
            elif len(ab_map[n]) == 2:
                a, b = ab_map[n]  # get two elements respectively
                a = calculate_order(a)
                b = calculate_order(b)
                if a == b:
                    result = a + 1
                else:
                    result = max(a, b)
            
            elif len(ab_map[n]) == 3:
                a, b, c = ab_map[n]  # get three elements respectively
                a = calculate_order(a)
                b = calculate_order(b)
                c = calculate_order(c)
                
                temp = [a,b,c]
                        
                if a == b==c:
                    result = a + 1
                if a!=b!=c:
                    result = max(temp)
                if (a!=b) | (a!=c) | (b!=c): 
                    c = Counter(temp)
                    common = 0
                    for i,j in c.items():
                        if j == 2:
                            common = i
                    once = [x for x in temp if x!=common][0]
                    twice = common+1
                    result = max(once,twice) 
                           
            elif len(ab_map[n]) == 4:  # Handling four dependencies
                a, b, c, d = ab_map[n]  # get four elements respectively
                a = calculate_order(a)
                b = calculate_order(b)
                c = calculate_order(c)
                d = calculate_order(d)
                
                if a == b == c == d:
                    result = max(a, b, c, d) + 1
                elif a == b == c and d != a:
                    result = max(a, b, c, d) + 1
                elif (a == b and c == d) or (a == c and b == d) or (a == d and b == c):
                    result = max(a, b, c, d) + 1
                else:
                    result = max(a, b, c, d)
                                               
            else:
                raise ValueError("Unreachable code")
            order_results[n] = result
            return result

        '''segments with numbers'''
        feedback.setProgressText(self.tr("Data loaded \n Calculating flow orders \n"))
        calculate_order("Out")
        
        '''sink definition'''
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT, context, out_fields, raw_layer.wkbType(), raw_layer.sourceCrs())

        '''add new features to sink'''
        feedback.setProgressText(self.tr("creating output \n"))
        features = raw_layer.getFeatures()
        
        for (n, feature) in enumerate(features):
            # Stop the algorithm if cancel button has been clicked
            if feedback.isCanceled():
                break

            # Add a feature in the sink
            outFt = QgsFeature(out_fields)

            # Copy previous data
            outFt.setGeometry(feature.geometry())
            outFt.setAttributes(feature.attributes() + [None] + [None] + [None] + [None] +[None] + [None])  # expand size of array

            # Write into the new fields
            outFt["FLOW_LINE"] = result1[n]
            outFt["TILE_FLOW"] = total - result1.index(feature[from_field])
            outFt["BURY_ORDER"] = total - outFt["TILE_FLOW"] + 1
            outFt["SIZING_ID"] = total - outFt["BURY_ORDER"] + 1
            
            # Write FLOW_ORDER            
            outFt["FLOW_ORDER"] = order_results[str(result1[n])]

            # Write TILE_ORDER
            net = feature[idx_from]
            outFt["TILE_ORDER"] = order_results[str(net)]
            sink.addFeature(outFt, QgsFeatureSink.FastInsert)
            
            # Update the progress bar
            feedback.setProgress(int(n * total))
       
        return {self.OUTPUT: dest_id}
