# -*- coding: utf-8 -*-

"""
/***************************************************************************
 illini_drainage_tools
                                 A QGIS plugin
 Performs Specific Draiange Related Tasks and Analysis on a Site
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-15
        copyright            : (C) 2022 by FALASY  Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY  Anamelechi'
__date__ = '2022-03-15'
__copyright__ = '(C) 2022 by FALASY  Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import processing
import os, math
import inspect
import time
import qgis.utils
import numpy as np

from qgis.gui import *
from PyQt5 import QtWidgets
from collections import Counter
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication, QVariant

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFolderDestination
from qgis.core import QgsProcessingParameterFileDestination
from qgis.core import QgsProcessingParameterVectorDestination
from qgis.core import QgsProcessingParameterExtent
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterPoint
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterCrs
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsFeatureSink
from qgis.core import QgsFeatureRequest
from qgis.core import QgsVectorLayer
from qgis.core import QgsLineSymbol
from qgis.core import QgsProperty
from qgis.core import QgsProcessingLayerPostProcessorInterface


from qgis.core import (edit,QgsField, QgsFeature, QgsPointXY, QgsWkbTypes, QgsGeometry, QgsFields)

class NetworkElevationAlgorithm(QgsProcessingAlgorithm):            
        
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
        
    def createInstance(self):
        return NetworkElevationAlgorithm()
        
    def name(self):
        return 'h. Network Elevation Exports'

    def displayName(self):
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr("""This Tool is used to generates elevation points and calculate the logitudinal slope for each line segment of the Tile Network.
        
        Workflow: 
        1. Select two layers: a DEM Layer and the Tile Line Layer from "Tile Network Flow Ordering". This is a follow-up from "Routine G"
        2. Select a reference field for generating the elevation points from
        3. Specify a value for the line segment. This can be left at Default Value
        4. Select a desired coordinate reference system for displaying the generated elevation points
        5. Save the output files (optional)
        6. Click on \"Run\"
        
        Notes for Input parameters: 
        1 - Line Segment: It is advisable that the length of the segments in the selected vector line layer be equal or greater than 5 times the pixel size of the DEM. The value entered here determines the length of the line segments created.  
        2 - Digital Elevation Model (DEM): any elevation raster, with elevation values in same units as road network vector layer lengths. 
        3 - The Tile Lines: Select any vector line layer that is completely within the DEM data area. 
        
        The script will gives out three outputs.

        Some significant fields are:
        \"Length", with the current length of the segmentation (note that there might be residual segments, of less than the chosen length); 
        \"Slope_%", with the longitudinal slope of each segment, in percentage.         
                        
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.             
        """)    
        
    def helpUrl(self):
        return "https://publish.illinois.edu/illinoisdrainageguide/files/2022/06/PublicAccess.pdf"  
    
    
    def initAlgorithm(self, config=None):        
        self.addParameter(QgsProcessingParameterRasterLayer('MDFT', 'Original Field DEM',  defaultValue=None))
        self.addParameter(QgsProcessingParameterBoolean('VERBOSE_LOG', 'Verbose logging', optional=True, defaultValue=True))
        self.addParameter(QgsProcessingParameterVectorLayer('LineSegmentLayer', 'Tile Lines: from Tile Network Ordering', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        
        self.addParameter(QgsProcessingParameterField('FGHTY', 'Field to Calculate [TILE_ID]', parentLayerParameterName = 'LineSegmentLayer', type = QgsProcessingParameterField.Any,))
        self.addParameter(QgsProcessingParameterNumber('SegmentLength', 'Line Segment (=> 5 times pixel size)', type=QgsProcessingParameterNumber.Double, maxValue=1.79769e+308, defaultValue=5000))
        self.addParameter(QgsProcessingParameterCrs('CRS', 'Coordinate Reference System', defaultValue='EPSG:3435'))
        
        self.addParameter(QgsProcessingParameterVectorDestination('FinalFields', 'Reference Fields with Elevation Statistics', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('EndpointElevations', 'End Point Elevations', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('TerrainProfiles', 'Network Elevation Points', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
                                    
                        
    def processAlgorithm(self, parameters, context, feedback):
                                              
        # Split lines by maximum length
        split_params = processing.run('native:splitlinesbylength', 
        {'INPUT': parameters['LineSegmentLayer'], 'LENGTH': parameters['SegmentLength'], 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #1

        results_a = split_params['OUTPUT']
               
        # Drape (set Z value from raster)
        drape_params = processing.run('native:setzfromraster', 
        {'BAND': 1, 'INPUT': results_a, 'NODATA': -9999, 'RASTER': parameters['MDFT'], 'SCALE': 1, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #2

        results_b = drape_params['OUTPUT']
                
        # Extract Z values
        elev_params = processing.run('native:extractzvalues', 
        {'COLUMN_PREFIX': 'Elev_', 'INPUT': results_b, 'SUMMARIES': [0,1], 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #3

        results_c = elev_params['OUTPUT']
                
        # Calculates True Length
        line_params = processing.run('sagang:lineproperties', 
        {'LINES': results_c, 'BPARTS': False, 'BPOINT': False, 'BLENGTH': True, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #4

        results_d = line_params['OUTPUT']
        
        # Field calculator2
        calcu_params = processing.run('native:fieldcalculator',
        {'FIELD_LENGTH': 18, 'FIELD_NAME': 'Seg_Slope', 'FIELD_PRECISION': 3, 'FIELD_TYPE': 0, 'FORMULA': '(abs(\"Elev_first\" - \"Elev_last\") / \"LENGTH\")', 
        'INPUT': results_d, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #5
        
        results_e = calcu_params['OUTPUT']
        
        # Final Retained Fields of Interest
        retained_params = processing.run('native:retainfields', 
        {"INPUT": results_e, "FIELDS": ['Tile_ID', 'Tile_FROM', 'Tile_TO', 'Elev_First', 'Elev_Last', 'LENGTH', 'Seg_Slope', 'FLOW_LINE', 
        'TILE_FLOW', 'FLOW_ORDER', 'Tile_ORDER', 'BURY_ORDER', 'SIZING_ID'], "OUTPUT": parameters['FinalFields']},
        context=context, feedback=feedback, is_child_algorithm=True) #6
        
        results_f = retained_params['OUTPUT']
        
        # Extract Vertex
        vertex_params = processing.run('native:extractvertices', 
        {'INPUT': results_f, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #7
        
        results_g = vertex_params['OUTPUT']
        
        # Add X & Y Fields
        xyadds_params = processing.run('native:addxyfields', 
        {'INPUT': results_g, 'CRS': parameters['CRS'], 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #8
        
        results_h = xyadds_params['OUTPUT']
       
        # Add Field ID
        idz_params = processing.run('native:fieldcalculator', 
        {'FIELD_LENGTH': 11, 'FIELD_NAME': 'Point_ID', 'FIELD_PRECISION': 3, 'FIELD_TYPE': 1, 'FORMULA': '$id', 
        'INPUT': results_h, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #9
        
        results_i = xyadds_params['OUTPUT']
            
        # Endpoint Fields of Interest
        endpoint_params = processing.run('native:retainfields', 
        {"INPUT": results_i, "FIELDS": ['Point_ID', 'x', 'y'], "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #10
        
        results_j = endpoint_params['OUTPUT']
        
        # Add Raster Values to Points
        elevation_params = processing.run('sagang:addrastervaluestopoints', 
        {'SHAPES': results_j, 'GRIDS': parameters['MDFT'], 'RESAMPLING': 0, 'RESULT': parameters['EndpointElevations']},
        context=context, feedback=feedback, is_child_algorithm=True) #11
        
        results_k = elevation_params['RESULT']
        
        # Line Terrain Profiles
        terrain_params = processing.run('sagang:profilesfromlines',
        {'DEM': parameters['MDFT'], 'LINES': results_f, 'NAME': parameters['FGHTY'], 'PROFILE': QgsProcessing.TEMPORARY_OUTPUT, 'PROFILES': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #12
       
        results_l = terrain_params['PROFILE']        
        
        # Rename Field Name        
        rename_params = processing.run('qgis:renametablefield', 
        {'INPUT': results_l, 'FIELD': 'Z', 'NEW_NAME': 'SURF_ELEV', 'OUTPUT': parameters['TerrainProfiles']},
        context=context, feedback=feedback, is_child_algorithm=True) #13
        
        results_m = rename_params['OUTPUT']       
                             
        global renamer_a       
        renamer_a = Renamer_1('Final Referenced Fields')
        context.layerToLoadOnCompletionDetails(results_f).setPostProcessor(renamer_a)
        
        global renamer_b       
        renamer_b = Renamer_2('Endpoint Elevations')
        context.layerToLoadOnCompletionDetails(results_k).setPostProcessor(renamer_b)
        
        global renamer_c       
        renamer_c = Renamer_3('Network Elevation Points')
        context.layerToLoadOnCompletionDetails(results_m).setPostProcessor(renamer_c)
        
        return {'FinalFields': results_f, 'EndpointElevations': results_k, 'TerrainProfiles': results_m}
        
class Renamer_1(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_2(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_3(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)

