# -*- coding: utf-8 -*-

"""
/***************************************************************************
 illini_drainage_tools
                                 A QGIS plugin
 Performs Specific Draiange Related Tasks and Analysis on a Site
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-03-15
        copyright            : (C) 2022 by FALASY  Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY  Anamelechi'
__date__ = '2022-03-15'
__copyright__ = '(C) 2022 by FALASY  Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import processing
import os, math
import inspect
import time
import random
import qgis.utils
import numpy as np
import pandas as pd

from qgis.gui import *
from PyQt5 import QtWidgets
from PyQt5.QtGui import QColor
from random import randrange
from collections import Counter
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsGradientColorRamp
from qgis.PyQt.QtCore import QCoreApplication, QVariant

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFolderDestination
from qgis.core import QgsProcessingParameterFileDestination
from qgis.core import QgsProcessingParameterVectorDestination
from qgis.core import QgsProcessingParameterExtent
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterPoint
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterCrs
from qgis.core import QgsProcessingParameterFile
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsFeatureSink
from qgis.core import QgsFeatureRequest
from qgis.core import QgsVectorLayer
from qgis.core import QgsLineSymbol
from qgis.core import QgsProperty
from qgis.core import QgsAggregateCalculator
from qgis.core import QgsWkbTypes
from qgis.core import QgsProject
from qgis.core import QgsProcessingParameterVectorDestination

from qgis.core import QgsLineString, QgsPoint

from qgis.utils import iface

from qgis.core import (
    QgsCategorizedSymbolRenderer,
    QgsSymbol,
    QgsExpression,
    QgsFillSymbol,
    QgsRendererCategory,
    QgsSimpleFillSymbolLayer,
    QgsColorRampShader,
    QgsVectorDataProvider)

from qgis.core import QgsProcessingLayerPostProcessorInterface

from qgis.core import (edit,QgsField, QgsFeature, QgsPointXY, QgsWkbTypes, QgsGeometry, QgsFields)

# Register native QGIS processing algorithms
#QgsApplication.processingRegistry().addProvider(QgsNativeAlgorithms())


class PriceEstimatesAlgorithm(QgsProcessingAlgorithm):
    INPUT_LAYER = 'INPUT_LAYER'
    INPUT_PRICE = 'INPUT_PRICE'
    SEGMENT_KEY = 'SIZING_ID'
    PIPE_KEY = 'NOMINAL'
    LENGTH_KEY = 'LENGTH_DIST'
    CRS_KEY = 'CRS_KEY'
    OUTPUT_LAYER = 'OUTPUT_LAYER'
    
        
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
        
    def createInstance(self):
        return PriceEstimatesAlgorithm()
        
    def name(self):
        return 'l. Sized Pipe Estimations'

    def displayName(self):
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr("""This Tool generates an estimated price for the entire network of sized pipes, depending on the diameter, length and kind of pipe materials.
        
        Workflow: 
        1. Select a Line Layer (e.g. the "Network Pipe Sizings"). This is a follow-up from "Routine K"
        2. Select the two fields used for generating the price estimations (that is, the "NOMINAL" and "LENGTH")
        3. Fill out the prices for the different pipe sizes, using the "prize_table" file. Copy and paste link to download: 
           https://drive.google.com/file/d/1CJ5yFAuIZeRE1vOX1FEWkeTbSHunxtId/view?usp=sharing
        4. Save the output files (optional)
        5. Click on \"Run\"
        
        The script will gives out an output.         
                
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.             
        """)    
        
    def helpUrl(self):
        return "https://publish.illinois.edu/illinoisdrainageguide/files/2022/06/PublicAccess.pdf"  
    
    
    def initAlgorithm(self, config):        
              
                
        self.addParameter(QgsProcessingParameterVectorLayer(self.INPUT_LAYER, self.tr('Network Pipe Sizings'), [QgsProcessing.TypeVectorLine], defaultValue=None)) 
                
        self.addParameter(QgsProcessingParameterField(self.PIPE_KEY, self.tr("Pipe Sizes [NOMINAL_SIZE]"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))       
        
        self.addParameter(QgsProcessingParameterField(self.LENGTH_KEY, self.tr("Pipe Length [LENGTH]"), parentLayerParameterName = self.INPUT_LAYER, type = QgsProcessingParameterField.Any, defaultValue=None))

        self.addParameter(QgsProcessingParameterFile(self.INPUT_PRICE, self.tr('Insert Filled Price Table'), extension='csv', defaultValue=None))        
                       
        self.addParameter(QgsProcessingParameterVectorDestination(self.OUTPUT_LAYER, self.tr('Price Estimations for Sized Pipes [$ Per Foot Length]'), type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))       
    
                 
    def processAlgorithm(self, parameters, context, feedback):       
                
        rawz_layer = self.parameterAsVectorLayer(parameters, self.INPUT_LAYER, context)
        
        if rawz_layer is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        rawz_fields = rawz_layer.fields() 
       
        '''Counter for the progress bar'''
        total = rawz_layer.featureCount()
        parts = 100/total
      
        '''names of fields from Tile Network'''      
        size_field = self.parameterAsString(parameters, self.PIPE_KEY, context)
        length_field = self.parameterAsString(parameters, self.LENGTH_KEY, context)
        price_table = self.parameterAsString(parameters, self.INPUT_PRICE, context)
        prices_df = pd.read_csv(price_table)
               
        '''field index for id,next segment, previous segment'''        
        p_size_index = rawz_layer.fields().indexFromName(size_field)
        length_index = rawz_layer.fields().indexFromName(length_field)
        
        # Define pipe sizes and associated price tables
        size_pipe = list(prices_df['PipeSize'])
        single_wall_price = list(prices_df['SingleWall'])
        smooth_wall_price = list(prices_df['SmoothWall'])
        clay_wall_price = list(prices_df['Clay'])
        concrete_wall_price = list(prices_df['Concrete'])
        
        #define new fields for the output layer       
        out_fields = QgsFields()                
        out_fields.append(QgsField('N_SIZES', QVariant.Int))
        out_fields.append(QgsField('FREQUENCY', QVariant.Int))
        out_fields.append(QgsField('TOTAL_FEET', QVariant.Double))
        out_fields.append(QgsField('SINGLE_W[$]', QVariant.Double))    
        out_fields.append(QgsField('SMOOTH_W[$]', QVariant.Double))    
        out_fields.append(QgsField('CLAY_W[$]', QVariant.Double))    
        out_fields.append(QgsField('CONCRETE_W[$]', QVariant.Double))                                      
       
        '''load data from layer "raw_layer" '''
        feedback.setProgressText(self.tr("Loading Price Estimations\n "))
        
        # Initialize lists for output attributes
        n_sizes = []
        n_freq = []
        total_length = []
        sing_wall = []
        smot_wall = []    
        clay_wall = []    
        conc_wall = []
            
        # Loop through features and group by pipe size
        groups = {}
        for feature in rawz_layer.getFeatures():          
            p_size = int(feature.attributes()[p_size_index])
            length = float(feature.attributes()[length_index])

            # Add feature to corresponding pipe size group
            if p_size not in groups:                
                groups[p_size] = {'freq': 0, 'length': 0}
            groups[p_size]['freq'] += 1
            groups[p_size]['length'] += length
           
        # Loop through pipe size groups and calculate output attributes
        for size in groups:
            #if size in groups:
            n_sizes.append(size)
            n_freq.append(groups[size]['freq'])
            total_length.append(groups[size]['length'])
            sing_wall.append(groups[size]['length'] * single_wall_price[size_pipe.index(size)])            
            smot_wall.append(groups[size]['length'] * smooth_wall_price[size_pipe.index(size)])            
            clay_wall.append(groups[size]['length'] * clay_wall_price[size_pipe.index(size)])            
            conc_wall.append(groups[size]['length'] * concrete_wall_price[size_pipe.index(size)])                           
                
        # Use random colors to create categorized symbol for each group/category
        color_list = ['#FF0000', '#00FF00', '#0000FF', '#FFFF00', '#00FFFF', '#FF00FF', '#800000', '#008000', '#000080', '#808000', '#008080', '#800080', '#C0C0C0']
        categories = []
        i = 0
        for n_size in n_sizes:           
            symbol = QgsSymbol.defaultSymbol(rawz_layer.geometryType())            
            symbol.setColor(QColor(color_list[i % len(color_list)]))                        
            category = QgsRendererCategory(n_size, symbol, str(n_size))            
            categories.append(category)
            i += 1
        renderer = QgsCategorizedSymbolRenderer(size_field, categories)               
        rawz_layer.setRenderer(renderer)
        rawz_layer.triggerRepaint()         
         
        '''load data from layer "raw_layer" '''
        feedback.setProgressText(self.tr("Loading Price Estimations\n "))
               
        # Part 3
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT_LAYER, context, out_fields, rawz_layer.wkbType(), rawz_layer.sourceCrs())                  
        
        # Add features to output layer with new fields of attribute values
        for i, n_size in enumerate(n_sizes):
            line = QgsLineString()  # Create a new QgsLineString for each line segment
            line.addVertex(QgsPoint(0, i))
            
            # Create a new feature with the line geometry
            feature = QgsFeature()
            feature.setGeometry(QgsGeometry.fromPolyline(line))

            # Append the values from the 11 lists to the feature attributes            
            feature.setAttributes([
                n_sizes[i],
                n_freq[i],
                total_length[i],
                sing_wall[i],            
                smot_wall[i],
                clay_wall[i],            
                conc_wall[i]                
            ])
            
            # Add the feature to the layer
            sink.addFeature(feature, QgsFeatureSink.FastInsert)

        # Set the extent of the new layer to the original extent
        rawz_layer_extent = rawz_layer.extent()
        sink_layer = QgsVectorLayer(dest_id, self.OUTPUT_LAYER, "memory")
        sink_layer.setExtent(rawz_layer_extent)       
          
        ## Return result
        return {self.OUTPUT_LAYER: dest_id}
        return {self.OUTPUT_LAYER: rawz_layer}
        return {self.OUTPUT_LAYER: sink_layer}         