# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IdevDockWidget
                                 A QGIS plugin
 Infraestructura Valenciana de Dades Espacials
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-08-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Alfonso Moya Fuero
        email                : moya_alf@gva.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys
import webbrowser
from PyQt5 import Qt, uic, QtGui, QtCore
from PyQt5.QtWidgets import QTreeWidgetItem, QMessageBox
from qgis.PyQt import *
from qgis.PyQt.QtCore import *
from qgis.utils import iface
from qgis.core import QgsRectangle, QgsRasterLayer, QgsProject, QgsVectorLayer, QgsLayerTreeGroup, QgsLayerTreeLayer, \
    QgsLayerTreeNode, QgsGeometry, QgsPointXY, QgsPoint
from PyQt5.QtGui import QPixmap
import requests, json
from json import loads
from qgis.PyQt.QtCore import QUrl
from qgis.PyQt.QtWebKitWidgets import QWebView

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'idev_visor_dockwidget_base.ui'))


class IdevDockWidget(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(IdevDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect

        self.iface = iface  # Loading the iface class to control QGIS events

        """ Configuration of the API event connections """
        self.setupUi(self)
        self.setupPlugin()  # Appearance initialization
        self.canvas = iface.mapCanvas()  # We take control of the canvas through the panel
        self.list_toponimia.hide()  # Hide the ListWidget of the results of the toponimic search
        self.list_capa.hide()  # We hide the list of the layer search engine, it will appear when doing search

        """ Dashboard widget event connectors """
        self.rdb_cas.toggled.connect(lambda:self.changeLanguage(self.rdb_cas))
        self.rdb_val.toggled.connect(lambda: self.changeLanguage(self.rdb_val))
        self.txt_toponimia.textChanged.connect(self.searchToponym)
        self.txt_toponimia.cursorPositionChanged.connect(self.clearToponym)
        self.list_toponimia.itemClicked.connect(self.zoomToponym)
        self.cmb_capas_base.currentIndexChanged.connect(self.changeBaseMap)
        self.tree_toc.itemClicked.connect(self.selectTocLayer)
        self.tree_toc.itemChanged.connect(self.checkTreeLayer)
        self.txt_busca_capa.textChanged.connect(self.searchLayer)
        self.list_capa.itemClicked.connect(self.selectTreeLayer)
        self.txt_busca_capa.cursorPositionChanged.connect(self.clearLayer)
        self.btn_meta.clicked.connect(self.openCatalog)
        self.btn_icv.clicked.connect(self.openIcvSite)
        self.btn_idev.clicked.connect(self.openIdevSite)
        self.btn_help.clicked.connect(self.openHelp)

        """ Layer QTreeWidget Settings  """

        self.tree_toc.headerItem().setText(0, "")

        """ We dynamically load the layers in the QtreeWidget at various parent / child levels """

        self.createTree()

    """ Function to load the initial appearance of the plugin  """
    def setupPlugin(self):
        baseDirectory = os.path.dirname(os.path.realpath(__file__)) # Plugin absolute path
        #self.im_idev = QPixmap(os.path.dirname(os.path.realpath(__file__)) + '/IDEV_Logo.png')
        #self.txt_logo_1.setPixmap(self.im_idev)  # Load the ICV lgo
        self.im_icv = QPixmap(os.path.dirname(os.path.realpath(__file__)) + '/IDEV.png')
        self.txt_logo_2.setPixmap(self.im_icv)   # Loading the IDEV logo
        self.rdb_cas.setChecked(True)   # Default language "Castellano"
        self.btn_meta.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/info_on.png'))
        self.btn_icv.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/icon.png'))
        self.btn_idev.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/icon_idev.png'))
        self.btn_help.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/help.png'))

    """ Function that changes the language of the controls. The languages are Spanish / Valencian """

    def changeLanguage(self, b):
        self.createTree()  # Function that changes the language of the controls. The languages are Spanish / Valencian
        self.txt_capa_seleccionada.setEnabled(False)  # Activate the label of the active layer
        self.txt_capa_seleccionada.setText("")  # Claer the text of the label layer name
        self.txt_info_capa.setEnabled(False)  # Desactivate the label of the layer name
        self.btn_meta.setEnabled(False)  # Desactivate the button of the info layer
        """ Check the language and set the text of the widgets """
        if b.text() == "Cas":
            if self.rdb_cas.isChecked():
                self.txt_toponimia.setText("Busca topónimo, dirección o ref. catastral")
                self.txt_busca_capa.setText("Busca capa...")
                self.cmb_capas_base.setItemText(0, "Sin fondo")
                self.cmb_capas_base.setItemText(1, "Imagen")
                self.cmb_capas_base.setItemText(2, "Híbrido")
                self.cmb_capas_base.setItemText(3, "Relieve")
                self.cmb_capas_base.setItemText(4, "Topográfico")
                self.cmb_capas_base.setItemText(5, "Topográfico gris")
                self.cmb_capas_base.setItemText(6, "Topográfico básico")
                self.txt_info_capa.setText("Catálogo de la IDEV:")
                """ Tooltilps translations to Spanish """
                self.btn_icv.setToolTip("Ir a la web del Institut Cartogràfic Valencià")
                self.btn_idev.setToolTip("Ir a la web de la Infraestructura Valenciana de Datos Espaciales")
                self.cmb_capas_base.setToolTip("Seleccionar capa base de fondo")
                self.txt_toponimia.setToolTip("Inserte el texto para la búsqueda toponímica")
                self.btn_meta.setToolTip("Pulsar para consultar el catálogo de la IDEV de la capa seleccionada")
                self.rdb_cas.setToolTip("Activar para traducir el complemento al castellano")
                self.rdb_val.setToolTip("Activar para traducir el complemento al valenciano")
                self.txt_busca_capa.setToolTip("Inserte el texto para la búsqueda de capas")
        if b.text() == "Val":
            if self.rdb_val.isChecked():
                self.txt_toponimia.setText("Busca topònim, direcció o ref. cadastral")
                self.txt_busca_capa.setText("Busca capa...")
                self.cmb_capas_base.setItemText(0, "Sense fons")
                self.cmb_capas_base.setItemText(1, "Imatge")
                self.cmb_capas_base.setItemText(2, "Híbrid")
                self.cmb_capas_base.setItemText(3, "Relleu")
                self.cmb_capas_base.setItemText(4, "Topogràfic")
                self.cmb_capas_base.setItemText(5, "Topogràfic gris")
                self.cmb_capas_base.setItemText(6, "Topogràfic bàsic")
                self.txt_info_capa.setText("Catàleg de la IDEV:")
                """ Tooltilps translations to Valencian """
                self.btn_icv.setToolTip("Anar a la web de l'Institut Cartogràfic Valencià")
                self.btn_idev.setToolTip("Anar a la web de la Infraestructura Valenciana de Dades Espacials")
                self.cmb_capas_base.setToolTip("Seleccionar capa base de fons")
                self.txt_toponimia.setToolTip("Inserisca el text per a la cerca toponímica")
                self.btn_meta.setToolTip("Prémer per a consultar el catàleg de la IDEV de la capa seleccionada")
                self.rdb_cas.setToolTip("Activar per a traduir el complement al castellà")
                self.rdb_val.setToolTip("Activar per a traduir el complement al valencià")
                self.txt_busca_capa.setToolTip("Inserisca el text per a la cerca de capes")

    """  Function for toponymy search. Connection with the IDEV search engine service """

    def searchToponym(self):
        # Disable the search with the default help text of the control
        if self.txt_toponimia.text() == 'Busca topónimo, dirección o ref. catastral' or self.txt_toponimia.text() == 'Busca topònim, direcció o ref. cadastral':
            pass
        # When change the text of the textline activate the search
        else:
            text = self.txt_toponimia.text()
            self.list_toponimia.clear()
            if len(text) > 2:  # The search began when type 3 or more characters
                self.list_toponimia.show()  # Show the textlist of the results of the search
                url = 'http://descargas.icv.gva.es/server_api/buscador/solrclient.php?start=0&limit=40&query=' + text   # Create the url search query
                s = requests.get(str(url)).text  # Request the query
                start = s.find("[") + len("[")
                end = s.find("]")
                substring = "[" + s[start:end] + "]" # Format of the response. Create a JSON file
                # print(substring)
                y = json.loads(substring)  # Load the result as a JSON file
                i = len(y)  # Calculate the lenght of the query result
                for x in range(0, i):   # Load in the ListWidget the results of the query
                    titulo = y[x]["titulo"]
                    clasificacion = y[x]["clasificacion"]
                    descripcion = y[x]["descripcion"]
                    if titulo.find('\n') != -1:
                        titulo = titulo.replace('\n', '')  # remove that character of some query results
                    if descripcion == '':
                        descripcion = ''
                    else:
                        descripcion = "\n" + descripcion  # Format the result in the ListWidget
                    widgetText = QtWidgets.QListWidgetItem('{0}'.format(titulo) + "\t " + clasificacion + descripcion)
                    self.list_toponimia.addItem(widgetText)  # Add items to the ListWidget
            else:
                self.list_toponimia.hide()  # If the query is null, hide the ListWidget

    """ Function that centers the zoom on the toponym selected from the ListWidget  """

    def zoomToponym(self):
        texto = self.list_toponimia.currentItem().text()  # Capture the exact name of the toponym
        text, tipo = texto.split("\t")  # Split the information of the toponym
        self.txt_toponimia.setText(text)  # Write the toponymin the labeltext of search
        text = text.replace('/', '')  # Format the toponym text
        url = 'http://descargas.icv.gva.es/server_api/buscador/solrclient.php?start=0&limit=40&query=' + text  # Create the query with the exact toponym
        s = requests.get(str(url)).text
        start = s.find("[") + len("[")
        end = s.find("]")
        substring = "[" + s[start:end] + "]"  # Format of the response. Create a JSON file
        y = json.loads(substring)  # Load the result as a JSON file
        extent = y[0]["boundingbox"]  # Get the boundingbox of the toponym
        XMin, Ymin, XMax, Ymax = extent.split(",")  # Asign the coordinates of the extent
        zoomRectangle = QgsRectangle(float(XMin), float(Ymin), float(XMax), float(Ymax))  # Create a zoomRectangle
        self.iface.mapCanvas().setExtent(zoomRectangle)  # Set the extent o the project
        if XMin == XMax:
            self.iface.mapCanvas().zoomScale(1000)  # Default scale if the toponym is a puntual shape
        self.iface.mapCanvas().refresh()  # Refresh the canvas view
        self.list_toponimia.hide()  # Hide the listwidget

    """ Function to load the background base layers  """

    def changeBaseMap(self):
        extent = self.canvas.extent()  # Store the actual extent in a variable
        names = [layer.name() for layer in QgsProject.instance().mapLayers().values()]  # Store in a list the names of the layers
        for i in names:  # Unload the layer by name
            if i == 'Contorno autonómico':
                self.unloadLayerToc('Contorno autonómico')
            if i == 'Ortofoto 2019':
                self.unloadLayerToc('Ortofoto 2019')
            if i == 'ESRI Satellite':
                self.unloadLayerToc('ESRI Satellite')
            if i == 'Capa base Híbrido':
                self.unloadLayerToc('Capa base Híbrido')
            if i == 'Capa base Relieve':
                self.unloadLayerToc('Capa base Relieve')
            if i == 'Capa base Topográfico':
                self.unloadLayerToc('Capa base Topográfico')
            if i == 'Capa base Topográfico Básico':
                self.unloadLayerToc('Capa base Topográfico Básico')
            if i == 'Capa base Topográfico Gris':
                self.unloadLayerToc('Capa base Topográfico Gris')

        """ Loading the different base layers in the project  """

        if self.cmb_capas_base.currentIndex() == 1:
            urlWithParams_cv = "crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map"
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_orto = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=01_8bits_01_RGB_05_PNG&styles&tileMatrixSet=01_8bits_01_RGB_05_PNG-wmsc-0&url=http://terramapas.icv.gva.es/odcv05_etrs89h30_2019_3857'
            rasterLyr_orto = QgsRasterLayer(urlWithParams_orto, 'Ortofoto 2019', 'wms')
            if not rasterLyr_orto.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_orto, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_orto))
            urlWithParams_esri = 'type=xyz&zmin=0&zmax=20&url=https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}'
            rasterLyr_esri = QgsRasterLayer(urlWithParams_esri, 'ESRI Satellite', 'wms')
            if not rasterLyr_esri.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_esri, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_esri))

        if self.cmb_capas_base.currentIndex() == 2:
            urlWithParams_hibrido = 'crs=EPSG:3857&dpiMode=7&format=image/png&layers=mapabase_hibrid&styles&tileMatrixSet=mapabase_hibrid-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_hibrid/'
            rasterLyr_hibrido = QgsRasterLayer(urlWithParams_hibrido, 'Capa base Híbrido', 'wms')
            if not rasterLyr_hibrido.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_hibrido, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_hibrido))
            urlWithParams_orto = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=01_8bits_01_RGB_05_PNG&styles&tileMatrixSet=01_8bits_01_RGB_05_PNG-wmsc-0&url=http://terramapas.icv.gva.es/odcv05_etrs89h30_2019_3857'
            rasterLyr_orto = QgsRasterLayer(urlWithParams_orto, 'Ortofoto 2019', 'wms')
            if not rasterLyr_orto.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_orto, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_orto))
            urlWithParams_esri = 'type=xyz&zmin=0&zmax=20&url=https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}'
            rasterLyr_esri = QgsRasterLayer(urlWithParams_esri, 'ESRI Satellite', 'wms')
            if not rasterLyr_esri.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_esri, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_esri))

        if self.cmb_capas_base.currentIndex() == 3:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_relieve = 'crs=EPSG:3857&dpiMode=7&format=image/png&layers=01_8bits_01_RGB_05_PNG&styles&tileMatrixSet=01_8bits_01_RGB_05_PNG-wmsc-1&url=http://terramapas.icv.gva.es/mapabase_isohipsas'
            rasterLyr_relieve = QgsRasterLayer(urlWithParams_relieve, 'Capa base Relieve', 'wms')
            if not rasterLyr_relieve.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_relieve, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_relieve))

        if self.cmb_capas_base.currentIndex() == 4:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_topografico = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=topografico_continuo_epsg3857&styles&tileMatrixSet=topografico_continuo_epsg3857-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_topografico/'
            rasterLyr_topografico = QgsRasterLayer(urlWithParams_topografico, 'Capa base Topográfico', 'wms')
            if not rasterLyr_topografico.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_topografico, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_topografico))

        if self.cmb_capas_base.currentIndex() == 5:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))

            urlWithParams_gris = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=mapabase_topografico_grises&styles&tileMatrixSet=mapabase_topografico_grises-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_topografico_grises'
            rasterLyr_gris = QgsRasterLayer(urlWithParams_gris, 'Capa base Topográfico Gris', 'wms')
            if not rasterLyr_gris.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_gris, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_gris))

        if self.cmb_capas_base.currentIndex() == 6:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_basico = 'crs=EPSG:3857&dpiMode=7&format=image/png&layers=mapabase_basico&styles&tileMatrixSet=mapabase_basico-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_basico/'
            rasterLyr_basico = QgsRasterLayer(urlWithParams_basico, 'Capa base Topográfico Básico', 'wms')
            if not rasterLyr_basico.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_basico, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_basico))

        iface.mapCanvas().setExtent(extent)
        iface.mapCanvas().refresh()

    """ Selecting a layer in the layer tree and activating the catalog button  """

    #@QtCore.pyqtSlot(QtWidgets.QTreeWidgetItem, int)
    def selectTocLayer(self):
        i = 0
        for ix in self.tree_toc.selectedIndexes():
            if self.rdb_cas.isChecked() == True:
                for nombre in capasIDEV:
                    if ix.data() == nombre['nombre_cas'] and i == 0:
                        if nombre['metadato']:
                            self.btn_meta.setEnabled(True)
                            self.txt_info_capa.setEnabled(True)
                            self.txt_capa_seleccionada.setText(nombre['nombre_cas'])
                            self.txt_capa_seleccionada.setEnabled(True)
                        else:
                            self.btn_meta.setEnabled(False)
                            self.txt_info_capa.setEnabled(False)
                            self.txt_capa_seleccionada.setText('')
                            self.txt_capa_seleccionada.setEnabled(False)
                        i = i  + 1

            if self.rdb_val.isChecked() == True:
                for nombre in capasIDEV:
                    if ix.data() == nombre['nombre_val']:
                        if nombre['metadato']:
                            self.btn_meta.setEnabled(True)
                            self.txt_info_capa.setEnabled(True)
                            self.txt_capa_seleccionada.setText(nombre['nombre_val'])
                            self.txt_capa_seleccionada.setEnabled(True)
                        else:
                            self.btn_meta.setEnabled(False)
                            self.txt_info_capa.setEnabled(False)
                            self.txt_capa_seleccionada.setText('')
                            self.txt_capa_seleccionada.setEnabled(False)
                        i = i  + 1

    """ When the focus goes to the toponymic search, clear the info text  """

    def clearToponym(self):
        if self.txt_toponimia.text() == 'Busca topónimo, dirección o ref. catastral':
            self.txt_toponimia.setText('')
        if self.txt_toponimia.text() == 'Busca topònim, direcció o ref. cadastral':
            self.txt_toponimia.setText('')

    """ When the focus goes to the layer search, clear the info text  """

    def clearLayer(self):
        if self.txt_busca_capa.text() == 'Busca capa...':
            self.txt_busca_capa.setText('')

    """ Button to open the ICV website   """

    def openIcvSite(self):
        if self.rdb_cas.isChecked() == True:
            webbrowser.open('http://www.icv.gva.es/es/inicio')
        if self.rdb_val.isChecked() == True:
            webbrowser.open('http://www.icv.gva.es/va/inicio')

    """ Button to open the IDEV website   """

    def openIdevSite(self):
        if self.rdb_cas.isChecked() == True:
            webbrowser.open('http://www.idev.gva.es/es/inicio')
        if self.rdb_val.isChecked() == True:
            webbrowser.open('http://www.idev.gva.es/va/inicio')

    def openHelp(self):
        if self.rdb_cas.isChecked() == True:
            webbrowser.open(os.path.dirname(os.path.realpath(__file__)) + '/data/help_cast.html')
        if self.rdb_val.isChecked() == True:
            webbrowser.open(os.path.dirname(os.path.realpath(__file__)) + '/data/help_val.html')

    """ Button to open the catalog website of the selected layer in the QTreeWidget """

    def openCatalog(self):  # The layer name is different in each language, there is a different search in the layer dictionary
        if self.rdb_cas.isChecked() == True:
            for nombre in capasIDEV:
                if self.txt_capa_seleccionada.text() == nombre['nombre_cas']:
                    webbrowser.open('http://www.icv.gva.es/auto/aplicaciones/icv_geocat/#/search?uuid=' + nombre['metadato']) # Open the catalog
        if self.rdb_val.isChecked() == True:
            for nombre in capasIDEV:
                if self.txt_capa_seleccionada.text() == nombre['nombre_val']:
                    webbrowser.open('http://www.icv.gva.es/auto/aplicaciones/icv_geocat/#/search?uuid=' + nombre['metadato']) # Open the catalog

    """ Load the layer in the QGIS project whrn check the item in the QTreeWidget """

    def checkTreeLayer(self, it, col): # The layer name is different in each language, there is a different search in the layer dictionary
        if self.rdb_cas.isChecked() == True:
            for nombre in capasIDEV:  # Search in the layer dictionary by spanish name
                if it.checkState(0) == QtCore.Qt.Checked:
                    if it.text(col) == nombre['nombre_cas']:
                        self.loadLayerToc(nombre['url'], nombre['nombre_cas'])  # load the layer Checked in the QGIS project
                        if nombre['aviso_cas'] != "":
                            msg = QMessageBox.information(self, "Aviso:", nombre['aviso_cas'])  # Show advice if is not null
                            #msg.exec()
                else:
                    if it.text(col) == nombre['nombre_cas']:
                        try:
                            self.unloadLayerToc(nombre['nombre_cas']) # Unload the layer of the proyect if is unchecked
                        except:
                            pass

        if self.rdb_val.isChecked() == True:
            for nombre in capasIDEV:  # Search in the layer dictionary by valencian name
                if it.checkState(0) == QtCore.Qt.Checked:
                    if it.text(col) == nombre['nombre_val']:
                        self.loadLayerToc(nombre['url'], nombre['nombre_val'])  # load the layer Checked in the QGIS project
                        if nombre['aviso_val'] != "":
                            msg = QMessageBox.information(self, "Avís:", nombre['aviso_val']) # Show advice if is not null
                            #msg.exec()
                else:
                    if it.text(col) == nombre['nombre_val']:
                        self.unloadLayerToc(nombre['nombre_val'])  # Unload the layer of the proyect if is unchecked

    """ Funcion for load a layer in the QGIS project by name and url connection string """

    def loadLayerToc(self, url, nombre):
        layer = QgsRasterLayer(url, nombre, 'wms')  # Create a PyQt layer
        if not layer.isValid():
            print("Capa no válida")
            iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
        else:
            QgsProject.instance().addMapLayer(layer, False)  # Add the layer in the project
            layerTree = iface.layerTreeCanvasBridge().rootGroup()  # Add the layer on the top of the TOC
            layerTree.insertChildNode(0, QgsLayerTreeLayer(layer))

    """ Funcion for unload a layer in the QGIS project by layers name """

    def unloadLayerToc(self, nombre):
        try:
            QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName(nombre)[0])  # Unload the layer form the TOC
        except:
            pass
        iface.mapCanvas().refresh()  # Refresh the projet view in QGIS

    """ Function to dynamically load the layers in the QTreeWidget in the corresponding language """

    def createTree(self):
        self.tree_toc.clear() # Clear the tree
        capas = QTreeWidgetItem(self.tree_toc)  # Create the QtreeWidget
        if self.rdb_cas.isChecked() == True: # Create the fahther and child nodes in spanish
            capas.setText(0, "Capas del visor de la IDEV") # First item of the tree, father 0
            carto = QTreeWidgetItem(capas)
            carto.setText(0, "Cartografía de referencia")
            toponimia = QTreeWidgetItem(carto)
            toponimia.setFlags(toponimia.flags() | Qt.ItemIsUserCheckable)
            toponimia.setText(0, "Nomenclator Toponimico Valenciano")
            toponimia.setCheckState(0, Qt.Unchecked)
            basecartografica05 = QTreeWidgetItem(carto)
            basecartografica05.setText(0, "Base Cartográfica CV05")
            orografia05 = QTreeWidgetItem(basecartografica05)
            orografia05.setFlags(orografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia05.setText(0, "Orografía")
            orografia05.setCheckState(0, Qt.Unchecked)
            puntoscota = QTreeWidgetItem(orografia05)
            puntoscota.setFlags(puntoscota.flags() | Qt.ItemIsUserCheckable)
            puntoscota.setText(0, "Puntos de cota CV05")
            puntoscota.setCheckState(0, Qt.Unchecked)
            orolineas = QTreeWidgetItem(orografia05)
            orolineas.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            orolineas.setText(0, "Orografía líneas CV05")
            orolineas.setCheckState(0, Qt.Unchecked)
            curvasnivel = QTreeWidgetItem(orografia05)
            curvasnivel.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            curvasnivel.setText(0, "Curvas de nivel CV05")
            curvasnivel.setCheckState(0, Qt.Unchecked)
            hidrografia05 = QTreeWidgetItem(basecartografica05)
            hidrografia05.setFlags(hidrografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia05.setText(0, "Hidrografía")
            hidrografia05.setCheckState(0, Qt.Unchecked)
            hidropuntos05 = QTreeWidgetItem(hidrografia05)
            hidropuntos05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidropuntos05.setText(0, "Hidrografía puntual CV05")
            hidropuntos05.setCheckState(0, Qt.Unchecked)
            hidrolineas05 = QTreeWidgetItem(hidrografia05)
            hidrolineas05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidrolineas05.setText(0, "Hidrografía lineal CV05")
            hidrolineas05.setCheckState(0, Qt.Unchecked)
            construcciones05 = QTreeWidgetItem(basecartografica05)
            construcciones05.setFlags(construcciones05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            construcciones05.setText(0, "Edificaciones y construcciones")
            construcciones05.setCheckState(0, Qt.Unchecked)
            construpuntos05 = QTreeWidgetItem(construcciones05)
            construpuntos05.setFlags(construpuntos05.flags() | Qt.ItemIsUserCheckable)
            construpuntos05.setText(0, "Construcciones puntuales CV05")
            construpuntos05.setCheckState(0, Qt.Unchecked)
            construservi05 = QTreeWidgetItem(construcciones05)
            construservi05.setFlags(construservi05.flags() | Qt.ItemIsUserCheckable)
            construservi05.setText(0, "Servicios e instalaciones CV05")
            construservi05.setCheckState(0, Qt.Unchecked)
            construlinea05 = QTreeWidgetItem(construcciones05)
            construlinea05.setFlags(construlinea05.flags() | Qt.ItemIsUserCheckable)
            construlinea05.setText(0, "Construcciones lineales CV05")
            construlinea05.setCheckState(0, Qt.Unchecked)
            construedifi05 = QTreeWidgetItem(construcciones05)
            construedifi05.setFlags(construedifi05.flags() | Qt.ItemIsUserCheckable)
            construedifi05.setText(0, "Edificaciones CV05")
            construedifi05.setCheckState(0, Qt.Unchecked)
            construcons05 = QTreeWidgetItem(construcciones05)
            construcons05.setFlags(construcons05.flags() | Qt.ItemIsUserCheckable)
            construcons05.setText(0, "Construcciones CV05")
            construcons05.setCheckState(0, Qt.Unchecked)
            usos05 = QTreeWidgetItem(basecartografica05)
            usos05.setFlags(usos05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            usos05.setText(0, "Usos del suelo")
            usos05.setCheckState(0, Qt.Unchecked)
            usoshidro05 = QTreeWidgetItem(usos05)
            usoshidro05.setFlags(usoshidro05.flags() | Qt.ItemIsUserCheckable)
            usoshidro05.setText(0, "Hidrografía CV05")
            usoshidro05.setCheckState(0, Qt.Unchecked)
            usosarboles05 = QTreeWidgetItem(usos05)
            usosarboles05.setFlags(usosarboles05.flags() | Qt.ItemIsUserCheckable)
            usosarboles05.setText(0, "Zonas arboladas CV05")
            usosarboles05.setCheckState(0, Qt.Unchecked)
            usosinfra05 = QTreeWidgetItem(usos05)
            usosinfra05.setFlags(usosinfra05.flags() | Qt.ItemIsUserCheckable)
            usosinfra05.setText(0, "Infraestructuras viarias CV05")
            usosinfra05.setCheckState(0, Qt.Unchecked)
            usosserv05 = QTreeWidgetItem(usos05)
            usosserv05.setFlags(usosserv05.flags() | Qt.ItemIsUserCheckable)
            usosserv05.setText(0, "Servicios e instalaciones CV05")
            usosserv05.setCheckState(0, Qt.Unchecked)
            usoscultiv05 = QTreeWidgetItem(usos05)
            usoscultiv05.setFlags(usoscultiv05.flags() | Qt.ItemIsUserCheckable)
            usoscultiv05.setText(0, "Cultivos CV05")
            usoscultiv05.setCheckState(0, Qt.Unchecked)
            usosentorn05 = QTreeWidgetItem(usos05)
            usosentorn05.setFlags(usosentorn05.flags() | Qt.ItemIsUserCheckable)
            usosentorn05.setText(0, "Entornos urbanos CV05")
            usosentorn05.setCheckState(0, Qt.Unchecked)
            vias05 = QTreeWidgetItem(basecartografica05)
            vias05.setFlags(vias05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            vias05.setText(0, "Vias de Comunicación")
            vias05.setCheckState(0, Qt.Unchecked)
            viasnomen05 = QTreeWidgetItem(vias05)
            viasnomen05.setFlags(viasnomen05.flags() | Qt.ItemIsUserCheckable)
            viasnomen05.setText(0, "Nomenclatura infraestructura viaria CV05")
            viasnomen05.setCheckState(0, Qt.Unchecked)
            viasferro05 = QTreeWidgetItem(vias05)
            viasferro05.setFlags(viasferro05.flags() | Qt.ItemIsUserCheckable)
            viasferro05.setText(0, "Red de ferrocarriles CV05")
            viasferro05.setCheckState(0, Qt.Unchecked)
            viascomu05 = QTreeWidgetItem(vias05)
            viascomu05.setFlags(viascomu05.flags() | Qt.ItemIsUserCheckable)
            viascomu05.setText(0, "Red de comunicaciones CV05")
            viascomu05.setCheckState(0, Qt.Unchecked)
            basecartografica50 = QTreeWidgetItem(carto)
            basecartografica50.setText(0, "Base Cartográfica CV50")
            orografia50 = QTreeWidgetItem(basecartografica50)
            orografia50.setFlags(orografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia50.setText(0, "Orografía  ")
            orografia50.setCheckState(0, Qt.Unchecked)
            orografiacosta50 = QTreeWidgetItem(orografia50)
            orografiacosta50.setFlags(orografiacosta50.flags() | Qt.ItemIsUserCheckable)
            orografiacosta50.setText(0, "Línea de costa CV50")
            orografiacosta50.setCheckState(0, Qt.Unchecked)
            orografiacurva50 = QTreeWidgetItem(orografia50)
            orografiacurva50.setFlags(orografiacurva50.flags() | Qt.ItemIsUserCheckable)
            orografiacurva50.setText(0, "Curvas de nivel CV50")
            orografiacurva50.setCheckState(0, Qt.Unchecked)
            hidrografia50 = QTreeWidgetItem(basecartografica50)
            hidrografia50.setFlags(hidrografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia50.setText(0, "Hidrografía")
            hidrografia50.setCheckState(0, Qt.Unchecked)
            hidrocursoa50 = QTreeWidgetItem(hidrografia50)
            hidrocursoa50.setFlags(hidrocursoa50.flags() | Qt.ItemIsUserCheckable)
            hidrocursoa50.setText(0, "Curso natural CV50")
            hidrocursoa50.setCheckState(0, Qt.Unchecked)
            hidrocurson50 = QTreeWidgetItem(hidrografia50)
            hidrocurson50.setFlags(hidrocurson50.flags() | Qt.ItemIsUserCheckable)
            hidrocurson50.setText(0, "Curso artificial CV50")
            hidrocurson50.setCheckState(0, Qt.Unchecked)
            hidrolecho50 = QTreeWidgetItem(hidrografia50)
            hidrolecho50.setFlags(hidrolecho50.flags() | Qt.ItemIsUserCheckable)
            hidrolecho50.setText(0, "Lecho natural CV50")
            hidrolecho50.setCheckState(0, Qt.Unchecked)
            hidroembal50 = QTreeWidgetItem(hidrografia50)
            hidroembal50.setFlags(hidroembal50.flags() | Qt.ItemIsUserCheckable)
            hidroembal50.setText(0, "Embalse CV50")
            hidroembal50.setCheckState(0, Qt.Unchecked)
            hidrolago50 = QTreeWidgetItem(hidrografia50)
            hidrolago50.setFlags(hidrolago50.flags() | Qt.ItemIsUserCheckable)
            hidrolago50.setText(0, "Lago CV50")
            hidrolago50.setCheckState(0, Qt.Unchecked)
            hidroisla50 = QTreeWidgetItem(hidrografia50)
            hidroisla50.setFlags(hidroisla50.flags() | Qt.ItemIsUserCheckable)
            hidroisla50.setText(0, "Isla CV50")
            hidroisla50.setCheckState(0, Qt.Unchecked)
            edificacion50 = QTreeWidgetItem(basecartografica50)
            edificacion50.setFlags(edificacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edificacion50.setText(0, "Edificaciones y construcciones")
            edificacion50.setCheckState(0, Qt.Unchecked)
            edifiedi50 = QTreeWidgetItem(edificacion50)
            edifiedi50.setFlags(edifiedi50.flags() | Qt.ItemIsUserCheckable)
            edifiedi50.setText(0, "Edificaciones CV50")
            edifiedi50.setCheckState(0, Qt.Unchecked)
            edifiedip50 = QTreeWidgetItem(edificacion50)
            edifiedip50.setFlags(edifiedip50.flags() | Qt.ItemIsUserCheckable)
            edifiedip50.setText(0, "Edificaciones puntuales CV50")
            edifiedip50.setCheckState(0, Qt.Unchecked)
            edifipisci50 = QTreeWidgetItem(edificacion50)
            edifipisci50.setFlags(edifipisci50.flags() | Qt.ItemIsUserCheckable)
            edifipisci50.setText(0, "Piscina / Balsa CV50")
            edifipisci50.setCheckState(0, Qt.Unchecked)
            edifipiscip50 = QTreeWidgetItem(edificacion50)
            edifipiscip50.setFlags(edifipiscip50.flags() | Qt.ItemIsUserCheckable)
            edifipiscip50.setText(0, "Piscina / Balsa puntual CV50")
            edifipiscip50.setCheckState(0, Qt.Unchecked)
            edifiruina50 = QTreeWidgetItem(edificacion50)
            edifiruina50.setFlags(edifiruina50.flags() | Qt.ItemIsUserCheckable)
            edifiruina50.setText(0, "Edificación en ruinas CV50")
            edifiruina50.setCheckState(0, Qt.Unchecked)
            edifiruinap50 = QTreeWidgetItem(edificacion50)
            edifiruinap50.setFlags(edifiruinap50.flags() | Qt.ItemIsUserCheckable)
            edifiruinap50.setText(0, "Edificación en ruinas puntual CV50")
            edifiruinap50.setCheckState(0, Qt.Unchecked)
            edifextrac50 = QTreeWidgetItem(edificacion50)
            edifextrac50.setFlags(edifextrac50.flags() | Qt.ItemIsUserCheckable)
            edifextrac50.setText(0, "Actividad extractiva CV50")
            edifextrac50.setCheckState(0, Qt.Unchecked)
            edifextracp50 = QTreeWidgetItem(edificacion50)
            edifextracp50.setFlags(edifextracp50.flags() | Qt.ItemIsUserCheckable)
            edifextracp50.setText(0, "Actividad extractiva puntual CV50")
            edifextracp50.setCheckState(0, Qt.Unchecked)
            edifdeposit50 = QTreeWidgetItem(edificacion50)
            edifdeposit50.setFlags(edifdeposit50.flags() | Qt.ItemIsUserCheckable)
            edifdeposit50.setText(0, "Depósito")
            edifdeposit50.setCheckState(0, Qt.Unchecked)
            edifobrac50 = QTreeWidgetItem(edificacion50)
            edifobrac50.setFlags(edifobrac50.flags() | Qt.ItemIsUserCheckable)
            edifobrac50.setText(0, "Obra de contención")
            edifobrac50.setCheckState(0, Qt.Unchecked)
            edifinverna50 = QTreeWidgetItem(edificacion50)
            edifinverna50.setFlags(edifinverna50.flags() | Qt.ItemIsUserCheckable)
            edifinverna50.setText(0, "Invernadero")
            edifinverna50.setCheckState(0, Qt.Unchecked)
            edifpatio50 = QTreeWidgetItem(edificacion50)
            edifpatio50.setFlags(edifpatio50.flags() | Qt.ItemIsUserCheckable)
            edifpatio50.setText(0, "Patio")
            edifpatio50.setCheckState(0, Qt.Unchecked)
            edifmuralla50 = QTreeWidgetItem(edificacion50)
            edifmuralla50.setFlags(edifmuralla50.flags() | Qt.ItemIsUserCheckable)
            edifmuralla50.setText(0, "Muralla histórica")
            edifmuralla50.setCheckState(0, Qt.Unchecked)
            instalacion50 = QTreeWidgetItem(basecartografica50)
            instalacion50.setFlags(instalacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instalacion50.setText(0, "Instalaciones y equipamientos")
            instalacion50.setCheckState(0, Qt.Unchecked)
            instadota50 = QTreeWidgetItem(instalacion50)
            instadota50.setFlags(instadota50.flags() | Qt.ItemIsUserCheckable)
            instadota50.setText(0, "Espacio dotacional")
            instadota50.setCheckState(0, Qt.Unchecked)
            instacircu50 = QTreeWidgetItem(instalacion50)
            instacircu50.setFlags(instacircu50.flags() | Qt.ItemIsUserCheckable)
            instacircu50.setText(0, "Circuito")
            instacircu50.setCheckState(0, Qt.Unchecked)
            instapoli50 = QTreeWidgetItem(instalacion50)
            instapoli50.setFlags(instapoli50.flags() | Qt.ItemIsUserCheckable)
            instapoli50.setText(0, "Instalación de transporte poligonal")
            instapoli50.setCheckState(0, Qt.Unchecked)
            instalinea50 = QTreeWidgetItem(instalacion50)
            instalinea50.setFlags(instalinea50.flags() | Qt.ItemIsUserCheckable)
            instalinea50.setText(0, "Instalación de transporte lineal")
            instalinea50.setCheckState(0, Qt.Unchecked)
            instapunt50 = QTreeWidgetItem(instalacion50)
            instapunt50.setFlags(instapunt50.flags() | Qt.ItemIsUserCheckable)
            instapunt50.setText(0, "Instalación de transporte puntual")
            instapunt50.setCheckState(0, Qt.Unchecked)
            instadotpun50 = QTreeWidgetItem(instalacion50)
            instadotpun50.setFlags(instadotpun50.flags() | Qt.ItemIsUserCheckable)
            instadotpun50.setText(0, "Espacio dotacional puntual")
            instadotpun50.setCheckState(0, Qt.Unchecked)
            instaelect50 = QTreeWidgetItem(instalacion50)
            instaelect50.setFlags(instaelect50.flags() | Qt.ItemIsUserCheckable)
            instaelect50.setText(0, "Línea eléctrica")
            instaelect50.setCheckState(0, Qt.Unchecked)
            instavertic50 = QTreeWidgetItem(instalacion50)
            instavertic50.setFlags(instavertic50.flags() | Qt.ItemIsUserCheckable)
            instavertic50.setText(0, "Vértices geodésicos")
            instavertic50.setCheckState(0, Qt.Unchecked)
            viascomu50 = QTreeWidgetItem(basecartografica50)
            viascomu50.setFlags(viascomu50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            viascomu50.setText(0, "Vias de Comunicación")
            viascomu50.setCheckState(0, Qt.Unchecked)
            instared50 = QTreeWidgetItem(viascomu50)
            instared50.setFlags(instared50.flags() | Qt.ItemIsUserCheckable)
            instared50.setText(0, "Red de Comunicaciones")
            instared50.setCheckState(0, Qt.Unchecked)
            instaferroc50 = QTreeWidgetItem(viascomu50)
            instaferroc50.setFlags(instaferroc50.flags() | Qt.ItemIsUserCheckable)
            instaferroc50.setText(0, "Ferrocarril")
            instaferroc50.setCheckState(0, Qt.Unchecked)
            instaportal0 = QTreeWidgetItem(viascomu50)
            instaportal0.setFlags(instaportal0.flags() | Qt.ItemIsUserCheckable)
            instaportal0.setText(0, "Portales/PKs")
            instaportal0.setCheckState(0, Qt.Unchecked)
            instabocat0 = QTreeWidgetItem(viascomu50)
            instabocat0.setFlags(instabocat0.flags() | Qt.ItemIsUserCheckable)
            instabocat0.setText(0, "Boca de túnel")
            instabocat0.setCheckState(0, Qt.Unchecked)
            instaredele50 = QTreeWidgetItem(viascomu50)
            instaredele50.setFlags(instaredele50.flags() | Qt.ItemIsUserCheckable)
            instaredele50.setText(0, "Red viaria elevada")
            instaredele50.setCheckState(0, Qt.Unchecked)
            instaferrel50 = QTreeWidgetItem(viascomu50)
            instaferrel50.setFlags(instaferrel50.flags() | Qt.ItemIsUserCheckable)
            instaferrel50.setText(0, "Ferrocarril elevado")
            instaferrel50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Red viaria subterránea")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Ferrocarril subterráneo")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            basecartografica100 = QTreeWidgetItem(carto)
            basecartografica100.setText(0, "Base Cartogràfica CV100")
            orografia100 = QTreeWidgetItem(basecartografica100)
            orografia100.setFlags(orografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia100.setText(0, "Orografía")
            orografia100.setCheckState(0, Qt.Unchecked)
            costa100 = QTreeWidgetItem(orografia100)
            costa100.setFlags(costa100.flags() | Qt.ItemIsUserCheckable)
            costa100.setText(0, "Línea de costa CV100")
            costa100.setCheckState(0, Qt.Unchecked)
            curvas100 = QTreeWidgetItem(orografia100)
            curvas100.setFlags(curvas100.flags() | Qt.ItemIsUserCheckable)
            curvas100.setText(0, "Curvas de nivel CV100")
            curvas100.setCheckState(0, Qt.Unchecked)
            cota100 = QTreeWidgetItem(orografia100)
            cota100.setFlags(cota100.flags() | Qt.ItemIsUserCheckable)
            cota100.setText(0, "Puntos de cota CV100")
            cota100.setCheckState(0, Qt.Unchecked)
            hidrografia100 = QTreeWidgetItem(basecartografica100)
            hidrografia100.setFlags(hidrografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia100.setText(0, "Hidrografia")
            hidrografia100.setCheckState(0, Qt.Unchecked)
            curson100 = QTreeWidgetItem(hidrografia100)
            curson100.setFlags(curson100.flags() | Qt.ItemIsUserCheckable)
            curson100.setText(0, "Curso natural CV100")
            curson100.setCheckState(0, Qt.Unchecked)
            lecho100 = QTreeWidgetItem(hidrografia100)
            lecho100.setFlags(lecho100.flags() | Qt.ItemIsUserCheckable)
            lecho100.setText(0, "Lecho natural CV100")
            lecho100.setCheckState(0, Qt.Unchecked)
            lago100 = QTreeWidgetItem(hidrografia100)
            lago100.setFlags(lago100.flags() | Qt.ItemIsUserCheckable)
            lago100.setText(0, "Lago CV100")
            lago100.setCheckState(0, Qt.Unchecked)
            embalse100 = QTreeWidgetItem(hidrografia100)
            embalse100.setFlags(embalse100.flags() | Qt.ItemIsUserCheckable)
            embalse100.setText(0, "Embalse CV100")
            embalse100.setCheckState(0, Qt.Unchecked)
            isla100 = QTreeWidgetItem(hidrografia100)
            isla100.setFlags(isla100.flags() | Qt.ItemIsUserCheckable)
            isla100.setText(0, "Isla CV100")
            isla100.setCheckState(0, Qt.Unchecked)
            edifica100 = QTreeWidgetItem(basecartografica100)
            edifica100.setFlags(edifica100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edifica100.setText(0, "Edificaciones y construcciones")
            edifica100.setCheckState(0, Qt.Unchecked)
            edificaed100 = QTreeWidgetItem(edifica100)
            edificaed100.setFlags(edificaed100.flags() | Qt.ItemIsUserCheckable)
            edificaed100.setText(0, "Edificación CV100")
            edificaed100.setCheckState(0, Qt.Unchecked)
            edificaedp100 = QTreeWidgetItem(edifica100)
            edificaedp100.setFlags(edificaedp100.flags() | Qt.ItemIsUserCheckable)
            edificaedp100.setText(0, "Edificación puntual CV100")
            edificaedp100.setCheckState(0, Qt.Unchecked)
            piscina100 = QTreeWidgetItem(edifica100)
            piscina100.setFlags(piscina100.flags() | Qt.ItemIsUserCheckable)
            piscina100.setText(0, "Piscina/Balsa CV100")
            piscina100.setCheckState(0, Qt.Unchecked)
            piscinap100 = QTreeWidgetItem(edifica100)
            piscinap100.setFlags(piscinap100.flags() | Qt.ItemIsUserCheckable)
            piscinap100.setText(0, "Piscina/Balsa puntual CV100")
            piscinap100.setCheckState(0, Qt.Unchecked)
            edificaedr100 = QTreeWidgetItem(edifica100)
            edificaedr100.setFlags(edificaedr100.flags() | Qt.ItemIsUserCheckable)
            edificaedr100.setText(0, "Edificación en ruinas CV100")
            edificaedr100.setCheckState(0, Qt.Unchecked)
            edificaedrp100 = QTreeWidgetItem(edifica100)
            edificaedrp100.setFlags(edificaedrp100.flags() | Qt.ItemIsUserCheckable)
            edificaedrp100.setText(0, "Edificación en ruinas puntual CV100")
            edificaedrp100.setCheckState(0, Qt.Unchecked)
            actext100 = QTreeWidgetItem(edifica100)
            actext100.setFlags(actext100.flags() | Qt.ItemIsUserCheckable)
            actext100.setText(0, "Actividad extractiva CV100")
            actext100.setCheckState(0, Qt.Unchecked)
            actextp100 = QTreeWidgetItem(edifica100)
            actextp100.setFlags(actextp100.flags() | Qt.ItemIsUserCheckable)
            actextp100.setText(0, "Actividad extractiva puntual CV100")
            actextp100.setCheckState(0, Qt.Unchecked)
            obracon100 = QTreeWidgetItem(edifica100)
            obracon100.setFlags(obracon100.flags() | Qt.ItemIsUserCheckable)
            obracon100.setText(0, "Obra de contención CV100")
            obracon100.setCheckState(0, Qt.Unchecked)
            inverna100 = QTreeWidgetItem(edifica100)
            inverna100.setFlags(inverna100.flags() | Qt.ItemIsUserCheckable)
            inverna100.setText(0, "Invernadero CV100")
            inverna100.setCheckState(0, Qt.Unchecked)
            patio100 = QTreeWidgetItem(edifica100)
            patio100.setFlags(patio100.flags() | Qt.ItemIsUserCheckable)
            patio100.setText(0, "Patio CV100")
            patio100.setCheckState(0, Qt.Unchecked)
            muralla100 = QTreeWidgetItem(edifica100)
            muralla100.setFlags(muralla100.flags() | Qt.ItemIsUserCheckable)
            muralla100.setText(0, "Muralla histórica CV100")
            muralla100.setCheckState(0, Qt.Unchecked)
            instala100 = QTreeWidgetItem(basecartografica100)
            instala100.setFlags(instala100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instala100.setText(0, "Instalaciones y equipamientos")
            instala100.setCheckState(0, Qt.Unchecked)
            instalinea100 = QTreeWidgetItem(instala100)
            instalinea100.setFlags(instalinea100.flags() | Qt.ItemIsUserCheckable)
            instalinea100.setText(0, "Línea eléctrica CV100")
            instalinea100.setCheckState(0, Qt.Unchecked)
            vertices100 = QTreeWidgetItem(instala100)
            vertices100.setFlags(vertices100.flags() | Qt.ItemIsUserCheckable)
            vertices100.setText(0, "Vértices geodésicos CV100")
            vertices100.setCheckState(0, Qt.Unchecked)
            dotapunt100 = QTreeWidgetItem(instala100)
            dotapunt100.setFlags(dotapunt100.flags() | Qt.ItemIsUserCheckable)
            dotapunt100.setText(0, "Espacio dotacional puntual CV100")
            dotapunt100.setCheckState(0, Qt.Unchecked)
            transpunt100 = QTreeWidgetItem(instala100)
            transpunt100.setFlags(transpunt100.flags() | Qt.ItemIsUserCheckable)
            transpunt100.setText(0, "Instalación de transporte puntual CV100")
            transpunt100.setCheckState(0, Qt.Unchecked)
            deposito100 = QTreeWidgetItem(instala100)
            deposito100.setFlags(deposito100.flags() | Qt.ItemIsUserCheckable)
            deposito100.setText(0, "Depósito CV100")
            deposito100.setCheckState(0, Qt.Unchecked)
            translin100 = QTreeWidgetItem(instala100)
            translin100.setFlags(translin100.flags() | Qt.ItemIsUserCheckable)
            translin100.setText(0, "Instalación de transporte lineal CV100")
            translin100.setCheckState(0, Qt.Unchecked)
            transpol100 = QTreeWidgetItem(instala100)
            transpol100.setFlags(transpol100.flags() | Qt.ItemIsUserCheckable)
            transpol100.setText(0, "Instalación de transporte poligonal CV100")
            transpol100.setCheckState(0, Qt.Unchecked)
            espadot100 = QTreeWidgetItem(instala100)
            espadot100.setFlags(espadot100.flags() | Qt.ItemIsUserCheckable)
            espadot100.setText(0, "Espacio dotacional CV100")
            espadot100.setCheckState(0, Qt.Unchecked)
            comunicacion100 = QTreeWidgetItem(basecartografica100)
            comunicacion100.setFlags(comunicacion100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            comunicacion100.setText(0, "Vías de comunicación")
            comunicacion100.setCheckState(0, Qt.Unchecked)
            comured100 = QTreeWidgetItem(comunicacion100)
            comured100.setFlags(comured100.flags() | Qt.ItemIsUserCheckable)
            comured100.setText(0, "Red viaria CV100")
            comured100.setCheckState(0, Qt.Unchecked)
            ferro100 = QTreeWidgetItem(comunicacion100)
            ferro100.setFlags(ferro100.flags() | Qt.ItemIsUserCheckable)
            ferro100.setText(0, "Ferrocarril CV100")
            ferro100.setCheckState(0, Qt.Unchecked)
            tunel100 = QTreeWidgetItem(comunicacion100)
            tunel100.setFlags(tunel100.flags() | Qt.ItemIsUserCheckable)
            tunel100.setText(0, "Boca de túnel CV100")
            tunel100.setCheckState(0, Qt.Unchecked)
            comurede100 = QTreeWidgetItem(comunicacion100)
            comurede100.setFlags(comurede100.flags() | Qt.ItemIsUserCheckable)
            comurede100.setText(0, "Red viaria elevada CV100")
            comurede100.setCheckState(0, Qt.Unchecked)
            ferroe100 = QTreeWidgetItem(comunicacion100)
            ferroe100.setFlags(ferroe100.flags() | Qt.ItemIsUserCheckable)
            ferroe100.setText(0, "Ferrocarril elevado CV100")
            ferroe100.setCheckState(0, Qt.Unchecked)
            comureds100 = QTreeWidgetItem(comunicacion100)
            comureds100.setFlags(comureds100.flags() | Qt.ItemIsUserCheckable)
            comureds100.setText(0, "Red viaria subterránea CV100")
            comureds100.setCheckState(0, Qt.Unchecked)
            ferros100 = QTreeWidgetItem(comunicacion100)
            ferros100.setFlags(ferros100.flags() | Qt.ItemIsUserCheckable)
            ferros100.setText(0, "Ferrocarril subterráneo CV100")
            ferros100.setCheckState(0, Qt.Unchecked)
            fechasbases = QTreeWidgetItem(carto)
            fechasbases.setText(0, "Fechas Bases cartográficas")
            fechasvuelos = QTreeWidgetItem(fechasbases)
            fechasvuelos.setFlags(fechasvuelos.flags() | Qt.ItemIsUserCheckable)
            fechasvuelos.setText(0, "Fechas de vuelo")
            fechasvuelos.setCheckState(0, Qt.Unchecked)
            redtransp = QTreeWidgetItem(carto)
            redtransp.setText(0, "Red de Transportes")
            redcarretera = QTreeWidgetItem(redtransp)
            redcarretera.setFlags(redcarretera.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            redcarretera.setText(0, "Transporte Carretera")
            redcarretera.setCheckState(0, Qt.Unchecked)
            sistviari = QTreeWidgetItem(redcarretera)
            sistviari.setFlags(sistviari.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sistviari.setText(0, "Sistema viario")
            sistviari.setCheckState(0, Qt.Unchecked)
            cataviario = QTreeWidgetItem(sistviari)
            cataviario.setFlags(cataviario.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            cataviario.setText(0, "Catálogo Viario")
            cataviario.setCheckState(0, Qt.Unchecked)
            cataviario1 = QTreeWidgetItem(cataviario)
            cataviario1.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario1.setText(0, "Catálogo viario escala 1")
            cataviario1.setCheckState(0, Qt.Unchecked)
            cataviario2 = QTreeWidgetItem(cataviario)
            cataviario2.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario2.setText(0, "Catálogo viario escala 2")
            cataviario2.setCheckState(0, Qt.Unchecked)
            cataviario3 = QTreeWidgetItem(cataviario)
            cataviario3.setFlags(cataviario3.flags() | Qt.ItemIsUserCheckable)
            cataviario3.setText(0, "Catálogo viario escala 3")
            cataviario3.setCheckState(0, Qt.Unchecked)
            cataviario4 = QTreeWidgetItem(cataviario)
            cataviario4.setFlags(cataviario4.flags() | Qt.ItemIsUserCheckable)
            cataviario4.setText(0, "Catálogo viario escala 4")
            cataviario4.setCheckState(0, Qt.Unchecked)
            puntokil = QTreeWidgetItem(sistviari)
            puntokil.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            puntokil.setText(0, "Puntos kilométricos")
            puntokil.setCheckState(0, Qt.Unchecked)
            caminos = QTreeWidgetItem(sistviari)
            caminos.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            caminos.setText(0, "Caminos")
            caminos.setCheckState(0, Qt.Unchecked)
            viaciclista = QTreeWidgetItem(sistviari)
            viaciclista.setFlags(viaciclista.flags() | Qt.ItemIsUserCheckable)
            viaciclista.setText(0, "Vía ciclista")
            viaciclista.setCheckState(0, Qt.Unchecked)
            urbana = QTreeWidgetItem(sistviari)
            urbana.setFlags(urbana.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            urbana.setText(0, "Urbana")
            urbana.setCheckState(0, Qt.Unchecked)
            listacalles = QTreeWidgetItem(urbana)
            listacalles.setFlags(listacalles.flags() | Qt.ItemIsUserCheckable)
            listacalles.setText(0, "Listado de calles")
            listacalles.setCheckState(0, Qt.Unchecked)
            portal = QTreeWidgetItem(urbana)
            portal.setFlags(portal.flags() | Qt.ItemIsUserCheckable)
            portal.setText(0, "Portal")
            portal.setCheckState(0, Qt.Unchecked)
            infraestruc = QTreeWidgetItem(redcarretera)
            infraestruc.setFlags(infraestruc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraestruc.setText(0, "Infraestructuras e instalaciones")
            infraestruc.setCheckState(0, Qt.Unchecked)
            estautob = QTreeWidgetItem(infraestruc)
            estautob.setFlags(estautob.flags() | Qt.ItemIsUserCheckable)
            estautob.setText(0, "Estación de autobuses")
            estautob.setCheckState(0, Qt.Unchecked)
            peaje = QTreeWidgetItem(infraestruc)
            peaje.setFlags(peaje.flags() | Qt.ItemIsUserCheckable)
            peaje.setText(0, "Peaje")
            peaje.setCheckState(0, Qt.Unchecked)
            areaserv = QTreeWidgetItem(infraestruc)
            areaserv.setFlags(areaserv.flags() | Qt.ItemIsUserCheckable)
            areaserv.setText(0, "Áreas de servicio")
            areaserv.setCheckState(0, Qt.Unchecked)
            areaservin = QTreeWidgetItem(infraestruc)
            areaservin.setFlags(areaservin.flags() | Qt.ItemIsUserCheckable)
            areaservin.setText(0, "Aparcamiento de servicios viarios invernal")
            areaservin.setCheckState(0, Qt.Unchecked)
            puente = QTreeWidgetItem(infraestruc)
            puente.setFlags(puente.flags() | Qt.ItemIsUserCheckable)
            puente.setText(0, "Puente")
            puente.setCheckState(0, Qt.Unchecked)
            redferrocarril = QTreeWidgetItem(redtransp)
            redferrocarril.setFlags(redferrocarril.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            redferrocarril.setText(0, "Transporte Ferrocarril")
            redferrocarril.setCheckState(0, Qt.Unchecked)
            pkffcc = QTreeWidgetItem(redferrocarril)
            pkffcc.setFlags(pkffcc.flags() | Qt.ItemIsUserCheckable)
            pkffcc.setText(0, "PK FFCC")
            pkffcc.setCheckState(0, Qt.Unchecked)
            redadif = QTreeWidgetItem(redferrocarril)
            redadif.setFlags(redadif.flags() | Qt.ItemIsUserCheckable)
            redadif.setText(0, "Red ferrocarriles ADIF")
            redadif.setCheckState(0, Qt.Unchecked)
            redgeneralit = QTreeWidgetItem(redferrocarril)
            redgeneralit.setFlags(redgeneralit.flags() | Qt.ItemIsUserCheckable)
            redgeneralit.setText(0, "Red ferrocarriles de la Generalitat")
            redgeneralit.setCheckState(0, Qt.Unchecked)
            redotros = QTreeWidgetItem(redferrocarril)
            redotros.setFlags(redotros.flags() | Qt.ItemIsUserCheckable)
            redotros.setText(0, "Otros FFCC")
            redotros.setCheckState(0, Qt.Unchecked)
            instferro = QTreeWidgetItem(redferrocarril)
            instferro.setFlags(instferro.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instferro.setText(0, "Infraestructuras e instalaciones ferroviarias")
            instferro.setCheckState(0, Qt.Unchecked)
            apeaderos = QTreeWidgetItem(instferro)
            apeaderos.setFlags(apeaderos.flags() | Qt.ItemIsUserCheckable)
            apeaderos.setText(0, "Estaciones. Apeaderos. Otros")
            apeaderos.setCheckState(0, Qt.Unchecked)
            pasoanivel = QTreeWidgetItem(instferro)
            pasoanivel.setFlags(pasoanivel.flags() | Qt.ItemIsUserCheckable)
            pasoanivel.setText(0, "Paso a nivel GVA")
            pasoanivel.setCheckState(0, Qt.Unchecked)
            pasoanivelo = QTreeWidgetItem(instferro)
            pasoanivelo.setFlags(pasoanivelo.flags() | Qt.ItemIsUserCheckable)
            pasoanivelo.setText(0, "Otros. Paso a nivel")
            pasoanivelo.setCheckState(0, Qt.Unchecked)
            puentefe = QTreeWidgetItem(instferro)
            puentefe.setFlags(puentefe.flags() | Qt.ItemIsUserCheckable)
            puentefe.setText(0, "Puente FFCC")
            puentefe.setCheckState(0, Qt.Unchecked)
            instaere = QTreeWidgetItem(redtransp)
            instaere.setFlags(instaere.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instaere.setText(0, "Transporte Aéreo")
            instaere.setCheckState(0, Qt.Unchecked)
            instaerodro = QTreeWidgetItem(instaere)
            instaerodro.setFlags(instaerodro.flags() | Qt.ItemIsUserCheckable)
            instaerodro.setText(0, "Aeródromo. Helipuerto")
            instaerodro.setCheckState(0, Qt.Unchecked)
            instamar = QTreeWidgetItem(redtransp)
            instamar.setFlags(instaere.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instamar.setText(0, "Transporte Marítimo")
            instamar.setCheckState(0, Qt.Unchecked)
            instamaritim = QTreeWidgetItem(instamar)
            instamaritim.setFlags(instamaritim.flags() | Qt.ItemIsUserCheckable)
            instamaritim.setText(0, "Instalaciones marítimas")
            instamaritim.setCheckState(0, Qt.Unchecked)
            cuadricula = QTreeWidgetItem(carto)
            cuadricula.setText(0, "Cuadrículas geográficas")
            hojacv05 = QTreeWidgetItem(cuadricula)
            hojacv05.setFlags(hojacv05.flags() | Qt.ItemIsUserCheckable)
            hojacv05.setText(0, "Hojas CV05")
            hojacv05.setCheckState(0, Qt.Unchecked)
            hojacv50 = QTreeWidgetItem(cuadricula)
            hojacv50.setFlags(hojacv50.flags() | Qt.ItemIsUserCheckable)
            hojacv50.setText(0, "Hojas CV50")
            hojacv50.setCheckState(0, Qt.Unchecked)
            hojacv100 = QTreeWidgetItem(cuadricula)
            hojacv100.setFlags(hojacv100.flags() | Qt.ItemIsUserCheckable)
            hojacv100.setText(0, "Hojas CV100")
            hojacv100.setCheckState(0, Qt.Unchecked)
            unidades = QTreeWidgetItem(carto)
            unidades.setText(0, "Unitats administratives")
            limit_autono = QTreeWidgetItem(unidades)
            limit_autono.setFlags(limit_autono.flags() | Qt.ItemIsUserCheckable)
            limit_autono.setText(0, "Límite autonómico")
            limit_autono.setCheckState(0, Qt.Unchecked)
            limit_prov = QTreeWidgetItem(unidades)
            limit_prov.setFlags(limit_prov.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            limit_prov.setText(0, "Límite provincial")
            limit_prov.setCheckState(0, Qt.Unchecked)
            limitproet = QTreeWidgetItem(limit_prov)
            limitproet.setFlags(limitproet.flags() | Qt.ItemIsUserCheckable)
            limitproet.setText(0, "Límite provincial - Etiquetas")
            limitproet.setCheckState(0, Qt.Unchecked)
            limitproli = QTreeWidgetItem(limit_prov)
            limitproli.setFlags(limitproli.flags() | Qt.ItemIsUserCheckable)
            limitproli.setText(0, "Límite provincial - Líneas")
            limitproli.setCheckState(0, Qt.Unchecked)
            limit_com = QTreeWidgetItem(unidades)
            limit_com.setFlags(limit_prov.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            limit_com.setText(0, "Límite comarcal")
            limit_com.setCheckState(0, Qt.Unchecked)
            limitcomet = QTreeWidgetItem(limit_com)
            limitcomet.setFlags(limitcomet.flags() | Qt.ItemIsUserCheckable)
            limitcomet.setText(0, "Límite comarcal - Etiquetas")
            limitcomet.setCheckState(0, Qt.Unchecked)
            limitcomli = QTreeWidgetItem(limit_com)
            limitcomli.setFlags(limitcomli.flags() | Qt.ItemIsUserCheckable)
            limitcomli.setText(0, "Límite comarcal - Líneas")
            limitcomli.setCheckState(0, Qt.Unchecked)
            limit_mun = QTreeWidgetItem(unidades)
            limit_mun.setFlags(limit_mun.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            limit_mun.setText(0, "Límite municipal")
            limit_mun.setCheckState(0, Qt.Unchecked)
            limitmunet = QTreeWidgetItem(limit_mun)
            limitmunet.setFlags(limitmunet.flags() | Qt.ItemIsUserCheckable)
            limitmunet.setText(0, "Límite municipal - Etiquetas")
            limitmunet.setCheckState(0, Qt.Unchecked)
            limitmunli = QTreeWidgetItem(limit_mun)
            limitmunli.setFlags(limitmunli.flags() | Qt.ItemIsUserCheckable)
            limitmunli.setText(0, "Límite municipal - Líneas")
            limitmunli.setCheckState(0, Qt.Unchecked)
            geodesia = QTreeWidgetItem(carto)
            geodesia.setText(0, "Geodesia/GNSS")
            red4gnss = QTreeWidgetItem(geodesia)
            red4gnss.setFlags(red4gnss.flags() | Qt.ItemIsUserCheckable)
            red4gnss.setText(0, "Red de estaciones permanentes GNSS (ERVA)")
            red4gnss.setCheckState(0, Qt.Unchecked)
            red4orden = QTreeWidgetItem(geodesia)
            red4orden.setFlags(red4orden.flags() | Qt.ItemIsUserCheckable)
            red4orden.setText(0, "Red de 4º orden")
            red4orden.setCheckState(0, Qt.Unchecked)
            planilimit = QTreeWidgetItem(carto)
            planilimit.setFlags(planilimit.flags() | Qt.ItemIsUserCheckable)
            planilimit.setText(0, "Planificación de líneas límite municipales")
            planilimit.setCheckState(0, Qt.Unchecked)
            orto = QTreeWidgetItem(capas)
            orto.setText(0, "Ortofotos e Imágenes")
            oortoRGB = QTreeWidgetItem(orto)
            oortoRGB.setText(0, "Ortofotos RGB")
            orto2019 = QTreeWidgetItem(oortoRGB)
            orto2019.setFlags(orto2019.flags() | Qt.ItemIsUserCheckable)
            orto2019.setText(0, "Año 2019")
            orto2019.setCheckState(0, Qt.Unchecked)
            orto2018 = QTreeWidgetItem(oortoRGB)
            orto2018.setFlags(orto2018.flags() | Qt.ItemIsUserCheckable)
            orto2018.setText(0, "Año 2018")
            orto2018.setCheckState(0, Qt.Unchecked)
            orto2017 = QTreeWidgetItem(oortoRGB)
            orto2017.setFlags(orto2017.flags() | Qt.ItemIsUserCheckable)
            orto2017.setText(0, "Año 2017")
            orto2017.setCheckState(0, Qt.Unchecked)
            orto2015 = QTreeWidgetItem(oortoRGB)
            orto2015.setFlags(orto2015.flags() | Qt.ItemIsUserCheckable)
            orto2015.setText(0, "Año 2015 prov. Valencia y Castellón")
            orto2015.setCheckState(0, Qt.Unchecked)
            orto2014 = QTreeWidgetItem(oortoRGB)
            orto2014.setFlags(orto2014.flags() | Qt.ItemIsUserCheckable)
            orto2014.setText(0, "Año 2014 prov. Alicante")
            orto2014.setCheckState(0, Qt.Unchecked)
            orto2012 = QTreeWidgetItem(oortoRGB)
            orto2012.setFlags(orto2012.flags() | Qt.ItemIsUserCheckable)
            orto2012.setText(0, "Año 2012")
            orto2012.setCheckState(0, Qt.Unchecked)
            orto2010 = QTreeWidgetItem(oortoRGB)
            orto2010.setFlags(orto2010.flags() | Qt.ItemIsUserCheckable)
            orto2010.setText(0, "Año 2010 prov. Valencia")
            orto2010.setCheckState(0, Qt.Unchecked)
            orto2009c = QTreeWidgetItem(oortoRGB)
            orto2009c.setFlags(orto2009c.flags() | Qt.ItemIsUserCheckable)
            orto2009c.setText(0, "Año 2009 prov. Castellón")
            orto2009c.setCheckState(0, Qt.Unchecked)
            orto2009v = QTreeWidgetItem(oortoRGB)
            orto2009v.setFlags(orto2009v.flags() | Qt.ItemIsUserCheckable)
            orto2009v.setText(0, "Año 2009 prov. Alicante")
            orto2009v.setCheckState(0, Qt.Unchecked)
            orto2008 = QTreeWidgetItem(oortoRGB)
            orto2008.setFlags(orto2008.flags() | Qt.ItemIsUserCheckable)
            orto2008.setText(0, "Año 2008 prov. Valencia")
            orto2008.setCheckState(0, Qt.Unchecked)
            orto2007 = QTreeWidgetItem(oortoRGB)
            orto2007.setFlags(orto2007.flags() | Qt.ItemIsUserCheckable)
            orto2007.setText(0, "Año 2007 prov. Castellón")
            orto2007.setCheckState(0, Qt.Unchecked)
            orto2007a = QTreeWidgetItem(oortoRGB)
            orto2007a.setFlags(orto2007a.flags() | Qt.ItemIsUserCheckable)
            orto2007a.setText(0, "Año 2007 prov. Alicante")
            orto2007a.setCheckState(0, Qt.Unchecked)
            orto2006 = QTreeWidgetItem(oortoRGB)
            orto2006.setFlags(orto2006.flags() | Qt.ItemIsUserCheckable)
            orto2006.setText(0, "Año 2006 prov. Valencia")
            orto2006.setCheckState(0, Qt.Unchecked)
            orto2005c = QTreeWidgetItem(oortoRGB)
            orto2005c.setFlags(orto2005c.flags() | Qt.ItemIsUserCheckable)
            orto2005c.setText(0, "Año 2005 prov. Castellón")
            orto2005c.setCheckState(0, Qt.Unchecked)
            orto2005a = QTreeWidgetItem(oortoRGB)
            orto2005a.setFlags(orto2005a.flags() | Qt.ItemIsUserCheckable)
            orto2005a.setText(0, "Año 2005 prov. Alicante")
            orto2005a.setCheckState(0, Qt.Unchecked)
            orto2004 = QTreeWidgetItem(oortoRGB)
            orto2004.setFlags(orto2004.flags() | Qt.ItemIsUserCheckable)
            orto2004.setText(0, "Año 2004 prov. Valencia")
            orto2004.setCheckState(0, Qt.Unchecked)
            orto2003c = QTreeWidgetItem(oortoRGB)
            orto2003c.setFlags(orto2003c.flags() | Qt.ItemIsUserCheckable)
            orto2003c.setText(0, "Año 2003 prov. Castellón")
            orto2003c.setCheckState(0, Qt.Unchecked)
            orto2002 = QTreeWidgetItem(oortoRGB)
            orto2002.setFlags(orto2002.flags() | Qt.ItemIsUserCheckable)
            orto2002.setText(0, "Año 2002 prov. Valencia y Alicante")
            orto2002.setCheckState(0, Qt.Unchecked)
            orto2000 = QTreeWidgetItem(oortoRGB)
            orto2000.setFlags(orto2000.flags() | Qt.ItemIsUserCheckable)
            orto2000.setText(0, "Año 2000 prov. Valencia (Este)")
            orto2000.setCheckState(0, Qt.Unchecked)
            orto1997 = QTreeWidgetItem(oortoRGB)
            orto1997.setFlags(orto1997.flags() | Qt.ItemIsUserCheckable)
            orto1997.setText(0, "Año 1997 prov. Castellón (Sur)")
            orto1997.setCheckState(0, Qt.Unchecked)
            orto1996 = QTreeWidgetItem(oortoRGB)
            orto1996.setFlags(orto1996.flags() | Qt.ItemIsUserCheckable)
            orto1996.setText(0, "Año 1996 prov. Castellón (Norte)")
            orto1996.setCheckState(0, Qt.Unchecked)
            orto1956 = QTreeWidgetItem(oortoRGB)
            orto1956.setFlags(orto1956.flags() | Qt.ItemIsUserCheckable)
            orto1956.setText(0, "Año 1956")
            orto1956.setCheckState(0, Qt.Unchecked)
            oortoIRG = QTreeWidgetItem(orto)
            oortoIRG.setText(0, "Ortofotos IRG")
            orto2009ir = QTreeWidgetItem(oortoIRG)
            orto2009ir.setFlags(orto2009ir.flags() | Qt.ItemIsUserCheckable)
            orto2009ir.setText(0, "Año 2009 prov. Castellón - IRG")
            orto2009ir.setCheckState(0, Qt.Unchecked)
            orto2008ir = QTreeWidgetItem(oortoIRG)
            orto2008ir.setFlags(orto2008ir.flags() | Qt.ItemIsUserCheckable)
            orto2008ir.setText(0, "Año 2008 prov. Valencia - IRG")
            orto2008ir.setCheckState(0, Qt.Unchecked)
            orto2007cir = QTreeWidgetItem(oortoIRG)
            orto2007cir.setFlags(orto2007cir.flags() | Qt.ItemIsUserCheckable)
            orto2007cir.setText(0, "Año 2007 prov. Castellón - IRG")
            orto2007cir.setCheckState(0, Qt.Unchecked)
            orto2007ir = QTreeWidgetItem(oortoIRG)
            orto2007ir.setFlags(orto2007ir.flags() | Qt.ItemIsUserCheckable)
            orto2007ir.setText(0, "Año 2007 prov. Castellón - IRG")
            orto2007ir.setCheckState(0, Qt.Unchecked)
            orto2006ir = QTreeWidgetItem(oortoIRG)
            orto2006ir.setFlags(orto2006ir.flags() | Qt.ItemIsUserCheckable)
            orto2006ir.setText(0, "Año 2006 prov. Valencia - IRG")
            orto2006ir.setCheckState(0, Qt.Unchecked)
            orto2005ir = QTreeWidgetItem(oortoIRG)
            orto2005ir.setFlags(orto2005ir.flags() | Qt.ItemIsUserCheckable)
            orto2005ir.setText(0, "Año 2005 prov. Castellón - IRG")
            orto2005ir.setCheckState(0, Qt.Unchecked)
            satelite = QTreeWidgetItem(orto)
            satelite.setText(0, "Satélite")
            sentinel2 = QTreeWidgetItem(satelite)
            sentinel2.setText(0, "Sentinel-2")
            sent2020 = QTreeWidgetItem(sentinel2)
            sent2020.setFlags(sent2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2020.setText(0, "2020")
            sent2020.setCheckState(0, Qt.Unchecked)
            sent2020a = QTreeWidgetItem(sent2020)
            sent2020a.setFlags(sent2020a.flags() | Qt.ItemIsUserCheckable)
            sent2020a.setText(0, "20200311 RGB")
            sent2020a.setCheckState(0, Qt.Unchecked)
            sent2020b = QTreeWidgetItem(sent2020)
            sent2020b.setFlags(sent2020b.flags() | Qt.ItemIsUserCheckable)
            sent2020b.setText(0, "20200311 IGB")
            sent2020b.setCheckState(0, Qt.Unchecked)
            sent2020c = QTreeWidgetItem(sent2020)
            sent2020c.setFlags(sent2020c.flags() | Qt.ItemIsUserCheckable)
            sent2020c.setText(0, "20200106 RGB")
            sent2020c.setCheckState(0, Qt.Unchecked)
            sent2020d = QTreeWidgetItem(sent2020)
            sent2020d.setFlags(sent2020d.flags() | Qt.ItemIsUserCheckable)
            sent2020d.setText(0, "20200106 IGB")
            sent2020d.setCheckState(0, Qt.Unchecked)
            sent2019 = QTreeWidgetItem(sentinel2)
            sent2019.setFlags(sent2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2019.setText(0, "2019")
            sent2019.setCheckState(0, Qt.Unchecked)
            sent2019a = QTreeWidgetItem(sent2019)
            sent2019a.setFlags(sent2019a.flags() | Qt.ItemIsUserCheckable)
            sent2019a.setText(0, "20190918 RGB")
            sent2019a.setCheckState(0, Qt.Unchecked)
            sent2019b = QTreeWidgetItem(sent2019)
            sent2019b.setFlags(sent2019b.flags() | Qt.ItemIsUserCheckable)
            sent2019b.setText(0, "20190918 IGB")
            sent2019b.setCheckState(0, Qt.Unchecked)
            sent2019c = QTreeWidgetItem(sent2019)
            sent2019c.setFlags(sent2019c.flags() | Qt.ItemIsUserCheckable)
            sent2019c.setText(0, "20190531 RGB")
            sent2019c.setCheckState(0, Qt.Unchecked)
            sent2019d = QTreeWidgetItem(sent2019)
            sent2019d.setFlags(sent2019d.flags() | Qt.ItemIsUserCheckable)
            sent2019d.setText(0, "20190531 IGB")
            sent2019d.setCheckState(0, Qt.Unchecked)
            sent2019e = QTreeWidgetItem(sent2019)
            sent2019e.setFlags(sent2019e.flags() | Qt.ItemIsUserCheckable)
            sent2019e.setText(0, "20190111 RGB")
            sent2019e.setCheckState(0, Qt.Unchecked)
            sent2019f = QTreeWidgetItem(sent2019)
            sent2019f.setFlags(sent2019f.flags() | Qt.ItemIsUserCheckable)
            sent2019f.setText(0, "20190111 IGB")
            sent2019f.setCheckState(0, Qt.Unchecked)
            sent2018 = QTreeWidgetItem(sentinel2)
            sent2018.setFlags(sent2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2018.setText(0, "2018")
            sent2018.setCheckState(0, Qt.Unchecked)
            sent2018a = QTreeWidgetItem(sent2018)
            sent2018a.setFlags(sent2018a.flags() | Qt.ItemIsUserCheckable)
            sent2018a.setText(0, "20181003 RGB")
            sent2018a.setCheckState(0, Qt.Unchecked)
            sent2018b = QTreeWidgetItem(sent2018)
            sent2018b.setFlags(sent2018b.flags() | Qt.ItemIsUserCheckable)
            sent2018b.setText(0, "20181003 IGB")
            sent2018b.setCheckState(0, Qt.Unchecked)
            sent2018c = QTreeWidgetItem(sent2018)
            sent2018c.setFlags(sent2018c.flags() | Qt.ItemIsUserCheckable)
            sent2018c.setText(0, "20180615 RGB")
            sent2018c.setCheckState(0, Qt.Unchecked)
            sent2018d = QTreeWidgetItem(sent2018)
            sent2018d.setFlags(sent2018d.flags() | Qt.ItemIsUserCheckable)
            sent2018d.setText(0, "20180615 IGB")
            sent2018d.setCheckState(0, Qt.Unchecked)
            sent2018e = QTreeWidgetItem(sent2018)
            sent2018e.setFlags(sent2018e.flags() | Qt.ItemIsUserCheckable)
            sent2018e.setText(0, "20180307 RGB")
            sent2018e.setCheckState(0, Qt.Unchecked)
            sent2018f = QTreeWidgetItem(sent2018)
            sent2018f.setFlags(sent2018f.flags() | Qt.ItemIsUserCheckable)
            sent2018f.setText(0, "20180307 IGB")
            sent2018f.setCheckState(0, Qt.Unchecked)
            sent2018g = QTreeWidgetItem(sent2018)
            sent2018g.setFlags(sent2018g.flags() | Qt.ItemIsUserCheckable)
            sent2018g.setText(0, "20180116 RGB")
            sent2018g.setCheckState(0, Qt.Unchecked)
            sent2018h = QTreeWidgetItem(sent2018)
            sent2018h.setFlags(sent2018h.flags() | Qt.ItemIsUserCheckable)
            sent2018h.setText(0, "20180116 IGB")
            sent2018h.setCheckState(0, Qt.Unchecked)
            sent2017 = QTreeWidgetItem(sentinel2)
            sent2017.setFlags(sent2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2017.setText(0, "2017")
            sent2017.setCheckState(0, Qt.Unchecked)
            sent2017a = QTreeWidgetItem(sent2017)
            sent2017a.setFlags(sent2017a.flags() | Qt.ItemIsUserCheckable)
            sent2017a.setText(0, "20171112 RGB")
            sent2017a.setCheckState(0, Qt.Unchecked)
            sent2017b = QTreeWidgetItem(sent2017)
            sent2017b.setFlags(sent2017b.flags() | Qt.ItemIsUserCheckable)
            sent2017b.setText(0, "20170913 RGB")
            sent2017b.setCheckState(0, Qt.Unchecked)
            sent2017c = QTreeWidgetItem(sent2017)
            sent2017c.setFlags(sent2017c.flags() | Qt.ItemIsUserCheckable)
            sent2017c.setText(0, "20170824 RGB")
            sent2017c.setCheckState(0, Qt.Unchecked)
            sent2017d = QTreeWidgetItem(sent2017)
            sent2017d.setFlags(sent2017d.flags() | Qt.ItemIsUserCheckable)
            sent2017d.setText(0, "20170824 NIR")
            sent2017d.setCheckState(0, Qt.Unchecked)
            sent2017e = QTreeWidgetItem(sent2017)
            sent2017e.setFlags(sent2017e.flags() | Qt.ItemIsUserCheckable)
            sent2017e.setText(0, "20170804 RGB")
            sent2017e.setCheckState(0, Qt.Unchecked)
            sent2017f = QTreeWidgetItem(sent2017)
            sent2017f.setFlags(sent2017f.flags() | Qt.ItemIsUserCheckable)
            sent2017f.setText(0, "20170615 NIR")
            sent2017f.setCheckState(0, Qt.Unchecked)
            sent2017g = QTreeWidgetItem(sent2017)
            sent2017g.setFlags(sent2017g.flags() | Qt.ItemIsUserCheckable)
            sent2017g.setText(0, "20170506 RGB")
            sent2017g.setCheckState(0, Qt.Unchecked)
            sent2017h = QTreeWidgetItem(sent2017)
            sent2017h.setFlags(sent2017h.flags() | Qt.ItemIsUserCheckable)
            sent2017h.setText(0, "20170506 NIR")
            sent2017h.setCheckState(0, Qt.Unchecked)
            sent2016 = QTreeWidgetItem(sentinel2)
            sent2016.setFlags(sent2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2016.setText(0, "2016")
            sent2016.setCheckState(0, Qt.Unchecked)
            sent2016a = QTreeWidgetItem(sent2016)
            sent2016a.setFlags(sent2016a.flags() | Qt.ItemIsUserCheckable)
            sent2016a.setText(0, "20161227 RGB")
            sent2016a.setCheckState(0, Qt.Unchecked)
            sent2016b = QTreeWidgetItem(sent2016)
            sent2016b.setFlags(sent2016b.flags() | Qt.ItemIsUserCheckable)
            sent2016b.setText(0, "20161008 RGB")
            sent2016b.setCheckState(0, Qt.Unchecked)
            sent2016c = QTreeWidgetItem(sent2016)
            sent2016c.setFlags(sent2016c.flags() | Qt.ItemIsUserCheckable)
            sent2016c.setText(0, "20160819 RGB")
            sent2016c.setCheckState(0, Qt.Unchecked)
            sent2016d = QTreeWidgetItem(sent2016)
            sent2016d.setFlags(sent2016d.flags() | Qt.ItemIsUserCheckable)
            sent2016d.setText(0, "20160501 NIR")
            sent2016d.setCheckState(0, Qt.Unchecked)
            sent2015 = QTreeWidgetItem(sentinel2)
            sent2015.setFlags(sent2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2015.setText(0, "2015")
            sent2015.setCheckState(0, Qt.Unchecked)
            sent2015a = QTreeWidgetItem(sent2015)
            sent2015a.setFlags(sent2015a.flags() | Qt.ItemIsUserCheckable)
            sent2015a.setText(0, "20151203 NIR")
            sent2015a.setCheckState(0, Qt.Unchecked)
            sent2015b = QTreeWidgetItem(sent2015)
            sent2015b.setFlags(sent2015b.flags() | Qt.ItemIsUserCheckable)
            sent2015b.setText(0, "20150805 NIR")
            sent2015b.setCheckState(0, Qt.Unchecked)
            sent2015c = QTreeWidgetItem(sent2015)
            sent2015c.setFlags(sent2015c.flags() | Qt.ItemIsUserCheckable)
            sent2015c.setText(0, "20150706 NIR")
            sent2015c.setCheckState(0, Qt.Unchecked)
            usos = QTreeWidgetItem(capas)
            usos.setText(0, "Usos del Suelo")
            siose = QTreeWidgetItem(usos)
            siose.setText(0, "SIOSE")
            siose2015 = QTreeWidgetItem(siose)
            siose2015.setFlags(siose2015.flags() | Qt.ItemIsUserCheckable)
            siose2015.setText(0, "SIOSE 2015")
            siose2015.setCheckState(0, Qt.Unchecked)
            siose2011 = QTreeWidgetItem(siose)
            siose2011.setFlags(siose2011.flags() | Qt.ItemIsUserCheckable)
            siose2011.setText(0, "SIOSE 2011")
            siose2011.setCheckState(0, Qt.Unchecked)
            siose2009 = QTreeWidgetItem(siose)
            siose2009.setFlags(siose2009.flags() | Qt.ItemIsUserCheckable)
            siose2009.setText(0, "SIOSE 2009")
            siose2009.setCheckState(0, Qt.Unchecked)
            siose2005 = QTreeWidgetItem(siose)
            siose2005.setFlags(siose2005.flags() | Qt.ItemIsUserCheckable)
            siose2005.setText(0, "SIOSE 2009")
            siose2005.setCheckState(0, Qt.Unchecked)
            corine = QTreeWidgetItem(usos)
            corine.setText(0, "CORINE Land Cover")
            corine2018 = QTreeWidgetItem(corine)
            corine2018.setFlags(corine2018.flags() | Qt.ItemIsUserCheckable)
            corine2018.setText(0, "CLC 2018")
            corine2018.setCheckState(0, Qt.Unchecked)
            corine2012 = QTreeWidgetItem(corine)
            corine2012.setFlags(corine2012.flags() | Qt.ItemIsUserCheckable)
            corine2012.setText(0, "CLC 2012")
            corine2012.setCheckState(0, Qt.Unchecked)
            corine2006 = QTreeWidgetItem(corine)
            corine2006.setFlags(corine2006.flags() | Qt.ItemIsUserCheckable)
            corine2006.setText(0, "CLC 2006")
            corine2006.setCheckState(0, Qt.Unchecked)
            corine2000 = QTreeWidgetItem(corine)
            corine2000.setFlags(corine2000.flags() | Qt.ItemIsUserCheckable)
            corine2000.setText(0, "CLC 2000")
            corine2000.setCheckState(0, Qt.Unchecked)
            corine1990 = QTreeWidgetItem(corine)
            corine1990.setFlags(corine1990.flags() | Qt.ItemIsUserCheckable)
            corine1990.setText(0, "CLC 1990")
            corine1990.setCheckState(0, Qt.Unchecked)
            medioambiente = QTreeWidgetItem(capas)
            medioambiente.setText(0, "Medio ambiente")
            aguas = QTreeWidgetItem(medioambiente)
            aguas.setText(0, "Aguas")
            playas = QTreeWidgetItem(aguas)
            playas.setFlags(playas.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            playas.setText(0, "Playas")
            playas.setCheckState(0, Qt.Unchecked)
            bandazul = QTreeWidgetItem(playas)
            bandazul.setFlags(bandazul.flags() | Qt.ItemIsUserCheckable)
            bandazul.setText(0, "Banderas azules")
            bandazul.setCheckState(0, Qt.Unchecked)
            puntsmuest = QTreeWidgetItem(playas)
            puntsmuest.setFlags(puntsmuest.flags() | Qt.ItemIsUserCheckable)
            puntsmuest.setText(0, "Puntos de muestreo")
            puntsmuest.setCheckState(0, Qt.Unchecked)
            lineacosta = QTreeWidgetItem(playas)
            lineacosta.setFlags(lineacosta.flags() | Qt.ItemIsUserCheckable)
            lineacosta.setText(0, "Línea de costa")
            lineacosta.setCheckState(0, Qt.Unchecked)
            nitrats = QTreeWidgetItem(aguas)
            nitrats.setFlags(nitrats.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            nitrats.setText(0, "Zonas vulnerables por nitratos")
            nitrats.setCheckState(0, Qt.Unchecked)
            infonitrat = QTreeWidgetItem(nitrats)
            infonitrat.setFlags(infonitrat.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infonitrat.setText(0, "Información de referencia")
            infonitrat.setCheckState(0, Qt.Unchecked)
            inforedhidro = QTreeWidgetItem(infonitrat)
            inforedhidro.setFlags(inforedhidro.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            inforedhidro.setText(0, "Red hidrográfica")
            inforedhidro.setCheckState(0, Qt.Unchecked)
            masassuperfafec = QTreeWidgetItem(infonitrat)
            masassuperfafec.setFlags(masassuperfafec.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperfafec.setText(0, "Masas superficiales afectadas")
            masassuperfafec.setCheckState(0, Qt.Unchecked)
            masassuperfrio = QTreeWidgetItem(masassuperfafec)
            masassuperfrio.setFlags(masassuperfrio.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperfrio.setText(0, "Ríos")
            masassuperfrio.setCheckState(0, Qt.Unchecked)
            masassuperemba = QTreeWidgetItem(masassuperfafec)
            masassuperemba.setFlags(masassuperemba.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperemba.setText(0, "Embalses")
            masassuperemba.setCheckState(0, Qt.Unchecked)
            masassuperllac = QTreeWidgetItem(masassuperfafec)
            masassuperllac.setFlags(masassuperllac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperllac.setText(0, "Lagos")
            masassuperllac.setCheckState(0, Qt.Unchecked)
            zonasvulnsup = QTreeWidgetItem(nitrats)
            zonasvulnsup.setFlags(zonasvulnsup.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            zonasvulnsup.setText(0, "Zonas Vulnerables Superficiales")
            zonasvulnsup.setCheckState(0, Qt.Unchecked)
            zonasvulnsub = QTreeWidgetItem(nitrats)
            zonasvulnsub.setFlags(zonasvulnsub.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            zonasvulnsub.setText(0, "Zonas Vulnerables Subterráneas")
            zonasvulnsub.setCheckState(0, Qt.Unchecked)
            atlas = QTreeWidgetItem(medioambiente)
            atlas.setText(0, "Atlas climático de la C.V.")
            atlasref = QTreeWidgetItem(atlas)
            atlasref.setFlags(atlasref.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasref.setText(0, "Estaciones de referencia")
            atlasref.setCheckState(0, Qt.Unchecked)
            atlasanu = QTreeWidgetItem(atlas)
            atlasanu.setText(0, "Datos anuales")
            atlasanuprec = QTreeWidgetItem(atlasanu)
            atlasanuprec.setFlags(atlasanuprec.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuprec.setText(0, "Precipitación acumulada anual [mm]")
            atlasanuprec.setCheckState(0, Qt.Unchecked)
            atlasanuptemp = QTreeWidgetItem(atlasanu)
            atlasanuptemp.setFlags(atlasanuptemp.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptemp.setText(0, "Temperatura media anual [C]")
            atlasanuptemp.setCheckState(0, Qt.Unchecked)
            atlasanuptempmi = QTreeWidgetItem(atlasanu)
            atlasanuptempmi.setFlags(atlasanuptempmi.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempmi.setText(0, "Temperatura mínima anual [C]")
            atlasanuptempmi.setCheckState(0, Qt.Unchecked)
            atlasanuptempma = QTreeWidgetItem(atlasanu)
            atlasanuptempma.setFlags(atlasanuptempma.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempma.setText(0, "Temperatura máxima anual [C]")
            atlasanuptempma.setCheckState(0, Qt.Unchecked)
            atlasanuptempmemi = QTreeWidgetItem(atlasanu)
            atlasanuptempmemi.setFlags(atlasanuptempmemi.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempmemi.setText(0, "Temperatura media de las mínimas anual [C]")
            atlasanuptempmemi.setCheckState(0, Qt.Unchecked)
            atlasanuptempmema = QTreeWidgetItem(atlasanu)
            atlasanuptempmema.setFlags(atlasanuptempmema.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempmema.setText(0, "Temperatura media de las máximas anual [C]")
            atlasanuptempmema.setCheckState(0, Qt.Unchecked)
            atlasesta = QTreeWidgetItem(atlas)
            atlasesta.setText(0, "Datos estacionales")
            atlasestapreci = QTreeWidgetItem(atlasesta)
            atlasestapreci.setText(0, "Precipitación acumulada [mm] - Estacional")
            atlasestaprecipri = QTreeWidgetItem(atlasestapreci)
            atlasestaprecipri.setFlags(atlasestaprecipri.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestaprecipri.setText(0, "Prec. primavera [mm]")
            atlasestaprecipri.setCheckState(0, Qt.Unchecked)
            atlasestapreciver = QTreeWidgetItem(atlasestapreci)
            atlasestapreciver.setFlags(atlasestapreciver.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciver.setText(0, "Prec. verano [mm]")
            atlasestapreciver.setCheckState(0, Qt.Unchecked)
            atlasestaprecoto = QTreeWidgetItem(atlasestapreci)
            atlasestaprecoto.setFlags(atlasestaprecoto.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestaprecoto.setText(0, "Prec. otoño [mm]")
            atlasestaprecoto.setCheckState(0, Qt.Unchecked)
            atlasestaprecinv = QTreeWidgetItem(atlasestapreci)
            atlasestaprecinv.setFlags(atlasestaprecinv.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestaprecinv.setText(0, "Prec. invierno [mm]")
            atlasestaprecinv.setCheckState(0, Qt.Unchecked)
            atlasestatempe = QTreeWidgetItem(atlasesta)
            atlasestatempe.setText(0, "Temperatura media [C] - Estacional")
            atlasestatempeipri = QTreeWidgetItem(atlasestatempe)
            atlasestatempeipri.setFlags(atlasestatempeipri.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri.setText(0, "Ta media primavera [c]")
            atlasestatempeipri.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver = QTreeWidgetItem(atlasestatempe)
            atlasestatempeiver.setFlags(atlasestatempeiver.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver.setText(0, "Ta media verano [c]")
            atlasestatempeiver.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto = QTreeWidgetItem(atlasestatempe)
            atlasestatempeoto.setFlags(atlasestatempeoto.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto.setText(0, "Ta media otoño [c]")
            atlasestatempeoto.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv = QTreeWidgetItem(atlasestatempe)
            atlasestatempeinv.setFlags(atlasestatempeinv.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv.setText(0, "Ta media invierno [c]")
            atlasestatempeinv.setCheckState(0, Qt.Unchecked)
            atlasestatempe1 = QTreeWidgetItem(atlasesta)
            atlasestatempe1.setText(0, "Temperatura mínima [C] - Estacional")
            atlasestatempeipri1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeipri1.setFlags(atlasestatempeipri1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri1.setText(0, "Ta mínima primavera [c]")
            atlasestatempeipri1.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeiver1.setFlags(atlasestatempeiver1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver1.setText(0, "Ta mínima verano [c]")
            atlasestatempeiver1.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeoto1.setFlags(atlasestatempeoto1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto1.setText(0, "Ta mínima otoño [c]")
            atlasestatempeoto1.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeinv1.setFlags(atlasestatempeinv1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv1.setText(0, "Ta mínima invierno [c]")
            atlasestatempeinv1.setCheckState(0, Qt.Unchecked)
            atlasestatempe2 = QTreeWidgetItem(atlasesta)
            atlasestatempe2.setText(0, "Temperatura máxima [C] - Estacional")
            atlasestatempeipri2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeipri2.setFlags(atlasestatempeipri2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri2.setText(0, "Ta máxima primavera [c]")
            atlasestatempeipri2.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeiver2.setFlags(atlasestatempeiver2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver2.setText(0, "Ta máxima verano [c]")
            atlasestatempeiver2.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeoto2.setFlags(atlasestatempeoto2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto2.setText(0, "Ta máxima otoño [c]")
            atlasestatempeoto2.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeinv2.setFlags(atlasestatempeinv2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv2.setText(0, "Ta máxima invierno [c]")
            atlasestatempeinv2.setCheckState(0, Qt.Unchecked)
            atlasestatempe3 = QTreeWidgetItem(atlasesta)
            atlasestatempe3.setText(0, "Temperatura media de las mínimas [C] - Estacional")
            atlasestatempeipri3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeipri3.setFlags(atlasestatempeipri3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri3.setText(0, "Ta media de las mínimas primavera [c]")
            atlasestatempeipri3.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeiver3.setFlags(atlasestatempeiver3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver3.setText(0, "Ta media de las mínimas verano [c]")
            atlasestatempeiver3.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeoto3.setFlags(atlasestatempeoto3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto3.setText(0, "Ta media de las mínimas otoño [c]")
            atlasestatempeoto3.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeinv3.setFlags(atlasestatempeinv3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv3.setText(0, "Ta media de las mínimas invierno [c]")
            atlasestatempeinv3.setCheckState(0, Qt.Unchecked)
            atlasestatempe4 = QTreeWidgetItem(atlasesta)
            atlasestatempe4.setText(0, "Temperatura media de las máximas [C] - Estacional")
            atlasestatempeipri4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeipri4.setFlags(atlasestatempeipri4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri4.setText(0, "Ta media de las máximas primavera [c]")
            atlasestatempeipri4.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeiver4.setFlags(atlasestatempeiver4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver4.setText(0, "Ta media de las máximas verano [c]")
            atlasestatempeiver4.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeoto4.setFlags(atlasestatempeoto4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto4.setText(0, "Ta media de las máximas otoño [c]")
            atlasestatempeoto4.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeinv4.setFlags(atlasestatempeinv4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv4.setText(0, "Ta media de las máximas invierno [c]")
            atlasestatempeinv4.setCheckState(0, Qt.Unchecked)
            atlasmensu = QTreeWidgetItem(atlas)
            atlasmensu.setText(0, "Datos mensuales")
            atlasestaprecim = QTreeWidgetItem(atlasmensu)
            atlasestaprecim.setText(0, "Precipitación acumulada [mm] - Mensual")
            atlasestapreciprim1 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreciprim1.setFlags(atlasestapreciprim1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1.setText(0, "Prec. enero [mm]")
            atlasestapreciprim1.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreciprim2.setFlags(atlasestapreciprim2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2.setText(0, "Prec. febrero [mm]")
            atlasestapreciprim2.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim3.setFlags(atlasestapreprim3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3.setText(0, "Prec. marzo [mm]")
            atlasestapreprim3.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim4.setFlags(atlasestapreprim4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4.setText(0, "Prec. abril [mm]")
            atlasestapreprim4.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim5.setFlags(atlasestapreprim5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5.setText(0, "Prec. mayo [mm]")
            atlasestapreprim5.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim6.setFlags(atlasestapreprim6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6.setText(0, "Prec. junio [mm]")
            atlasestapreprim6.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim7.setFlags(atlasestapreprim7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7.setText(0, "Prec. julio [mm]")
            atlasestapreprim7.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim8.setFlags(atlasestapreprim8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8.setText(0, "Prec. agosto [mm]")
            atlasestapreprim8.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim9.setFlags(atlasestapreprim9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9.setText(0, "Prec. septiembre [mm]")
            atlasestapreprim9.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim10.setFlags(atlasestapreprim10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10.setText(0, "Prec. octubre [mm]")
            atlasestapreprim10.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim11.setFlags(atlasestapreprim11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11.setText(0, "Prec. noviembre [mm]")
            atlasestapreprim11.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim12.setFlags(atlasestapreprim12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12.setText(0, "Prec. diciembre [mm]")
            atlasestapreprim12.setCheckState(0, Qt.Unchecked)
            atlasestaprecime = QTreeWidgetItem(atlasmensu)
            atlasestaprecime.setText(0, "Temperatura media [C] - Mensual")
            atlasestapreciprim1e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreciprim1e.setFlags(atlasestapreciprim1e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1e.setText(0, "Ta media enero [C]")
            atlasestapreciprim1e.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreciprim2e.setFlags(atlasestapreciprim2e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2e.setText(0, "Ta media febrero [C]")
            atlasestapreciprim2e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim3e.setFlags(atlasestapreprim3e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3e.setText(0, "Ta media marzo [C]")
            atlasestapreprim3e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim4e.setFlags(atlasestapreprim4e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4e.setText(0, "Ta media abril [C]")
            atlasestapreprim4e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim5e.setFlags(atlasestapreprim5e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5e.setText(0, "Ta media mayo [C]")
            atlasestapreprim5e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim6e.setFlags(atlasestapreprim6e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6e.setText(0, "Ta media junio [C]")
            atlasestapreprim6e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim7e.setFlags(atlasestapreprim7e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7e.setText(0, "Ta media julio [C]")
            atlasestapreprim7e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim8e.setFlags(atlasestapreprim8e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8e.setText(0, "Ta media agosto [C]")
            atlasestapreprim8e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim9e.setFlags(atlasestapreprim9e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9e.setText(0, "Ta media septiembre [C]")
            atlasestapreprim9e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim10e.setFlags(atlasestapreprim10e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10e.setText(0, "Ta media octubre [C]")
            atlasestapreprim10e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim11e.setFlags(atlasestapreprim11e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11e.setText(0, "Ta media noviembre [C]")
            atlasestapreprim11e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim12e.setFlags(atlasestapreprim12e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12e.setText(0, "Ta media diciembre [C]")
            atlasestapreprim12e.setCheckState(0, Qt.Unchecked)
            atlasestaprecimm = QTreeWidgetItem(atlasmensu)
            atlasestaprecimm.setText(0, "Temperatura mínima [C] - Mensual")
            atlasestapreciprim1m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreciprim1m.setFlags(atlasestapreciprim1m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1m.setText(0, "Ta mínima enero [C]")
            atlasestapreciprim1m.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreciprim2m.setFlags(atlasestapreciprim2m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2m.setText(0, "Ta mínima febrero [C]")
            atlasestapreciprim2m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim3m.setFlags(atlasestapreprim3m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3m.setText(0, "Ta mínima marzo [C]")
            atlasestapreprim3m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim4m.setFlags(atlasestapreprim4m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4m.setText(0, "Ta mínima abril [C]")
            atlasestapreprim4m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim5m.setFlags(atlasestapreprim5m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5m.setText(0, "Ta mínima mayo [C]")
            atlasestapreprim5m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim6m.setFlags(atlasestapreprim6m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6m.setText(0, "Ta mínima junio [C]")
            atlasestapreprim6m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim7m.setFlags(atlasestapreprim7m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7m.setText(0, "Ta mínima julio [C]")
            atlasestapreprim7m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim8m.setFlags(atlasestapreprim8m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8m.setText(0, "Ta mínima agosto [C]")
            atlasestapreprim8m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim9m.setFlags(atlasestapreprim9m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9m.setText(0, "Ta mínima septiembre [C]")
            atlasestapreprim9m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim10m.setFlags(atlasestapreprim10m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10m.setText(0, "Ta mínima octubre [C]")
            atlasestapreprim10m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim11m.setFlags(atlasestapreprim11m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11m.setText(0, "Ta mínima noviembre [C]")
            atlasestapreprim11m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim12m.setFlags(atlasestapreprim12m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12m.setText(0, "Ta mínima diciembre [C]")
            atlasestapreprim12m.setCheckState(0, Qt.Unchecked)
            atlasestaprecimn = QTreeWidgetItem(atlasmensu)
            atlasestaprecimn.setText(0, "Temperatura máxima [C] - Mensual")
            atlasestapreciprim1n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreciprim1n.setFlags(atlasestapreciprim1n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1n.setText(0, "Ta máxima enero [C]")
            atlasestapreciprim1n.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreciprim2n.setFlags(atlasestapreciprim2n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2n.setText(0, "Ta máxima febrero [C]")
            atlasestapreciprim2n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim3n.setFlags(atlasestapreprim3n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3n.setText(0, "Ta máxima marzo [C]")
            atlasestapreprim3n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim4n.setFlags(atlasestapreprim4n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4n.setText(0, "Ta máxima abril [C]")
            atlasestapreprim4n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim5n.setFlags(atlasestapreprim5n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5n.setText(0, "Ta máxima mayo [C]")
            atlasestapreprim5n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim6n.setFlags(atlasestapreprim6n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6n.setText(0, "Ta máxima junio [C]")
            atlasestapreprim6n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim7n.setFlags(atlasestapreprim7n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7n.setText(0, "Ta máxima julio [C]")
            atlasestapreprim7n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim8n.setFlags(atlasestapreprim8n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8n.setText(0, "Ta máxima agosto [C]")
            atlasestapreprim8n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim9n.setFlags(atlasestapreprim9n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9n.setText(0, "Ta máxima septiembre [C]")
            atlasestapreprim9n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim10n.setFlags(atlasestapreprim10n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10n.setText(0, "Ta máxima octubre [C]")
            atlasestapreprim10n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim11n.setFlags(atlasestapreprim11n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11n.setText(0, "Ta máxima noviembre [C]")
            atlasestapreprim11n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim12n.setFlags(atlasestapreprim12n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12n.setText(0, "Ta máxima diciembre [C]")
            atlasestapreprim12n.setCheckState(0, Qt.Unchecked)
            atlasestaprecimq = QTreeWidgetItem(atlasmensu)
            atlasestaprecimq.setText(0, "Temperatura media de las mínimas [C] - Mensual")
            atlasestapreciprim1q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreciprim1q.setFlags(atlasestapreciprim1q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1q.setText(0, "Ta media de las mínimas enero [C]")
            atlasestapreciprim1q.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreciprim2q.setFlags(atlasestapreciprim2q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2q.setText(0, "Ta media de las mínimas febrero [C]")
            atlasestapreciprim2q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim3q.setFlags(atlasestapreprim3q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3q.setText(0, "Ta media de las mínimas marzo [C]")
            atlasestapreprim3q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim4q.setFlags(atlasestapreprim4q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4q.setText(0, "Ta media de las mínimas abril [C]")
            atlasestapreprim4q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim5q.setFlags(atlasestapreprim5q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5q.setText(0, "Ta media de las mínimas mayo [C]")
            atlasestapreprim5q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim6q.setFlags(atlasestapreprim6q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6q.setText(0, "Ta media de las mínimas junio [C]")
            atlasestapreprim6q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim7q.setFlags(atlasestapreprim7q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7q.setText(0, "Ta media de las mínimas julio [C]")
            atlasestapreprim7q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim8q.setFlags(atlasestapreprim8q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8q.setText(0, "Ta media de las mínimas agosto [C]")
            atlasestapreprim8q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim9q.setFlags(atlasestapreprim9q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9q.setText(0, "Ta media de las mínimas septiembre [C]")
            atlasestapreprim9q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim10q.setFlags(atlasestapreprim10q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10q.setText(0, "Ta media de las mínimas octubre [C]")
            atlasestapreprim10q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim11q.setFlags(atlasestapreprim11q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11q.setText(0, "Ta media de las mínimas noviembre [C]")
            atlasestapreprim11q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim12q.setFlags(atlasestapreprim12q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12q.setText(0, "Ta media de las máximas diciembre [C]")
            atlasestapreprim12q.setCheckState(0, Qt.Unchecked)
            atlasestaprecimz = QTreeWidgetItem(atlasmensu)
            atlasestaprecimz.setText(0, "Temperatura media de las máximas [C] - Mensual")
            atlasestapreciprim1z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreciprim1z.setFlags(atlasestapreciprim1z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1z.setText(0, "Ta media de las máximas enero [C]")
            atlasestapreciprim1z.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreciprim2z.setFlags(atlasestapreciprim2z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2z.setText(0, "Ta media de las máximas febrero [C]")
            atlasestapreciprim2z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim3z.setFlags(atlasestapreprim3z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3z.setText(0, "Ta media de las máximas marzo [C]")
            atlasestapreprim3z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim4z.setFlags(atlasestapreprim4z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4z.setText(0, "Ta media de las máximas abril [C]")
            atlasestapreprim4z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim5z.setFlags(atlasestapreprim5z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5z.setText(0, "Ta media de las máximas mayo [C]")
            atlasestapreprim5z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim6z.setFlags(atlasestapreprim6z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6z.setText(0, "Ta media de las máximas junio [C]")
            atlasestapreprim6z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim7z.setFlags(atlasestapreprim7z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7z.setText(0, "Ta media de las máximas julio [C]")
            atlasestapreprim7z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim8z.setFlags(atlasestapreprim8z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8z.setText(0, "Ta media de las máximas agosto [C]")
            atlasestapreprim8z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim9z.setFlags(atlasestapreprim9z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9z.setText(0, "Ta media de las máximas septiembre [C]")
            atlasestapreprim9z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim10z.setFlags(atlasestapreprim10z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10z.setText(0, "Ta media de las máximas octubre [C]")
            atlasestapreprim10z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim11z.setFlags(atlasestapreprim11z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11z.setText(0, "Ta media de las máximas noviembre [C]")
            atlasestapreprim11z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim12z.setFlags(atlasestapreprim12z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12z.setText(0, "Ta media de las máximas diciembre [C]")
            atlasestapreprim12z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12t = QTreeWidgetItem(atlas)
            atlasestapreprim12t.setFlags(atlasestapreprim12t.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12t.setText(0, "Cuadrícula de referencia")
            atlasestapreprim12t.setCheckState(0, Qt.Unchecked)



            mediorural = QTreeWidgetItem(capas)
            mediorural.setText(0, "Medio rural")
            sigpac = QTreeWidgetItem(mediorural)
            sigpac.setText(0, "SIGPAC")
            sigpac2020 = QTreeWidgetItem(sigpac)
            sigpac2020.setFlags(sigpac2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2020.setText(0, "Año 2020 ")
            sigpac2020.setCheckState(0, Qt.Unchecked)
            sigpacpar2020 = QTreeWidgetItem(sigpac2020)
            sigpacpar2020.setFlags(sigpacpar2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2020.setText(0, "Parcelas 2020")
            sigpacpar2020.setCheckState(0, Qt.Unchecked)
            sigpacrec2020 = QTreeWidgetItem(sigpac2020)
            sigpacrec2020.setFlags(sigpacrec2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2020.setText(0, "Recintos 2020")
            sigpacrec2020.setCheckState(0, Qt.Unchecked)
            sigpac2019 = QTreeWidgetItem(sigpac)
            sigpac2019.setFlags(sigpac2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2019.setText(0, "Año 2019 ")
            sigpac2019.setCheckState(0, Qt.Unchecked)
            sigpacpar2019 = QTreeWidgetItem(sigpac2019)
            sigpacpar2019.setFlags(sigpacpar2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2019.setText(0, "Parcelas 2019")
            sigpacpar2019.setCheckState(0, Qt.Unchecked)
            sigpacrec2019 = QTreeWidgetItem(sigpac2019)
            sigpacrec2019.setFlags(sigpacrec2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2019.setText(0, "Recintos 2019")
            sigpacrec2019.setCheckState(0, Qt.Unchecked)
            sigpac2018 = QTreeWidgetItem(sigpac)
            sigpac2018.setFlags(sigpac2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2018.setText(0, "Año 2018 ")
            sigpac2018.setCheckState(0, Qt.Unchecked)
            sigpacpar2018 = QTreeWidgetItem(sigpac2018)
            sigpacpar2018.setFlags(sigpacpar2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2018.setText(0, "Parcelas 2018")
            sigpacpar2018.setCheckState(0, Qt.Unchecked)
            sigpacrec2018 = QTreeWidgetItem(sigpac2018)
            sigpacrec2018.setFlags(sigpacrec2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2018.setText(0, "Recintos 2018")
            sigpacrec2018.setCheckState(0, Qt.Unchecked)
            sigpac2017 = QTreeWidgetItem(sigpac)
            sigpac2017.setFlags(sigpac2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2017.setText(0, "Año 2017 ")
            sigpac2017.setCheckState(0, Qt.Unchecked)
            sigpacpar2017 = QTreeWidgetItem(sigpac2017)
            sigpacpar2017.setFlags(sigpacpar2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2017.setText(0, "Parcelas 2017")
            sigpacpar2017.setCheckState(0, Qt.Unchecked)
            sigpacrec2017 = QTreeWidgetItem(sigpac2017)
            sigpacrec2017.setFlags(sigpacrec2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2017.setText(0, "Recintos 2017")
            sigpacrec2017.setCheckState(0, Qt.Unchecked)
            sigpac2016 = QTreeWidgetItem(sigpac)
            sigpac2016.setFlags(sigpac2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2016.setText(0, "Año 2016 ")
            sigpac2016.setCheckState(0, Qt.Unchecked)
            sigpacpar2016 = QTreeWidgetItem(sigpac2016)
            sigpacpar2016.setFlags(sigpacpar2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2016.setText(0, "Parcelas 2016")
            sigpacpar2016.setCheckState(0, Qt.Unchecked)
            sigpacrec2016 = QTreeWidgetItem(sigpac2016)
            sigpacrec2016.setFlags(sigpacrec2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2016.setText(0, "Recintos 2016")
            sigpacrec2016.setCheckState(0, Qt.Unchecked)
            sigpac2015 = QTreeWidgetItem(sigpac)
            sigpac2015.setFlags(sigpac2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2015.setText(0, "Año 2015 ")
            sigpac2015.setCheckState(0, Qt.Unchecked)
            sigpacpar2015 = QTreeWidgetItem(sigpac2015)
            sigpacpar2015.setFlags(sigpacpar2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2015.setText(0, "Parcelas 2015")
            sigpacpar2015.setCheckState(0, Qt.Unchecked)
            sigpacrec2015 = QTreeWidgetItem(sigpac2015)
            sigpacrec2015.setFlags(sigpacrec2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2015.setText(0, "Recintos 2015")
            sigpacrec2015.setCheckState(0, Qt.Unchecked)
            infraestructuras = QTreeWidgetItem(capas)
            infraestructuras.setText(0, "Infraestructures")
            infraarqui = QTreeWidgetItem(infraestructuras)
            infraarqui.setText(0, "Arquitectura")
            infraarquito = QTreeWidgetItem(infraarqui)
            infraarquito.setFlags(infraarquito.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraarquito.setText(0, "Torres de vigía")
            infraarquito.setCheckState(0, Qt.Unchecked)
            infraarquiru = QTreeWidgetItem(infraarqui)
            infraarquiru.setFlags(infraarquiru.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraarquiru.setText(0, "Ruta - Torres")
            infraarquiru.setCheckState(0, Qt.Unchecked)
            infracostes = QTreeWidgetItem(infraestructuras)
            infracostes.setText(0, "Costas")
            costesfotogr = QTreeWidgetItem(infracostes)
            costesfotogr.setFlags(costesfotogr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr.setText(0, "Fotogramas")
            costesfotogr.setCheckState(0, Qt.Unchecked)
            costesfotogr98 = QTreeWidgetItem(costesfotogr)
            costesfotogr98.setFlags(costesfotogr98.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr98.setText(0, "Fotogramas año 1998")
            costesfotogr98.setCheckState(0, Qt.Unchecked)
            costesfotogr96 = QTreeWidgetItem(costesfotogr)
            costesfotogr96.setFlags(costesfotogr96.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr96.setText(0, "Fotogramas año 1996")
            costesfotogr96.setCheckState(0, Qt.Unchecked)
            costesfotogr94 = QTreeWidgetItem(costesfotogr)
            costesfotogr94.setFlags(costesfotogr94.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr94.setText(0, "Fotogramas año 1994")
            costesfotogr94.setCheckState(0, Qt.Unchecked)
            costesfotogr92 = QTreeWidgetItem(costesfotogr)
            costesfotogr92.setFlags(costesfotogr92.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr92.setText(0, "Fotogramas año 1992")
            costesfotogr92.setCheckState(0, Qt.Unchecked)
            costesfotogr90 = QTreeWidgetItem(costesfotogr)
            costesfotogr90.setFlags(costesfotogr90.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr90.setText(0, "Fotogramas año 1990")
            costesfotogr90.setCheckState(0, Qt.Unchecked)
            costesfotogr86 = QTreeWidgetItem(costesfotogr)
            costesfotogr86.setFlags(costesfotogr86.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr86.setText(0, "Fotogramas año 1986")
            costesfotogr86.setCheckState(0, Qt.Unchecked)
            costesfotogr81 = QTreeWidgetItem(costesfotogr)
            costesfotogr81.setFlags(costesfotogr81.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr81.setText(0, "Fotogramas años 1981-1983")
            costesfotogr81.setCheckState(0, Qt.Unchecked)
            costesfotogr56 = QTreeWidgetItem(costesfotogr)
            costesfotogr56.setFlags(costesfotogr56.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr56.setText(0, "Fotogramas años 1956-1957")
            costesfotogr56.setCheckState(0, Qt.Unchecked)
            costesobliq = QTreeWidgetItem(infracostes)
            costesobliq.setFlags(costesobliq.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq.setText(0, "Oblicuas")
            costesobliq.setCheckState(0, Qt.Unchecked)
            costesobliq2009 = QTreeWidgetItem(costesobliq)
            costesobliq2009.setFlags(costesobliq2009.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq2009.setText(0, "Oblicuas año 2009")
            costesobliq2009.setCheckState(0, Qt.Unchecked)
            costesobliq2001 = QTreeWidgetItem(costesobliq)
            costesobliq2001.setFlags(costesobliq2001.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq2001.setText(0, "Oblicuas año 2001")
            costesobliq2001.setCheckState(0, Qt.Unchecked)
            costesobliq1998 = QTreeWidgetItem(costesobliq)
            costesobliq1998.setFlags(costesobliq1998.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq1998.setText(0, "Oblicuas año 1998")
            costesobliq1998.setCheckState(0, Qt.Unchecked)
            infraesviarias = QTreeWidgetItem(infraestructuras)
            infraesviarias.setText(0, "Infraestructuras viarias")
            infraviariasci = QTreeWidgetItem(infraesviarias)
            infraviariasci.setFlags(infraviariasci.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariasci.setText(0, "Ciclo-rutas")
            infraviariasci.setCheckState(0, Qt.Unchecked)
            infraviariascia = QTreeWidgetItem(infraviariasci)
            infraviariascia.setFlags(infraviariascia.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariascia.setText(0, "Actuales")
            infraviariascia.setCheckState(0, Qt.Unchecked)
            infraviariascif = QTreeWidgetItem(infraviariasci)
            infraviariascif.setFlags(infraviariascif.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariascif.setText(0, "Futuras")
            infraviariascif.setCheckState(0, Qt.Unchecked)
            infraviaricarr = QTreeWidgetItem(infraesviarias)
            infraviaricarr.setFlags(infraviaricarr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr.setText(0, "Carreteras")
            infraviaricarr.setCheckState(0, Qt.Unchecked)
            infraviaricta = QTreeWidgetItem(infraviaricarr)
            infraviaricta.setFlags(infraviaricta.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricta.setText(0, "Catálogo viario")
            infraviaricta.setCheckState(0, Qt.Unchecked)
            cataviario1i = QTreeWidgetItem(infraviaricta)
            cataviario1i.setFlags(cataviario1i.flags() | Qt.ItemIsUserCheckable)
            cataviario1i.setText(0, "Catálogo viario escala 1")
            cataviario1i.setCheckState(0, Qt.Unchecked)
            cataviario2i = QTreeWidgetItem(infraviaricta)
            cataviario2i.setFlags(cataviario2i.flags() | Qt.ItemIsUserCheckable)
            cataviario2i.setText(0, "Catálogo viario escala 2")
            cataviario2i.setCheckState(0, Qt.Unchecked)
            cataviario3i = QTreeWidgetItem(infraviaricta)
            cataviario3i.setFlags(cataviario3i.flags() | Qt.ItemIsUserCheckable)
            cataviario3i.setText(0, "Catálogo viario escala 3")
            cataviario3i.setCheckState(0, Qt.Unchecked)
            cataviario4i = QTreeWidgetItem(infraviaricta)
            cataviario4i.setFlags(cataviario4i.flags() | Qt.ItemIsUserCheckable)
            cataviario4i.setText(0, "Catálogo viario escala 4")
            cataviario4i.setCheckState(0, Qt.Unchecked)
            cataviariopk = QTreeWidgetItem(infraviaricarr)
            cataviariopk.setFlags(cataviariopk.flags() | Qt.ItemIsUserCheckable)
            cataviariopk.setText(0, "Puntos kilométricos")
            cataviariopk.setCheckState(0, Qt.Unchecked)
            infraviariimd = QTreeWidgetItem(infraviaricarr)
            infraviariimd.setFlags(infraviariimd.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd.setText(0, "IMD")
            infraviariimd.setCheckState(0, Qt.Unchecked)
            infraviariimd19 = QTreeWidgetItem(infraviariimd)
            infraviariimd19.setFlags(infraviariimd19.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd19.setText(0, "Intensidad media 2019")
            infraviariimd19.setCheckState(0, Qt.Unchecked)
            infraviariimd18 = QTreeWidgetItem(infraviariimd)
            infraviariimd18.setFlags(infraviariimd18.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd18.setText(0, "Intensidad media 2018")
            infraviariimd18.setCheckState(0, Qt.Unchecked)
            infraviariimd17 = QTreeWidgetItem(infraviariimd)
            infraviariimd17.setFlags(infraviariimd17.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd17.setText(0, "Intensidad media 2017")
            infraviariimd17.setCheckState(0, Qt.Unchecked)
            infraviariimd16 = QTreeWidgetItem(infraviariimd)
            infraviariimd16.setFlags(infraviariimd16.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd16.setText(0, "Intensidad media 2016")
            infraviariimd16.setCheckState(0, Qt.Unchecked)
            infraviariimd15 = QTreeWidgetItem(infraviariimd)
            infraviariimd15.setFlags(infraviariimd15.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd15.setText(0, "Intensidad media 2015")
            infraviariimd15.setCheckState(0, Qt.Unchecked)
            infraviariimd14 = QTreeWidgetItem(infraviariimd)
            infraviariimd14.setFlags(infraviariimd14.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd14.setText(0, "Intensidad media 2014")
            infraviariimd14.setCheckState(0, Qt.Unchecked)
            infraviariimd13 = QTreeWidgetItem(infraviariimd)
            infraviariimd13.setFlags(infraviariimd13.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd13.setText(0, "Intensidad media 2013")
            infraviariimd13.setCheckState(0, Qt.Unchecked)
            infraviariimd12 = QTreeWidgetItem(infraviariimd)
            infraviariimd12.setFlags(infraviariimd12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd12.setText(0, "Intensidad media 2012")
            infraviariimd12.setCheckState(0, Qt.Unchecked)
            infraviariimd11 = QTreeWidgetItem(infraviariimd)
            infraviariimd11.setFlags(infraviariimd11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd11.setText(0, "Intensidad media 2011")
            infraviariimd11.setCheckState(0, Qt.Unchecked)
            infraviariimd10 = QTreeWidgetItem(infraviariimd)
            infraviariimd10.setFlags(infraviariimd10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd10.setText(0, "Intensidad media 2010")
            infraviariimd10.setCheckState(0, Qt.Unchecked)
            infraviariimd09 = QTreeWidgetItem(infraviariimd)
            infraviariimd09.setFlags(infraviariimd09.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd09.setText(0, "Intensidad media 2009")
            infraviariimd09.setCheckState(0, Qt.Unchecked)
            infraviaricarrh = QTreeWidgetItem(infraesviarias)
            infraviaricarrh.setFlags(infraviaricarrh.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarrh.setText(0, "Carreteras históricas")
            infraviaricarrh.setCheckState(0, Qt.Unchecked)
            infraviaricarrhc = QTreeWidgetItem(infraviaricarrh)
            infraviaricarrhc.setFlags(infraviaricarrhc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarrhc.setText(0, "Casillas de peones camineros-históricas")
            infraviaricarrhc.setCheckState(0, Qt.Unchecked)
            infraviaricarr76 = QTreeWidgetItem(infraviaricarrh)
            infraviaricarr76.setFlags(infraviaricarr76.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr76.setText(0, "Red de carreteras año 1976")
            infraviaricarr76.setCheckState(0, Qt.Unchecked)
            infraviaricarr56 = QTreeWidgetItem(infraviaricarrh)
            infraviaricarr56.setFlags(infraviaricarr56.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr56.setText(0, "Red de carreteras año 1956")
            infraviaricarr56.setCheckState(0, Qt.Unchecked)
            infraviaricarr09 = QTreeWidgetItem(infraviaricarrh)
            infraviaricarr09.setFlags(infraviaricarr09.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr09.setText(0, "Red de carreteras año 1909")
            infraviaricarr09.setCheckState(0, Qt.Unchecked)
            infraviaricalz = QTreeWidgetItem(infraesviarias)
            infraviaricalz.setFlags(infraviaricalz.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricalz.setText(0, "Calzadas romanas")
            infraviaricalz.setCheckState(0, Qt.Unchecked)
            infraviariaug = QTreeWidgetItem(infraviaricalz)
            infraviariaug.setFlags(infraviariaug.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariaug.setText(0, "Via Augusta")
            infraviariaug.setCheckState(0, Qt.Unchecked)
            infraviaridia = QTreeWidgetItem(infraviaricalz)
            infraviaridia.setFlags(infraviaridia.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaridia.setText(0, "Via Dianium")
            infraviaridia.setCheckState(0, Qt.Unchecked)
            infraviarialac = QTreeWidgetItem(infraviaricalz)
            infraviarialac.setFlags(infraviarialac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviarialac.setText(0, "Ramal Alicante")
            infraviarialac.setCheckState(0, Qt.Unchecked)
            infraesmobili = QTreeWidgetItem(infraestructuras)
            infraesmobili.setText(0, "Movilidad")
            infraviamobej = QTreeWidgetItem(infraesmobili)
            infraviamobej.setFlags(infraviamobej.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobej.setText(0, "Manual ejemplos constructivos buenas")
            infraviamobej.setCheckState(0, Qt.Unchecked)
            infraviamobejl = QTreeWidgetItem(infraviamobej)
            infraviamobejl.setFlags(infraviamobejl.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobejl.setText(0, "Líneas de intervención")
            infraviamobejl.setCheckState(0, Qt.Unchecked)
            infraviamobcap = QTreeWidgetItem(infraviamobejl)
            infraviamobcap.setFlags(infraviamobcap.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobcap.setText(0, "Capacidad funcional")
            infraviamobcap.setCheckState(0, Qt.Unchecked)
            infraviamobpue = QTreeWidgetItem(infraviamobejl)
            infraviamobpue.setFlags(infraviamobpue.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobpue.setText(0, "Puerta de entrada")
            infraviamobpue.setCheckState(0, Qt.Unchecked)
            infraviamobcic = QTreeWidgetItem(infraviamobejl)
            infraviamobcic.setFlags(infraviamobcic.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobcic.setText(0, "Mejora peatonal ciclista")
            infraviamobcic.setCheckState(0, Qt.Unchecked)
            infraviamobmod = QTreeWidgetItem(infraviamobejl)
            infraviamobmod.setFlags(infraviamobmod.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobmod.setText(0, "Moderación de velocidad")
            infraviamobmod.setCheckState(0, Qt.Unchecked)
            infraviamobpea = QTreeWidgetItem(infraviamobejl)
            infraviamobpea.setFlags(infraviamobpea.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobpea.setText(0, "Permeabilidad peatonal")
            infraviamobpea.setCheckState(0, Qt.Unchecked)
            infraviamobiti = QTreeWidgetItem(infraviamobejl)
            infraviamobiti.setFlags(infraviamobiti.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobiti.setText(0, "Itinerarios accesibles")
            infraviamobiti.setCheckState(0, Qt.Unchecked)
            infraviamobordt = QTreeWidgetItem(infraviamobejl)
            infraviamobordt.setFlags(infraviamobordt.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobordt.setText(0, "Ordenación del transporte")
            infraviamobordt.setCheckState(0, Qt.Unchecked)
            infraviamoborde = QTreeWidgetItem(infraviamobejl)
            infraviamoborde.setFlags(infraviamoborde.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamoborde.setText(0, "Ordenación del entorno")
            infraviamoborde.setCheckState(0, Qt.Unchecked)
            infraviamobactu = QTreeWidgetItem(infraviamobej)
            infraviamobactu.setFlags(infraviamobactu.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobactu.setText(0, "Actuaciones")
            infraviamobactu.setCheckState(0, Qt.Unchecked)
            infraesports = QTreeWidgetItem(infraestructuras)
            infraesports.setText(0, "Puertos")
            infraportcv = QTreeWidgetItem(infraesports)
            infraportcv.setFlags(infraportcv.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportcv.setText(0, "Puertos de la Comunitat Valenciana")
            infraportcv.setCheckState(0, Qt.Unchecked)
            infraportact = QTreeWidgetItem(infraesports)
            infraportact.setFlags(infraportact.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportact.setText(0, "Actividades náuticas deportivas")
            infraportact.setCheckState(0, Qt.Unchecked)
            infraportaca = QTreeWidgetItem(infraportact)
            infraportaca.setFlags(infraportaca.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportaca.setText(0, "Academias náuticas")
            infraportaca.setCheckState(0, Qt.Unchecked)
            infraportabu = QTreeWidgetItem(infraportact)
            infraportabu.setFlags(infraportabu.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportabu.setText(0, "Centros de buceo")
            infraportabu.setCheckState(0, Qt.Unchecked)
            infraesruido = QTreeWidgetItem(infraestructuras)
            infraesruido.setText(0, "Ruido")
            infraesruidoma = QTreeWidgetItem(infraesruido)
            infraesruidoma.setFlags(infraesruidoma.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidoma.setText(0, "Mapas de ruido - Grandes ejes viarios - 3ª fase")
            infraesruidoma.setCheckState(0, Qt.Unchecked)
            infraesruidomac = QTreeWidgetItem(infraesruidoma)
            infraesruidomac.setFlags(infraesruidomac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidomac.setText(0, "Condicionantes acústicos carreteras fase 3")
            infraesruidomac.setCheckState(0, Qt.Unchecked)
            infraesruidolden = QTreeWidgetItem(infraesruidoma)
            infraesruidolden.setFlags(infraesruidolden.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidolden.setText(0, "Lden carreteras fase 3")
            infraesruidolden.setCheckState(0, Qt.Unchecked)
            infraesruidold = QTreeWidgetItem(infraesruidoma)
            infraesruidold.setFlags(infraesruidold.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidold.setText(0, "Ld carreteras fase 3")
            infraesruidold.setCheckState(0, Qt.Unchecked)
            infraesruidole = QTreeWidgetItem(infraesruidoma)
            infraesruidole.setFlags(infraesruidole.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidole.setText(0, "Le carreteras fase 3")
            infraesruidole.setCheckState(0, Qt.Unchecked)
            infraesruidoln = QTreeWidgetItem(infraesruidoma)
            infraesruidoln.setFlags(infraesruidoln.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidoln.setText(0, "Ln carreteras fase 3")
            infraesruidoln.setCheckState(0, Qt.Unchecked)
            infraesruidofe = QTreeWidgetItem(infraesruido)
            infraesruidofe.setFlags(infraesruidofe.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidofe.setText(0, "Mapas de ruido - Grandes ejes ferroviarios - 3ª fase")
            infraesruidofe.setCheckState(0, Qt.Unchecked)
            infraesruidomaf = QTreeWidgetItem(infraesruidofe)
            infraesruidomaf.setFlags(infraesruidomaf.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidomaf.setText(0, "Condicionantes acústicos ferroviarios fase 3")
            infraesruidomaf.setCheckState(0, Qt.Unchecked)
            infraesruidolden = QTreeWidgetItem(infraesruidofe)
            infraesruidolden.setFlags(infraesruidolden.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidolden.setText(0, "Lden ferroviarios fase 3")
            infraesruidolden.setCheckState(0, Qt.Unchecked)
            infraesruidold = QTreeWidgetItem(infraesruidofe)
            infraesruidold.setFlags(infraesruidold.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidold.setText(0, "Ld ferroviarios fase 3")
            infraesruidold.setCheckState(0, Qt.Unchecked)
            infraesruidole = QTreeWidgetItem(infraesruidofe)
            infraesruidole.setFlags(infraesruidole.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidole.setText(0, "Le ferroviarios fase 3")
            infraesruidole.setCheckState(0, Qt.Unchecked)
            infraesruidoln = QTreeWidgetItem(infraesruidofe)
            infraesruidoln.setFlags(infraesruidoln.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidoln.setText(0, "Ln ferroviarios fase 3")
            infraesruidoln.setCheckState(0, Qt.Unchecked)
            telecomunicaciones = QTreeWidgetItem(infraestructuras)
            telecomunicaciones.setText(0, "Telecomunicaciones")
            telecomunicacionesr = QTreeWidgetItem(telecomunicaciones)
            telecomunicacionesr.setFlags(telecomunicacionesr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesr.setText(0, "Cobertura redes fija por velocidad de acceso")
            telecomunicacionesr.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm = QTreeWidgetItem(telecomunicacionesr)
            telecomunicacionesrm.setFlags(telecomunicacionesrm.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm.setText(0, "Por municipio")
            telecomunicacionesrm.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm100 = QTreeWidgetItem(telecomunicacionesrm)
            telecomunicacionesrm100.setFlags(telecomunicacionesrm100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm100.setText(0, "100 Mbps")
            telecomunicacionesrm100.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm30 = QTreeWidgetItem(telecomunicacionesrm)
            telecomunicacionesrm30.setFlags(telecomunicacionesrm30.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm30.setText(0, "30 Mbps")
            telecomunicacionesrm30.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm10 = QTreeWidgetItem(telecomunicacionesrm)
            telecomunicacionesrm10.setFlags(telecomunicacionesrm10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm10.setText(0, "10 Mbps")
            telecomunicacionesrm10.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn = QTreeWidgetItem(telecomunicacionesr)
            telecomunicacionesrn.setFlags(telecomunicacionesrn.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn.setText(0, "Por núcleo de población")
            telecomunicacionesrn.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn100 = QTreeWidgetItem(telecomunicacionesrn)
            telecomunicacionesrn100.setFlags(telecomunicacionesrn100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn100.setText(0, "100 Mbps ")
            telecomunicacionesrn100.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn30 = QTreeWidgetItem(telecomunicacionesrn)
            telecomunicacionesrn30.setFlags(telecomunicacionesrn30.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn30.setText(0, "30 Mbps ")
            telecomunicacionesrn30.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn10 = QTreeWidgetItem(telecomunicacionesrn)
            telecomunicacionesrn10.setFlags(telecomunicacionesrn10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn10.setText(0, "10 Mbps ")
            telecomunicacionesrn10.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp = QTreeWidgetItem(telecomunicacionesr)
            telecomunicacionesrp.setFlags(telecomunicacionesrp.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp.setText(0, "Por polígono industrial")
            telecomunicacionesrp.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp100 = QTreeWidgetItem(telecomunicacionesrp)
            telecomunicacionesrp100.setFlags(telecomunicacionesrp100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp100.setText(0, "100 Mbps  ")
            telecomunicacionesrp100.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp30 = QTreeWidgetItem(telecomunicacionesrp)
            telecomunicacionesrp30.setFlags(telecomunicacionesrp30.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp30.setText(0, "30 Mbps  ")
            telecomunicacionesrp30.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp10 = QTreeWidgetItem(telecomunicacionesrp)
            telecomunicacionesrp10.setFlags(telecomunicacionesrp10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp10.setText(0, "10 Mbps  ")
            telecomunicacionesrp10.setCheckState(0, Qt.Unchecked)
            telecomunicacionesz = QTreeWidgetItem(telecomunicaciones)
            telecomunicacionesz.setFlags(telecomunicacionesz.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesz.setText(0, "Zonas Blancas NGA")
            telecomunicacionesz.setCheckState(0, Qt.Unchecked)
            telecomunicacioneszr = QTreeWidgetItem(telecomunicacionesz)
            telecomunicacioneszr.setFlags(telecomunicacioneszr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacioneszr.setText(0, "Áreas residenciales")
            telecomunicacioneszr.setCheckState(0, Qt.Unchecked)
            telecomunicacioneszi = QTreeWidgetItem(telecomunicacionesz)
            telecomunicacioneszi.setFlags(telecomunicacioneszi.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacioneszi.setText(0, "Áreas industriales")
            telecomunicacioneszi.setCheckState(0, Qt.Unchecked)
            transport = QTreeWidgetItem(infraestructuras)
            transport.setText(0, "Transportes")
            transportt = QTreeWidgetItem(transport)
            transportt.setFlags(transportt.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            transportt.setText(0, "Taxi APC")
            transportt.setCheckState(0, Qt.Unchecked)
            industria = QTreeWidgetItem(capas)
            industria.setText(0, "Industria")
            industriac = QTreeWidgetItem(industria)
            industriac.setText(0, "Certificados energéticos")
            industriacer = QTreeWidgetItem(industriac)
            industriacer.setFlags(industriacer.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            industriacer.setText(0, "Certificados")
            industriacer.setCheckState(0, Qt.Unchecked)
            ordenacio = QTreeWidgetItem(capas)
            ordenacio.setText(0, "Ordenación del territorio y Urbanismo")
            ordenacioar = QTreeWidgetItem(ordenacio)
            ordenacioar.setText(0, "Áreas críticas frente al Cambio Climático")
            ordenacioarac = QTreeWidgetItem(ordenacioar)
            ordenacioarac.setFlags(ordenacioarac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioarac.setText(0, "Recarga de acuíferos")
            ordenacioarac.setCheckState(0, Qt.Unchecked)
            ordenacioarper = QTreeWidgetItem(ordenacioar)
            ordenacioarper.setFlags(ordenacioarper.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioarper.setText(0, "Permeabilidad del suelo")
            ordenacioarper.setCheckState(0, Qt.Unchecked)
            ordenacioarpmar = QTreeWidgetItem(ordenacioar)
            ordenacioarpmar.setFlags(ordenacioarpmar.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioarpmar.setText(0, "Intrusión marina")
            ordenacioarpmar.setCheckState(0, Qt.Unchecked)
            ordenacioin = QTreeWidgetItem(ordenacio)
            ordenacioin.setText(0, "Infraestructura Verde")
            ordenacioinreg = QTreeWidgetItem(ordenacioin)
            ordenacioinreg.setText(0, "Infraestructura Verde regional")
            ordenacioinregca = QTreeWidgetItem(ordenacioinreg)
            ordenacioinregca.setFlags(ordenacioinregca.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinregca.setText(0, "Cavidades subterráneas catalogadas - Municipios")
            ordenacioinregca.setCheckState(0, Qt.Unchecked)
            ordenacioinunes = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunes.setFlags(ordenacioinunes.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunes.setText(0, "Patrimonio Mundial de la Unesco")
            ordenacioinunes.setCheckState(0, Qt.Unchecked)
            ordenacioinunesl = QTreeWidgetItem(ordenacioinunes)
            ordenacioinunesl.setFlags(ordenacioinunesl.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunesl.setText(0, "Lonja de la seda de València")
            ordenacioinunesl.setCheckState(0, Qt.Unchecked)
            ordenacioinunesp = QTreeWidgetItem(ordenacioinunes)
            ordenacioinunesp.setFlags(ordenacioinunesp.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunesp.setText(0, "Palmeral de Elche")
            ordenacioinunesp.setCheckState(0, Qt.Unchecked)
            ordenacioinunesa = QTreeWidgetItem(ordenacioinunes)
            ordenacioinunesa.setFlags(ordenacioinunesa.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunesa.setText(0, "Arte rupestre del Arco Mediterráneo de la Península Ibérica")
            ordenacioinunesa.setCheckState(0, Qt.Unchecked)
            ordenacioinuneam = QTreeWidgetItem(ordenacioinreg)
            ordenacioinuneam.setFlags(ordenacioinuneam.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinuneam.setText(0, "Zona de Amortiguacion de Monumentos Naturales")
            ordenacioinuneam.setCheckState(0, Qt.Unchecked)
            ordenacioinunemo = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunemo.setFlags(ordenacioinunemo.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunemo.setText(0, "Monumentos Naturales")
            ordenacioinunemo.setCheckState(0, Qt.Unchecked)
            ordenacioinunezo = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunezo.setFlags(ordenacioinunezo.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunezo.setText(0, "Zonas Húmedas de Importancia Inernacional")
            ordenacioinunezo.setCheckState(0, Qt.Unchecked)
            ordenacioinunezoc = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunezoc.setFlags(ordenacioinunezoc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunezoc.setText(0, "Zonas Húmedas Catalogadas")
            ordenacioinunezoc.setCheckState(0, Qt.Unchecked)
            ordenacioinunezop = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunezop.setFlags(ordenacioinunezop.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunezop.setText(0, "Zona de Protección de Zonas Húmedas")
            ordenacioinunezop.setCheckState(0, Qt.Unchecked)
            ordenacioparque = QTreeWidgetItem(ordenacioinreg)
            ordenacioparque.setFlags(ordenacioparque.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioparque.setText(0, "Parques Naturales")
            ordenacioparque.setCheckState(0, Qt.Unchecked)
            ordenacioparaje = QTreeWidgetItem(ordenacioinreg)
            ordenacioparaje.setFlags(ordenacioparaje.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioparaje.setText(0, "Parajes Naturales Municipales")
            ordenacioparaje.setCheckState(0, Qt.Unchecked)
            ordenacioreserva = QTreeWidgetItem(ordenacioinreg)
            ordenacioreserva.setFlags(ordenacioreserva.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioreserva.setText(0, "Reservas Naturales")
            ordenacioreserva.setCheckState(0, Qt.Unchecked)
            ordenacioprotegido = QTreeWidgetItem(ordenacioinreg)
            ordenacioprotegido.setFlags(ordenacioprotegido.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioprotegido.setText(0, "Paisajes Protegidos")
            ordenacioprotegido.setCheckState(0, Qt.Unchecked)
            ordenacioincopl = QTreeWidgetItem(ordenacioinreg)
            ordenacioincopl.setFlags(ordenacioincopl.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincopl.setText(0, "Incorporaciones - Planes Sectoriales")
            ordenacioincopl.setCheckState(0, Qt.Unchecked)
            ordenacioincopu = QTreeWidgetItem(ordenacioinreg)
            ordenacioincopu.setFlags(ordenacioincopu.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincopu.setText(0, "Incorporaciones - Planes Urbanísticos")
            ordenacioincopu.setCheckState(0, Qt.Unchecked)
            ordenacioincopt = QTreeWidgetItem(ordenacioinreg)
            ordenacioincopt.setFlags(ordenacioincopt.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincopt.setText(0, "Incorporaciones - Planes de Acción Territorial")
            ordenacioincopt.setCheckState(0, Qt.Unchecked)
            ordenacioinzoso = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzoso.setFlags(ordenacioinzoso.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzoso.setText(0, "Zonas sometidas a peligrosidad de inundación")
            ordenacioinzoso.setCheckState(0, Qt.Unchecked)
            ordenacioinmontes = QTreeWidgetItem(ordenacioinreg)
            ordenacioinmontes.setFlags(ordenacioinmontes.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmontes.setText(0, "Montes Catalogados")
            ordenacioinmontes.setCheckState(0, Qt.Unchecked)
            ordenacioinlics = QTreeWidgetItem(ordenacioinreg)
            ordenacioinlics.setFlags(ordenacioinlics.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinlics.setText(0, "Lugares de Interés Comunitario")
            ordenacioinlics.setCheckState(0, Qt.Unchecked)
            ordenacioinzepas = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzepas.setFlags(ordenacioinzepas.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzepas.setText(0, "Zonas de Especial Protección para las Aves")
            ordenacioinzepas.setCheckState(0, Qt.Unchecked)
            ordenacioinzepas = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzepas.setFlags(ordenacioinzepas.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzepas.setText(0, "Zonas de Especial Conservación")
            ordenacioinzepas.setCheckState(0, Qt.Unchecked)
            ordenacioinzepim = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzepim.setFlags(ordenacioinzepim.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzepim.setText(0, "Zonas Especialmente Protegidas de Importancia para el Mediterráneo")
            ordenacioinzepim.setCheckState(0, Qt.Unchecked)
            ordenacioinpatfor = QTreeWidgetItem(ordenacioinreg)
            ordenacioinpatfor.setFlags(ordenacioinpatfor.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinpatfor.setText(0, "Terreno forestal estratégico - PATFOR")
            ordenacioinpatfor.setCheckState(0, Qt.Unchecked)
            ordenacioincorre = QTreeWidgetItem(ordenacioinreg)
            ordenacioincorre.setFlags(ordenacioincorre.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincorre.setText(0, "Corredores territoriales")
            ordenacioincorre.setCheckState(0, Qt.Unchecked)
            ordenacioinregio = QTreeWidgetItem(ordenacioinreg)
            ordenacioinregio.setFlags(ordenacioinregio.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinregio.setText(0, "Paisajes de Relevancia Regional")
            ordenacioinregio.setCheckState(0, Qt.Unchecked)
            ordenacioinmun = QTreeWidgetItem(ordenacioin)
            ordenacioinmun.setText(0, "Infraestructura Verde Municipal")
            ordenacioinmun01 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun01.setFlags(ordenacioinmun01.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun01.setText(0, "IVM Espacios Naturales Protegidos")
            ordenacioinmun01.setCheckState(0, Qt.Unchecked)
            ordenacioinmun02 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun02.setFlags(ordenacioinmun02.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun02.setText(0, "IVM Red Natura 2000")
            ordenacioinmun02.setCheckState(0, Qt.Unchecked)
            ordenacioinmun03 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun03.setFlags(ordenacioinmun03.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun03.setText(0, "IVM Humedales Masas de agua")
            ordenacioinmun03.setCheckState(0, Qt.Unchecked)
            ordenacioinmun04 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun04.setFlags(ordenacioinmun04.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun04.setText(0, "IVM Patrim. Nat. Internacional")
            ordenacioinmun04.setCheckState(0, Qt.Unchecked)
            ordenacioinmun05 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun05.setFlags(ordenacioinmun05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun05.setText(0, "IVM Montes y suelo forestal")
            ordenacioinmun05.setCheckState(0, Qt.Unchecked)
            ordenacioinmun06 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun06.setFlags(ordenacioinmun06.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun06.setText(0, "IVM Riesgos naturales")
            ordenacioinmun06.setCheckState(0, Qt.Unchecked)
            ordenacioinmun07 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun07.setFlags(ordenacioinmun07.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun07.setText(0, "IVM Espacios paisajísticos (pun).")
            ordenacioinmun07.setCheckState(0, Qt.Unchecked)
            ordenacioinmun08 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun08.setFlags(ordenacioinmun08.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun08.setText(0, "IVM Espacios paisajísticos (pol).")
            ordenacioinmun08.setCheckState(0, Qt.Unchecked)
            ordenacioinmun09 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun09.setFlags(ordenacioinmun09.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun09.setText(0, "IVM Valor Cultural (pun).")
            ordenacioinmun09.setCheckState(0, Qt.Unchecked)
            ordenacioinmun10 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun10.setFlags(ordenacioinmun10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun10.setText(0, "IVM Valor Cultural (pol).")
            ordenacioinmun10.setCheckState(0, Qt.Unchecked)
            ordenacioinmun11 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun11.setFlags(ordenacioinmun11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun11.setText(0, "IVM Conectores y Corredores (lin).")
            ordenacioinmun11.setCheckState(0, Qt.Unchecked)
            ordenacioinmun12 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun12.setFlags(ordenacioinmun12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun12.setText(0, "IVM Conectores y Corredores (pol).")
            ordenacioinmun12.setCheckState(0, Qt.Unchecked)
            ordenacioinmun13 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun13.setFlags(ordenacioinmun13.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun13.setText(0, "IVM Suelo Urbano y Urbanizable")
            ordenacioinmun13.setCheckState(0, Qt.Unchecked)
            ordenacioinmun14 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun14.setFlags(ordenacioinmun14.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun14.setText(0, "IVM Delimitación y planeamiento")
            ordenacioinmun14.setCheckState(0, Qt.Unchecked)
            ordenaciorecur = QTreeWidgetItem(ordenacioin)
            ordenaciorecur.setText(0, "Recursos Paisajísticos")
            ordenacioirecur1 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur1.setFlags(ordenacioirecur1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur1.setText(0, "RP Culturales locales (elementos)")
            ordenacioirecur1.setCheckState(0, Qt.Unchecked)
            ordenacioirecur2 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur2.setFlags(ordenacioirecur2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur2.setText(0, "RP Culturales regionales (elementos)")
            ordenacioirecur2.setCheckState(0, Qt.Unchecked)
            ordenacioirecur3 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur3.setFlags(ordenacioirecur3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur3.setText(0, "RP Culturales regionales (recintos)")
            ordenacioirecur3.setCheckState(0, Qt.Unchecked)
            ordenacioirecur6 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur6.setFlags(ordenacioirecur6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur6.setText(0, "RP Cavidades subterráneas catalogadas - Municipios")
            ordenacioirecur6.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes = QTreeWidgetItem(ordenaciorecur)
            ordenaciorecurunes.setFlags(costesfotogr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes.setText(0, "RP  Patrimonio Mundial de la UNESCO")
            ordenaciorecurunes.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes1 = QTreeWidgetItem(ordenaciorecurunes)
            ordenaciorecurunes1.setFlags(ordenaciorecurunes1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes1.setText(0, "Lonja de la Seda de València")
            ordenaciorecurunes1.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes2 = QTreeWidgetItem(ordenaciorecurunes)
            ordenaciorecurunes2.setFlags(ordenaciorecurunes2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes2.setText(0, "Palmeral de Elche")
            ordenaciorecurunes2.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes3 = QTreeWidgetItem(ordenaciorecurunes)
            ordenaciorecurunes3.setFlags(ordenaciorecurunes3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes3.setText(0, "Arte rupestre del Arco Mediterráneo de la Península Ibérica")
            ordenaciorecurunes3.setCheckState(0, Qt.Unchecked)
            ordenacioirecur4 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur4.setFlags(ordenacioirecur4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur4.setText(0, "RP Zona de Amortiguación de Monumentos Naturales")
            ordenacioirecur4.setCheckState(0, Qt.Unchecked)
            ordenacioirecur5 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur5.setFlags(ordenacioirecur5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur5.setText(0, "RP Monumentos Naturales")
            ordenacioirecur5.setCheckState(0, Qt.Unchecked)
            ordenaterrito = QTreeWidgetItem(ordenacioin)
            ordenaterrito.setText(0, "Ordenación territorial")
            ordenacioiterrito1 = QTreeWidgetItem(ordenaterrito)
            ordenacioiterrito1.setText(0, "PATRICOVA-Plan de Acción Territorial de carácter sectorial sobre prevención del Riesgo de Inundación en Comunitat Valenciana")
            ordenacioiterrito1.setFlags(ordenacioiterrito1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito1.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito2 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito2.setText(0, "Estudios de inundabilidad")
            ordenacioiterrito2.setFlags(ordenacioiterrito2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito2.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito3 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito3.setText(0, "Peligrosidad por inundación")
            ordenacioiterrito3.setFlags(ordenacioiterrito3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito3.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito4 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito4.setText(0, "Red de cauces")
            ordenacioiterrito4.setFlags(ordenacioiterrito4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito4.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito5 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito5.setText(0, "Peligrosidad 1")
            ordenacioiterrito5.setFlags(ordenacioiterrito5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito5.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito6 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito6.setText(0, "Peligrosidad 2")
            ordenacioiterrito6.setFlags(ordenacioiterrito6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito6.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito7 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito7.setText(0, "Peligrosidad 3")
            ordenacioiterrito7.setFlags(ordenacioiterrito7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito7.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito8 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito8.setText(0, "Peligrosidad 4")
            ordenacioiterrito8.setFlags(ordenacioiterrito8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito8.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito9 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito9.setText(0, "Peligrosidad 5")
            ordenacioiterrito9.setFlags(ordenacioiterrito9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito9.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito10 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito10.setText(0, "Peligrosidad 6")
            ordenacioiterrito10.setFlags(ordenacioiterrito10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito10.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito11 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito11.setText(0, "Peligrosidad Geomorfológica")
            ordenacioiterrito11.setFlags(ordenacioiterrito11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito11.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito12 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito12.setText(0, "Envolvente de Peligrosidad por Inundación")
            ordenacioiterrito12.setFlags(ordenacioiterrito12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito12.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito13 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito13.setText(0, "Riesgo de Inundación")
            ordenacioiterrito13.setFlags(ordenacioiterrito13.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito13.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat = QTreeWidgetItem(ordenaterrito)
            ordenacioterritopat.setText(0, "PATIVEL")
            ordenacioterritopat.setFlags(ordenacioterritopat.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat1 = QTreeWidgetItem(ordenacioterritopat)
            ordenacioterritopat1.setText(0, "Zonas de Protección")
            ordenacioterritopat1.setFlags(ordenacioterritopat1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat1.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat2 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat2.setText(0, "Ámbito estricto")
            ordenacioterritopat2.setFlags(ordenacioterritopat2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat2.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat3 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat3.setText(0, "Ámbito ampliado")
            ordenacioterritopat3.setFlags(ordenacioterritopat3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat3.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat4 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat4.setText(0, "Ámbito de conexión")
            ordenacioterritopat4.setFlags(ordenacioterritopat4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat4.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat5 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat5.setText(0, "Protección litoral")
            ordenacioterritopat5.setFlags(ordenacioterritopat5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat5.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat6 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat6.setText(0, "Suelos transitorios")
            ordenacioterritopat6.setFlags(ordenacioterritopat6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat6.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat7 = QTreeWidgetItem(ordenacioterritopat)
            ordenacioterritopat7.setText(0, "Catálogo de playas de la C.V.")
            ordenacioterritopat7.setFlags(ordenacioterritopat7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat7.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat8 = QTreeWidgetItem(ordenacioterritopat7)
            ordenacioterritopat8.setText(0, "Catálogo")
            ordenacioterritopat8.setFlags(ordenacioterritopat8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat8.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer = QTreeWidgetItem(ordenaterrito)
            ordenacioterritohuer.setText(0, "Ley de la Huerta de València")
            ordenacioterritohuer.setFlags(ordenacioterritohuer.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer1 = QTreeWidgetItem(ordenacioterritohuer)
            ordenacioterritohuer1.setText(0, "Ámbito Ley de la Huerta")
            ordenacioterritohuer1.setFlags(ordenacioterritohuer1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer1.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer2 = QTreeWidgetItem(ordenaterrito)
            ordenacioterritohuer2.setText(0, "PAT de la Huerta")
            ordenacioterritohuer2.setFlags(ordenacioterritohuer.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer2.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer3 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer3.setText(0, "Ámbito estricto ")
            ordenacioterritohuer3.setFlags(ordenacioterritohuer3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer3.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer4 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer4.setText(0, "Ámbito ampliado ")
            ordenacioterritohuer4.setFlags(ordenacioterritohuer4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer4.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer5 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer5.setText(0, "Enclaves huerta")
            ordenacioterritohuer5.setFlags(ordenacioterritohuer5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer5.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer6 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer6.setText(0, "Disposición transitoria")
            ordenacioterritohuer6.setFlags(ordenacioterritohuer6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer6.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer7 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer7.setText(0, "Sectores recuperación huerta")
            ordenacioterritohuer7.setFlags(ordenacioterritohuer7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer7.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer8 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer8.setText(0, "Zonas rurales comunes")
            ordenacioterritohuer8.setFlags(ordenacioterritohuer8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer8.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer9 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer9.setText(0, "Áreas protección huerta")
            ordenacioterritohuer9.setFlags(ordenacioterritohuer9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer9.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett = QTreeWidgetItem(ordenaterrito)
            ordenacioterritoett.setText(0, "Estrategia Territorial de la Comunitat Valenciana")
            ordenacioterritoett.setFlags(ordenacioterritoett.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett1 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett1.setText(0, "Municipios CV límites")
            ordenacioterritoett1.setFlags(ordenacioterritoett1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett1.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett2 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett2.setText(0, "Municipios CV etiquetas")
            ordenacioterritoett2.setFlags(ordenacioterritoett2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett2.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett3 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett3.setText(0, "Áreas funcionales")
            ordenacioterritoett3.setFlags(ordenacioterritoett3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett3.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett4 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett4.setText(0, "Comarcas")
            ordenacioterritoett4.setFlags(ordenacioterritoett4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett4.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett5 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett5.setText(0, "Ámbito")
            ordenacioterritoett5.setFlags(ordenacioterritoett5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett5.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett6 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett6.setText(0, "Área Urbana Integrada")
            ordenacioterritoett6.setFlags(ordenacioterritoett6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett6.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett7 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett7.setText(0, "Sistema Nodal de Referencia")
            ordenacioterritoett7.setFlags(ordenacioterritoett7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett7.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett8 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett8.setText(0, "Tipo de Nodo")
            ordenacioterritoett8.setFlags(ordenacioterritoett8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett8.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett9 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett9.setText(0, "Área Mercado Local Trabajo")
            ordenacioterritoett9.setFlags(ordenacioterritoett9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett9.setCheckState(0, Qt.Unchecked)
            ordenacioterritopend = QTreeWidgetItem(ordenaterrito)
            ordenacioterritopend.setText(0, "Pendientes (regulación territorial)")
            ordenacioterritopend.setFlags(ordenacioterritopend.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopend.setCheckState(0, Qt.Unchecked)
            ordenacioterritopend1 = QTreeWidgetItem(ordenacioterritopend)
            ordenacioterritopend1.setText(0, "Pendientes (%)")
            ordenacioterritopend1.setFlags(ordenacioterritopend1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopend1.setCheckState(0, Qt.Unchecked)
            ordenacioplanea = QTreeWidgetItem(ordenacioin)
            ordenacioplanea.setText(0, "Planeamiento Urbanístico")
            ordenacioiplane1 = QTreeWidgetItem(ordenacioplanea)
            ordenacioiplane1.setFlags(ordenacioiplane1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiplane1.setText(0, "Clasificación")
            ordenacioiplane1.setCheckState(0, Qt.Unchecked)
            ordenacioiplane2 = QTreeWidgetItem(ordenacioplanea)
            ordenacioiplane2.setFlags(ordenacioiplane2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiplane2.setText(0, "Zonificación")
            ordenacioiplane2.setCheckState(0, Qt.Unchecked)
            ordenacioplanean = QTreeWidgetItem(ordenacioplanea)
            ordenacioplanean.setText(0, "Reclasificaciones no aprobadas")
            ordenacioiplane3 = QTreeWidgetItem(ordenacioplanean)
            ordenacioiplane3.setFlags(ordenacioiplane2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiplane3.setText(0, "Reclasificaciones no aprobadas")
            ordenacioiplane3.setCheckState(0, Qt.Unchecked)










        if self.rdb_val.isChecked() == True:  # Create the fahther and child nodes in valencian
            capas.setText(0, "Capas del visor de la IDEV") # First item of the tree, father 0
            carto = QTreeWidgetItem(capas)
            carto.setText(0, "Cartografía de referencia")
            toponimia = QTreeWidgetItem(carto)
            toponimia.setFlags(toponimia.flags() | Qt.ItemIsUserCheckable)
            toponimia.setText(0, "Nomenclàtor Toponímic Valencià")
            toponimia.setCheckState(0, Qt.Unchecked)
            basecartografica05 = QTreeWidgetItem(carto)
            basecartografica05.setText(0, "Base Cartogràfica CV05")
            orografia05 = QTreeWidgetItem(basecartografica05)
            orografia05.setFlags(orografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia05.setText(0, "Orografia")
            orografia05.setCheckState(0, Qt.Unchecked)
            puntoscota = QTreeWidgetItem(orografia05)
            puntoscota.setFlags(puntoscota.flags() | Qt.ItemIsUserCheckable)
            puntoscota.setText(0, "Punts de cota CV05")
            puntoscota.setCheckState(0, Qt.Unchecked)
            orolineas = QTreeWidgetItem(orografia05)
            orolineas.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            orolineas.setText(0, "Orografia línies CV05")
            orolineas.setCheckState(0, Qt.Unchecked)
            curvasnivel = QTreeWidgetItem(orografia05)
            curvasnivel.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            curvasnivel.setText(0, "Corbes de nivell CV05")
            curvasnivel.setCheckState(0, Qt.Unchecked)
            hidrografia05 = QTreeWidgetItem(basecartografica05)
            hidrografia05.setFlags(hidrografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia05.setText(0, "Hidrografia")
            hidrografia05.setCheckState(0, Qt.Unchecked)
            hidropuntos05 = QTreeWidgetItem(hidrografia05)
            hidropuntos05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidropuntos05.setText(0, "Hidrografia puntual CV05")
            hidropuntos05.setCheckState(0, Qt.Unchecked)
            hidrolineas05 = QTreeWidgetItem(hidrografia05)
            hidrolineas05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidrolineas05.setText(0, "Hidrografia lineal CV05")
            hidrolineas05.setCheckState(0, Qt.Unchecked)
            construcciones05 = QTreeWidgetItem(basecartografica05)
            construcciones05.setFlags(construcciones05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            construcciones05.setText(0, "Edificacions i construccions")
            construcciones05.setCheckState(0, Qt.Unchecked)
            construpuntos05 = QTreeWidgetItem(construcciones05)
            construpuntos05.setFlags(construpuntos05.flags() | Qt.ItemIsUserCheckable)
            construpuntos05.setText(0, "Construccions puntuals CV05")
            construpuntos05.setCheckState(0, Qt.Unchecked)
            construservi05 = QTreeWidgetItem(construcciones05)
            construservi05.setFlags(construservi05.flags() | Qt.ItemIsUserCheckable)
            construservi05.setText(0, "Serveis i instal·lacions CV05")
            construservi05.setCheckState(0, Qt.Unchecked)
            construlinea05 = QTreeWidgetItem(construcciones05)
            construlinea05.setFlags(construlinea05.flags() | Qt.ItemIsUserCheckable)
            construlinea05.setText(0, "Construccions lineals CV05")
            construlinea05.setCheckState(0, Qt.Unchecked)
            construedifi05 = QTreeWidgetItem(construcciones05)
            construedifi05.setFlags(construedifi05.flags() | Qt.ItemIsUserCheckable)
            construedifi05.setText(0, "Edificacions CV05")
            construedifi05.setCheckState(0, Qt.Unchecked)
            construcons05 = QTreeWidgetItem(construcciones05)
            construcons05.setFlags(construcons05.flags() | Qt.ItemIsUserCheckable)
            construcons05.setText(0, "Construccions CV05")
            construcons05.setCheckState(0, Qt.Unchecked)
            usos05 = QTreeWidgetItem(basecartografica05)
            usos05.setFlags(usos05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            usos05.setText(0, "Usos del sòl")
            usos05.setCheckState(0, Qt.Unchecked)
            usoshidro05 = QTreeWidgetItem(usos05)
            usoshidro05.setFlags(usoshidro05.flags() | Qt.ItemIsUserCheckable)
            usoshidro05.setText(0, "Hidrografia CV05")
            usoshidro05.setCheckState(0, Qt.Unchecked)
            usosarboles05 = QTreeWidgetItem(usos05)
            usosarboles05.setFlags(usosarboles05.flags() | Qt.ItemIsUserCheckable)
            usosarboles05.setText(0, "Zones amb arbres CV05")
            usosarboles05.setCheckState(0, Qt.Unchecked)
            usosinfra05 = QTreeWidgetItem(usos05)
            usosinfra05.setFlags(usosinfra05.flags() | Qt.ItemIsUserCheckable)
            usosinfra05.setText(0, "Infraestructures viàries CV05")
            usosinfra05.setCheckState(0, Qt.Unchecked)
            usosserv05 = QTreeWidgetItem(usos05)
            usosserv05.setFlags(usosserv05.flags() | Qt.ItemIsUserCheckable)
            usosserv05.setText(0, "Serveis i instal·lacions CV05")
            usosserv05.setCheckState(0, Qt.Unchecked)
            usoscultiv05 = QTreeWidgetItem(usos05)
            usoscultiv05.setFlags(usoscultiv05.flags() | Qt.ItemIsUserCheckable)
            usoscultiv05.setText(0, "Cultius CV05")
            usoscultiv05.setCheckState(0, Qt.Unchecked)
            usosentorn05 = QTreeWidgetItem(usos05)
            usosentorn05.setFlags(usosentorn05.flags() | Qt.ItemIsUserCheckable)
            usosentorn05.setText(0, "Entorns urbans CV05")
            usosentorn05.setCheckState(0, Qt.Unchecked)
            vias05 = QTreeWidgetItem(basecartografica05)
            vias05.setFlags(vias05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            vias05.setText(0, "Vies de Comunicació")
            vias05.setCheckState(0, Qt.Unchecked)
            viasnomen05 = QTreeWidgetItem(vias05)
            viasnomen05.setFlags(viasnomen05.flags() | Qt.ItemIsUserCheckable)
            viasnomen05.setText(0, "Nomenclatura infraestructura viària CV05")
            viasnomen05.setCheckState(0, Qt.Unchecked)
            viasferro05 = QTreeWidgetItem(vias05)
            viasferro05.setFlags(viasferro05.flags() | Qt.ItemIsUserCheckable)
            viasferro05.setText(0, "Xarxa de ferrocarrils CV05")
            viasferro05.setCheckState(0, Qt.Unchecked)
            viascomu05 = QTreeWidgetItem(vias05)
            viascomu05.setFlags(viascomu05.flags() | Qt.ItemIsUserCheckable)
            viascomu05.setText(0, "Xarxa de comunicacions CV05")
            viascomu05.setCheckState(0, Qt.Unchecked)
            basecartografica50 = QTreeWidgetItem(carto)
            basecartografica50.setText(0, "Base Cartogràfica CV50")
            orografia50 = QTreeWidgetItem(basecartografica50)
            orografia50.setFlags(orografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia50.setText(0, "Orografia  ")
            orografia50.setCheckState(0, Qt.Unchecked)
            orografiacosta50 = QTreeWidgetItem(orografia50)
            orografiacosta50.setFlags(orografiacosta50.flags() | Qt.ItemIsUserCheckable)
            orografiacosta50.setText(0, "Línia de costa CV50")
            orografiacosta50.setCheckState(0, Qt.Unchecked)
            orografiacurva50 = QTreeWidgetItem(orografia50)
            orografiacurva50.setFlags(orografiacurva50.flags() | Qt.ItemIsUserCheckable)
            orografiacurva50.setText(0, "Corbes de nivell CV50")
            orografiacurva50.setCheckState(0, Qt.Unchecked)
            hidrografia50 = QTreeWidgetItem(basecartografica50)
            hidrografia50.setFlags(hidrografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia50.setText(0, "Hidrografia")
            hidrografia50.setCheckState(0, Qt.Unchecked)
            hidrocursoa50 = QTreeWidgetItem(hidrografia50)
            hidrocursoa50.setFlags(hidrocursoa50.flags() | Qt.ItemIsUserCheckable)
            hidrocursoa50.setText(0, "Curs natural CV50")
            hidrocursoa50.setCheckState(0, Qt.Unchecked)
            hidrocurson50 = QTreeWidgetItem(hidrografia50)
            hidrocurson50.setFlags(hidrocurson50.flags() | Qt.ItemIsUserCheckable)
            hidrocurson50.setText(0, "Curs artificial CV50")
            hidrocurson50.setCheckState(0, Qt.Unchecked)
            hidrolecho50 = QTreeWidgetItem(hidrografia50)
            hidrolecho50.setFlags(hidrolecho50.flags() | Qt.ItemIsUserCheckable)
            hidrolecho50.setText(0, "Llit natural CV50")
            hidrolecho50.setCheckState(0, Qt.Unchecked)
            hidroembal50 = QTreeWidgetItem(hidrografia50)
            hidroembal50.setFlags(hidroembal50.flags() | Qt.ItemIsUserCheckable)
            hidroembal50.setText(0, "Embassament CV50")
            hidroembal50.setCheckState(0, Qt.Unchecked)
            hidrolago50 = QTreeWidgetItem(hidrografia50)
            hidrolago50.setFlags(hidrolago50.flags() | Qt.ItemIsUserCheckable)
            hidrolago50.setText(0, "Llac CV50")
            hidrolago50.setCheckState(0, Qt.Unchecked)
            hidroisla50 = QTreeWidgetItem(hidrografia50)
            hidroisla50.setFlags(hidroisla50.flags() | Qt.ItemIsUserCheckable)
            hidroisla50.setText(0, "Illa CV50")
            hidroisla50.setCheckState(0, Qt.Unchecked)
            edificacion50 = QTreeWidgetItem(basecartografica50)
            edificacion50.setFlags(edificacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edificacion50.setText(0, "Edificacions i construccions")
            edificacion50.setCheckState(0, Qt.Unchecked)
            edifiedi50 = QTreeWidgetItem(edificacion50)
            edifiedi50.setFlags(edifiedi50.flags() | Qt.ItemIsUserCheckable)
            edifiedi50.setText(0, "Edificacions CV50")
            edifiedi50.setCheckState(0, Qt.Unchecked)
            edifiedip50 = QTreeWidgetItem(edificacion50)
            edifiedip50.setFlags(edifiedip50.flags() | Qt.ItemIsUserCheckable)
            edifiedip50.setText(0, "Edificacions puntuals CV50")
            edifiedip50.setCheckState(0, Qt.Unchecked)
            edifipisci50 = QTreeWidgetItem(edificacion50)
            edifipisci50.setFlags(edifipisci50.flags() | Qt.ItemIsUserCheckable)
            edifipisci50.setText(0, "Piscina / Bassa CV50")
            edifipisci50.setCheckState(0, Qt.Unchecked)
            edifipiscip50 = QTreeWidgetItem(edificacion50)
            edifipiscip50.setFlags(edifipiscip50.flags() | Qt.ItemIsUserCheckable)
            edifipiscip50.setText(0, "Piscina / Bassa puntual CV50")
            edifipiscip50.setCheckState(0, Qt.Unchecked)
            edifiruina50 = QTreeWidgetItem(edificacion50)
            edifiruina50.setFlags(edifiruina50.flags() | Qt.ItemIsUserCheckable)
            edifiruina50.setText(0, "Edificació en ruïnes CV50")
            edifiruina50.setCheckState(0, Qt.Unchecked)
            edifiruinap50 = QTreeWidgetItem(edificacion50)
            edifiruinap50.setFlags(edifiruinap50.flags() | Qt.ItemIsUserCheckable)
            edifiruinap50.setText(0, "Edificació en ruïnes puntual CV50")
            edifiruinap50.setCheckState(0, Qt.Unchecked)
            edifextrac50 = QTreeWidgetItem(edificacion50)
            edifextrac50.setFlags(edifextrac50.flags() | Qt.ItemIsUserCheckable)
            edifextrac50.setText(0, "Activitat extractiva CV50")
            edifextrac50.setCheckState(0, Qt.Unchecked)
            edifextracp50 = QTreeWidgetItem(edificacion50)
            edifextracp50.setFlags(edifextracp50.flags() | Qt.ItemIsUserCheckable)
            edifextracp50.setText(0, "Activitat extractiva puntual CV50")
            edifextracp50.setCheckState(0, Qt.Unchecked)
            edifdeposit50 = QTreeWidgetItem(edificacion50)
            edifdeposit50.setFlags(edifdeposit50.flags() | Qt.ItemIsUserCheckable)
            edifdeposit50.setText(0, "Dipòsit")
            edifdeposit50.setCheckState(0, Qt.Unchecked)
            edifobrac50 = QTreeWidgetItem(edificacion50)
            edifobrac50.setFlags(edifobrac50.flags() | Qt.ItemIsUserCheckable)
            edifobrac50.setText(0, "Obra de contenció")
            edifobrac50.setCheckState(0, Qt.Unchecked)
            edifinverna50 = QTreeWidgetItem(edificacion50)
            edifinverna50.setFlags(edifinverna50.flags() | Qt.ItemIsUserCheckable)
            edifinverna50.setText(0, "Hivernacle")
            edifinverna50.setCheckState(0, Qt.Unchecked)
            edifpatio50 = QTreeWidgetItem(edificacion50)
            edifpatio50.setFlags(edifpatio50.flags() | Qt.ItemIsUserCheckable)
            edifpatio50.setText(0, "Pati")
            edifpatio50.setCheckState(0, Qt.Unchecked)
            edifmuralla50 = QTreeWidgetItem(edificacion50)
            edifmuralla50.setFlags(edifmuralla50.flags() | Qt.ItemIsUserCheckable)
            edifmuralla50.setText(0, "Muralla històrica")
            edifmuralla50.setCheckState(0, Qt.Unchecked)
            instalacion50 = QTreeWidgetItem(basecartografica50)
            instalacion50.setFlags(instalacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instalacion50.setText(0, "Instal·lacions i equipaments")
            instalacion50.setCheckState(0, Qt.Unchecked)
            instadota50 = QTreeWidgetItem(instalacion50)
            instadota50.setFlags(instadota50.flags() | Qt.ItemIsUserCheckable)
            instadota50.setText(0, "Espai dotacional")
            instadota50.setCheckState(0, Qt.Unchecked)
            instacircu50 = QTreeWidgetItem(instalacion50)
            instacircu50.setFlags(instacircu50.flags() | Qt.ItemIsUserCheckable)
            instacircu50.setText(0, "Circuit")
            instacircu50.setCheckState(0, Qt.Unchecked)
            instapoli50 = QTreeWidgetItem(instalacion50)
            instapoli50.setFlags(instapoli50.flags() | Qt.ItemIsUserCheckable)
            instapoli50.setText(0, "Instal·lació de transport poligonal")
            instapoli50.setCheckState(0, Qt.Unchecked)
            instalinea50 = QTreeWidgetItem(instalacion50)
            instalinea50.setFlags(instalinea50.flags() | Qt.ItemIsUserCheckable)
            instalinea50.setText(0, "Instal·lació de transport lineal")
            instalinea50.setCheckState(0, Qt.Unchecked)
            instapunt50 = QTreeWidgetItem(instalacion50)
            instapunt50.setFlags(instapunt50.flags() | Qt.ItemIsUserCheckable)
            instapunt50.setText(0, "Instal·lació de transport puntual")
            instapunt50.setCheckState(0, Qt.Unchecked)
            instadotpun50 = QTreeWidgetItem(instalacion50)
            instadotpun50.setFlags(instadotpun50.flags() | Qt.ItemIsUserCheckable)
            instadotpun50.setText(0, "Espai dotacional puntual")
            instadotpun50.setCheckState(0, Qt.Unchecked)
            instaelect50 = QTreeWidgetItem(instalacion50)
            instaelect50.setFlags(instaelect50.flags() | Qt.ItemIsUserCheckable)
            instaelect50.setText(0, "Línia elèctrica")
            instaelect50.setCheckState(0, Qt.Unchecked)
            instavertic50 = QTreeWidgetItem(instalacion50)
            instavertic50.setFlags(instavertic50.flags() | Qt.ItemIsUserCheckable)
            instavertic50.setText(0, "Vèrtexs geodèsics")
            instavertic50.setCheckState(0, Qt.Unchecked)
            viascomu50 = QTreeWidgetItem(basecartografica50)
            viascomu50.setFlags(viascomu50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            viascomu50.setText(0, "Vies de Comunicació")
            viascomu50.setCheckState(0, Qt.Unchecked)
            instared50 = QTreeWidgetItem(viascomu50)
            instared50.setFlags(instared50.flags() | Qt.ItemIsUserCheckable)
            instared50.setText(0, "Xarxa de Comunicacions")
            instared50.setCheckState(0, Qt.Unchecked)
            instaferroc50 = QTreeWidgetItem(viascomu50)
            instaferroc50.setFlags(instaferroc50.flags() | Qt.ItemIsUserCheckable)
            instaferroc50.setText(0, "Ferrocarril")
            instaferroc50.setCheckState(0, Qt.Unchecked)
            instaportal0 = QTreeWidgetItem(viascomu50)
            instaportal0.setFlags(instaportal0.flags() | Qt.ItemIsUserCheckable)
            instaportal0.setText(0, "Portals/PKs")
            instaportal0.setCheckState(0, Qt.Unchecked)
            instabocat50 = QTreeWidgetItem(viascomu50)
            instabocat50.setFlags(instabocat50.flags() | Qt.ItemIsUserCheckable)
            instabocat50.setText(0, "Boca de túnel")
            instabocat50.setCheckState(0, Qt.Unchecked)
            instaredele50 = QTreeWidgetItem(viascomu50)
            instaredele50.setFlags(instaredele50.flags() | Qt.ItemIsUserCheckable)
            instaredele50.setText(0, "Xarxa viària elevada")
            instaredele50.setCheckState(0, Qt.Unchecked)
            instaferrel50 = QTreeWidgetItem(viascomu50)
            instaferrel50.setFlags(instaferrel50.flags() | Qt.ItemIsUserCheckable)
            instaferrel50.setText(0, "Ferrocarril elevat")
            instaferrel50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Xarxa viària subterrània")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Ferrocarril subterrani")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            basecartografica100 = QTreeWidgetItem(carto)
            basecartografica100.setText(0, "Base Cartogràfica CV100")
            orografia100 = QTreeWidgetItem(basecartografica100)
            orografia100.setFlags(orografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia100.setText(0, "Orografia")
            orografia100.setCheckState(0, Qt.Unchecked)
            costa100 = QTreeWidgetItem(orografia100)
            costa100.setFlags(costa100.flags() | Qt.ItemIsUserCheckable)
            costa100.setText(0, "Línia de costa CV100")
            costa100.setCheckState(0, Qt.Unchecked)
            curvas100 = QTreeWidgetItem(orografia100)
            curvas100.setFlags(curvas100.flags() | Qt.ItemIsUserCheckable)
            curvas100.setText(0, "Corbes de nivell CV100")
            curvas100.setCheckState(0, Qt.Unchecked)
            cota100 = QTreeWidgetItem(orografia100)
            cota100.setFlags(cota100.flags() | Qt.ItemIsUserCheckable)
            cota100.setText(0, "Punts de cota CV100")
            cota100.setCheckState(0, Qt.Unchecked)
            hidrografia100 = QTreeWidgetItem(basecartografica100)
            hidrografia100.setFlags(hidrografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia100.setText(0, "Hidrografia")
            hidrografia100.setCheckState(0, Qt.Unchecked)
            curson100 = QTreeWidgetItem(hidrografia100)
            curson100.setFlags(curson100.flags() | Qt.ItemIsUserCheckable)
            curson100.setText(0, "Curs natural CV100")
            curson100.setCheckState(0, Qt.Unchecked)
            lecho100 = QTreeWidgetItem(hidrografia100)
            lecho100.setFlags(lecho100.flags() | Qt.ItemIsUserCheckable)
            lecho100.setText(0, "Llit natural CV100")
            lecho100.setCheckState(0, Qt.Unchecked)
            lago100 = QTreeWidgetItem(hidrografia100)
            lago100.setFlags(lago100.flags() | Qt.ItemIsUserCheckable)
            lago100.setText(0, "Llac CV100")
            lago100.setCheckState(0, Qt.Unchecked)
            embalse100 = QTreeWidgetItem(hidrografia100)
            embalse100.setFlags(embalse100.flags() | Qt.ItemIsUserCheckable)
            embalse100.setText(0, "Embassament CV100")
            embalse100.setCheckState(0, Qt.Unchecked)
            isla100 = QTreeWidgetItem(hidrografia100)
            isla100.setFlags(isla100.flags() | Qt.ItemIsUserCheckable)
            isla100.setText(0, "Illa CV100")
            isla100.setCheckState(0, Qt.Unchecked)
            edifica100 = QTreeWidgetItem(basecartografica100)
            edifica100.setFlags(edifica100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edifica100.setText(0, "Edificacions i construccions")
            edifica100.setCheckState(0, Qt.Unchecked)
            edificaed100 = QTreeWidgetItem(edifica100)
            edificaed100.setFlags(edificaed100.flags() | Qt.ItemIsUserCheckable)
            edificaed100.setText(0, "Edificació CV100")
            edificaed100.setCheckState(0, Qt.Unchecked)
            edificaedp100 = QTreeWidgetItem(edifica100)
            edificaedp100.setFlags(edificaedp100.flags() | Qt.ItemIsUserCheckable)
            edificaedp100.setText(0, "Edificació puntual CV100")
            edificaedp100.setCheckState(0, Qt.Unchecked)
            piscina100 = QTreeWidgetItem(edifica100)
            piscina100.setFlags(piscina100.flags() | Qt.ItemIsUserCheckable)
            piscina100.setText(0, "Piscina/Bassa CV100")
            piscina100.setCheckState(0, Qt.Unchecked)
            piscinap100 = QTreeWidgetItem(edifica100)
            piscinap100.setFlags(piscinap100.flags() | Qt.ItemIsUserCheckable)
            piscinap100.setText(0, "Piscina/Bassa puntual CV100")
            piscinap100.setCheckState(0, Qt.Unchecked)
            edificaedr100 = QTreeWidgetItem(edifica100)
            edificaedr100.setFlags(edificaedr100.flags() | Qt.ItemIsUserCheckable)
            edificaedr100.setText(0, "Edificació en ruïnes CV100")
            edificaedr100.setCheckState(0, Qt.Unchecked)
            edificaedrp100 = QTreeWidgetItem(edifica100)
            edificaedrp100.setFlags(edificaedrp100.flags() | Qt.ItemIsUserCheckable)
            edificaedrp100.setText(0, "Edificació en ruïnes puntual CV100")
            edificaedrp100.setCheckState(0, Qt.Unchecked)
            actext100 = QTreeWidgetItem(edifica100)
            actext100.setFlags(actext100.flags() | Qt.ItemIsUserCheckable)
            actext100.setText(0, "Activitat extractiva CV100")
            actext100.setCheckState(0, Qt.Unchecked)
            actextp100 = QTreeWidgetItem(edifica100)
            actextp100.setFlags(actextp100.flags() | Qt.ItemIsUserCheckable)
            actextp100.setText(0, "Activitat extractiva puntual CV100")
            actextp100.setCheckState(0, Qt.Unchecked)
            obracon100 = QTreeWidgetItem(edifica100)
            obracon100.setFlags(obracon100.flags() | Qt.ItemIsUserCheckable)
            obracon100.setText(0, "Obra de contenció CV100")
            obracon100.setCheckState(0, Qt.Unchecked)
            inverna100 = QTreeWidgetItem(edifica100)
            inverna100.setFlags(inverna100.flags() | Qt.ItemIsUserCheckable)
            inverna100.setText(0, "Hivernacle CV100")
            inverna100.setCheckState(0, Qt.Unchecked)
            patio100 = QTreeWidgetItem(edifica100)
            patio100.setFlags(patio100.flags() | Qt.ItemIsUserCheckable)
            patio100.setText(0, "Pati CV100")
            patio100.setCheckState(0, Qt.Unchecked)
            muralla100 = QTreeWidgetItem(edifica100)
            muralla100.setFlags(muralla100.flags() | Qt.ItemIsUserCheckable)
            muralla100.setText(0, "Muralla històrica CV100")
            muralla100.setCheckState(0, Qt.Unchecked)
            instala100 = QTreeWidgetItem(basecartografica100)
            instala100.setFlags(instala100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instala100.setText(0, "Instal·lacions y equipaments")
            instala100.setCheckState(0, Qt.Unchecked)
            instalinea100 = QTreeWidgetItem(instala100)
            instalinea100.setFlags(instalinea100.flags() | Qt.ItemIsUserCheckable)
            instalinea100.setText(0, "Línia elèctrica CV100")
            instalinea100.setCheckState(0, Qt.Unchecked)
            vertices100 = QTreeWidgetItem(instala100)
            vertices100.setFlags(vertices100.flags() | Qt.ItemIsUserCheckable)
            vertices100.setText(0, "Vèrtexs geodèsics CV100")
            vertices100.setCheckState(0, Qt.Unchecked)
            dotapunt100 = QTreeWidgetItem(instala100)
            dotapunt100.setFlags(dotapunt100.flags() | Qt.ItemIsUserCheckable)
            dotapunt100.setText(0, "Espai dotacional puntual CV100")
            dotapunt100.setCheckState(0, Qt.Unchecked)
            transpunt100 = QTreeWidgetItem(instala100)
            transpunt100.setFlags(transpunt100.flags() | Qt.ItemIsUserCheckable)
            transpunt100.setText(0, "Instal·lació de transport puntual CV100")
            transpunt100.setCheckState(0, Qt.Unchecked)
            deposito100 = QTreeWidgetItem(instala100)
            deposito100.setFlags(deposito100.flags() | Qt.ItemIsUserCheckable)
            deposito100.setText(0, "Depòsit CV100")
            deposito100.setCheckState(0, Qt.Unchecked)
            translin100 = QTreeWidgetItem(instala100)
            translin100.setFlags(translin100.flags() | Qt.ItemIsUserCheckable)
            translin100.setText(0, "Instal·lació de transport lineal CV100")
            translin100.setCheckState(0, Qt.Unchecked)
            transpol100 = QTreeWidgetItem(instala100)
            transpol100.setFlags(transpol100.flags() | Qt.ItemIsUserCheckable)
            transpol100.setText(0, "Instal·lació de transport poligonal CV100")
            transpol100.setCheckState(0, Qt.Unchecked)
            espadot100 = QTreeWidgetItem(instala100)
            espadot100.setFlags(espadot100.flags() | Qt.ItemIsUserCheckable)
            espadot100.setText(0, "Espai dotacional CV100")
            espadot100.setCheckState(0, Qt.Unchecked)
            comunicacion100 = QTreeWidgetItem(basecartografica100)
            comunicacion100.setFlags(comunicacion100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            comunicacion100.setText(0, "Vies de comunicació")
            comunicacion100.setCheckState(0, Qt.Unchecked)
            comured100 = QTreeWidgetItem(comunicacion100)
            comured100.setFlags(comured100.flags() | Qt.ItemIsUserCheckable)
            comured100.setText(0, "Xarxa viària CV100")
            comured100.setCheckState(0, Qt.Unchecked)
            ferro100 = QTreeWidgetItem(comunicacion100)
            ferro100.setFlags(ferro100.flags() | Qt.ItemIsUserCheckable)
            ferro100.setText(0, "Ferrocarril CV100")
            ferro100.setCheckState(0, Qt.Unchecked)
            tunel100 = QTreeWidgetItem(comunicacion100)
            tunel100.setFlags(tunel100.flags() | Qt.ItemIsUserCheckable)
            tunel100.setText(0, "Boca de túnel CV100")
            tunel100.setCheckState(0, Qt.Unchecked)
            comurede100 = QTreeWidgetItem(comunicacion100)
            comurede100.setFlags(comurede100.flags() | Qt.ItemIsUserCheckable)
            comurede100.setText(0, "Xarxa viària elevada CV100")
            comurede100.setCheckState(0, Qt.Unchecked)
            ferroe100 = QTreeWidgetItem(comunicacion100)
            ferroe100.setFlags(ferroe100.flags() | Qt.ItemIsUserCheckable)
            ferroe100.setText(0, "Ferrocarril elevat CV100")
            ferroe100.setCheckState(0, Qt.Unchecked)
            comureds100 = QTreeWidgetItem(comunicacion100)
            comureds100.setFlags(comureds100.flags() | Qt.ItemIsUserCheckable)
            comureds100.setText(0, "Xarxa viària subterrània CV100")
            comureds100.setCheckState(0, Qt.Unchecked)
            ferros100 = QTreeWidgetItem(comunicacion100)
            ferros100.setFlags(ferros100.flags() | Qt.ItemIsUserCheckable)
            ferros100.setText(0, "Ferrocarril subterrani CV100")
            ferros100.setCheckState(0, Qt.Unchecked)
            fechasbases = QTreeWidgetItem(carto)
            fechasbases.setText(0, "Dates Bases cartogràfiques")
            fechasvuelos = QTreeWidgetItem(fechasbases)
            fechasvuelos.setFlags(fechasvuelos.flags() | Qt.ItemIsUserCheckable)
            fechasvuelos.setText(0, "Dates de vol")
            fechasvuelos.setCheckState(0, Qt.Unchecked)
            redtransp = QTreeWidgetItem(carto)
            redtransp.setText(0, "Xarxa de Transports")
            redcarretera = QTreeWidgetItem(redtransp)
            redcarretera.setFlags(redcarretera.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            redcarretera.setText(0, "Transport Carretera")
            redcarretera.setCheckState(0, Qt.Unchecked)
            sistviari = QTreeWidgetItem(redcarretera)
            sistviari.setFlags(sistviari.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sistviari.setText(0, "Sistema Viari")
            sistviari.setCheckState(0, Qt.Unchecked)
            cataviario = QTreeWidgetItem(sistviari)
            cataviario.setFlags(cataviario.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            cataviario.setText(0, "Catàleg Viari")
            cataviario.setCheckState(0, Qt.Unchecked)
            cataviario1 = QTreeWidgetItem(cataviario)
            cataviario1.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario1.setText(0, "Catàleg viari escala 1")
            cataviario1.setCheckState(0, Qt.Unchecked)
            cataviario2 = QTreeWidgetItem(cataviario)
            cataviario2.setFlags(cataviario2.flags() | Qt.ItemIsUserCheckable)
            cataviario2.setText(0, "Catàleg viari escala 2")
            cataviario2.setCheckState(0, Qt.Unchecked)
            cataviario3 = QTreeWidgetItem(cataviario)
            cataviario3.setFlags(cataviario3.flags() | Qt.ItemIsUserCheckable)
            cataviario3.setText(0, "Catàleg viari escala 3")
            cataviario3.setCheckState(0, Qt.Unchecked)
            cataviario4 = QTreeWidgetItem(cataviario)
            cataviario4.setFlags(cataviario4.flags() | Qt.ItemIsUserCheckable)
            cataviario4.setText(0, "Catàleg viari escala 4")
            cataviario4.setCheckState(0, Qt.Unchecked)
            puntokil = QTreeWidgetItem(sistviari)
            puntokil.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            puntokil.setText(0, "Punts quilomètrics")
            puntokil.setCheckState(0, Qt.Unchecked)
            caminos = QTreeWidgetItem(sistviari)
            caminos.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            caminos.setText(0, "Camins")
            caminos.setCheckState(0, Qt.Unchecked)
            viaciclista = QTreeWidgetItem(sistviari)
            viaciclista.setFlags(viaciclista.flags() | Qt.ItemIsUserCheckable)
            viaciclista.setText(0, "Via ciclista")
            viaciclista.setCheckState(0, Qt.Unchecked)
            urbana = QTreeWidgetItem(sistviari)
            urbana.setFlags(urbana.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            urbana.setText(0, "Urbana")
            urbana.setCheckState(0, Qt.Unchecked)
            portal = QTreeWidgetItem(urbana)
            portal.setFlags(portal.flags() | Qt.ItemIsUserCheckable)
            portal.setText(0, "Portal")
            portal.setCheckState(0, Qt.Unchecked)
            listacalles = QTreeWidgetItem(urbana)
            listacalles.setFlags(listacalles.flags() | Qt.ItemIsUserCheckable)
            listacalles.setText(0, "Llistat de carrers")
            listacalles.setCheckState(0, Qt.Unchecked)
            infraestruc = QTreeWidgetItem(redcarretera)
            infraestruc.setFlags(infraestruc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraestruc.setText(0, "Infraestructures e instal·lacions")
            infraestruc.setCheckState(0, Qt.Unchecked)
            estautob = QTreeWidgetItem(infraestruc)
            estautob.setFlags(estautob.flags() | Qt.ItemIsUserCheckable)
            estautob.setText(0, "Estació d'autobusos")
            estautob.setCheckState(0, Qt.Unchecked)
            peaje = QTreeWidgetItem(infraestruc)
            peaje.setFlags(peaje.flags() | Qt.ItemIsUserCheckable)
            peaje.setText(0, "Peatge")
            peaje.setCheckState(0, Qt.Unchecked)
            areaserv = QTreeWidgetItem(infraestruc)
            areaserv.setFlags(areaserv.flags() | Qt.ItemIsUserCheckable)
            areaserv.setText(0, "Àrees de servei")
            areaserv.setCheckState(0, Qt.Unchecked)
            areaservin = QTreeWidgetItem(infraestruc)
            areaservin.setFlags(areaservin.flags() | Qt.ItemIsUserCheckable)
            areaservin.setText(0, "Aparcament de servicis viaris hivernal")
            areaservin.setCheckState(0, Qt.Unchecked)
            puente = QTreeWidgetItem(infraestruc)
            puente.setFlags(puente.flags() | Qt.ItemIsUserCheckable)
            puente.setText(0, "Pont")
            puente.setCheckState(0, Qt.Unchecked)
            redferrocarril = QTreeWidgetItem(redtransp)
            redferrocarril.setFlags(redferrocarril.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            redferrocarril.setText(0, "Transport Ferrocarril")
            redferrocarril.setCheckState(0, Qt.Unchecked)
            pkffcc = QTreeWidgetItem(redferrocarril)
            pkffcc.setFlags(pkffcc.flags() | Qt.ItemIsUserCheckable)
            pkffcc.setText(0, "PK FFCC")
            pkffcc.setCheckState(0, Qt.Unchecked)
            redadif = QTreeWidgetItem(redferrocarril)
            redadif.setFlags(redadif.flags() | Qt.ItemIsUserCheckable)
            redadif.setText(0, "Xarxa ferrocarrils ADIF")
            redadif.setCheckState(0, Qt.Unchecked)
            redgeneralit = QTreeWidgetItem(redferrocarril)
            redgeneralit.setFlags(redgeneralit.flags() | Qt.ItemIsUserCheckable)
            redgeneralit.setText(0, "Xarxa ferrocarrils de la Generalitat")
            redgeneralit.setCheckState(0, Qt.Unchecked)
            redotros = QTreeWidgetItem(redferrocarril)
            redotros.setFlags(redotros.flags() | Qt.ItemIsUserCheckable)
            redotros.setText(0, "Altres FFCC")
            redotros.setCheckState(0, Qt.Unchecked)
            instferro = QTreeWidgetItem(redferrocarril)
            instferro.setFlags(instferro.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instferro.setText(0, "Infraestructures i instal·lacions ferroviàries")
            instferro.setCheckState(0, Qt.Unchecked)
            apeaderos = QTreeWidgetItem(instferro)
            apeaderos.setFlags(apeaderos.flags() | Qt.ItemIsUserCheckable)
            apeaderos.setText(0, "Estacions. Baixadors. Altres")
            apeaderos.setCheckState(0, Qt.Unchecked)
            pasoanivel = QTreeWidgetItem(instferro)
            pasoanivel.setFlags(pasoanivel.flags() | Qt.ItemIsUserCheckable)
            pasoanivel.setText(0, "Pas a nivell GVA")
            pasoanivel.setCheckState(0, Qt.Unchecked)
            pasoanivelo = QTreeWidgetItem(instferro)
            pasoanivelo.setFlags(pasoanivelo.flags() | Qt.ItemIsUserCheckable)
            pasoanivelo.setText(0, "Altres. Pas a nivell")
            pasoanivelo.setCheckState(0, Qt.Unchecked)
            puentefe = QTreeWidgetItem(instferro)
            puentefe.setFlags(puentefe.flags() | Qt.ItemIsUserCheckable)
            puentefe.setText(0, "Pont FFCC")
            puentefe.setCheckState(0, Qt.Unchecked)
            instaere = QTreeWidgetItem(redtransp)
            instaere.setFlags(instaere.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instaere.setText(0, "Transport Aeri")
            instaere.setCheckState(0, Qt.Unchecked)
            instaerodro = QTreeWidgetItem(instaere)
            instaerodro.setFlags(instaerodro.flags() | Qt.ItemIsUserCheckable)
            instaerodro.setText(0, "Aeròdrom. Heliport")
            instaerodro.setCheckState(0, Qt.Unchecked)
            instamar = QTreeWidgetItem(redtransp)
            instamar.setFlags(instaere.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instamar.setText(0, "Transport Marítim")
            instamar.setCheckState(0, Qt.Unchecked)
            instamaritim = QTreeWidgetItem(instamar)
            instamaritim.setFlags(instamaritim.flags() | Qt.ItemIsUserCheckable)
            instamaritim.setText(0, "Instal·lacions marítimes")
            instamaritim.setCheckState(0, Qt.Unchecked)
            cuadricula = QTreeWidgetItem(carto)
            cuadricula.setText(0, "Quadrícules geogràfiques")
            hojacv05 = QTreeWidgetItem(cuadricula)
            hojacv05.setFlags(hojacv05.flags() | Qt.ItemIsUserCheckable)
            hojacv05.setText(0, "Fulles CV05")
            hojacv05.setCheckState(0, Qt.Unchecked)
            hojacv50 = QTreeWidgetItem(cuadricula)
            hojacv50.setFlags(hojacv50.flags() | Qt.ItemIsUserCheckable)
            hojacv50.setText(0, "Fulles CV50")
            hojacv50.setCheckState(0, Qt.Unchecked)
            hojacv100 = QTreeWidgetItem(cuadricula)
            hojacv100.setFlags(hojacv100.flags() | Qt.ItemIsUserCheckable)
            hojacv100.setText(0, "Fulles CV100")
            hojacv100.setCheckState(0, Qt.Unchecked)
            unidades = QTreeWidgetItem(carto)
            unidades.setText(0, "Unitats administratives")
            limit_autono = QTreeWidgetItem(unidades)
            limit_autono.setFlags(limit_autono.flags() | Qt.ItemIsUserCheckable)
            limit_autono.setText(0, "Límit autonòmic")
            limit_autono.setCheckState(0, Qt.Unchecked)
            limit_prov = QTreeWidgetItem(unidades)
            limit_prov.setFlags(limit_prov.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            limit_prov.setText(0, "Límit provincial")
            limit_prov.setCheckState(0, Qt.Unchecked)
            limitproet = QTreeWidgetItem(limit_prov)
            limitproet.setFlags(limitproet.flags() | Qt.ItemIsUserCheckable)
            limitproet.setText(0, "Límit provincial - Etiquetes")
            limitproet.setCheckState(0, Qt.Unchecked)
            limitproli = QTreeWidgetItem(limit_prov)
            limitproli.setFlags(limitproli.flags() | Qt.ItemIsUserCheckable)
            limitproli.setText(0, "Límit provincial - Línies")
            limitproli.setCheckState(0, Qt.Unchecked)
            limit_com = QTreeWidgetItem(unidades)
            limit_com.setFlags(limit_prov.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            limit_com.setText(0, "Límit comarcal")
            limit_com.setCheckState(0, Qt.Unchecked)
            limitcomet = QTreeWidgetItem(limit_com)
            limitcomet.setFlags(limitcomet.flags() | Qt.ItemIsUserCheckable)
            limitcomet.setText(0, "Límit comarcal - Etiquetes")
            limitcomet.setCheckState(0, Qt.Unchecked)
            limitcomli = QTreeWidgetItem(limit_com)
            limitcomli.setFlags(limitcomli.flags() | Qt.ItemIsUserCheckable)
            limitcomli.setText(0, "Límit comarcal - Línies")
            limitcomli.setCheckState(0, Qt.Unchecked)
            limit_mun = QTreeWidgetItem(unidades)
            limit_mun.setFlags(limit_mun.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            limit_mun.setText(0, "Límit municipal")
            limit_mun.setCheckState(0, Qt.Unchecked)
            limitmunet = QTreeWidgetItem(limit_mun)
            limitmunet.setFlags(limitmunet.flags() | Qt.ItemIsUserCheckable)
            limitmunet.setText(0, "Límit municipal - Etiquetes")
            limitmunet.setCheckState(0, Qt.Unchecked)
            limitmunli = QTreeWidgetItem(limit_mun)
            limitmunli.setFlags(limitmunli.flags() | Qt.ItemIsUserCheckable)
            limitmunli.setText(0, "Límit municipal - Línies")
            limitmunli.setCheckState(0, Qt.Unchecked)
            geodesia = QTreeWidgetItem(carto)
            geodesia.setText(0, "Geodèsia/GNSS")
            red4gnss = QTreeWidgetItem(geodesia)
            red4gnss.setFlags(red4gnss.flags() | Qt.ItemIsUserCheckable)
            red4gnss.setText(0, "Xarxa d'estacions permanents GNSS (ERVA)")
            red4gnss.setCheckState(0, Qt.Unchecked)
            red4orden = QTreeWidgetItem(geodesia)
            red4orden.setFlags(red4orden.flags() | Qt.ItemIsUserCheckable)
            red4orden.setText(0, "Xarxa de 4t ordre")
            red4orden.setCheckState(0, Qt.Unchecked)
            planilimit = QTreeWidgetItem(carto)
            planilimit.setFlags(planilimit.flags() | Qt.ItemIsUserCheckable)
            planilimit.setText(0, "Planificació de línies límit municipals")
            planilimit.setCheckState(0, Qt.Unchecked)
            orto = QTreeWidgetItem(capas)
            orto.setText(0, "Ortofotos i Imatges")
            oortoRGB = QTreeWidgetItem(orto)
            oortoRGB.setText(0, "Ortofotos RGB")
            orto2019 = QTreeWidgetItem(oortoRGB)
            orto2019.setFlags(orto2019.flags() | Qt.ItemIsUserCheckable)
            orto2019.setText(0, "Any 2019")
            orto2019.setCheckState(0, Qt.Unchecked)
            orto2018 = QTreeWidgetItem(oortoRGB)
            orto2018.setFlags(orto2018.flags() | Qt.ItemIsUserCheckable)
            orto2018.setText(0, "Any 2018")
            orto2018.setCheckState(0, Qt.Unchecked)
            orto2017 = QTreeWidgetItem(oortoRGB)
            orto2017.setFlags(orto2017.flags() | Qt.ItemIsUserCheckable)
            orto2017.setText(0, "Any 2017")
            orto2017.setCheckState(0, Qt.Unchecked)
            orto2015 = QTreeWidgetItem(oortoRGB)
            orto2015.setFlags(orto2015.flags() | Qt.ItemIsUserCheckable)
            orto2015.setText(0, "Any 2015 prov. València i Castelló")
            orto2015.setCheckState(0, Qt.Unchecked)
            orto2014 = QTreeWidgetItem(oortoRGB)
            orto2014.setFlags(orto2014.flags() | Qt.ItemIsUserCheckable)
            orto2014.setText(0, "Any 2014 prov. Alacant")
            orto2014.setCheckState(0, Qt.Unchecked)
            orto2012 = QTreeWidgetItem(oortoRGB)
            orto2012.setFlags(orto2012.flags() | Qt.ItemIsUserCheckable)
            orto2012.setText(0, "Any 2012")
            orto2012.setCheckState(0, Qt.Unchecked)
            orto2010 = QTreeWidgetItem(oortoRGB)
            orto2010.setFlags(orto2010.flags() | Qt.ItemIsUserCheckable)
            orto2010.setText(0, "Any 2010 prov. València")
            orto2010.setCheckState(0, Qt.Unchecked)
            orto2009c = QTreeWidgetItem(oortoRGB)
            orto2009c.setFlags(orto2009c.flags() | Qt.ItemIsUserCheckable)
            orto2009c.setText(0, "Any 2009 prov. Castelló")
            orto2009c.setCheckState(0, Qt.Unchecked)
            orto2009v = QTreeWidgetItem(oortoRGB)
            orto2009v.setFlags(orto2009v.flags() | Qt.ItemIsUserCheckable)
            orto2009v.setText(0, "Any 2009 prov. Alacant")
            orto2009v.setCheckState(0, Qt.Unchecked)
            orto2008 = QTreeWidgetItem(oortoRGB)
            orto2008.setFlags(orto2008.flags() | Qt.ItemIsUserCheckable)
            orto2008.setText(0, "Any 2008 prov. València")
            orto2008.setCheckState(0, Qt.Unchecked)
            orto2007 = QTreeWidgetItem(oortoRGB)
            orto2007.setFlags(orto2007.flags() | Qt.ItemIsUserCheckable)
            orto2007.setText(0, "Any 2007 prov. Castelló")
            orto2007.setCheckState(0, Qt.Unchecked)
            orto2007a = QTreeWidgetItem(oortoRGB)
            orto2007a.setFlags(orto2007a.flags() | Qt.ItemIsUserCheckable)
            orto2007a.setText(0, "Any 2007 prov. Alacant")
            orto2007a.setCheckState(0, Qt.Unchecked)
            orto2006 = QTreeWidgetItem(oortoRGB)
            orto2006.setFlags(orto2006.flags() | Qt.ItemIsUserCheckable)
            orto2006.setText(0, "Any 2006 prov. València")
            orto2006.setCheckState(0, Qt.Unchecked)
            orto2005c = QTreeWidgetItem(oortoRGB)
            orto2005c.setFlags(orto2005c.flags() | Qt.ItemIsUserCheckable)
            orto2005c.setText(0, "Any 2005 prov. Castelló")
            orto2005c.setCheckState(0, Qt.Unchecked)
            orto2005a = QTreeWidgetItem(oortoRGB)
            orto2005a.setFlags(orto2005a.flags() | Qt.ItemIsUserCheckable)
            orto2005a.setText(0, "Any 2005 prov. Alacant")
            orto2005a.setCheckState(0, Qt.Unchecked)
            orto2004 = QTreeWidgetItem(oortoRGB)
            orto2004.setFlags(orto2004.flags() | Qt.ItemIsUserCheckable)
            orto2004.setText(0, "Any 2004 prov. València")
            orto2004.setCheckState(0, Qt.Unchecked)
            orto2003c = QTreeWidgetItem(oortoRGB)
            orto2003c.setFlags(orto2003c.flags() | Qt.ItemIsUserCheckable)
            orto2003c.setText(0, "Any 2003 prov. Castelló")
            orto2003c.setCheckState(0, Qt.Unchecked)
            orto2002 = QTreeWidgetItem(oortoRGB)
            orto2002.setFlags(orto2002.flags() | Qt.ItemIsUserCheckable)
            orto2002.setText(0, "Any 2002 prov. València i Alacant")
            orto2002.setCheckState(0, Qt.Unchecked)
            orto2000 = QTreeWidgetItem(oortoRGB)
            orto2000.setFlags(orto2000.flags() | Qt.ItemIsUserCheckable)
            orto2000.setText(0, "Any 2000 prov. València (Est)")
            orto2000.setCheckState(0, Qt.Unchecked)
            orto1997 = QTreeWidgetItem(oortoRGB)
            orto1997.setFlags(orto1997.flags() | Qt.ItemIsUserCheckable)
            orto1997.setText(0, "Any 1997 prov. Castelló (Sud)")
            orto1997.setCheckState(0, Qt.Unchecked)
            orto1996 = QTreeWidgetItem(oortoRGB)
            orto1996.setFlags(orto1996.flags() | Qt.ItemIsUserCheckable)
            orto1996.setText(0, "Any 1996 prov. Castelló (Nord)")
            orto1996.setCheckState(0, Qt.Unchecked)
            orto1956 = QTreeWidgetItem(oortoRGB)
            orto1956.setFlags(orto1956.flags() | Qt.ItemIsUserCheckable)
            orto1956.setText(0, "Any 1956")
            orto1956.setCheckState(0, Qt.Unchecked)
            oortoIRG = QTreeWidgetItem(orto)
            oortoIRG.setText(0, "Ortofotos IRG")
            orto2009ir = QTreeWidgetItem(oortoIRG)
            orto2009ir.setFlags(orto2009ir.flags() | Qt.ItemIsUserCheckable)
            orto2009ir.setText(0, "Any 2009 prov. Castelló - IRG")
            orto2009ir.setCheckState(0, Qt.Unchecked)
            orto2008ir = QTreeWidgetItem(oortoIRG)
            orto2008ir.setFlags(orto2008ir.flags() | Qt.ItemIsUserCheckable)
            orto2008ir.setText(0, "Any 2008 prov. València - IRG")
            orto2008ir.setCheckState(0, Qt.Unchecked)
            orto2007cir = QTreeWidgetItem(oortoIRG)
            orto2007cir.setFlags(orto2007cir.flags() | Qt.ItemIsUserCheckable)
            orto2007cir.setText(0, "Any 2007 prov. Castelló - IRG")
            orto2007cir.setCheckState(0, Qt.Unchecked)
            orto2007ir = QTreeWidgetItem(oortoIRG)
            orto2007ir.setFlags(orto2007ir.flags() | Qt.ItemIsUserCheckable)
            orto2007ir.setText(0, "Any 2007 prov. Alacant - IRG")
            orto2007ir.setCheckState(0, Qt.Unchecked)
            orto2006ir = QTreeWidgetItem(oortoIRG)
            orto2006ir.setFlags(orto2006ir.flags() | Qt.ItemIsUserCheckable)
            orto2006ir.setText(0, "Any 2006 prov. València - IRG")
            orto2006ir.setCheckState(0, Qt.Unchecked)
            orto2005ir = QTreeWidgetItem(oortoIRG)
            orto2005ir.setFlags(orto2005ir.flags() | Qt.ItemIsUserCheckable)
            orto2005ir.setText(0, "Any 2005 prov. Castelló - IRG")
            orto2005ir.setCheckState(0, Qt.Unchecked)
            satelite = QTreeWidgetItem(orto)
            satelite.setText(0, "Satélite")
            sentinel2 = QTreeWidgetItem(satelite)
            sentinel2.setText(0, "Sentinel-2")
            sent2020 = QTreeWidgetItem(sentinel2)
            sent2020.setFlags(sent2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2020.setText(0, "2020")
            sent2020.setCheckState(0, Qt.Unchecked)
            sent2020a = QTreeWidgetItem(sent2020)
            sent2020a.setFlags(sent2020a.flags() | Qt.ItemIsUserCheckable)
            sent2020a.setText(0, "20200311 RGB")
            sent2020a.setCheckState(0, Qt.Unchecked)
            sent2020b = QTreeWidgetItem(sent2020)
            sent2020b.setFlags(sent2020b.flags() | Qt.ItemIsUserCheckable)
            sent2020b.setText(0, "20200311 IGB")
            sent2020b.setCheckState(0, Qt.Unchecked)
            sent2020c = QTreeWidgetItem(sent2020)
            sent2020c.setFlags(sent2020c.flags() | Qt.ItemIsUserCheckable)
            sent2020c.setText(0, "20200106 RGB")
            sent2020c.setCheckState(0, Qt.Unchecked)
            sent2020d = QTreeWidgetItem(sent2020)
            sent2020d.setFlags(sent2020d.flags() | Qt.ItemIsUserCheckable)
            sent2020d.setText(0, "20200106 IGB")
            sent2020d.setCheckState(0, Qt.Unchecked)
            sent2019 = QTreeWidgetItem(sentinel2)
            sent2019.setFlags(sent2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2019.setText(0, "2019")
            sent2019.setCheckState(0, Qt.Unchecked)
            sent2019a = QTreeWidgetItem(sent2019)
            sent2019a.setFlags(sent2019a.flags() | Qt.ItemIsUserCheckable)
            sent2019a.setText(0, "20190918 RGB")
            sent2019a.setCheckState(0, Qt.Unchecked)
            sent2019b = QTreeWidgetItem(sent2019)
            sent2019b.setFlags(sent2019b.flags() | Qt.ItemIsUserCheckable)
            sent2019b.setText(0, "20190918 IGB")
            sent2019b.setCheckState(0, Qt.Unchecked)
            sent2019c = QTreeWidgetItem(sent2019)
            sent2019c.setFlags(sent2019c.flags() | Qt.ItemIsUserCheckable)
            sent2019c.setText(0, "20190531 RGB")
            sent2019c.setCheckState(0, Qt.Unchecked)
            sent2019d = QTreeWidgetItem(sent2019)
            sent2019d.setFlags(sent2019d.flags() | Qt.ItemIsUserCheckable)
            sent2019d.setText(0, "20190531 IGB")
            sent2019d.setCheckState(0, Qt.Unchecked)
            sent2019e = QTreeWidgetItem(sent2019)
            sent2019e.setFlags(sent2019e.flags() | Qt.ItemIsUserCheckable)
            sent2019e.setText(0, "20190111 RGB")
            sent2019e.setCheckState(0, Qt.Unchecked)
            sent2019f = QTreeWidgetItem(sent2019)
            sent2019f.setFlags(sent2019f.flags() | Qt.ItemIsUserCheckable)
            sent2019f.setText(0, "20190111 IGB")
            sent2019f.setCheckState(0, Qt.Unchecked)
            sent2018 = QTreeWidgetItem(sentinel2)
            sent2018.setFlags(sent2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2018.setText(0, "2018")
            sent2018.setCheckState(0, Qt.Unchecked)
            sent2018a = QTreeWidgetItem(sent2018)
            sent2018a.setFlags(sent2018a.flags() | Qt.ItemIsUserCheckable)
            sent2018a.setText(0, "20181003 RGB")
            sent2018a.setCheckState(0, Qt.Unchecked)
            sent2018b = QTreeWidgetItem(sent2018)
            sent2018b.setFlags(sent2018b.flags() | Qt.ItemIsUserCheckable)
            sent2018b.setText(0, "20181003 IGB")
            sent2018b.setCheckState(0, Qt.Unchecked)
            sent2018c = QTreeWidgetItem(sent2018)
            sent2018c.setFlags(sent2018c.flags() | Qt.ItemIsUserCheckable)
            sent2018c.setText(0, "20180615 RGB")
            sent2018c.setCheckState(0, Qt.Unchecked)
            sent2018d = QTreeWidgetItem(sent2018)
            sent2018d.setFlags(sent2018d.flags() | Qt.ItemIsUserCheckable)
            sent2018d.setText(0, "20180615 IGB")
            sent2018d.setCheckState(0, Qt.Unchecked)
            sent2018e = QTreeWidgetItem(sent2018)
            sent2018e.setFlags(sent2018e.flags() | Qt.ItemIsUserCheckable)
            sent2018e.setText(0, "20180307 RGB")
            sent2018e.setCheckState(0, Qt.Unchecked)
            sent2018f = QTreeWidgetItem(sent2018)
            sent2018f.setFlags(sent2018f.flags() | Qt.ItemIsUserCheckable)
            sent2018f.setText(0, "20180307 IGB")
            sent2018f.setCheckState(0, Qt.Unchecked)
            sent2018g = QTreeWidgetItem(sent2018)
            sent2018g.setFlags(sent2018g.flags() | Qt.ItemIsUserCheckable)
            sent2018g.setText(0, "20180116 RGB")
            sent2018g.setCheckState(0, Qt.Unchecked)
            sent2018h = QTreeWidgetItem(sent2018)
            sent2018h.setFlags(sent2018h.flags() | Qt.ItemIsUserCheckable)
            sent2018h.setText(0, "20180116 IGB")
            sent2018h.setCheckState(0, Qt.Unchecked)
            sent2017 = QTreeWidgetItem(sentinel2)
            sent2017.setFlags(sent2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2017.setText(0, "2017")
            sent2017.setCheckState(0, Qt.Unchecked)
            sent2017a = QTreeWidgetItem(sent2017)
            sent2017a.setFlags(sent2017a.flags() | Qt.ItemIsUserCheckable)
            sent2017a.setText(0, "20171112 RGB")
            sent2017a.setCheckState(0, Qt.Unchecked)
            sent2017b = QTreeWidgetItem(sent2017)
            sent2017b.setFlags(sent2017b.flags() | Qt.ItemIsUserCheckable)
            sent2017b.setText(0, "20170913 RGB")
            sent2017b.setCheckState(0, Qt.Unchecked)
            sent2017c = QTreeWidgetItem(sent2017)
            sent2017c.setFlags(sent2017c.flags() | Qt.ItemIsUserCheckable)
            sent2017c.setText(0, "20170824 RGB")
            sent2017c.setCheckState(0, Qt.Unchecked)
            sent2017d = QTreeWidgetItem(sent2017)
            sent2017d.setFlags(sent2017d.flags() | Qt.ItemIsUserCheckable)
            sent2017d.setText(0, "20170824 NIR")
            sent2017d.setCheckState(0, Qt.Unchecked)
            sent2017e = QTreeWidgetItem(sent2017)
            sent2017e.setFlags(sent2017e.flags() | Qt.ItemIsUserCheckable)
            sent2017e.setText(0, "20170804 RGB")
            sent2017e.setCheckState(0, Qt.Unchecked)
            sent2017f = QTreeWidgetItem(sent2017)
            sent2017f.setFlags(sent2017f.flags() | Qt.ItemIsUserCheckable)
            sent2017f.setText(0, "20170615 NIR")
            sent2017f.setCheckState(0, Qt.Unchecked)
            sent2017g = QTreeWidgetItem(sent2017)
            sent2017g.setFlags(sent2017g.flags() | Qt.ItemIsUserCheckable)
            sent2017g.setText(0, "20170506 RGB")
            sent2017g.setCheckState(0, Qt.Unchecked)
            sent2017h = QTreeWidgetItem(sent2017)
            sent2017h.setFlags(sent2017h.flags() | Qt.ItemIsUserCheckable)
            sent2017h.setText(0, "20170506 NIR")
            sent2017h.setCheckState(0, Qt.Unchecked)
            sent2016 = QTreeWidgetItem(sentinel2)
            sent2016.setFlags(sent2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2016.setText(0, "2016")
            sent2016.setCheckState(0, Qt.Unchecked)
            sent2016a = QTreeWidgetItem(sent2016)
            sent2016a.setFlags(sent2016a.flags() | Qt.ItemIsUserCheckable)
            sent2016a.setText(0, "20161227 RGB")
            sent2016a.setCheckState(0, Qt.Unchecked)
            sent2016b = QTreeWidgetItem(sent2016)
            sent2016b.setFlags(sent2016b.flags() | Qt.ItemIsUserCheckable)
            sent2016b.setText(0, "20161008 RGB")
            sent2016b.setCheckState(0, Qt.Unchecked)
            sent2016c = QTreeWidgetItem(sent2016)
            sent2016c.setFlags(sent2016c.flags() | Qt.ItemIsUserCheckable)
            sent2016c.setText(0, "20160819 RGB")
            sent2016c.setCheckState(0, Qt.Unchecked)
            sent2016d = QTreeWidgetItem(sent2016)
            sent2016d.setFlags(sent2016d.flags() | Qt.ItemIsUserCheckable)
            sent2016d.setText(0, "20160501 NIR")
            sent2016d.setCheckState(0, Qt.Unchecked)
            sent2015 = QTreeWidgetItem(sentinel2)
            sent2015.setFlags(sent2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sent2015.setText(0, "2015")
            sent2015.setCheckState(0, Qt.Unchecked)
            sent2015a = QTreeWidgetItem(sent2015)
            sent2015a.setFlags(sent2015a.flags() | Qt.ItemIsUserCheckable)
            sent2015a.setText(0, "20151203 NIR")
            sent2015a.setCheckState(0, Qt.Unchecked)
            sent2015b = QTreeWidgetItem(sent2015)
            sent2015b.setFlags(sent2015b.flags() | Qt.ItemIsUserCheckable)
            sent2015b.setText(0, "20150805 NIR")
            sent2015b.setCheckState(0, Qt.Unchecked)
            sent2015c = QTreeWidgetItem(sent2015)
            sent2015c.setFlags(sent2015c.flags() | Qt.ItemIsUserCheckable)
            sent2015c.setText(0, "20150706 NIR")
            sent2015c.setCheckState(0, Qt.Unchecked)
            usos = QTreeWidgetItem(capas)
            usos.setText(0, "Usos del Sòl")
            siose = QTreeWidgetItem(usos)
            siose.setText(0, "SIOSE")
            siose2015 = QTreeWidgetItem(siose)
            siose2015.setFlags(siose2015.flags() | Qt.ItemIsUserCheckable)
            siose2015.setText(0, "SIOSE 2015")
            siose2015.setCheckState(0, Qt.Unchecked)
            siose2011 = QTreeWidgetItem(siose)
            siose2011.setFlags(siose2011.flags() | Qt.ItemIsUserCheckable)
            siose2011.setText(0, "SIOSE 2011")
            siose2011.setCheckState(0, Qt.Unchecked)
            siose2009 = QTreeWidgetItem(siose)
            siose2009.setFlags(siose2009.flags() | Qt.ItemIsUserCheckable)
            siose2009.setText(0, "SIOSE 2009")
            siose2009.setCheckState(0, Qt.Unchecked)
            siose2005 = QTreeWidgetItem(siose)
            siose2005.setFlags(siose2005.flags() | Qt.ItemIsUserCheckable)
            siose2005.setText(0, "SIOSE 2009")
            siose2005.setCheckState(0, Qt.Unchecked)
            corine = QTreeWidgetItem(usos)
            corine.setText(0, "CORINE Land Cover")
            corine2018 = QTreeWidgetItem(corine)
            corine2018.setFlags(corine2018.flags() | Qt.ItemIsUserCheckable)
            corine2018.setText(0, "CLC 2018")
            corine2018.setCheckState(0, Qt.Unchecked)
            corine2012 = QTreeWidgetItem(corine)
            corine2012.setFlags(corine2012.flags() | Qt.ItemIsUserCheckable)
            corine2012.setText(0, "CLC 2012")
            corine2012.setCheckState(0, Qt.Unchecked)
            corine2006 = QTreeWidgetItem(corine)
            corine2006.setFlags(corine2006.flags() | Qt.ItemIsUserCheckable)
            corine2006.setText(0, "CLC 2006")
            corine2006.setCheckState(0, Qt.Unchecked)
            corine2000 = QTreeWidgetItem(corine)
            corine2000.setFlags(corine2000.flags() | Qt.ItemIsUserCheckable)
            corine2000.setText(0, "CLC 2000")
            corine2000.setCheckState(0, Qt.Unchecked)
            corine1990 = QTreeWidgetItem(corine)
            corine1990.setFlags(corine1990.flags() | Qt.ItemIsUserCheckable)
            corine1990.setText(0, "CLC 1990")
            corine1990.setCheckState(0, Qt.Unchecked)
            medioambiente = QTreeWidgetItem(capas)
            medioambiente.setText(0, "Medio ambiente")
            aguas = QTreeWidgetItem(medioambiente)
            aguas.setText(0, "Aigües")
            playas = QTreeWidgetItem(aguas)
            playas.setFlags(playas.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            playas.setText(0, "Platges")
            playas.setCheckState(0, Qt.Unchecked)
            bandazul = QTreeWidgetItem(playas)
            bandazul.setFlags(bandazul.flags() | Qt.ItemIsUserCheckable)
            bandazul.setText(0, "Banderes blaves")
            bandazul.setCheckState(0, Qt.Unchecked)
            puntsmuest = QTreeWidgetItem(playas)
            puntsmuest.setFlags(puntsmuest.flags() | Qt.ItemIsUserCheckable)
            puntsmuest.setText(0, "Punts de mostreig")
            puntsmuest.setCheckState(0, Qt.Unchecked)
            lineacosta = QTreeWidgetItem(playas)
            lineacosta.setFlags(lineacosta.flags() | Qt.ItemIsUserCheckable)
            lineacosta.setText(0, "Línia de costa")
            lineacosta.setCheckState(0, Qt.Unchecked)
            nitrats = QTreeWidgetItem(aguas)
            nitrats.setFlags(nitrats.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            nitrats.setText(0, "Zones vulnerables per nitrats")
            nitrats.setCheckState(0, Qt.Unchecked)
            infonitrat = QTreeWidgetItem(nitrats)
            infonitrat.setFlags(infonitrat.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infonitrat.setText(0, "Informació de referència")
            infonitrat.setCheckState(0, Qt.Unchecked)
            inforedhidro = QTreeWidgetItem(infonitrat)
            inforedhidro.setFlags(inforedhidro.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            inforedhidro.setText(0, "Xarxa hidrogràfica")
            inforedhidro.setCheckState(0, Qt.Unchecked)
            masassuperfafec = QTreeWidgetItem(infonitrat)
            masassuperfafec.setFlags(masassuperfafec.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperfafec.setText(0, "Masses superficials afectades")
            masassuperfafec.setCheckState(0, Qt.Unchecked)
            masassuperfrio = QTreeWidgetItem(masassuperfafec)
            masassuperfrio.setFlags(masassuperfrio.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperfrio.setText(0, "Rius")
            masassuperfrio.setCheckState(0, Qt.Unchecked)
            masassuperemba = QTreeWidgetItem(masassuperfafec)
            masassuperemba.setFlags(masassuperemba.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperemba.setText(0, "Embassaments")
            masassuperemba.setCheckState(0, Qt.Unchecked)
            masassuperllac = QTreeWidgetItem(masassuperfafec)
            masassuperllac.setFlags(masassuperllac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            masassuperllac.setText(0, "Llacs")
            masassuperllac.setCheckState(0, Qt.Unchecked)
            zonasvulnsup = QTreeWidgetItem(nitrats)
            zonasvulnsup.setFlags(zonasvulnsup.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            zonasvulnsup.setText(0, "Zones Vulnerables Superficials")
            zonasvulnsup.setCheckState(0, Qt.Unchecked)
            zonasvulnsub = QTreeWidgetItem(nitrats)
            zonasvulnsub.setFlags(zonasvulnsub.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            zonasvulnsub.setText(0, "Zonas Vulnerables Subterrànies")
            zonasvulnsub.setCheckState(0, Qt.Unchecked)
            atlas = QTreeWidgetItem(medioambiente)
            atlas.setText(0, "Atles climàtic de la C.V.")
            atlasref = QTreeWidgetItem(atlas)
            atlasref.setFlags(atlasref.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasref.setText(0, "Estacions de referència")
            atlasref.setCheckState(0, Qt.Unchecked)
            atlasanu = QTreeWidgetItem(atlas)
            atlasanu.setText(0, "Dades anuals")
            atlasanuprec = QTreeWidgetItem(atlasanu)
            atlasanuprec.setFlags(atlasanuprec.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuprec.setText(0, "Precipitació acumulada anual [mm]")
            atlasanuprec.setCheckState(0, Qt.Unchecked)
            atlasanuptemp = QTreeWidgetItem(atlasanu)
            atlasanuptemp.setFlags(atlasanuptemp.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptemp.setText(0, "Temperatura mitjana anual [C]")
            atlasanuptemp.setCheckState(0, Qt.Unchecked)
            atlasanuptempmi = QTreeWidgetItem(atlasanu)
            atlasanuptempmi.setFlags(atlasanuptempmi.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempmi.setText(0, "Temperatura mínima anual [C]")
            atlasanuptempmi.setCheckState(0, Qt.Unchecked)
            atlasanuptempma = QTreeWidgetItem(atlasanu)
            atlasanuptempma.setFlags(atlasanuptempma.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempma.setText(0, "Temperatura màxima anual [C]")
            atlasanuptempma.setCheckState(0, Qt.Unchecked)
            atlasanuptempmemi = QTreeWidgetItem(atlasanu)
            atlasanuptempmemi.setFlags(atlasanuptempmemi.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempmemi.setText(0, "Temperatura mitjana de les mínimes anual [C]")
            atlasanuptempmemi.setCheckState(0, Qt.Unchecked)
            atlasanuptempmema = QTreeWidgetItem(atlasanu)
            atlasanuptempmema.setFlags(atlasanuptempmema.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasanuptempmema.setText(0, "Temperatura mitjana de les màximes anual [C]")
            atlasanuptempmema.setCheckState(0, Qt.Unchecked)
            atlasesta = QTreeWidgetItem(atlas)
            atlasesta.setText(0, "Dades estacionals")
            atlasestapreci = QTreeWidgetItem(atlasesta)
            atlasestapreci.setText(0, "Precipitació acumulada [mm] - Estacional")
            atlasestaprecipri = QTreeWidgetItem(atlasestapreci)
            atlasestaprecipri.setFlags(atlasestaprecipri.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestaprecipri.setText(0, "Prec. primavera [mm]")
            atlasestaprecipri.setCheckState(0, Qt.Unchecked)
            atlasestapreciver = QTreeWidgetItem(atlasestapreci)
            atlasestapreciver.setFlags(atlasestapreciver.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciver.setText(0, "Prec. estiu [mm]")
            atlasestapreciver.setCheckState(0, Qt.Unchecked)
            atlasestaprecoto = QTreeWidgetItem(atlasestapreci)
            atlasestaprecoto.setFlags(atlasestaprecoto.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestaprecoto.setText(0, "Prec. tardor [mm]")
            atlasestaprecoto.setCheckState(0, Qt.Unchecked)
            atlasestaprecinv = QTreeWidgetItem(atlasestapreci)
            atlasestaprecinv.setFlags(atlasestaprecinv.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestaprecinv.setText(0, "Prec. hivern [mm]")
            atlasestaprecinv.setCheckState(0, Qt.Unchecked)
            atlasestatempe = QTreeWidgetItem(atlasesta)
            atlasestatempe.setText(0, "Temperatura mitjana [C] - Estacional")
            atlasestatempeipri = QTreeWidgetItem(atlasestatempe)
            atlasestatempeipri.setFlags(atlasestatempeipri.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri.setText(0, "Ta mitjana primavera [c]")
            atlasestatempeipri.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver = QTreeWidgetItem(atlasestatempe)
            atlasestatempeiver.setFlags(atlasestatempeiver.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver.setText(0, "Ta mitjana estiu [c]")
            atlasestatempeiver.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto = QTreeWidgetItem(atlasestatempe)
            atlasestatempeoto.setFlags(atlasestatempeoto.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto.setText(0, "Ta mitjana tardor [c]")
            atlasestatempeoto.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv = QTreeWidgetItem(atlasestatempe)
            atlasestatempeinv.setFlags(atlasestatempeinv.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv.setText(0, "Ta mitjana hivern [c]")
            atlasestatempeinv.setCheckState(0, Qt.Unchecked)
            atlasestatempe1 = QTreeWidgetItem(atlasesta)
            atlasestatempe1.setText(0, "Temperatura mínima [C] - Estacional")
            atlasestatempeipri1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeipri1.setFlags(atlasestatempeipri1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri1.setText(0, "Ta mínima primavera [c]")
            atlasestatempeipri1.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeiver1.setFlags(atlasestatempeiver1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver1.setText(0, "Ta mínima estiu [c]")
            atlasestatempeiver1.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeoto1.setFlags(atlasestatempeoto1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto1.setText(0, "Ta mínima tardor [c]")
            atlasestatempeoto1.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv1 = QTreeWidgetItem(atlasestatempe1)
            atlasestatempeinv1.setFlags(atlasestatempeinv1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv1.setText(0, "Ta mínima hivern [c]")
            atlasestatempeinv1.setCheckState(0, Qt.Unchecked)
            atlasestatempe2 = QTreeWidgetItem(atlasesta)
            atlasestatempe2.setText(0, "Temperatura màxima [C] - Estacional")
            atlasestatempeipri2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeipri2.setFlags(atlasestatempeipri2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri2.setText(0, "Ta màxima primavera [c]")
            atlasestatempeipri2.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeiver2.setFlags(atlasestatempeiver2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver2.setText(0, "Ta màxima estiu [c]")
            atlasestatempeiver2.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeoto2.setFlags(atlasestatempeoto2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto2.setText(0, "Ta màxima tardor [c]")
            atlasestatempeoto2.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv2 = QTreeWidgetItem(atlasestatempe2)
            atlasestatempeinv2.setFlags(atlasestatempeinv2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv2.setText(0, "Ta màxima hivern [c]")
            atlasestatempeinv2.setCheckState(0, Qt.Unchecked)
            atlasestatempe3 = QTreeWidgetItem(atlasesta)
            atlasestatempe3.setText(0, "Temperatura mitjana de les mínimes [C] - Estacional")
            atlasestatempeipri3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeipri3.setFlags(atlasestatempeipri3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri3.setText(0, "Ta mitjana de les mínimes primavera [c]")
            atlasestatempeipri3.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeiver3.setFlags(atlasestatempeiver3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver3.setText(0, "Ta mitjana de les mínimes estiu [c]")
            atlasestatempeiver3.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeoto3.setFlags(atlasestatempeoto3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto3.setText(0, "Ta mitjana de les mínimes tardor [c]")
            atlasestatempeoto3.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv3 = QTreeWidgetItem(atlasestatempe3)
            atlasestatempeinv3.setFlags(atlasestatempeinv3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv3.setText(0, "Ta mitjana de les mínimes hivern [c]")
            atlasestatempeinv3.setCheckState(0, Qt.Unchecked)
            atlasestatempe4 = QTreeWidgetItem(atlasesta)
            atlasestatempe4.setText(0, "Temperatura mitjana de les màximes [C] - Estacional")
            atlasestatempeipri4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeipri4.setFlags(atlasestatempeipri4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeipri4.setText(0, "Ta mitjana de les màximes primavera [c]")
            atlasestatempeipri4.setCheckState(0, Qt.Unchecked)
            atlasestatempeiver4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeiver4.setFlags(atlasestatempeiver4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeiver4.setText(0, "Ta mitjana de les màximes estiu [c]")
            atlasestatempeiver4.setCheckState(0, Qt.Unchecked)
            atlasestatempeoto4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeoto4.setFlags(atlasestatempeoto4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeoto4.setText(0, "Ta mitjana de les màximes tardor [c]")
            atlasestatempeoto4.setCheckState(0, Qt.Unchecked)
            atlasestatempeinv4 = QTreeWidgetItem(atlasestatempe4)
            atlasestatempeinv4.setFlags(atlasestatempeinv4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestatempeinv4.setText(0, "Ta mitjana de les màximes hivern [c]")
            atlasestatempeinv4.setCheckState(0, Qt.Unchecked)
            atlasmensu = QTreeWidgetItem(atlas)
            atlasmensu.setText(0, "Dades mensuals")
            atlasestaprecim = QTreeWidgetItem(atlasmensu)
            atlasestaprecim.setText(0, "Precipitació acumulada [mm] - Mensual")
            atlasestapreciprim1 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreciprim1.setFlags(atlasestapreciprim1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1.setText(0, "Prec. gener [mm]")
            atlasestapreciprim1.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreciprim2.setFlags(atlasestapreciprim2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2.setText(0, "Prec. febrer [mm]")
            atlasestapreciprim2.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim3.setFlags(atlasestapreprim3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3.setText(0, "Prec. març [mm]")
            atlasestapreprim3.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim4.setFlags(atlasestapreprim4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4.setText(0, "Prec. abril [mm]")
            atlasestapreprim4.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim5.setFlags(atlasestapreprim5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5.setText(0, "Prec. maig [mm]")
            atlasestapreprim5.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim6.setFlags(atlasestapreprim6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6.setText(0, "Prec. juny [mm]")
            atlasestapreprim6.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim7.setFlags(atlasestapreprim7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7.setText(0, "Prec. juliol [mm]")
            atlasestapreprim7.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim8.setFlags(atlasestapreprim8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8.setText(0, "Prec. agost [mm]")
            atlasestapreprim8.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim9.setFlags(atlasestapreprim9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9.setText(0, "Prec. setembre [mm]")
            atlasestapreprim9.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim10.setFlags(atlasestapreprim10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10.setText(0, "Prec. octubre [mm]")
            atlasestapreprim10.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim11.setFlags(atlasestapreprim11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11.setText(0, "Prec. novembre [mm]")
            atlasestapreprim11.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12 = QTreeWidgetItem(atlasestaprecim)
            atlasestapreprim12.setFlags(atlasestapreprim12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12.setText(0, "Prec. desembre [mm]")
            atlasestapreprim12.setCheckState(0, Qt.Unchecked)
            atlasestaprecime = QTreeWidgetItem(atlasmensu)
            atlasestaprecime.setText(0, "Temperatura mitjana [C] - Mensual")
            atlasestapreciprim1e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreciprim1e.setFlags(atlasestapreciprim1e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1e.setText(0, "Ta mitjana gener [C]")
            atlasestapreciprim1e.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreciprim2e.setFlags(atlasestapreciprim2e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2e.setText(0, "Ta mitjana febrer [C]")
            atlasestapreciprim2e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim3e.setFlags(atlasestapreprim3e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3e.setText(0, "Ta mitjana març [C]")
            atlasestapreprim3e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim4e.setFlags(atlasestapreprim4e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4e.setText(0, "Ta mitjana abril [C]")
            atlasestapreprim4e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim5e.setFlags(atlasestapreprim5e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5e.setText(0, "Ta mitjana maig [C]")
            atlasestapreprim5e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim6e.setFlags(atlasestapreprim6e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6e.setText(0, "Ta mitjana juny [C]")
            atlasestapreprim6e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim7e.setFlags(atlasestapreprim7e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7e.setText(0, "Ta mitjana juliol [C]")
            atlasestapreprim7e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim8e.setFlags(atlasestapreprim8e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8e.setText(0, "Ta mitjana agost [C]")
            atlasestapreprim8e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim9e.setFlags(atlasestapreprim9e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9e.setText(0, "Ta mitjana setembre [C]")
            atlasestapreprim9e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim10e.setFlags(atlasestapreprim10e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10e.setText(0, "Ta mitjana octubre [C]")
            atlasestapreprim10e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim11e.setFlags(atlasestapreprim11e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11e.setText(0, "Ta mitjana novembre [C]")
            atlasestapreprim11e.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12e = QTreeWidgetItem(atlasestaprecime)
            atlasestapreprim12e.setFlags(atlasestapreprim12e.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12e.setText(0, "Ta mitjana desembre [C]")
            atlasestapreprim12e.setCheckState(0, Qt.Unchecked)
            atlasestaprecimm = QTreeWidgetItem(atlasmensu)
            atlasestaprecimm.setText(0, "Temperatura mínima [C] - Mensual")
            atlasestapreciprim1m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreciprim1m.setFlags(atlasestapreciprim1m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1m.setText(0, "Ta mínima gener [C]")
            atlasestapreciprim1m.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreciprim2m.setFlags(atlasestapreciprim2m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2m.setText(0, "Ta mínima febrer [C]")
            atlasestapreciprim2m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim3m.setFlags(atlasestapreprim3m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3m.setText(0, "Ta mínima març [C]")
            atlasestapreprim3m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim4m.setFlags(atlasestapreprim4m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4m.setText(0, "Ta mínima abril [C]")
            atlasestapreprim4m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim5m.setFlags(atlasestapreprim5m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5m.setText(0, "Ta mínima maig [C]")
            atlasestapreprim5m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim6m.setFlags(atlasestapreprim6m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6m.setText(0, "Ta mínima juny [C]")
            atlasestapreprim6m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim7m.setFlags(atlasestapreprim7m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7m.setText(0, "Ta mínima juliol [C]")
            atlasestapreprim7m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim8m.setFlags(atlasestapreprim8m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8m.setText(0, "Ta mínima agost [C]")
            atlasestapreprim8m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim9m.setFlags(atlasestapreprim9m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9m.setText(0, "Ta mínima setembre [C]")
            atlasestapreprim9m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim10m.setFlags(atlasestapreprim10m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10m.setText(0, "Ta mínima octubre [C]")
            atlasestapreprim10m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim11m.setFlags(atlasestapreprim11m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11m.setText(0, "Ta mínima novembre [C]")
            atlasestapreprim11m.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12m = QTreeWidgetItem(atlasestaprecimm)
            atlasestapreprim12m.setFlags(atlasestapreprim12m.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12m.setText(0, "Ta mínima desembre [C]")
            atlasestapreprim12m.setCheckState(0, Qt.Unchecked)
            atlasestaprecimn = QTreeWidgetItem(atlasmensu)
            atlasestaprecimn.setText(0, "Temperatura màxima [C] - Mensual")
            atlasestapreciprim1n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreciprim1n.setFlags(atlasestapreciprim1n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1n.setText(0, "Ta màxima gener [C]")
            atlasestapreciprim1n.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreciprim2n.setFlags(atlasestapreciprim2n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2n.setText(0, "Ta màxima febrer [C]")
            atlasestapreciprim2n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim3n.setFlags(atlasestapreprim3n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3n.setText(0, "Ta màxima març [C]")
            atlasestapreprim3n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim4n.setFlags(atlasestapreprim4n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4n.setText(0, "Ta màxima abril [C]")
            atlasestapreprim4n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim5n.setFlags(atlasestapreprim5n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5n.setText(0, "Ta màxima maig [C]")
            atlasestapreprim5n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim6n.setFlags(atlasestapreprim6n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6n.setText(0, "Ta màxima juny [C]")
            atlasestapreprim6n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim7n.setFlags(atlasestapreprim7n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7n.setText(0, "Ta màxima juliol [C]")
            atlasestapreprim7n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim8n.setFlags(atlasestapreprim8n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8n.setText(0, "Ta màxima agost [C]")
            atlasestapreprim8n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim9n.setFlags(atlasestapreprim9n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9n.setText(0, "Ta màxima setembre [C]")
            atlasestapreprim9n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim10n.setFlags(atlasestapreprim10n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10n.setText(0, "Ta màxima octubre [C]")
            atlasestapreprim10n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim11n.setFlags(atlasestapreprim11n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11n.setText(0, "Ta màxima novembre [C]")
            atlasestapreprim11n.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12n = QTreeWidgetItem(atlasestaprecimn)
            atlasestapreprim12n.setFlags(atlasestapreprim12n.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12n.setText(0, "Ta màxima desembre [C]")
            atlasestapreprim12n.setCheckState(0, Qt.Unchecked)
            atlasestaprecimq = QTreeWidgetItem(atlasmensu)
            atlasestaprecimq.setText(0, "Temperatura mitjana de les mínimes [C] - Mensual")
            atlasestapreciprim1q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreciprim1q.setFlags(atlasestapreciprim1q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1q.setText(0, "Ta mitjana de les mínimes gener [C]")
            atlasestapreciprim1q.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreciprim2q.setFlags(atlasestapreciprim2q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2q.setText(0, "Ta mitjana de les mínimes febrer [C]")
            atlasestapreciprim2q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim3q.setFlags(atlasestapreprim3q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3q.setText(0, "Ta mitjana de les mínimes març [C]")
            atlasestapreprim3q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim4q.setFlags(atlasestapreprim4q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4q.setText(0, "Ta mitjana de les mínimes abril [C]")
            atlasestapreprim4q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim5q.setFlags(atlasestapreprim5q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5q.setText(0, "Ta mitjana de les mínimes maig [C]")
            atlasestapreprim5q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim6q.setFlags(atlasestapreprim6q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6q.setText(0, "Ta mitjana de les mínimes juny [C]")
            atlasestapreprim6q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim7q.setFlags(atlasestapreprim7q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7q.setText(0, "Ta mitjana de les mínimes juliol [C]")
            atlasestapreprim7q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim8q.setFlags(atlasestapreprim8q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8q.setText(0, "Ta mitjana de les mínimes agost [C]")
            atlasestapreprim8q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim9q.setFlags(atlasestapreprim9q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9q.setText(0, "Ta mitjana de les mínimes setembre [C]")
            atlasestapreprim9q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim10q.setFlags(atlasestapreprim10q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10q.setText(0, "Ta mitjana de les mínimes octubre [C]")
            atlasestapreprim10q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim11q.setFlags(atlasestapreprim11q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11q.setText(0, "Ta mitjana de les mínimes novembre [C]")
            atlasestapreprim11q.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12q = QTreeWidgetItem(atlasestaprecimq)
            atlasestapreprim12q.setFlags(atlasestapreprim12q.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12q.setText(0, "Ta mitjana de les màximes desembre [C]")
            atlasestapreprim12q.setCheckState(0, Qt.Unchecked)
            atlasestaprecimz = QTreeWidgetItem(atlasmensu)
            atlasestaprecimz.setText(0, "Temperatura mitjana de les màximes [C] - Mensual")
            atlasestapreciprim1z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreciprim1z.setFlags(atlasestapreciprim1z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim1z.setText(0, "Ta mitjana de les màximes gener [C]")
            atlasestapreciprim1z.setCheckState(0, Qt.Unchecked)
            atlasestapreciprim2z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreciprim2z.setFlags(atlasestapreciprim2z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreciprim2z.setText(0, "Ta mitjana de les màximes febrer [C]")
            atlasestapreciprim2z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim3z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim3z.setFlags(atlasestapreprim3z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim3z.setText(0, "Ta mitjana de les màximes març [C]")
            atlasestapreprim3z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim4z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim4z.setFlags(atlasestapreprim4z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim4z.setText(0, "Ta mitjana de les màximes abril [C]")
            atlasestapreprim4z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim5z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim5z.setFlags(atlasestapreprim5z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim5z.setText(0, "Ta mitjana de les màximes maig [C]")
            atlasestapreprim5z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim6z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim6z.setFlags(atlasestapreprim6z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim6z.setText(0, "Ta mitjana de les màximes juny [C]")
            atlasestapreprim6z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim7z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim7z.setFlags(atlasestapreprim7z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim7z.setText(0, "Ta mitjana de les màximes juliol [C]")
            atlasestapreprim7z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim8z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim8z.setFlags(atlasestapreprim8z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim8z.setText(0, "Ta mitjana de les màximes agost [C]")
            atlasestapreprim8z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim9z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim9z.setFlags(atlasestapreprim9z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim9z.setText(0, "Ta mitjana de les màximes setembre [C]")
            atlasestapreprim9z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim10z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim10z.setFlags(atlasestapreprim10z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim10z.setText(0, "Ta mitjana de les màximes octubre [C]")
            atlasestapreprim10z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim11z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim11z.setFlags(atlasestapreprim11z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim11z.setText(0, "Ta mitjana de les màximes novembre [C]")
            atlasestapreprim11z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12z = QTreeWidgetItem(atlasestaprecimz)
            atlasestapreprim12z.setFlags(atlasestapreprim12z.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12z.setText(0, "Ta mitjana de les màximes desembre [C]")
            atlasestapreprim12z.setCheckState(0, Qt.Unchecked)
            atlasestapreprim12t = QTreeWidgetItem(atlas)
            atlasestapreprim12t.setFlags(atlasestapreprim12t.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            atlasestapreprim12t.setText(0, "Quadrícula de referència")
            atlasestapreprim12t.setCheckState(0, Qt.Unchecked)



            mediorural = QTreeWidgetItem(capas)
            mediorural.setText(0, "Medi rural")
            sigpac = QTreeWidgetItem(mediorural)
            sigpac.setText(0, "SIGPAC")
            sigpac2020 = QTreeWidgetItem(sigpac)
            sigpac2020.setFlags(sigpac2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2020.setText(0, "Any 2020 ")
            sigpac2020.setCheckState(0, Qt.Unchecked)
            sigpacpar2020 = QTreeWidgetItem(sigpac2020)
            sigpacpar2020.setFlags(sigpacpar2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2020.setText(0, "Parcel·les 2020")
            sigpacpar2020.setCheckState(0, Qt.Unchecked)
            sigpacrec2020 = QTreeWidgetItem(sigpac2020)
            sigpacrec2020.setFlags(sigpacrec2020.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2020.setText(0, "Recintes 2020")
            sigpacrec2020.setCheckState(0, Qt.Unchecked)
            sigpac2019 = QTreeWidgetItem(sigpac)
            sigpac2019.setFlags(sigpac2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2019.setText(0, "Any 2019 ")
            sigpac2019.setCheckState(0, Qt.Unchecked)
            sigpacpar2019 = QTreeWidgetItem(sigpac2019)
            sigpacpar2019.setFlags(sigpacpar2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2019.setText(0, "Parcel·les 2019")
            sigpacpar2019.setCheckState(0, Qt.Unchecked)
            sigpacrec2019 = QTreeWidgetItem(sigpac2019)
            sigpacrec2019.setFlags(sigpacrec2019.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2019.setText(0, "Recintes 2019")
            sigpacrec2019.setCheckState(0, Qt.Unchecked)
            sigpac2018 = QTreeWidgetItem(sigpac)
            sigpac2018.setFlags(sigpac2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2018.setText(0, "Any 2018 ")
            sigpac2018.setCheckState(0, Qt.Unchecked)
            sigpacpar2018 = QTreeWidgetItem(sigpac2018)
            sigpacpar2018.setFlags(sigpacpar2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2018.setText(0, "Parcel·les 2018")
            sigpacpar2018.setCheckState(0, Qt.Unchecked)
            sigpacrec2018 = QTreeWidgetItem(sigpac2018)
            sigpacrec2018.setFlags(sigpacrec2018.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2018.setText(0, "Recintes 2018")
            sigpacrec2018.setCheckState(0, Qt.Unchecked)
            sigpac2017 = QTreeWidgetItem(sigpac)
            sigpac2017.setFlags(sigpac2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2017.setText(0, "Any 2017 ")
            sigpac2017.setCheckState(0, Qt.Unchecked)
            sigpacpar2017 = QTreeWidgetItem(sigpac2017)
            sigpacpar2017.setFlags(sigpacpar2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2017.setText(0, "Parcel·les 2017")
            sigpacpar2017.setCheckState(0, Qt.Unchecked)
            sigpacrec2017 = QTreeWidgetItem(sigpac2017)
            sigpacrec2017.setFlags(sigpacrec2017.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2017.setText(0, "Recintes 2017")
            sigpacrec2017.setCheckState(0, Qt.Unchecked)
            sigpac2016 = QTreeWidgetItem(sigpac)
            sigpac2016.setFlags(sigpac2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2016.setText(0, "Any 2016 ")
            sigpac2016.setCheckState(0, Qt.Unchecked)
            sigpacpar2016 = QTreeWidgetItem(sigpac2016)
            sigpacpar2016.setFlags(sigpacpar2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2016.setText(0, "Parcel·les 2016")
            sigpacpar2016.setCheckState(0, Qt.Unchecked)
            sigpacrec2016 = QTreeWidgetItem(sigpac2016)
            sigpacrec2016.setFlags(sigpacrec2016.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2016.setText(0, "Recintes 2016")
            sigpacrec2016.setCheckState(0, Qt.Unchecked)
            sigpac2015 = QTreeWidgetItem(sigpac)
            sigpac2015.setFlags(sigpac2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpac2015.setText(0, "Any 2015 ")
            sigpac2015.setCheckState(0, Qt.Unchecked)
            sigpacpar2015 = QTreeWidgetItem(sigpac2015)
            sigpacpar2015.setFlags(sigpacpar2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacpar2015.setText(0, "Parcel·les 2015")
            sigpacpar2015.setCheckState(0, Qt.Unchecked)
            sigpacrec2015 = QTreeWidgetItem(sigpac2015)
            sigpacrec2015.setFlags(sigpacrec2015.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sigpacrec2015.setText(0, "Recintes 2015")
            sigpacrec2015.setCheckState(0, Qt.Unchecked)
            infraestructuras = QTreeWidgetItem(capas)
            infraestructuras.setText(0, "Infraestructures")
            infraarqui = QTreeWidgetItem(infraestructuras)
            infraarqui.setText(0, "Arquitectura")
            infraarquito = QTreeWidgetItem(infraarqui)
            infraarquito.setFlags(infraarquito.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraarquito.setText(0, "Torres de guaita")
            infraarquito.setCheckState(0, Qt.Unchecked)
            infraarquiru = QTreeWidgetItem(infraarqui)
            infraarquiru.setFlags(infraarquiru.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraarquiru.setText(0, "Ruta - Torres")
            infraarquiru.setCheckState(0, Qt.Unchecked)
            infracostes = QTreeWidgetItem(infraestructuras)
            infracostes.setText(0, "Costes")
            costesfotogr = QTreeWidgetItem(infracostes)
            costesfotogr.setFlags(costesfotogr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr.setText(0, "Fotogrames")
            costesfotogr.setCheckState(0, Qt.Unchecked)
            costesfotogr98 = QTreeWidgetItem(costesfotogr)
            costesfotogr98.setFlags(costesfotogr98.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr98.setText(0, "Fotogrames any 1998")
            costesfotogr98.setCheckState(0, Qt.Unchecked)
            costesfotogr96 = QTreeWidgetItem(costesfotogr)
            costesfotogr96.setFlags(costesfotogr96.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr96.setText(0, "Fotogrames any 1996")
            costesfotogr96.setCheckState(0, Qt.Unchecked)
            costesfotogr94 = QTreeWidgetItem(costesfotogr)
            costesfotogr94.setFlags(costesfotogr94.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr94.setText(0, "Fotogrames any 1994")
            costesfotogr94.setCheckState(0, Qt.Unchecked)
            costesfotogr92 = QTreeWidgetItem(costesfotogr)
            costesfotogr92.setFlags(costesfotogr92.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr92.setText(0, "Fotogrames any 1992")
            costesfotogr92.setCheckState(0, Qt.Unchecked)
            costesfotogr90 = QTreeWidgetItem(costesfotogr)
            costesfotogr90.setFlags(costesfotogr90.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr90.setText(0, "Fotogrames any 1990")
            costesfotogr90.setCheckState(0, Qt.Unchecked)
            costesfotogr86 = QTreeWidgetItem(costesfotogr)
            costesfotogr86.setFlags(costesfotogr86.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr86.setText(0, "Fotogrames any 1986")
            costesfotogr86.setCheckState(0, Qt.Unchecked)
            costesfotogr81 = QTreeWidgetItem(costesfotogr)
            costesfotogr81.setFlags(costesfotogr81.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr81.setText(0, "Fotogrames anys 1981-1983")
            costesfotogr81.setCheckState(0, Qt.Unchecked)
            costesfotogr56 = QTreeWidgetItem(costesfotogr)
            costesfotogr56.setFlags(costesfotogr56.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesfotogr56.setText(0, "Fotogrames anys 1956-1957")
            costesfotogr56.setCheckState(0, Qt.Unchecked)
            costesobliq = QTreeWidgetItem(infracostes)
            costesobliq.setFlags(costesobliq.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq.setText(0, "Obliqües")
            costesobliq.setCheckState(0, Qt.Unchecked)
            costesobliq2009 = QTreeWidgetItem(costesobliq)
            costesobliq2009.setFlags(costesobliq2009.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq2009.setText(0, "Obliqües any 2009")
            costesobliq2009.setCheckState(0, Qt.Unchecked)
            costesobliq2001 = QTreeWidgetItem(costesobliq)
            costesobliq2001.setFlags(costesobliq2001.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq2001.setText(0, "Obliqües any 2001")
            costesobliq2001.setCheckState(0, Qt.Unchecked)
            costesobliq1998 = QTreeWidgetItem(costesobliq)
            costesobliq1998.setFlags(costesobliq1998.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            costesobliq1998.setText(0, "Obliqües any 1998")
            costesobliq1998.setCheckState(0, Qt.Unchecked)
            infraesviarias = QTreeWidgetItem(infraestructuras)
            infraesviarias.setText(0, "Infraestructures viäries")
            infraviariasci = QTreeWidgetItem(infraesviarias)
            infraviariasci.setFlags(infraviariasci.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariasci.setText(0, "Ciclo-rutes")
            infraviariasci.setCheckState(0, Qt.Unchecked)
            infraviariascia = QTreeWidgetItem(infraviariasci)
            infraviariascia.setFlags(infraviariascia.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariascia.setText(0, "Actuals")
            infraviariascia.setCheckState(0, Qt.Unchecked)
            infraviariascif = QTreeWidgetItem(infraviariasci)
            infraviariascif.setFlags(infraviariascif.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariascif.setText(0, "Futures")
            infraviariascif.setCheckState(0, Qt.Unchecked)
            infraviaricarr = QTreeWidgetItem(infraesviarias)
            infraviaricarr.setFlags(infraviaricarr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr.setText(0, "Carreteres")
            infraviaricarr.setCheckState(0, Qt.Unchecked)
            infraviaricta = QTreeWidgetItem(infraviaricarr)
            infraviaricta.setFlags(infraviaricta.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricta.setText(0, "Catàleg viari")
            infraviaricta.setCheckState(0, Qt.Unchecked)
            cataviario1i = QTreeWidgetItem(infraviaricta)
            cataviario1i.setFlags(cataviario1i.flags() | Qt.ItemIsUserCheckable)
            cataviario1i.setText(0, "Catàleg viari escala 1")
            cataviario1i.setCheckState(0, Qt.Unchecked)
            cataviario2i = QTreeWidgetItem(infraviaricta)
            cataviario2i.setFlags(cataviario2i.flags() | Qt.ItemIsUserCheckable)
            cataviario2i.setText(0, "Catàleg viari escala 2")
            cataviario2i.setCheckState(0, Qt.Unchecked)
            cataviario3i = QTreeWidgetItem(infraviaricta)
            cataviario3i.setFlags(cataviario3i.flags() | Qt.ItemIsUserCheckable)
            cataviario3i.setText(0, "Catàleg viari escala 3")
            cataviario3i.setCheckState(0, Qt.Unchecked)
            cataviario4i = QTreeWidgetItem(infraviaricta)
            cataviario4i.setFlags(cataviario4i.flags() | Qt.ItemIsUserCheckable)
            cataviario4i.setText(0, "Catàleg viari escala 4")
            cataviario4i.setCheckState(0, Qt.Unchecked)
            cataviariopk = QTreeWidgetItem(infraviaricarr)
            cataviariopk.setFlags(cataviariopk.flags() | Qt.ItemIsUserCheckable)
            cataviariopk.setText(0, "Punts quilomètrics")
            cataviariopk.setCheckState(0, Qt.Unchecked)
            infraviariimd = QTreeWidgetItem(infraviaricarr)
            infraviariimd.setFlags(infraviariimd.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd.setText(0, "IMD")
            infraviariimd.setCheckState(0, Qt.Unchecked)
            infraviariimd19 = QTreeWidgetItem(infraviariimd)
            infraviariimd19.setFlags(infraviariimd19.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd19.setText(0, "Intensitat mitjana 2019")
            infraviariimd19.setCheckState(0, Qt.Unchecked)
            infraviariimd18 = QTreeWidgetItem(infraviariimd)
            infraviariimd18.setFlags(infraviariimd18.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd18.setText(0, "Intensitat mitjana 2018")
            infraviariimd18.setCheckState(0, Qt.Unchecked)
            infraviariimd17 = QTreeWidgetItem(infraviariimd)
            infraviariimd17.setFlags(infraviariimd17.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd17.setText(0, "Intensitat mitjana 2017")
            infraviariimd17.setCheckState(0, Qt.Unchecked)
            infraviariimd16 = QTreeWidgetItem(infraviariimd)
            infraviariimd16.setFlags(infraviariimd16.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd16.setText(0, "Intensitat mitjana 2016")
            infraviariimd16.setCheckState(0, Qt.Unchecked)
            infraviariimd15 = QTreeWidgetItem(infraviariimd)
            infraviariimd15.setFlags(infraviariimd15.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd15.setText(0, "Intensitat mitjana 2015")
            infraviariimd15.setCheckState(0, Qt.Unchecked)
            infraviariimd14 = QTreeWidgetItem(infraviariimd)
            infraviariimd14.setFlags(infraviariimd14.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd14.setText(0, "Intensitat mitjana 2014")
            infraviariimd14.setCheckState(0, Qt.Unchecked)
            infraviariimd13 = QTreeWidgetItem(infraviariimd)
            infraviariimd13.setFlags(infraviariimd13.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd13.setText(0, "Intensitat mitjana 2013")
            infraviariimd13.setCheckState(0, Qt.Unchecked)
            infraviariimd12 = QTreeWidgetItem(infraviariimd)
            infraviariimd12.setFlags(infraviariimd12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd12.setText(0, "Intensitat mitjana 2012")
            infraviariimd12.setCheckState(0, Qt.Unchecked)
            infraviariimd11 = QTreeWidgetItem(infraviariimd)
            infraviariimd11.setFlags(infraviariimd11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd11.setText(0, "Intensitat mitjana 2011")
            infraviariimd11.setCheckState(0, Qt.Unchecked)
            infraviariimd10 = QTreeWidgetItem(infraviariimd)
            infraviariimd10.setFlags(infraviariimd10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd10.setText(0, "Intensitat mitjana 2010")
            infraviariimd10.setCheckState(0, Qt.Unchecked)
            infraviariimd09 = QTreeWidgetItem(infraviariimd)
            infraviariimd09.setFlags(infraviariimd09.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariimd09.setText(0, "Intensitat mitjana 2009")
            infraviariimd09.setCheckState(0, Qt.Unchecked)
            infraviaricarrh = QTreeWidgetItem(infraesviarias)
            infraviaricarrh.setFlags(infraviaricarrh.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarrh.setText(0, "Carreteres històriques")
            infraviaricarrh.setCheckState(0, Qt.Unchecked)
            infraviaricarrhc = QTreeWidgetItem(infraviaricarrh)
            infraviaricarrhc.setFlags(infraviaricarrhc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarrhc.setText(0, "Casetes de peons caminers-hostòrica")
            infraviaricarrhc.setCheckState(0, Qt.Unchecked)
            infraviaricarr76 = QTreeWidgetItem(infraviaricarrh)
            infraviaricarr76.setFlags(infraviaricarr76.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr76.setText(0, "Xarxa de carreteres any 1976")
            infraviaricarr76.setCheckState(0, Qt.Unchecked)
            infraviaricarr56 = QTreeWidgetItem(infraviaricarrh)
            infraviaricarr56.setFlags(infraviaricarr56.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr56.setText(0, "Xarxa de carreteres any 1956")
            infraviaricarr56.setCheckState(0, Qt.Unchecked)
            infraviaricarr09 = QTreeWidgetItem(infraviaricarrh)
            infraviaricarr09.setFlags(infraviaricarr09.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricarr09.setText(0, "Xarxa de carreteres any 1909")
            infraviaricarr09.setCheckState(0, Qt.Unchecked)
            infraviaricalz = QTreeWidgetItem(infraesviarias)
            infraviaricalz.setFlags(infraviaricalz.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaricalz.setText(0, "Calçades romanes")
            infraviaricalz.setCheckState(0, Qt.Unchecked)
            infraviariaug = QTreeWidgetItem(infraviaricalz)
            infraviariaug.setFlags(infraviariaug.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviariaug.setText(0, "Via Augusta")
            infraviariaug.setCheckState(0, Qt.Unchecked)
            infraviaridia = QTreeWidgetItem(infraviaricalz)
            infraviaridia.setFlags(infraviaridia.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviaridia.setText(0, "Via Dianium")
            infraviaridia.setCheckState(0, Qt.Unchecked)
            infraviarialac = QTreeWidgetItem(infraviaricalz)
            infraviarialac.setFlags(infraviarialac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviarialac.setText(0, "Ramal Alacant")
            infraviarialac.setCheckState(0, Qt.Unchecked)
            infraesmobili = QTreeWidgetItem(infraestructuras)
            infraesmobili.setText(0, "Mobilitat")
            infraviamobej = QTreeWidgetItem(infraesmobili)
            infraviamobej.setFlags(infraviamobej.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobej.setText(0, "Manual exemples constructius bons")
            infraviamobej.setCheckState(0, Qt.Unchecked)
            infraviamobejl = QTreeWidgetItem(infraviamobej)
            infraviamobejl.setFlags(infraviamobejl.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobejl.setText(0, "Línies d'intervenció")
            infraviamobejl.setCheckState(0, Qt.Unchecked)
            infraviamobcap = QTreeWidgetItem(infraviamobejl)
            infraviamobcap.setFlags(infraviamobcap.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobcap.setText(0, "Capacitat funcional")
            infraviamobcap.setCheckState(0, Qt.Unchecked)
            infraviamobpue = QTreeWidgetItem(infraviamobejl)
            infraviamobpue.setFlags(infraviamobpue.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobpue.setText(0, "Porta d'entrada")
            infraviamobpue.setCheckState(0, Qt.Unchecked)
            infraviamobcic = QTreeWidgetItem(infraviamobejl)
            infraviamobcic.setFlags(infraviamobcic.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobcic.setText(0, "Millora per als vianants ciclista")
            infraviamobcic.setCheckState(0, Qt.Unchecked)
            infraviamobmod = QTreeWidgetItem(infraviamobejl)
            infraviamobmod.setFlags(infraviamobmod.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobmod.setText(0, "Moderació de velocitat")
            infraviamobmod.setCheckState(0, Qt.Unchecked)
            infraviamobpea = QTreeWidgetItem(infraviamobejl)
            infraviamobpea.setFlags(infraviamobpea.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobpea.setText(0, "Permeabilitat per als vianants")
            infraviamobpea.setCheckState(0, Qt.Unchecked)
            infraviamobiti = QTreeWidgetItem(infraviamobejl)
            infraviamobiti.setFlags(infraviamobiti.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobiti.setText(0, "Itineraris accesibles")
            infraviamobiti.setCheckState(0, Qt.Unchecked)
            infraviamobordt = QTreeWidgetItem(infraviamobejl)
            infraviamobordt.setFlags(infraviamobordt.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobordt.setText(0, "Ordenació del transport")
            infraviamobordt.setCheckState(0, Qt.Unchecked)
            infraviamoborde = QTreeWidgetItem(infraviamobejl)
            infraviamoborde.setFlags(infraviamoborde.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamoborde.setText(0, "Ordenació de l'entorn")
            infraviamoborde.setCheckState(0, Qt.Unchecked)
            infraviamobactu = QTreeWidgetItem(infraviamobej)
            infraviamobactu.setFlags(infraviamobactu.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraviamobactu.setText(0, "Actuacions")
            infraviamobactu.setCheckState(0, Qt.Unchecked)
            infraesports = QTreeWidgetItem(infraestructuras)
            infraesports.setText(0, "Ports")
            infraportcv = QTreeWidgetItem(infraesports)
            infraportcv.setFlags(infraportcv.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportcv.setText(0, "Ports de la Comunitat Valenciana")
            infraportcv.setCheckState(0, Qt.Unchecked)
            infraportact = QTreeWidgetItem(infraesports)
            infraportact.setFlags(infraportact.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportact.setText(0, "Activitats nàutiques esportives")
            infraportact.setCheckState(0, Qt.Unchecked)
            infraportaca = QTreeWidgetItem(infraportact)
            infraportaca.setFlags(infraportaca.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportaca.setText(0, "Acadèmies nàutiques")
            infraportaca.setCheckState(0, Qt.Unchecked)
            infraportabu = QTreeWidgetItem(infraportact)
            infraportabu.setFlags(infraportabu.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraportabu.setText(0, "Centres de busseig")
            infraportabu.setCheckState(0, Qt.Unchecked)
            infraesruido = QTreeWidgetItem(infraestructuras)
            infraesruido.setText(0, "Soroll")
            infraesruidoma = QTreeWidgetItem(infraesruido)
            infraesruidoma.setFlags(infraesruidoma.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidoma.setText(0, "Mapes de soroll - Grans eixos viaris - 3ª fase")
            infraesruidoma.setCheckState(0, Qt.Unchecked)
            infraesruidomac = QTreeWidgetItem(infraesruidoma)
            infraesruidomac.setFlags(infraesruidomac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidomac.setText(0, "Condicionants acústics carreteres fase 3")
            infraesruidomac.setCheckState(0, Qt.Unchecked)
            infraesruidolden = QTreeWidgetItem(infraesruidoma)
            infraesruidolden.setFlags(infraesruidolden.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidolden.setText(0, "Lden carreteres fase 3")
            infraesruidolden.setCheckState(0, Qt.Unchecked)
            infraesruidold = QTreeWidgetItem(infraesruidoma)
            infraesruidold.setFlags(infraesruidold.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidold.setText(0, "Ld carreteres fase 3")
            infraesruidold.setCheckState(0, Qt.Unchecked)
            infraesruidole = QTreeWidgetItem(infraesruidoma)
            infraesruidole.setFlags(infraesruidole.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidole.setText(0, "Le carreteres fase 3")
            infraesruidole.setCheckState(0, Qt.Unchecked)
            infraesruidoln = QTreeWidgetItem(infraesruidoma)
            infraesruidoln.setFlags(infraesruidoln.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidoln.setText(0, "Ln carreteres fase 3")
            infraesruidoln.setCheckState(0, Qt.Unchecked)
            infraesruidofe = QTreeWidgetItem(infraesruido)
            infraesruidofe.setFlags(infraesruidofe.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidofe.setText(0, "Mapes de soroll - Grans eixos ferroviaris - 3ª fase")
            infraesruidofe.setCheckState(0, Qt.Unchecked)
            infraesruidomaf = QTreeWidgetItem(infraesruidofe)
            infraesruidomaf.setFlags(infraesruidomaf.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidomaf.setText(0, "Condicionants acústics ferroviaris fase 3")
            infraesruidomaf.setCheckState(0, Qt.Unchecked)
            infraesruidolden = QTreeWidgetItem(infraesruidofe)
            infraesruidolden.setFlags(infraesruidolden.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidolden.setText(0, "Lden ferroviaris fase 3")
            infraesruidolden.setCheckState(0, Qt.Unchecked)
            infraesruidold = QTreeWidgetItem(infraesruidofe)
            infraesruidold.setFlags(infraesruidold.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidold.setText(0, "Ld ferroviaris fase 3")
            infraesruidold.setCheckState(0, Qt.Unchecked)
            infraesruidole = QTreeWidgetItem(infraesruidofe)
            infraesruidole.setFlags(infraesruidole.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidole.setText(0, "Le ferroviaris fase 3")
            infraesruidole.setCheckState(0, Qt.Unchecked)
            infraesruidoln = QTreeWidgetItem(infraesruidofe)
            infraesruidoln.setFlags(infraesruidoln.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraesruidoln.setText(0, "Ln ferroviaris fase 3")
            infraesruidoln.setCheckState(0, Qt.Unchecked)
            telecomunicaciones = QTreeWidgetItem(infraestructuras)
            telecomunicaciones.setText(0, "Telecomunicacions")
            telecomunicacionesr = QTreeWidgetItem(telecomunicaciones)
            telecomunicacionesr.setFlags(telecomunicacionesr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesr.setText(0, "Cobertura xarxes fixes per velocitat d'accés")
            telecomunicacionesr.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm = QTreeWidgetItem(telecomunicacionesr)
            telecomunicacionesrm.setFlags(telecomunicacionesrm.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm.setText(0, "Per municipi")
            telecomunicacionesrm.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm100 = QTreeWidgetItem(telecomunicacionesrm)
            telecomunicacionesrm100.setFlags(telecomunicacionesrm100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm100.setText(0, "100 Mbps")
            telecomunicacionesrm100.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm30 = QTreeWidgetItem(telecomunicacionesrm)
            telecomunicacionesrm30.setFlags(telecomunicacionesrm30.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm30.setText(0, "30 Mbps")
            telecomunicacionesrm30.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrm10 = QTreeWidgetItem(telecomunicacionesrm)
            telecomunicacionesrm10.setFlags(telecomunicacionesrm10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrm10.setText(0, "10 Mbps")
            telecomunicacionesrm10.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn = QTreeWidgetItem(telecomunicacionesr)
            telecomunicacionesrn.setFlags(telecomunicacionesrn.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn.setText(0, "Per nucli de població")
            telecomunicacionesrn.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn100 = QTreeWidgetItem(telecomunicacionesrn)
            telecomunicacionesrn100.setFlags(telecomunicacionesrn100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn100.setText(0, "100 Mbps ")
            telecomunicacionesrn100.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn30 = QTreeWidgetItem(telecomunicacionesrn)
            telecomunicacionesrn30.setFlags(telecomunicacionesrn30.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn30.setText(0, "30 Mbps ")
            telecomunicacionesrn30.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrn10 = QTreeWidgetItem(telecomunicacionesrn)
            telecomunicacionesrn10.setFlags(telecomunicacionesrn10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrn10.setText(0, "10 Mbps ")
            telecomunicacionesrn10.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp = QTreeWidgetItem(telecomunicacionesr)
            telecomunicacionesrp.setFlags(telecomunicacionesrp.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp.setText(0, "Per polígon industrial")
            telecomunicacionesrp.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp100 = QTreeWidgetItem(telecomunicacionesrp)
            telecomunicacionesrp100.setFlags(telecomunicacionesrp100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp100.setText(0, "100 Mbps  ")
            telecomunicacionesrp100.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp30 = QTreeWidgetItem(telecomunicacionesrp)
            telecomunicacionesrp30.setFlags(telecomunicacionesrp30.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp30.setText(0, "30 Mbps  ")
            telecomunicacionesrp30.setCheckState(0, Qt.Unchecked)
            telecomunicacionesrp10 = QTreeWidgetItem(telecomunicacionesrp)
            telecomunicacionesrp10.setFlags(telecomunicacionesrp10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesrp10.setText(0, "10 Mbps  ")
            telecomunicacionesrp10.setCheckState(0, Qt.Unchecked)
            telecomunicacionesz = QTreeWidgetItem(telecomunicaciones)
            telecomunicacionesz.setFlags(telecomunicacionesz.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacionesz.setText(0, "Zones Blanques NGA")
            telecomunicacionesz.setCheckState(0, Qt.Unchecked)
            telecomunicacioneszr = QTreeWidgetItem(telecomunicacionesz)
            telecomunicacioneszr.setFlags(telecomunicacioneszr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacioneszr.setText(0, "Àrees residencials")
            telecomunicacioneszr.setCheckState(0, Qt.Unchecked)
            telecomunicacioneszi = QTreeWidgetItem(telecomunicacionesz)
            telecomunicacioneszi.setFlags(telecomunicacioneszi.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            telecomunicacioneszi.setText(0, "Àrees industrials")
            telecomunicacioneszi.setCheckState(0, Qt.Unchecked)
            transport = QTreeWidgetItem(infraestructuras)
            transport.setText(0, "Transports")
            transportt = QTreeWidgetItem(transport)
            transportt.setFlags(transportt.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            transportt.setText(0, "Taxi APC")
            transportt.setCheckState(0, Qt.Unchecked)
            industria = QTreeWidgetItem(capas)
            industria.setText(0, "Indústria")
            industriac = QTreeWidgetItem(industria)
            industriac.setText(0, "Certificats energètics")
            industriacer = QTreeWidgetItem(industriac)
            industriacer.setFlags(industriacer.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            industriacer.setText(0, "Certificats")
            industriacer.setCheckState(0, Qt.Unchecked)
            ordenacio = QTreeWidgetItem(capas)
            ordenacio.setText(0, "Ordenació del territori i Urbanisme")
            ordenacioar = QTreeWidgetItem(ordenacio)
            ordenacioar.setText(0, "Àrees crítiques front al Camvi Climàtic")
            ordenacioarac = QTreeWidgetItem(ordenacioar)
            ordenacioarac.setFlags(ordenacioarac.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioarac.setText(0, "Recàrrega d'aqüífers")
            ordenacioarac.setCheckState(0, Qt.Unchecked)
            ordenacioarper = QTreeWidgetItem(ordenacioar)
            ordenacioarper.setFlags(ordenacioarper.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioarper.setText(0, "Permeabilitat del sòl")
            ordenacioarper.setCheckState(0, Qt.Unchecked)
            ordenacioarpmar = QTreeWidgetItem(ordenacioar)
            ordenacioarpmar.setFlags(ordenacioarpmar.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioarpmar.setText(0, "Intrusió marina")
            ordenacioarpmar.setCheckState(0, Qt.Unchecked)
            ordenacioin = QTreeWidgetItem(ordenacio)
            ordenacioin.setText(0, "Infraestructura verda")
            ordenacioinreg = QTreeWidgetItem(ordenacioin)
            ordenacioinreg.setText(0, "Infraestructura verda regional")
            ordenacioinregca = QTreeWidgetItem(ordenacioinreg)
            ordenacioinregca.setFlags(ordenacioinregca.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinregca.setText(0, "Cavitats subterrànies catalogades - Municipis")
            ordenacioinregca.setCheckState(0, Qt.Unchecked)
            ordenacioinunes = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunes.setFlags(ordenacioinunes.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunes.setText(0, "Patrimoni Mundial de la Unesco")
            ordenacioinunes.setCheckState(0, Qt.Unchecked)
            ordenacioinunesl = QTreeWidgetItem(ordenacioinunes)
            ordenacioinunesl.setFlags(ordenacioinunesl.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunesl.setText(0, "Llotja de la seda de València")
            ordenacioinunesl.setCheckState(0, Qt.Unchecked)
            ordenacioinunesp = QTreeWidgetItem(ordenacioinunes)
            ordenacioinunesp.setFlags(ordenacioinunesp.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunesp.setText(0, "Palmerar d'Elx")
            ordenacioinunesp.setCheckState(0, Qt.Unchecked)
            ordenacioinunesa = QTreeWidgetItem(ordenacioinunes)
            ordenacioinunesa.setFlags(ordenacioinunesa.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunesa.setText(0, "Art rupestre de l'arc mediterrani de la peninsula ibèrica")
            ordenacioinunesa.setCheckState(0, Qt.Unchecked)
            ordenacioinuneam = QTreeWidgetItem(ordenacioinreg)
            ordenacioinuneam.setFlags(ordenacioinuneam.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinuneam.setText(0, "Zona d'amortiment de monuments naturals")
            ordenacioinuneam.setCheckState(0, Qt.Unchecked)
            ordenacioinunemo = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunemo.setFlags(ordenacioinunemo.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunemo.setText(0, "Monuments naturals")
            ordenacioinunemo.setCheckState(0, Qt.Unchecked)
            ordenacioinunezo = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunezo.setFlags(ordenacioinunezo.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunezo.setText(0, "Zones humides d'importància internacional")
            ordenacioinunezo.setCheckState(0, Qt.Unchecked)
            ordenacioinunezoc = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunezoc.setFlags(ordenacioinunezoc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunezoc.setText(0, "Zones humides catalogades")
            ordenacioinunezoc.setCheckState(0, Qt.Unchecked)
            ordenacioinunezop = QTreeWidgetItem(ordenacioinreg)
            ordenacioinunezop.setFlags(ordenacioinunezop.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinunezop.setText(0, "Zona de protecció de Zones Humides")
            ordenacioinunezop.setCheckState(0, Qt.Unchecked)
            ordenacioparque = QTreeWidgetItem(ordenacioinreg)
            ordenacioparque.setFlags(ordenacioparque.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioparque.setText(0, "Parcs Naturals")
            ordenacioparque.setCheckState(0, Qt.Unchecked)
            ordenacioparaje = QTreeWidgetItem(ordenacioinreg)
            ordenacioparaje.setFlags(ordenacioparaje.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioparaje.setText(0, "Paratges naturals municipals")
            ordenacioparaje.setCheckState(0, Qt.Unchecked)
            ordenacioreserva = QTreeWidgetItem(ordenacioinreg)
            ordenacioreserva.setFlags(ordenacioreserva.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioreserva.setText(0, "Reserves naturals")
            ordenacioreserva.setCheckState(0, Qt.Unchecked)
            ordenacioprotegido = QTreeWidgetItem(ordenacioinreg)
            ordenacioprotegido.setFlags(ordenacioprotegido.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioprotegido.setText(0, "Paisatges Protegits")
            ordenacioprotegido.setCheckState(0, Qt.Unchecked)
            ordenacioincopl = QTreeWidgetItem(ordenacioinreg)
            ordenacioincopl.setFlags(ordenacioincopl.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincopl.setText(0, "Incorporacions - Plans Sectorials")
            ordenacioincopl.setCheckState(0, Qt.Unchecked)
            ordenacioincopu = QTreeWidgetItem(ordenacioinreg)
            ordenacioincopu.setFlags(ordenacioincopu.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincopu.setText(0, "Incorporacions - Plans urbanístics")
            ordenacioincopu.setCheckState(0, Qt.Unchecked)
            ordenacioincopt = QTreeWidgetItem(ordenacioinreg)
            ordenacioincopt.setFlags(ordenacioincopt.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincopt.setText(0, "Incorporacions - Plans d'acció territorial")
            ordenacioincopt.setCheckState(0, Qt.Unchecked)
            ordenacioinzoso = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzoso.setFlags(ordenacioinzoso.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzoso.setText(0, "Zones sotmeses a perillositat d'inundació")
            ordenacioinzoso.setCheckState(0, Qt.Unchecked)
            ordenacioinmontes = QTreeWidgetItem(ordenacioinreg)
            ordenacioinmontes.setFlags(ordenacioinmontes.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmontes.setText(0, "Forests catalogats")
            ordenacioinmontes.setCheckState(0, Qt.Unchecked)
            ordenacioinlics = QTreeWidgetItem(ordenacioinreg)
            ordenacioinlics.setFlags(ordenacioinlics.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinlics.setText(0, "Llocs d'Interés Comunitari")
            ordenacioinlics.setCheckState(0, Qt.Unchecked)
            ordenacioinzepas = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzepas.setFlags(ordenacioinzepas.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzepas.setText(0, "Zones d'Especial Protecció per a les Aus")
            ordenacioinzepas.setCheckState(0, Qt.Unchecked)
            ordenacioinzepas = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzepas.setFlags(ordenacioinzepas.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzepas.setText(0, "Zones d'Especial Conservació")
            ordenacioinzepas.setCheckState(0, Qt.Unchecked)
            ordenacioinzepim = QTreeWidgetItem(ordenacioinreg)
            ordenacioinzepim.setFlags(ordenacioinzepim.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinzepim.setText(0, "Zones Especialment Protegides d'Importància per al Mediterrani")
            ordenacioinzepim.setCheckState(0, Qt.Unchecked)
            ordenacioinpatfor = QTreeWidgetItem(ordenacioinreg)
            ordenacioinpatfor.setFlags(ordenacioinpatfor.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinpatfor.setText(0, "Terreny forestal estratègic - PATFOR")
            ordenacioinpatfor.setCheckState(0, Qt.Unchecked)
            ordenacioincorre = QTreeWidgetItem(ordenacioinreg)
            ordenacioincorre.setFlags(ordenacioincorre.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioincorre.setText(0, "Corredors territorials")
            ordenacioincorre.setCheckState(0, Qt.Unchecked)
            ordenacioinregio = QTreeWidgetItem(ordenacioinreg)
            ordenacioinregio.setFlags(ordenacioinregio.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinregio.setText(0, "Paisatges de Rellevància Regional")
            ordenacioinregio.setCheckState(0, Qt.Unchecked)
            ordenacioinmun = QTreeWidgetItem(ordenacioin)
            ordenacioinmun.setText(0, "Infraestructura Verda Municipal")
            ordenacioinmun01 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun01.setFlags(ordenacioinmun01.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun01.setText(0, "IVM Espais Naturals Protegits")
            ordenacioinmun01.setCheckState(0, Qt.Unchecked)
            ordenacioinmun02 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun02.setFlags(ordenacioinmun02.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun02.setText(0, "IVM Xarxa Natura 2000")
            ordenacioinmun02.setCheckState(0, Qt.Unchecked)
            ordenacioinmun03 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun03.setFlags(ordenacioinmun03.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun03.setText(0, "IVM Aiguamolls Masses d'aigua")
            ordenacioinmun03.setCheckState(0, Qt.Unchecked)
            ordenacioinmun04 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun04.setFlags(ordenacioinmun04.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun04.setText(0, "IVM Patrim. Nat. Internacional")
            ordenacioinmun04.setCheckState(0, Qt.Unchecked)
            ordenacioinmun05 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun05.setFlags(ordenacioinmun05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun05.setText(0, "IVM Forest i sòl forestal")
            ordenacioinmun05.setCheckState(0, Qt.Unchecked)
            ordenacioinmun06 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun06.setFlags(ordenacioinmun06.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun06.setText(0, "IVM Riscos naturals")
            ordenacioinmun06.setCheckState(0, Qt.Unchecked)
            ordenacioinmun066 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun066.setFlags(ordenacioinmun066.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun066.setText(0, "IVM Àrees agrícoles")
            ordenacioinmun066.setCheckState(0, Qt.Unchecked)
            ordenacioinmun07 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun07.setFlags(ordenacioinmun07.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun07.setText(0, "IVM Espais paisatgístics (pun).")
            ordenacioinmun07.setCheckState(0, Qt.Unchecked)
            ordenacioinmun08 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun08.setFlags(ordenacioinmun08.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun08.setText(0, "IVM Espais paisatgístics (pol).")
            ordenacioinmun08.setCheckState(0, Qt.Unchecked)
            ordenacioinmun09 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun09.setFlags(ordenacioinmun09.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun09.setText(0, "IVM Valor Cultural (pun).")
            ordenacioinmun09.setCheckState(0, Qt.Unchecked)
            ordenacioinmun10 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun10.setFlags(ordenacioinmun10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun10.setText(0, "IVM Valor Cultural (pol).")
            ordenacioinmun10.setCheckState(0, Qt.Unchecked)
            ordenacioinmun11 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun11.setFlags(ordenacioinmun11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun11.setText(0, "IVM Connectors i Corridors (lin).")
            ordenacioinmun11.setCheckState(0, Qt.Unchecked)
            ordenacioinmun12 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun12.setFlags(ordenacioinmun12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun12.setText(0, "IVM Connectors i Corridors (pol).")
            ordenacioinmun12.setCheckState(0, Qt.Unchecked)
            ordenacioinmun13 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun13.setFlags(ordenacioinmun13.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun13.setText(0, "IVM Sòl urbà i Urbanitzable")
            ordenacioinmun13.setCheckState(0, Qt.Unchecked)
            ordenacioinmun14 = QTreeWidgetItem(ordenacioinmun)
            ordenacioinmun14.setFlags(ordenacioinmun14.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioinmun14.setText(0, "IVM Delimitació y planejament")
            ordenacioinmun14.setCheckState(0, Qt.Unchecked)
            ordenaciorecur = QTreeWidgetItem(ordenacioin)
            ordenaciorecur.setText(0, "Recursos Paisatgístics")
            ordenacioirecur1 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur1.setFlags(ordenacioirecur1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur1.setText(0, "RP Culturals locals (elements)")
            ordenacioirecur1.setCheckState(0, Qt.Unchecked)
            ordenacioirecur2 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur2.setFlags(ordenacioirecur2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur2.setText(0, "RP Culturals regionals (elements)")
            ordenacioirecur2.setCheckState(0, Qt.Unchecked)
            ordenacioirecur3 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur3.setFlags(ordenacioirecur3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur3.setText(0, "RP Culturals regionals (recintes)")
            ordenacioirecur3.setCheckState(0, Qt.Unchecked)
            ordenacioirecur6 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur6.setFlags(ordenacioirecur6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur6.setText(0, "RP Cavitats subterrànies catalogades - Municipis")
            ordenacioirecur6.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes = QTreeWidgetItem(ordenaciorecur)
            ordenaciorecurunes.setFlags(costesfotogr.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes.setText(0, "RP  Patrimoni mundial de la UNESCO")
            ordenaciorecurunes.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes1 = QTreeWidgetItem(ordenaciorecurunes)
            ordenaciorecurunes1.setFlags(ordenaciorecurunes1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes1.setText(0, "Llotja de la seda de València")
            ordenaciorecurunes1.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes2 = QTreeWidgetItem(ordenaciorecurunes)
            ordenaciorecurunes2.setFlags(ordenaciorecurunes2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes2.setText(0, "Palmerar d'Elxe")
            ordenaciorecurunes2.setCheckState(0, Qt.Unchecked)
            ordenaciorecurunes3 = QTreeWidgetItem(ordenaciorecurunes)
            ordenaciorecurunes3.setFlags(ordenaciorecurunes3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenaciorecurunes3.setText(0, "Art rupestre de l'arc mediterrani de la península ibèrica")
            ordenaciorecurunes3.setCheckState(0, Qt.Unchecked)
            ordenacioirecur4 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur4.setFlags(ordenacioirecur4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur4.setText(0, "RP Zona d'amortiment de monuments naturals")
            ordenacioirecur4.setCheckState(0, Qt.Unchecked)
            ordenacioirecur5 = QTreeWidgetItem(ordenaciorecur)
            ordenacioirecur5.setFlags(ordenacioirecur5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioirecur5.setText(0, "RP Monuments naturals")
            ordenacioirecur5.setCheckState(0, Qt.Unchecked)
            ordenaterrito = QTreeWidgetItem(ordenacioin)
            ordenaterrito.setText(0, "Ordenación territorial")
            ordenacioiterrito1 = QTreeWidgetItem(ordenaterrito)
            ordenacioiterrito1.setText(0, "PATRICOVA-Pla d'Acció Territorial de caràcter sectorial sobre prevenció del Risc d'Inundació a la Comunitat Valenciana")
            ordenacioiterrito1.setFlags(ordenacioiterrito1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito1.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito2 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito2.setText(0, "Estudis d'inundabilitat")
            ordenacioiterrito2.setFlags(ordenacioiterrito2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito2.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito3 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito3.setText(0, "Perillositat per inundació")
            ordenacioiterrito3.setFlags(ordenacioiterrito3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito3.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito4 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito4.setText(0, "Xarxa de llits")
            ordenacioiterrito4.setFlags(ordenacioiterrito4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito4.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito5 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito5.setText(0, "Perillositat 1")
            ordenacioiterrito5.setFlags(ordenacioiterrito5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito5.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito6 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito6.setText(0, "Perillositat 2")
            ordenacioiterrito6.setFlags(ordenacioiterrito6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito6.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito7 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito7.setText(0, "Perillositat 3")
            ordenacioiterrito7.setFlags(ordenacioiterrito7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito7.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito8 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito8.setText(0, "Perillositat 4")
            ordenacioiterrito8.setFlags(ordenacioiterrito8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito8.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito9 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito9.setText(0, "Perillositat 5")
            ordenacioiterrito9.setFlags(ordenacioiterrito9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito9.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito10 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito10.setText(0, "Perillositat 6")
            ordenacioiterrito10.setFlags(ordenacioiterrito10.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito10.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito11 = QTreeWidgetItem(ordenacioiterrito3)
            ordenacioiterrito11.setText(0, "Perillositat Geomorfològica")
            ordenacioiterrito11.setFlags(ordenacioiterrito11.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito11.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito12 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito12.setText(0, "Envoltant per perillositat per inundació")
            ordenacioiterrito12.setFlags(ordenacioiterrito12.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito12.setCheckState(0, Qt.Unchecked)
            ordenacioiterrito13 = QTreeWidgetItem(ordenacioiterrito1)
            ordenacioiterrito13.setText(0, "Risc d'inundació")
            ordenacioiterrito13.setFlags(ordenacioiterrito13.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiterrito13.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat = QTreeWidgetItem(ordenaterrito)
            ordenacioterritopat.setText(0, "PATIVEL")
            ordenacioterritopat.setFlags(ordenacioterritopat.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat1 = QTreeWidgetItem(ordenacioterritopat)
            ordenacioterritopat1.setText(0, "Zones de protecció")
            ordenacioterritopat1.setFlags(ordenacioterritopat1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat1.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat2 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat2.setText(0, "Àmbit estricte")
            ordenacioterritopat2.setFlags(ordenacioterritopat2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat2.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat3 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat3.setText(0, "Àmbit ampliat")
            ordenacioterritopat3.setFlags(ordenacioterritopat3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat3.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat4 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat4.setText(0, "Àmbit de conexió")
            ordenacioterritopat4.setFlags(ordenacioterritopat4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat4.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat5 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat5.setText(0, "Protecció litoral")
            ordenacioterritopat5.setFlags(ordenacioterritopat5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat5.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat6 = QTreeWidgetItem(ordenacioterritopat1)
            ordenacioterritopat6.setText(0, "Sòls transitoris")
            ordenacioterritopat6.setFlags(ordenacioterritopat6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat6.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat7 = QTreeWidgetItem(ordenacioterritopat)
            ordenacioterritopat7.setText(0, "Catàleg de platges de la C.V.")
            ordenacioterritopat7.setFlags(ordenacioterritopat7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat7.setCheckState(0, Qt.Unchecked)
            ordenacioterritopat8 = QTreeWidgetItem(ordenacioterritopat7)
            ordenacioterritopat8.setText(0, "Catàleg")
            ordenacioterritopat8.setFlags(ordenacioterritopat8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopat8.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer = QTreeWidgetItem(ordenaterrito)
            ordenacioterritohuer.setText(0, "Llei de l'Horta de València")
            ordenacioterritohuer.setFlags(ordenacioterritohuer.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer1 = QTreeWidgetItem(ordenacioterritohuer)
            ordenacioterritohuer1.setText(0, "Àmbit Llei de l'Horta")
            ordenacioterritohuer1.setFlags(ordenacioterritohuer1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer1.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer2 = QTreeWidgetItem(ordenaterrito)
            ordenacioterritohuer2.setText(0, "PAT de l'Horta")
            ordenacioterritohuer2.setFlags(ordenacioterritohuer.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer2.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer3 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer3.setText(0, "Àmbit estricte ")
            ordenacioterritohuer3.setFlags(ordenacioterritohuer3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer3.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer4 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer4.setText(0, "Àmbit ampliat ")
            ordenacioterritohuer4.setFlags(ordenacioterritohuer4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer4.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer5 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer5.setText(0, "Enclavaments horta")
            ordenacioterritohuer5.setFlags(ordenacioterritohuer5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer5.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer6 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer6.setText(0, "Disposició transotòria")
            ordenacioterritohuer6.setFlags(ordenacioterritohuer6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer6.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer7 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer7.setText(0, "Sectors recuperació horta")
            ordenacioterritohuer7.setFlags(ordenacioterritohuer7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer7.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer8 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer8.setText(0, "Zones rurals comunes")
            ordenacioterritohuer8.setFlags(ordenacioterritohuer8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer8.setCheckState(0, Qt.Unchecked)
            ordenacioterritohuer9 = QTreeWidgetItem(ordenacioterritohuer2)
            ordenacioterritohuer9.setText(0, "Àrees protecció horta")
            ordenacioterritohuer9.setFlags(ordenacioterritohuer9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritohuer9.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett = QTreeWidgetItem(ordenaterrito)
            ordenacioterritoett.setText(0, "Estratègia Territorial de la Comunitat Valenciana")
            ordenacioterritoett.setFlags(ordenacioterritoett.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett1 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett1.setText(0, "Municipis CV límits")
            ordenacioterritoett1.setFlags(ordenacioterritoett1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett1.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett2 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett2.setText(0, "Municipis CV etiquetes")
            ordenacioterritoett2.setFlags(ordenacioterritoett2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett2.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett3 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett3.setText(0, "Àrees funcionals")
            ordenacioterritoett3.setFlags(ordenacioterritoett3.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett3.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett4 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett4.setText(0, "Comarques")
            ordenacioterritoett4.setFlags(ordenacioterritoett4.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett4.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett5 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett5.setText(0, "Àmbit")
            ordenacioterritoett5.setFlags(ordenacioterritoett5.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett5.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett6 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett6.setText(0, "Àrea urbana integrada")
            ordenacioterritoett6.setFlags(ordenacioterritoett6.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett6.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett7 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett7.setText(0, "Sistema nodal de referència")
            ordenacioterritoett7.setFlags(ordenacioterritoett7.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett7.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett8 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett8.setText(0, "Tipus de node")
            ordenacioterritoett8.setFlags(ordenacioterritoett8.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett8.setCheckState(0, Qt.Unchecked)
            ordenacioterritoett9 = QTreeWidgetItem(ordenacioterritoett)
            ordenacioterritoett9.setText(0, "Àrea mercat Local treball")
            ordenacioterritoett9.setFlags(ordenacioterritoett9.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritoett9.setCheckState(0, Qt.Unchecked)
            ordenacioterritopend = QTreeWidgetItem(ordenaterrito)
            ordenacioterritopend.setText(0, "Pendientes (regulación territorial)")
            ordenacioterritopend.setFlags(ordenacioterritopend.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopend.setCheckState(0, Qt.Unchecked)
            ordenacioterritopend1 = QTreeWidgetItem(ordenacioterritopend)
            ordenacioterritopend1.setText(0, "Pendents (%)")
            ordenacioterritopend1.setFlags(ordenacioterritopend1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioterritopend1.setCheckState(0, Qt.Unchecked)
            ordenacioplanea = QTreeWidgetItem(ordenacioin)
            ordenacioplanea.setText(0, "Planejament Urbanístic")
            ordenacioiplane1 = QTreeWidgetItem(ordenacioplanea)
            ordenacioiplane1.setFlags(ordenacioiplane1.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiplane1.setText(0, "Classificació")
            ordenacioiplane1.setCheckState(0, Qt.Unchecked)
            ordenacioiplane2 = QTreeWidgetItem(ordenacioplanea)
            ordenacioiplane2.setFlags(ordenacioiplane2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiplane2.setText(0, "Zonificació")
            ordenacioiplane2.setCheckState(0, Qt.Unchecked)
            ordenacioplanean = QTreeWidgetItem(ordenacioplanea)
            ordenacioplanean.setText(0, "Reclassificacions no aprovades")
            ordenacioiplane3 = QTreeWidgetItem(ordenacioplanean)
            ordenacioiplane3.setFlags(ordenacioiplane2.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            ordenacioiplane3.setText(0, "Reclassificacions no aprovades")
            ordenacioiplane3.setCheckState(0, Qt.Unchecked)




        self.tree_toc.expandToDepth(0)  # Tree level in which it is presented when loaded

    """ Layer search function in the QtreeWidget """

    def searchLayer(self):
        if self.txt_busca_capa.text() == 'Busca capa...': # Help text
            pass
        else:  # Start the search if the text is not the help text
            text_capa = self.txt_busca_capa.text()  # Assign the search text to the variable
            self.list_capa.clear()
            if len(text_capa) > 2:  # Star the search if the text lenght is bigger than 3 characters
                self.list_capa.show()
                if self.rdb_cas.isChecked() == True: # Search in spanish
                    i = 0
                    for item in capasIDEV:  # We go through all the layers
                            if text_capa.lower() in capasIDEV[i]['nombre_cas'].lower():
                                self.list_capa.addItem(capasIDEV[i]['nombre_cas']) # If a layer matches the search pattern it is added to the listWisget
                            i = i + 1
                if self.rdb_val.isChecked() == True:  # Search in valencian
                    i = 0
                    for item in capasIDEV: # We go through all the layers
                        if text_capa.lower() in capasIDEV[i]['nombre_val'].lower():
                            self.list_capa.addItem(capasIDEV[i]['nombre_val']) # If a layer matches the search pattern it is added to the listWisget
                        i = i + 1
            else:
                self.list_capa.hide() # Hide the listWidget of the results of the layers search

    """ Function that when selecting a layer of the QTreeWidget activates the link button with the catalog """

    #@QtCore.pyqtSlot(QtWidgets.QTreeWidgetItem, int)
    def selectTreeLayer(self):
        self.tree_toc.clearSelection() # Clear the actual layers selection
        nom_capa = self.list_capa.currentItem().text() # We assign to the variable the selected layer of the QTreeWidget
        for item in self.tree_toc.findItems(nom_capa, Qt.MatchContains | Qt.MatchRecursive):
            self.tree_toc.setCurrentItem(item) # Capture of the selected item by clicking
            item.setSelected(True) # Select the item in the QTreeWidget
            item.setExpanded(True) # Expand the QtreeWidget at the item level
        if self.rdb_cas.isChecked() == True:
            self.txt_busca_capa.setText("Busca capa...")
        if self.rdb_val.isChecked() == True:
            self.txt_busca_capa.setText("Busca capa...")
        self.list_capa.hide()

    """ Function that closes the plugin """

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

""" We define the dictionary of layers outside the functions so that it is accessible in all """

path_capas_json = os.path.dirname(os.path.realpath(__file__)) + '/params.json' # Path of the JSON file with the definition of each layer
with open(path_capas_json, "r") as read_file:  # Read the JSON file
    capasIDEV = json.load(read_file)  # Store in a dictionary the JSON file, each element is a layer


""" We define the layer data structure as a class """

class capaIDEV:
    def __init__(self, nombre_cas, nombre_val, aviso_cas, aviso_val, metadato, url):
        self.nombre = nombre_cas
        self.tipo = nombre_val
        self.aviso = aviso_cas
        self.aviso = aviso_val
        self.metadato = metadato
        self.url = url

    def __str__(self):
        cadena = 'Nombre castellano: \n'.format(self.nombre_cas)
        cadena = 'Nombre valenciano: \n'.format(self.nombre_val)
        cadena = cadena + 'Aviso castellano: \n'.format(self.aviso_cas)
        cadena = cadena + 'Aviso valenciano: \n'.format(self.aviso_val)
        cadena = cadena + 'Metadato UIDD: \n'.format(self.metadato)
        cadena = cadena + 'URL conexión: \n'.format(self.url)
        return cadena
