# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IdevDockWidget
                                 A QGIS plugin
 Infraestructura Valenciana de Dades Espacials
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-08-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Alfonso Moya Fuero
        email                : moya_alf@gva.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import sys
import webbrowser
from PyQt5 import Qt, uic, QtGui, QtCore
from PyQt5.QtWidgets import QTreeWidgetItem, QMessageBox
from qgis.PyQt import *
from qgis.PyQt.QtCore import *
from qgis.utils import iface
from qgis.core import QgsRectangle, QgsRasterLayer, QgsProject, QgsVectorLayer, QgsLayerTreeGroup, QgsLayerTreeLayer, \
    QgsLayerTreeNode, QgsGeometry, QgsPointXY, QgsPoint
from PyQt5.QtGui import QPixmap
import requests, json
from json import loads
from qgis.PyQt.QtCore import QUrl
from qgis.PyQt.QtWebKitWidgets import QWebView

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'idev_visor_dockwidget_base.ui'))


class IdevDockWidget(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(IdevDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect

        self.iface = iface  # Loading the iface class to control QGIS events

        """ Configuration of the API event connections """
        self.setupUi(self)
        self.setupPlugin()  # Appearance initialization
        self.canvas = iface.mapCanvas()  # We take control of the canvas through the panel
        self.list_toponimia.hide()  # Hide the ListWidget of the results of the toponimic search
        self.list_capa.hide()  # We hide the list of the layer search engine, it will appear when doing search

        """ Dashboard widget event connectors """
        self.rdb_cas.toggled.connect(lambda:self.changeLanguage(self.rdb_cas))
        self.rdb_val.toggled.connect(lambda: self.changeLanguage(self.rdb_val))
        self.txt_toponimia.textChanged.connect(self.searchToponym)
        self.list_toponimia.itemClicked.connect(self.zoomToponym)
        self.cmb_capas_base.currentIndexChanged.connect(self.changeBaseMap)
        self.tree_toc.itemClicked.connect(self.selectTocLayer)
        self.tree_toc.itemChanged.connect(self.checkTreeLayer)
        self.txt_busca_capa.textChanged.connect(self.searchLayer)
        self.list_capa.itemClicked.connect(self.selectTreeLayer)
        self.btn_meta.clicked.connect(self.openCatalog)
        self.btn_icv.clicked.connect(self.openIcvSite)
        self.btn_idev.clicked.connect(self.openIdevSite)
        self.btn_help.clicked.connect(self.openHelp)

        """ Layer QTreeWidget Settings  """

        self.tree_toc.headerItem().setText(0, "")

        """ We dynamically load the layers in the QtreeWidget at various parent / child levels """

        self.createTree()

    """ Function to load the initial appearance of the plugin  """
    def setupPlugin(self):
        baseDirectory = os.path.dirname(os.path.realpath(__file__)) # Plugin absolute path
        #self.im_idev = QPixmap(os.path.dirname(os.path.realpath(__file__)) + '/IDEV_Logo.png')
        #self.txt_logo_1.setPixmap(self.im_idev)  # Load the ICV lgo
        self.im_icv = QPixmap(os.path.dirname(os.path.realpath(__file__)) + '/IDEV.png')
        self.txt_logo_2.setPixmap(self.im_icv)   # Loading the IDEV logo
        self.rdb_cas.setChecked(True)   # Default language "Castellano"
        self.btn_meta.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/info_on.png'))
        self.btn_icv.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/icon.png'))
        self.btn_idev.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/icon_idev.png'))
        self.btn_help.setIcon(QtGui.QIcon(os.path.dirname(os.path.realpath(__file__)) + '/help.png'))

    """ Function that changes the language of the controls. The languages are Spanish / Valencian """

    def changeLanguage(self, b):
        self.createTree()  # Function that changes the language of the controls. The languages are Spanish / Valencian
        self.txt_capa_seleccionada.setEnabled(False)  # Activate the label of the active layer
        self.txt_capa_seleccionada.setText("")  # Claer the text of the label layer name
        self.txt_info_capa.setEnabled(False)  # Desactivate the label of the layer name
        self.btn_meta.setEnabled(False)  # Desactivate the button of the info layer
        """ Check the language and set the text of the widgets """
        if b.text() == "Cas":
            if self.rdb_cas.isChecked():
                self.txt_toponimia.setText("Busca topónimo, dirección o ref. catastral")
                self.txt_busca_capa.setText("Busca capa...")
                self.cmb_capas_base.setItemText(0, "Sin fondo")
                self.cmb_capas_base.setItemText(1, "Imagen")
                self.cmb_capas_base.setItemText(2, "Híbrido")
                self.cmb_capas_base.setItemText(3, "Relieve")
                self.cmb_capas_base.setItemText(4, "Topográfico")
                self.cmb_capas_base.setItemText(5, "Topográfico gris")
                self.cmb_capas_base.setItemText(6, "Topográfico básico")
                self.txt_info_capa.setText("Catálogo de la IDEV:")
                """ Tooltilps translations to Spanish """
                self.btn_icv.setToolTip("Ir a la web del Institut Cartogràfic Valencià")
                self.btn_idev.setToolTip("Ir a la web de la Infraestructura Valenciana de Datos Espaciales")
                self.cmb_capas_base.setToolTip("Seleccionar capa base de fondo")
                self.txt_toponimia.setToolTip("Inserte el texto para la búsqueda toponímica")
                self.btn_meta.setToolTip("Pulsar para consultar el catálogo de la IDEV de la capa seleccionada")
                self.rdb_cas.setToolTip("Activar para traducir el complemento al castellano")
                self.rdb_val.setToolTip("Activar para traducir el complemento al valenciano")
                self.txt_busca_capa.setToolTip("Inserte el texto para la búsqueda de capas")
        if b.text() == "Val":
            if self.rdb_val.isChecked():
                self.txt_toponimia.setText("Busca topònim, direcció o ref. cadastral")
                self.txt_busca_capa.setText("Busca capa...")
                self.cmb_capas_base.setItemText(0, "Sense fons")
                self.cmb_capas_base.setItemText(1, "Imatge")
                self.cmb_capas_base.setItemText(2, "Híbrid")
                self.cmb_capas_base.setItemText(3, "Relleu")
                self.cmb_capas_base.setItemText(4, "Topogràfic")
                self.cmb_capas_base.setItemText(5, "Topogràfic gris")
                self.cmb_capas_base.setItemText(6, "Topogràfic bàsic")
                self.txt_info_capa.setText("Catàleg de la IDEV:")
                """ Tooltilps translations to Valencian """
                self.btn_icv.setToolTip("Anar a la web de l'Institut Cartogràfic Valencià")
                self.btn_idev.setToolTip("Anar a la web de la Infraestructura Valenciana de Dades Espacials")
                self.cmb_capas_base.setToolTip("Seleccionar capa base de fons")
                self.txt_toponimia.setToolTip("Inserisca el text per a la cerca toponímica")
                self.btn_meta.setToolTip("Prémer per a consultar el catàleg de la IDEV de la capa seleccionada")
                self.rdb_cas.setToolTip("Activar per a traduir el complement al castellà")
                self.rdb_val.setToolTip("Activar per a traduir el complement al valencià")
                self.txt_busca_capa.setToolTip("Inserisca el text per a la cerca de capes")

    """  Function for toponymy search. Connection with the IDEV search engine service """

    def searchToponym(self):
        # Disable the search with the default help text of the control
        if self.txt_toponimia.text() == 'Busca topónimo, dirección o ref. catastral' or self.txt_toponimia.text() == 'Busca topònim, direcció o ref. cadastral':
            pass
        # When change the text of the textline activate the search
        else:
            text = self.txt_toponimia.text()
            self.list_toponimia.clear()
            if len(text) > 2:  # The search began when type 3 or more characters
                self.list_toponimia.show()  # Show the textlist of the results of the search
                url = 'http://descargas.icv.gva.es/server_api/buscador/solrclient.php?start=0&limit=40&query=' + text   # Create the url search query
                s = requests.get(str(url)).text  # Request the query
                start = s.find("[") + len("[")
                end = s.find("]")
                substring = "[" + s[start:end] + "]" # Format of the response. Create a JSON file
                # print(substring)
                y = json.loads(substring)  # Load the result as a JSON file
                i = len(y)  # Calculate the lenght of the query result
                for x in range(0, i):   # Load in the ListWidget the results of the query
                    titulo = y[x]["titulo"]
                    clasificacion = y[x]["clasificacion"]
                    descripcion = y[x]["descripcion"]
                    if titulo.find('\n') != -1:
                        titulo = titulo.replace('\n', '')  # remove that character of some query results
                    if descripcion == '':
                        descripcion = ''
                    else:
                        descripcion = "\n" + descripcion  # Format the result in the ListWidget
                    widgetText = QtWidgets.QListWidgetItem('{0}'.format(titulo) + "\t " + clasificacion + descripcion)
                    self.list_toponimia.addItem(widgetText)  # Add items to the ListWidget
            else:
                self.list_toponimia.hide()  # If the query is null, hide the ListWidget

    """ Function that centers the zoom on the toponym selected from the ListWidget  """

    def zoomToponym(self):
        texto = self.list_toponimia.currentItem().text()  # Capture the exact name of the toponym
        text, tipo = texto.split("\t")  # Split the information of the toponym
        self.txt_toponimia.setText(text)  # Write the toponymin the labeltext of search
        text = text.replace('/', '')  # Format the toponym text
        url = 'http://descargas.icv.gva.es/server_api/buscador/solrclient.php?start=0&limit=40&query=' + text  # Create the query with the exact toponym
        s = requests.get(str(url)).text
        start = s.find("[") + len("[")
        end = s.find("]")
        substring = "[" + s[start:end] + "]"  # Format of the response. Create a JSON file
        y = json.loads(substring)  # Load the result as a JSON file
        extent = y[0]["boundingbox"]  # Get the boundingbox of the toponym
        XMin, Ymin, XMax, Ymax = extent.split(",")  # Asign the coordinates of the extent
        zoomRectangle = QgsRectangle(float(XMin), float(Ymin), float(XMax), float(Ymax))  # Create a zoomRectangle
        self.iface.mapCanvas().setExtent(zoomRectangle)  # Set the extent o the project
        if XMin == XMax:
            self.iface.mapCanvas().zoomScale(1000)  # Default scale if the toponym is a puntual shape
        self.iface.mapCanvas().refresh()  # Refresh the canvas view
        self.list_toponimia.hide()  # Hide the listwidget

    """ Function to load the background base layers  """

    def changeBaseMap(self):
        extent = self.canvas.extent()  # Store the actual extent in a variable
        names = [layer.name() for layer in QgsProject.instance().mapLayers().values()]  # Store in a list the names of the layers
        for i in names:  # Unload the layer by name
            if i == 'Contorno autonómico':
                self.unloadLayerToc('Contorno autonómico')
            if i == 'Ortofoto 2019':
                self.unloadLayerToc('Ortofoto 2019')
            if i == 'ESRI Satellite':
                self.unloadLayerToc('ESRI Satellite')
            if i == 'Capa base Híbrido':
                self.unloadLayerToc('Capa base Híbrido')
            if i == 'Capa base Relieve':
                self.unloadLayerToc('Capa base Relieve')
            if i == 'Capa base Topográfico':
                self.unloadLayerToc('Capa base Topográfico')
            if i == 'Capa base Topográfico Básico':
                self.unloadLayerToc('Capa base Topográfico Básico')
            if i == 'Capa base Topográfico Gris':
                self.unloadLayerToc('Capa base Topográfico Gris')

        """ Loading the different base layers in the project  """

        if self.cmb_capas_base.currentIndex() == 1:
            urlWithParams_cv = "crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map"
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_orto = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=01_8bits_01_RGB_05_PNG&styles&tileMatrixSet=01_8bits_01_RGB_05_PNG-wmsc-0&url=http://terramapas.icv.gva.es/odcv05_etrs89h30_2019_3857'
            rasterLyr_orto = QgsRasterLayer(urlWithParams_orto, 'Ortofoto 2019', 'wms')
            if not rasterLyr_orto.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_orto, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_orto))
            urlWithParams_esri = 'type=xyz&zmin=0&zmax=20&url=https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}'
            rasterLyr_esri = QgsRasterLayer(urlWithParams_esri, 'ESRI Satellite', 'wms')
            if not rasterLyr_esri.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_esri, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_esri))

        if self.cmb_capas_base.currentIndex() == 2:
            urlWithParams_hibrido = 'crs=EPSG:3857&dpiMode=7&format=image/png&layers=mapabase_hibrid&styles&tileMatrixSet=mapabase_hibrid-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_hibrid/'
            rasterLyr_hibrido = QgsRasterLayer(urlWithParams_hibrido, 'Capa base Híbrido', 'wms')
            if not rasterLyr_hibrido.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_hibrido, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_hibrido))
            urlWithParams_orto = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=01_8bits_01_RGB_05_PNG&styles&tileMatrixSet=01_8bits_01_RGB_05_PNG-wmsc-0&url=http://terramapas.icv.gva.es/odcv05_etrs89h30_2019_3857'
            rasterLyr_orto = QgsRasterLayer(urlWithParams_orto, 'Ortofoto 2019', 'wms')
            if not rasterLyr_orto.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_orto, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_orto))
            urlWithParams_esri = 'type=xyz&zmin=0&zmax=20&url=https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}'
            rasterLyr_esri = QgsRasterLayer(urlWithParams_esri, 'ESRI Satellite', 'wms')
            if not rasterLyr_esri.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_esri, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_esri))

        if self.cmb_capas_base.currentIndex() == 3:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_relieve = 'crs=EPSG:3857&dpiMode=7&format=image/png&layers=01_8bits_01_RGB_05_PNG&styles&tileMatrixSet=01_8bits_01_RGB_05_PNG-wmsc-1&url=http://terramapas.icv.gva.es/mapabase_isohipsas'
            rasterLyr_relieve = QgsRasterLayer(urlWithParams_relieve, 'Capa base Relieve', 'wms')
            if not rasterLyr_relieve.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_relieve, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_relieve))

        if self.cmb_capas_base.currentIndex() == 4:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_topografico = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=topografico_continuo_epsg3857&styles&tileMatrixSet=topografico_continuo_epsg3857-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_topografico/'
            rasterLyr_topografico = QgsRasterLayer(urlWithParams_topografico, 'Capa base Topográfico', 'wms')
            if not rasterLyr_topografico.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_topografico, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_topografico))

        if self.cmb_capas_base.currentIndex() == 5:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))

            urlWithParams_gris = 'crs=EPSG:3857&dpiMode=7&format=image/png;%20mode%3D8bit&layers=mapabase_topografico_grises&styles&tileMatrixSet=mapabase_topografico_grises-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_topografico_grises'
            rasterLyr_gris = QgsRasterLayer(urlWithParams_gris, 'Capa base Topográfico Gris', 'wms')
            if not rasterLyr_gris.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_gris, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_gris))

        if self.cmb_capas_base.currentIndex() == 6:
            urlWithParams_cv = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=limites_continuo&styles&url=https://terramapas.icv.gva.es/cgi-bin/mapserv.fcgi?map%3D/srv_apl/mapserv/servicios/01_cartografia/05_unidadesadm/01_contorno_autonomico/contorno_autonomico.map'
            rasterLyr_cv = QgsRasterLayer(urlWithParams_cv, 'Contorno autonómico', 'wms')
            if not rasterLyr_cv.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_cv, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_cv))
            urlWithParams_basico = 'crs=EPSG:3857&dpiMode=7&format=image/png&layers=mapabase_basico&styles&tileMatrixSet=mapabase_basico-wmsc-0&url=http://terramapas.icv.gva.es/mapabase_basico/'
            rasterLyr_basico = QgsRasterLayer(urlWithParams_basico, 'Capa base Topográfico Básico', 'wms')
            if not rasterLyr_basico.isValid():
                print("Capa no válida")
                iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
            else:
                QgsProject.instance().addMapLayer(rasterLyr_basico, False)
                layerTree = iface.layerTreeCanvasBridge().rootGroup()
                layerTree.insertChildNode(-1, QgsLayerTreeLayer(rasterLyr_basico))

        iface.mapCanvas().setExtent(extent)
        iface.mapCanvas().refresh()

    """ Selecting a layer in the layer tree and activating the catalog button  """

    #@QtCore.pyqtSlot(QtWidgets.QTreeWidgetItem, int)
    def selectTocLayer(self):
        i = 0
        for ix in self.tree_toc.selectedIndexes():
            if self.rdb_cas.isChecked() == True:
                for nombre in capasIDEV:
                    if ix.data() == nombre['nombre_cas'] and i == 0:
                        self.btn_meta.setEnabled(True)
                        self.txt_info_capa.setEnabled(True)
                        self.txt_capa_seleccionada.setText(nombre['nombre_cas'])
                        self.txt_capa_seleccionada.setEnabled(True)
                        i = i  + 1

            if self.rdb_val.isChecked() == True:
                for nombre in capasIDEV:
                    if ix.data() == nombre['nombre_val']:
                        self.btn_meta.setEnabled(True)
                        self.txt_info_capa.setEnabled(True)
                        self.txt_capa_seleccionada.setText(nombre['nombre_val'])
                        self.txt_capa_seleccionada.setEnabled(True)

    """ Button to open the ICV website   """

    def openIcvSite(self):
        if self.rdb_cas.isChecked() == True:
            webbrowser.open('http://www.icv.gva.es/es/inicio')
        if self.rdb_val.isChecked() == True:
            webbrowser.open('http://www.icv.gva.es/va/inicio')

    """ Button to open the IDEV website   """

    def openIdevSite(self):
        if self.rdb_cas.isChecked() == True:
            webbrowser.open('http://www.idev.gva.es/es/inicio')
        if self.rdb_val.isChecked() == True:
            webbrowser.open('http://www.idev.gva.es/va/inicio')

    def openHelp(self):
        if self.rdb_cas.isChecked() == True:
            webbrowser.open(os.path.dirname(os.path.realpath(__file__)) + '/data/help_cast.html')
        if self.rdb_val.isChecked() == True:
            webbrowser.open(os.path.dirname(os.path.realpath(__file__)) + '/data/help_val.html')

    """ Button to open the catalog website of the selected layer in the QTreeWidget """

    def openCatalog(self):  # The layer name is different in each language, there is a different search in the layer dictionary
        if self.rdb_cas.isChecked() == True:
            for nombre in capasIDEV:
                if self.txt_capa_seleccionada.text() == nombre['nombre_cas']:
                    webbrowser.open('http://www.icv.gva.es/auto/aplicaciones/icv_geocat/#/search?uuid=' + nombre['metadato']) # Open the catalog
        if self.rdb_val.isChecked() == True:
            for nombre in capasIDEV:
                if self.txt_capa_seleccionada.text() == nombre['nombre_val']:
                    webbrowser.open('http://www.icv.gva.es/auto/aplicaciones/icv_geocat/#/search?uuid=' + nombre['metadato']) # Open the catalog

    """ Load the layer in the QGIS project whrn check the item in the QTreeWidget """

    def checkTreeLayer(self, it, col): # The layer name is different in each language, there is a different search in the layer dictionary
        if self.rdb_cas.isChecked() == True:
            for nombre in capasIDEV:  # Search in the layer dictionary by spanish name
                if it.checkState(0) == QtCore.Qt.Checked:
                    if it.text(col) == nombre['nombre_cas']:
                        self.loadLayerToc(nombre['url'], nombre['nombre_cas'])  # load the layer Checked in the QGIS project
                        if nombre['aviso_cas'] != "":
                            msg = QMessageBox.information(self, "Aviso:", nombre['aviso_cas'])  # Show advice if is not null
                            #msg.exec()
                else:
                    if it.text(col) == nombre['nombre_cas']:
                        try:
                            self.unloadLayerToc(nombre['nombre_cas']) # Unload the layer of the proyect if is unchecked
                        except:
                            pass

        if self.rdb_val.isChecked() == True:
            for nombre in capasIDEV:  # Search in the layer dictionary by valencian name
                if it.checkState(0) == QtCore.Qt.Checked:
                    if it.text(col) == nombre['nombre_val']:
                        self.loadLayerToc(nombre['url'], nombre['nombre_val'])  # load the layer Checked in the QGIS project
                        if nombre['aviso_val'] != "":
                            msg = QMessageBox.information(self, "Avís:", nombre['aviso_val']) # Show advice if is not null
                            #msg.exec()
                else:
                    if it.text(col) == nombre['nombre_val']:
                        self.unloadLayerToc(nombre['nombre_val'])  # Unload the layer of the proyect if is unchecked

    """ Funcion for load a layer in the QGIS project by name and url connection string """

    def loadLayerToc(self, url, nombre):
        layer = QgsRasterLayer(url, nombre, 'wms')  # Create a PyQt layer
        if not layer.isValid():
            print("Capa no válida")
            iface.messageBar().pushMessage("Error", "Capa no válida", level=Qgis.Critical, duration=5)
        else:
            QgsProject.instance().addMapLayer(layer, False)  # Add the layer in the project
            layerTree = iface.layerTreeCanvasBridge().rootGroup()  # Add the layer on the top of the TOC
            layerTree.insertChildNode(0, QgsLayerTreeLayer(layer))

    """ Funcion for unload a layer in the QGIS project by layers name """

    def unloadLayerToc(self, nombre):
        try:
            QgsProject.instance().removeMapLayer(QgsProject.instance().mapLayersByName(nombre)[0])  # Unload the layer form the TOC
        except:
            pass
        iface.mapCanvas().refresh()  # Refresh the projet view in QGIS

    """ Function to dynamically load the layers in the QTreeWidget in the corresponding language """

    def createTree(self):
        self.tree_toc.clear() # Clear the tree
        carto = QTreeWidgetItem(self.tree_toc)  # Create the QtreeWidget
        if self.rdb_cas.isChecked() == True: # Create the fahther and child nodes in spanish
            carto.setText(0, "Cartografía de referencia") # First item of the tree, father 0
            # carto.setFlags(carto.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            toponimia = QTreeWidgetItem(carto)
            toponimia.setFlags(toponimia.flags() | Qt.ItemIsUserCheckable)
            toponimia.setText(0, "Nomenclator Toponimico Valenciano")
            toponimia.setCheckState(0, Qt.Unchecked)
            basecartografica05 = QTreeWidgetItem(carto)
            basecartografica05.setText(0, "Base Cartográfica CV05")
            orografia05 = QTreeWidgetItem(basecartografica05)
            orografia05.setFlags(orografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia05.setText(0, "Orografía")
            orografia05.setCheckState(0, Qt.Unchecked)
            puntoscota = QTreeWidgetItem(orografia05)
            puntoscota.setFlags(puntoscota.flags() | Qt.ItemIsUserCheckable)
            puntoscota.setText(0, "Puntos de cota CV05")
            puntoscota.setCheckState(0, Qt.Unchecked)
            orolineas = QTreeWidgetItem(orografia05)
            orolineas.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            orolineas.setText(0, "Orografía líneas CV05")
            orolineas.setCheckState(0, Qt.Unchecked)
            curvasnivel = QTreeWidgetItem(orografia05)
            curvasnivel.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            curvasnivel.setText(0, "Curvas de nivel CV05")
            curvasnivel.setCheckState(0, Qt.Unchecked)
            hidrografia05 = QTreeWidgetItem(basecartografica05)
            hidrografia05.setFlags(hidrografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia05.setText(0, "Hidrografía")
            hidrografia05.setCheckState(0, Qt.Unchecked)
            hidropuntos05 = QTreeWidgetItem(hidrografia05)
            hidropuntos05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidropuntos05.setText(0, "Hidrografía puntual CV05")
            hidropuntos05.setCheckState(0, Qt.Unchecked)
            hidrolineas05 = QTreeWidgetItem(hidrografia05)
            hidrolineas05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidrolineas05.setText(0, "Hidrografía lineal CV05")
            hidrolineas05.setCheckState(0, Qt.Unchecked)
            construcciones05 = QTreeWidgetItem(basecartografica05)
            construcciones05.setFlags(construcciones05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            construcciones05.setText(0, "Edificaciones y construcciones")
            construcciones05.setCheckState(0, Qt.Unchecked)
            construpuntos05 = QTreeWidgetItem(construcciones05)
            construpuntos05.setFlags(construpuntos05.flags() | Qt.ItemIsUserCheckable)
            construpuntos05.setText(0, "Construcciones puntuales CV05")
            construpuntos05.setCheckState(0, Qt.Unchecked)
            construservi05 = QTreeWidgetItem(construcciones05)
            construservi05.setFlags(construservi05.flags() | Qt.ItemIsUserCheckable)
            construservi05.setText(0, "Servicios e instalaciones CV05")
            construservi05.setCheckState(0, Qt.Unchecked)
            construlinea05 = QTreeWidgetItem(construcciones05)
            construlinea05.setFlags(construlinea05.flags() | Qt.ItemIsUserCheckable)
            construlinea05.setText(0, "Construcciones lineales CV05")
            construlinea05.setCheckState(0, Qt.Unchecked)
            construedifi05 = QTreeWidgetItem(construcciones05)
            construedifi05.setFlags(construedifi05.flags() | Qt.ItemIsUserCheckable)
            construedifi05.setText(0, "Edificaciones CV05")
            construedifi05.setCheckState(0, Qt.Unchecked)
            construcons05 = QTreeWidgetItem(construcciones05)
            construcons05.setFlags(construcons05.flags() | Qt.ItemIsUserCheckable)
            construcons05.setText(0, "Construcciones CV05")
            construcons05.setCheckState(0, Qt.Unchecked)
            usos05 = QTreeWidgetItem(basecartografica05)
            usos05.setFlags(usos05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            usos05.setText(0, "Usos del suelo")
            usos05.setCheckState(0, Qt.Unchecked)
            usoshidro05 = QTreeWidgetItem(usos05)
            usoshidro05.setFlags(usoshidro05.flags() | Qt.ItemIsUserCheckable)
            usoshidro05.setText(0, "Hidrografía CV05")
            usoshidro05.setCheckState(0, Qt.Unchecked)
            usosarboles05 = QTreeWidgetItem(usos05)
            usosarboles05.setFlags(usosarboles05.flags() | Qt.ItemIsUserCheckable)
            usosarboles05.setText(0, "Zonas arboladas CV05")
            usosarboles05.setCheckState(0, Qt.Unchecked)
            usosinfra05 = QTreeWidgetItem(usos05)
            usosinfra05.setFlags(usosinfra05.flags() | Qt.ItemIsUserCheckable)
            usosinfra05.setText(0, "Infraestructuras viarias CV05")
            usosinfra05.setCheckState(0, Qt.Unchecked)
            usosserv05 = QTreeWidgetItem(usos05)
            usosserv05.setFlags(usosserv05.flags() | Qt.ItemIsUserCheckable)
            usosserv05.setText(0, "Servicios e instalaciones CV05")
            usosserv05.setCheckState(0, Qt.Unchecked)
            usoscultiv05 = QTreeWidgetItem(usos05)
            usoscultiv05.setFlags(usoscultiv05.flags() | Qt.ItemIsUserCheckable)
            usoscultiv05.setText(0, "Cultivos CV05")
            usoscultiv05.setCheckState(0, Qt.Unchecked)
            usosentorn05 = QTreeWidgetItem(usos05)
            usosentorn05.setFlags(usosentorn05.flags() | Qt.ItemIsUserCheckable)
            usosentorn05.setText(0, "Entornos urbanos CV05")
            usosentorn05.setCheckState(0, Qt.Unchecked)
            vias05 = QTreeWidgetItem(basecartografica05)
            vias05.setFlags(vias05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            vias05.setText(0, "Vias de Comunicación")
            vias05.setCheckState(0, Qt.Unchecked)
            viasnomen05 = QTreeWidgetItem(vias05)
            viasnomen05.setFlags(viasnomen05.flags() | Qt.ItemIsUserCheckable)
            viasnomen05.setText(0, "Nomenclatura infraestructura viaria CV05")
            viasnomen05.setCheckState(0, Qt.Unchecked)
            viasferro05 = QTreeWidgetItem(vias05)
            viasferro05.setFlags(viasferro05.flags() | Qt.ItemIsUserCheckable)
            viasferro05.setText(0, "Red de ferrocarriles CV05")
            viasferro05.setCheckState(0, Qt.Unchecked)
            viascomu05 = QTreeWidgetItem(vias05)
            viascomu05.setFlags(viascomu05.flags() | Qt.ItemIsUserCheckable)
            viascomu05.setText(0, "Red de comunicaciones CV05")
            viascomu05.setCheckState(0, Qt.Unchecked)
            basecartografica50 = QTreeWidgetItem(carto)
            basecartografica50.setText(0, "Base Cartográfica CV50")
            orografia50 = QTreeWidgetItem(basecartografica50)
            orografia50.setFlags(orografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia50.setText(0, "Orografía  ")
            orografia50.setCheckState(0, Qt.Unchecked)
            orografiacosta50 = QTreeWidgetItem(orografia50)
            orografiacosta50.setFlags(orografiacosta50.flags() | Qt.ItemIsUserCheckable)
            orografiacosta50.setText(0, "Línea de costa CV50")
            orografiacosta50.setCheckState(0, Qt.Unchecked)
            orografiacurva50 = QTreeWidgetItem(orografia50)
            orografiacurva50.setFlags(orografiacurva50.flags() | Qt.ItemIsUserCheckable)
            orografiacurva50.setText(0, "Curvas de nivel CV50")
            orografiacurva50.setCheckState(0, Qt.Unchecked)
            hidrografia50 = QTreeWidgetItem(basecartografica50)
            hidrografia50.setFlags(hidrografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia50.setText(0, "Hidrografía")
            hidrografia50.setCheckState(0, Qt.Unchecked)
            hidrocursoa50 = QTreeWidgetItem(hidrografia50)
            hidrocursoa50.setFlags(hidrocursoa50.flags() | Qt.ItemIsUserCheckable)
            hidrocursoa50.setText(0, "Curso natural CV50")
            hidrocursoa50.setCheckState(0, Qt.Unchecked)
            hidrocurson50 = QTreeWidgetItem(hidrografia50)
            hidrocurson50.setFlags(hidrocurson50.flags() | Qt.ItemIsUserCheckable)
            hidrocurson50.setText(0, "Curso artificial CV50")
            hidrocurson50.setCheckState(0, Qt.Unchecked)
            hidrolecho50 = QTreeWidgetItem(hidrografia50)
            hidrolecho50.setFlags(hidrolecho50.flags() | Qt.ItemIsUserCheckable)
            hidrolecho50.setText(0, "Lecho natural CV50")
            hidrolecho50.setCheckState(0, Qt.Unchecked)
            hidroembal50 = QTreeWidgetItem(hidrografia50)
            hidroembal50.setFlags(hidroembal50.flags() | Qt.ItemIsUserCheckable)
            hidroembal50.setText(0, "Embalse CV50")
            hidroembal50.setCheckState(0, Qt.Unchecked)
            hidrolago50 = QTreeWidgetItem(hidrografia50)
            hidrolago50.setFlags(hidrolago50.flags() | Qt.ItemIsUserCheckable)
            hidrolago50.setText(0, "Lago CV50")
            hidrolago50.setCheckState(0, Qt.Unchecked)
            hidroisla50 = QTreeWidgetItem(hidrografia50)
            hidroisla50.setFlags(hidroisla50.flags() | Qt.ItemIsUserCheckable)
            hidroisla50.setText(0, "Isla CV50")
            hidroisla50.setCheckState(0, Qt.Unchecked)
            edificacion50 = QTreeWidgetItem(basecartografica50)
            edificacion50.setFlags(edificacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edificacion50.setText(0, "Edificaciones y construcciones")
            edificacion50.setCheckState(0, Qt.Unchecked)
            edifiedi50 = QTreeWidgetItem(edificacion50)
            edifiedi50.setFlags(edifiedi50.flags() | Qt.ItemIsUserCheckable)
            edifiedi50.setText(0, "Edificaciones CV50")
            edifiedi50.setCheckState(0, Qt.Unchecked)
            edifiedip50 = QTreeWidgetItem(edificacion50)
            edifiedip50.setFlags(edifiedip50.flags() | Qt.ItemIsUserCheckable)
            edifiedip50.setText(0, "Edificaciones puntuales CV50")
            edifiedip50.setCheckState(0, Qt.Unchecked)
            edifipisci50 = QTreeWidgetItem(edificacion50)
            edifipisci50.setFlags(edifipisci50.flags() | Qt.ItemIsUserCheckable)
            edifipisci50.setText(0, "Piscina / Balsa CV50")
            edifipisci50.setCheckState(0, Qt.Unchecked)
            edifipiscip50 = QTreeWidgetItem(edificacion50)
            edifipiscip50.setFlags(edifipiscip50.flags() | Qt.ItemIsUserCheckable)
            edifipiscip50.setText(0, "Piscina / Balsa puntual CV50")
            edifipiscip50.setCheckState(0, Qt.Unchecked)
            edifiruina50 = QTreeWidgetItem(edificacion50)
            edifiruina50.setFlags(edifiruina50.flags() | Qt.ItemIsUserCheckable)
            edifiruina50.setText(0, "Edificación en ruinas CV50")
            edifiruina50.setCheckState(0, Qt.Unchecked)
            edifiruinap50 = QTreeWidgetItem(edificacion50)
            edifiruinap50.setFlags(edifiruinap50.flags() | Qt.ItemIsUserCheckable)
            edifiruinap50.setText(0, "Edificación en ruinas puntual CV50")
            edifiruinap50.setCheckState(0, Qt.Unchecked)
            edifextrac50 = QTreeWidgetItem(edificacion50)
            edifextrac50.setFlags(edifextrac50.flags() | Qt.ItemIsUserCheckable)
            edifextrac50.setText(0, "Actividad extractiva CV50")
            edifextrac50.setCheckState(0, Qt.Unchecked)
            edifextracp50 = QTreeWidgetItem(edificacion50)
            edifextracp50.setFlags(edifextracp50.flags() | Qt.ItemIsUserCheckable)
            edifextracp50.setText(0, "Actividad extractiva puntual CV50")
            edifextracp50.setCheckState(0, Qt.Unchecked)
            edifdeposit50 = QTreeWidgetItem(edificacion50)
            edifdeposit50.setFlags(edifdeposit50.flags() | Qt.ItemIsUserCheckable)
            edifdeposit50.setText(0, "Depósito")
            edifdeposit50.setCheckState(0, Qt.Unchecked)
            edifobrac50 = QTreeWidgetItem(edificacion50)
            edifobrac50.setFlags(edifobrac50.flags() | Qt.ItemIsUserCheckable)
            edifobrac50.setText(0, "Obra de contención")
            edifobrac50.setCheckState(0, Qt.Unchecked)
            edifinverna50 = QTreeWidgetItem(edificacion50)
            edifinverna50.setFlags(edifinverna50.flags() | Qt.ItemIsUserCheckable)
            edifinverna50.setText(0, "Invernadero")
            edifinverna50.setCheckState(0, Qt.Unchecked)
            edifpatio50 = QTreeWidgetItem(edificacion50)
            edifpatio50.setFlags(edifpatio50.flags() | Qt.ItemIsUserCheckable)
            edifpatio50.setText(0, "Patio")
            edifpatio50.setCheckState(0, Qt.Unchecked)
            edifmuralla50 = QTreeWidgetItem(edificacion50)
            edifmuralla50.setFlags(edifmuralla50.flags() | Qt.ItemIsUserCheckable)
            edifmuralla50.setText(0, "Muralla histórica")
            edifmuralla50.setCheckState(0, Qt.Unchecked)
            instalacion50 = QTreeWidgetItem(basecartografica50)
            instalacion50.setFlags(instalacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instalacion50.setText(0, "Instalaciones y equipamientos")
            instalacion50.setCheckState(0, Qt.Unchecked)
            instadota50 = QTreeWidgetItem(instalacion50)
            instadota50.setFlags(instadota50.flags() | Qt.ItemIsUserCheckable)
            instadota50.setText(0, "Espacio dotacional")
            instadota50.setCheckState(0, Qt.Unchecked)
            instacircu50 = QTreeWidgetItem(instalacion50)
            instacircu50.setFlags(instacircu50.flags() | Qt.ItemIsUserCheckable)
            instacircu50.setText(0, "Circuito")
            instacircu50.setCheckState(0, Qt.Unchecked)
            instapoli50 = QTreeWidgetItem(instalacion50)
            instapoli50.setFlags(instapoli50.flags() | Qt.ItemIsUserCheckable)
            instapoli50.setText(0, "Instalación de transporte poligonal")
            instapoli50.setCheckState(0, Qt.Unchecked)
            instalinea50 = QTreeWidgetItem(instalacion50)
            instalinea50.setFlags(instalinea50.flags() | Qt.ItemIsUserCheckable)
            instalinea50.setText(0, "Instalación de transporte lineal")
            instalinea50.setCheckState(0, Qt.Unchecked)
            instapunt50 = QTreeWidgetItem(instalacion50)
            instapunt50.setFlags(instapunt50.flags() | Qt.ItemIsUserCheckable)
            instapunt50.setText(0, "Instalación de transporte puntual")
            instapunt50.setCheckState(0, Qt.Unchecked)
            instadotpun50 = QTreeWidgetItem(instalacion50)
            instadotpun50.setFlags(instadotpun50.flags() | Qt.ItemIsUserCheckable)
            instadotpun50.setText(0, "Espacio dotacional puntual")
            instadotpun50.setCheckState(0, Qt.Unchecked)
            instaelect50 = QTreeWidgetItem(instalacion50)
            instaelect50.setFlags(instaelect50.flags() | Qt.ItemIsUserCheckable)
            instaelect50.setText(0, "Línea eléctrica")
            instaelect50.setCheckState(0, Qt.Unchecked)
            instavertic50 = QTreeWidgetItem(instalacion50)
            instavertic50.setFlags(instavertic50.flags() | Qt.ItemIsUserCheckable)
            instavertic50.setText(0, "Vértices geodésicos")
            instavertic50.setCheckState(0, Qt.Unchecked)
            viascomu50 = QTreeWidgetItem(basecartografica50)
            viascomu50.setFlags(viascomu50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            viascomu50.setText(0, "Vias de Comunicación")
            viascomu50.setCheckState(0, Qt.Unchecked)
            instared50 = QTreeWidgetItem(viascomu50)
            instared50.setFlags(instared50.flags() | Qt.ItemIsUserCheckable)
            instared50.setText(0, "Red de Comunicaciones")
            instared50.setCheckState(0, Qt.Unchecked)
            instaferroc50 = QTreeWidgetItem(viascomu50)
            instaferroc50.setFlags(instaferroc50.flags() | Qt.ItemIsUserCheckable)
            instaferroc50.setText(0, "Ferrocarril")
            instaferroc50.setCheckState(0, Qt.Unchecked)
            instaportal0 = QTreeWidgetItem(viascomu50)
            instaportal0.setFlags(instaportal0.flags() | Qt.ItemIsUserCheckable)
            instaportal0.setText(0, "Portales/PKs")
            instaportal0.setCheckState(0, Qt.Unchecked)
            instabocat0 = QTreeWidgetItem(viascomu50)
            instabocat0.setFlags(instabocat0.flags() | Qt.ItemIsUserCheckable)
            instabocat0.setText(0, "Boca de túnel")
            instabocat0.setCheckState(0, Qt.Unchecked)
            instaredele50 = QTreeWidgetItem(viascomu50)
            instaredele50.setFlags(instaredele50.flags() | Qt.ItemIsUserCheckable)
            instaredele50.setText(0, "Red viaria elevada")
            instaredele50.setCheckState(0, Qt.Unchecked)
            instaferrel50 = QTreeWidgetItem(viascomu50)
            instaferrel50.setFlags(instaferrel50.flags() | Qt.ItemIsUserCheckable)
            instaferrel50.setText(0, "Ferrocarril elevado")
            instaferrel50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Red viaria subterránea")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Ferrocarril subterráneo")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            basecartografica100 = QTreeWidgetItem(carto)
            basecartografica100.setText(0, "Base Cartogràfica CV100")
            orografia100 = QTreeWidgetItem(basecartografica100)
            orografia100.setFlags(orografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia100.setText(0, "Orografía")
            orografia100.setCheckState(0, Qt.Unchecked)
            costa100 = QTreeWidgetItem(orografia100)
            costa100.setFlags(costa100.flags() | Qt.ItemIsUserCheckable)
            costa100.setText(0, "Línea de costa CV100")
            costa100.setCheckState(0, Qt.Unchecked)
            curvas100 = QTreeWidgetItem(orografia100)
            curvas100.setFlags(curvas100.flags() | Qt.ItemIsUserCheckable)
            curvas100.setText(0, "Curvas de nivel CV100")
            curvas100.setCheckState(0, Qt.Unchecked)
            cota100 = QTreeWidgetItem(orografia100)
            cota100.setFlags(cota100.flags() | Qt.ItemIsUserCheckable)
            cota100.setText(0, "Puntos de cota CV100")
            cota100.setCheckState(0, Qt.Unchecked)
            hidrografia100 = QTreeWidgetItem(basecartografica100)
            hidrografia100.setFlags(hidrografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia100.setText(0, "Hidrografia")
            hidrografia100.setCheckState(0, Qt.Unchecked)
            curson100 = QTreeWidgetItem(hidrografia100)
            curson100.setFlags(curson100.flags() | Qt.ItemIsUserCheckable)
            curson100.setText(0, "Curso natural CV100")
            curson100.setCheckState(0, Qt.Unchecked)
            lecho100 = QTreeWidgetItem(hidrografia100)
            lecho100.setFlags(lecho100.flags() | Qt.ItemIsUserCheckable)
            lecho100.setText(0, "Lecho natural CV100")
            lecho100.setCheckState(0, Qt.Unchecked)
            lago100 = QTreeWidgetItem(hidrografia100)
            lago100.setFlags(lago100.flags() | Qt.ItemIsUserCheckable)
            lago100.setText(0, "Lago CV100")
            lago100.setCheckState(0, Qt.Unchecked)
            embalse100 = QTreeWidgetItem(hidrografia100)
            embalse100.setFlags(embalse100.flags() | Qt.ItemIsUserCheckable)
            embalse100.setText(0, "Embalse CV100")
            embalse100.setCheckState(0, Qt.Unchecked)
            isla100 = QTreeWidgetItem(hidrografia100)
            isla100.setFlags(isla100.flags() | Qt.ItemIsUserCheckable)
            isla100.setText(0, "Isla CV100")
            isla100.setCheckState(0, Qt.Unchecked)
            edifica100 = QTreeWidgetItem(basecartografica100)
            edifica100.setFlags(edifica100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edifica100.setText(0, "Edificaciones y construcciones")
            edifica100.setCheckState(0, Qt.Unchecked)
            edificaed100 = QTreeWidgetItem(edifica100)
            edificaed100.setFlags(edificaed100.flags() | Qt.ItemIsUserCheckable)
            edificaed100.setText(0, "Edificación CV100")
            edificaed100.setCheckState(0, Qt.Unchecked)
            edificaedp100 = QTreeWidgetItem(edifica100)
            edificaedp100.setFlags(edificaedp100.flags() | Qt.ItemIsUserCheckable)
            edificaedp100.setText(0, "Edificación puntual CV100")
            edificaedp100.setCheckState(0, Qt.Unchecked)
            piscina100 = QTreeWidgetItem(edifica100)
            piscina100.setFlags(piscina100.flags() | Qt.ItemIsUserCheckable)
            piscina100.setText(0, "Piscina/Balsa CV100")
            piscina100.setCheckState(0, Qt.Unchecked)
            piscinap100 = QTreeWidgetItem(edifica100)
            piscinap100.setFlags(piscinap100.flags() | Qt.ItemIsUserCheckable)
            piscinap100.setText(0, "Piscina/Balsa puntual CV100")
            piscinap100.setCheckState(0, Qt.Unchecked)
            edificaedr100 = QTreeWidgetItem(edifica100)
            edificaedr100.setFlags(edificaedr100.flags() | Qt.ItemIsUserCheckable)
            edificaedr100.setText(0, "Edificación en ruinas CV100")
            edificaedr100.setCheckState(0, Qt.Unchecked)
            edificaedrp100 = QTreeWidgetItem(edifica100)
            edificaedrp100.setFlags(edificaedrp100.flags() | Qt.ItemIsUserCheckable)
            edificaedrp100.setText(0, "Edificación en ruinas puntual CV100")
            edificaedrp100.setCheckState(0, Qt.Unchecked)
            actext100 = QTreeWidgetItem(edifica100)
            actext100.setFlags(actext100.flags() | Qt.ItemIsUserCheckable)
            actext100.setText(0, "Actividad extractiva CV100")
            actext100.setCheckState(0, Qt.Unchecked)
            actextp100 = QTreeWidgetItem(edifica100)
            actextp100.setFlags(actextp100.flags() | Qt.ItemIsUserCheckable)
            actextp100.setText(0, "Actividad extractiva puntual CV100")
            actextp100.setCheckState(0, Qt.Unchecked)
            obracon100 = QTreeWidgetItem(edifica100)
            obracon100.setFlags(obracon100.flags() | Qt.ItemIsUserCheckable)
            obracon100.setText(0, "Obra de contención CV100")
            obracon100.setCheckState(0, Qt.Unchecked)
            inverna100 = QTreeWidgetItem(edifica100)
            inverna100.setFlags(inverna100.flags() | Qt.ItemIsUserCheckable)
            inverna100.setText(0, "Invernadero CV100")
            inverna100.setCheckState(0, Qt.Unchecked)
            patio100 = QTreeWidgetItem(edifica100)
            patio100.setFlags(patio100.flags() | Qt.ItemIsUserCheckable)
            patio100.setText(0, "Patio CV100")
            patio100.setCheckState(0, Qt.Unchecked)
            muralla100 = QTreeWidgetItem(edifica100)
            muralla100.setFlags(muralla100.flags() | Qt.ItemIsUserCheckable)
            muralla100.setText(0, "Muralla histórica CV100")
            muralla100.setCheckState(0, Qt.Unchecked)
            instala100 = QTreeWidgetItem(basecartografica100)
            instala100.setFlags(instala100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instala100.setText(0, "Instalaciones y equipamientos")
            instala100.setCheckState(0, Qt.Unchecked)
            instalinea100 = QTreeWidgetItem(instala100)
            instalinea100.setFlags(instalinea100.flags() | Qt.ItemIsUserCheckable)
            instalinea100.setText(0, "Línea eléctrica CV100")
            instalinea100.setCheckState(0, Qt.Unchecked)
            vertices100 = QTreeWidgetItem(instala100)
            vertices100.setFlags(vertices100.flags() | Qt.ItemIsUserCheckable)
            vertices100.setText(0, "Vértices geodésicos CV100")
            vertices100.setCheckState(0, Qt.Unchecked)
            dotapunt100 = QTreeWidgetItem(instala100)
            dotapunt100.setFlags(dotapunt100.flags() | Qt.ItemIsUserCheckable)
            dotapunt100.setText(0, "Espacio dotacional puntual CV100")
            dotapunt100.setCheckState(0, Qt.Unchecked)
            transpunt100 = QTreeWidgetItem(instala100)
            transpunt100.setFlags(transpunt100.flags() | Qt.ItemIsUserCheckable)
            transpunt100.setText(0, "Instalación de transporte puntual CV100")
            transpunt100.setCheckState(0, Qt.Unchecked)
            deposito100 = QTreeWidgetItem(instala100)
            deposito100.setFlags(deposito100.flags() | Qt.ItemIsUserCheckable)
            deposito100.setText(0, "Depósito CV100")
            deposito100.setCheckState(0, Qt.Unchecked)
            translin100 = QTreeWidgetItem(instala100)
            translin100.setFlags(translin100.flags() | Qt.ItemIsUserCheckable)
            translin100.setText(0, "Instalación de transporte lineal CV100")
            translin100.setCheckState(0, Qt.Unchecked)
            transpol100 = QTreeWidgetItem(instala100)
            transpol100.setFlags(transpol100.flags() | Qt.ItemIsUserCheckable)
            transpol100.setText(0, "Instalación de transporte poligonal CV100")
            transpol100.setCheckState(0, Qt.Unchecked)
            espadot100 = QTreeWidgetItem(instala100)
            espadot100.setFlags(espadot100.flags() | Qt.ItemIsUserCheckable)
            espadot100.setText(0, "Espacio dotacional CV100")
            espadot100.setCheckState(0, Qt.Unchecked)
            comunicacion100 = QTreeWidgetItem(basecartografica100)
            comunicacion100.setFlags(comunicacion100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            comunicacion100.setText(0, "Vías de comunicación")
            comunicacion100.setCheckState(0, Qt.Unchecked)
            comured100 = QTreeWidgetItem(comunicacion100)
            comured100.setFlags(comured100.flags() | Qt.ItemIsUserCheckable)
            comured100.setText(0, "Red viaria CV100")
            comured100.setCheckState(0, Qt.Unchecked)
            ferro100 = QTreeWidgetItem(comunicacion100)
            ferro100.setFlags(ferro100.flags() | Qt.ItemIsUserCheckable)
            ferro100.setText(0, "Ferrocarril CV100")
            ferro100.setCheckState(0, Qt.Unchecked)
            tunel100 = QTreeWidgetItem(comunicacion100)
            tunel100.setFlags(tunel100.flags() | Qt.ItemIsUserCheckable)
            tunel100.setText(0, "Boca de túnel CV100")
            tunel100.setCheckState(0, Qt.Unchecked)
            comurede100 = QTreeWidgetItem(comunicacion100)
            comurede100.setFlags(comurede100.flags() | Qt.ItemIsUserCheckable)
            comurede100.setText(0, "Red viaria elevada CV100")
            comurede100.setCheckState(0, Qt.Unchecked)
            ferroe100 = QTreeWidgetItem(comunicacion100)
            ferroe100.setFlags(ferroe100.flags() | Qt.ItemIsUserCheckable)
            ferroe100.setText(0, "Ferrocarril elevado CV100")
            ferroe100.setCheckState(0, Qt.Unchecked)
            comureds100 = QTreeWidgetItem(comunicacion100)
            comureds100.setFlags(comureds100.flags() | Qt.ItemIsUserCheckable)
            comureds100.setText(0, "Red viaria subterránea CV100")
            comureds100.setCheckState(0, Qt.Unchecked)
            ferros100 = QTreeWidgetItem(comunicacion100)
            ferros100.setFlags(ferros100.flags() | Qt.ItemIsUserCheckable)
            ferros100.setText(0, "Ferrocarril subterráneo CV100")
            ferros100.setCheckState(0, Qt.Unchecked)
            fechasbases = QTreeWidgetItem(carto)
            fechasbases.setText(0, "Fechas Bases cartográficas")
            fechasvuelos = QTreeWidgetItem(fechasbases)
            fechasvuelos.setFlags(fechasvuelos.flags() | Qt.ItemIsUserCheckable)
            fechasvuelos.setText(0, "Fechas de vuelo")
            fechasvuelos.setCheckState(0, Qt.Unchecked)
            redtransp = QTreeWidgetItem(carto)
            redtransp.setText(0, "Red de Transportes")
            redcarretera = QTreeWidgetItem(redtransp)
            redcarretera.setFlags(redcarretera.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            redcarretera.setText(0, "Transporte Carretera")
            redcarretera.setCheckState(0, Qt.Unchecked)
            sistviari = QTreeWidgetItem(redcarretera)
            sistviari.setFlags(sistviari.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sistviari.setText(0, "Sistema viario")
            sistviari.setCheckState(0, Qt.Unchecked)
            cataviario = QTreeWidgetItem(sistviari)
            cataviario.setFlags(cataviario.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            cataviario.setText(0, "Catálogo Viario")
            cataviario.setCheckState(0, Qt.Unchecked)
            cataviario1 = QTreeWidgetItem(cataviario)
            cataviario1.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario1.setText(0, "Catálogo viario escala 1")
            cataviario1.setCheckState(0, Qt.Unchecked)
            cataviario2 = QTreeWidgetItem(cataviario)
            cataviario2.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario2.setText(0, "Catálogo viario escala 2")
            cataviario2.setCheckState(0, Qt.Unchecked)
            cataviario3 = QTreeWidgetItem(cataviario)
            cataviario3.setFlags(cataviario3.flags() | Qt.ItemIsUserCheckable)
            cataviario3.setText(0, "Catálogo viario escala 3")
            cataviario3.setCheckState(0, Qt.Unchecked)
            cataviario4 = QTreeWidgetItem(cataviario)
            cataviario4.setFlags(cataviario4.flags() | Qt.ItemIsUserCheckable)
            cataviario4.setText(0, "Catálogo viario escala 4")
            cataviario4.setCheckState(0, Qt.Unchecked)
            puntokil = QTreeWidgetItem(sistviari)
            puntokil.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            puntokil.setText(0, "Puntos kilométricos")
            puntokil.setCheckState(0, Qt.Unchecked)
            caminos = QTreeWidgetItem(sistviari)
            caminos.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            caminos.setText(0, "Caminos")
            caminos.setCheckState(0, Qt.Unchecked)
            urbana = QTreeWidgetItem(sistviari)
            urbana.setFlags(urbana.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            urbana.setText(0, "Urbana")
            urbana.setCheckState(0, Qt.Unchecked)
            listacalles = QTreeWidgetItem(urbana)
            listacalles.setFlags(listacalles.flags() | Qt.ItemIsUserCheckable)
            listacalles.setText(0, "Listado de calles")
            listacalles.setCheckState(0, Qt.Unchecked)
            portal = QTreeWidgetItem(urbana)
            portal.setFlags(portal.flags() | Qt.ItemIsUserCheckable)
            portal.setText(0, "Portal")
            portal.setCheckState(0, Qt.Unchecked)
            infraestruc = QTreeWidgetItem(redcarretera)
            infraestruc.setFlags(infraestruc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraestruc.setText(0, "Infraestructuras e instalaciones")
            infraestruc.setCheckState(0, Qt.Unchecked)
            estautob = QTreeWidgetItem(infraestruc)
            estautob.setFlags(estautob.flags() | Qt.ItemIsUserCheckable)
            estautob.setText(0, "Estación de autobuses")
            estautob.setCheckState(0, Qt.Unchecked)
            peaje = QTreeWidgetItem(infraestruc)
            peaje.setFlags(peaje.flags() | Qt.ItemIsUserCheckable)
            peaje.setText(0, "Peaje")
            peaje.setCheckState(0, Qt.Unchecked)
            areaserv = QTreeWidgetItem(infraestruc)
            areaserv.setFlags(areaserv.flags() | Qt.ItemIsUserCheckable)
            areaserv.setText(0, "Áreas de servicio")
            areaserv.setCheckState(0, Qt.Unchecked)
            areaservin = QTreeWidgetItem(infraestruc)
            areaservin.setFlags(areaservin.flags() | Qt.ItemIsUserCheckable)
            areaservin.setText(0, "Aparcamiento de servicios viarios invernal")
            areaservin.setCheckState(0, Qt.Unchecked)
            puente = QTreeWidgetItem(infraestruc)
            puente.setFlags(puente.flags() | Qt.ItemIsUserCheckable)
            puente.setText(0, "Puente")
            puente.setCheckState(0, Qt.Unchecked)





        if self.rdb_val.isChecked() == True:  # Create the fahther and child nodes in valencian
            carto.setText(0, "Cartografia de referència")
            # carto.setFlags(carto.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            toponimia = QTreeWidgetItem(carto)
            toponimia.setFlags(toponimia.flags() | Qt.ItemIsUserCheckable)
            toponimia.setText(0, "Nomenclàtor Toponímic Valencià")
            toponimia.setCheckState(0, Qt.Unchecked)
            basecartografica05 = QTreeWidgetItem(carto)
            basecartografica05.setText(0, "Base Cartogràfica CV05")
            orografia05 = QTreeWidgetItem(basecartografica05)
            orografia05.setFlags(orografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia05.setText(0, "Orografia")
            orografia05.setCheckState(0, Qt.Unchecked)
            puntoscota = QTreeWidgetItem(orografia05)
            puntoscota.setFlags(puntoscota.flags() | Qt.ItemIsUserCheckable)
            puntoscota.setText(0, "Punts de cota CV05")
            puntoscota.setCheckState(0, Qt.Unchecked)
            orolineas = QTreeWidgetItem(orografia05)
            orolineas.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            orolineas.setText(0, "Orografia línies CV05")
            orolineas.setCheckState(0, Qt.Unchecked)
            curvasnivel = QTreeWidgetItem(orografia05)
            curvasnivel.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            curvasnivel.setText(0, "Corbes de nivell CV05")
            curvasnivel.setCheckState(0, Qt.Unchecked)
            hidrografia05 = QTreeWidgetItem(basecartografica05)
            hidrografia05.setFlags(hidrografia05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia05.setText(0, "Hidrografia")
            hidrografia05.setCheckState(0, Qt.Unchecked)
            hidropuntos05 = QTreeWidgetItem(hidrografia05)
            hidropuntos05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidropuntos05.setText(0, "Hidrografia puntual CV05")
            hidropuntos05.setCheckState(0, Qt.Unchecked)
            hidrolineas05 = QTreeWidgetItem(hidrografia05)
            hidrolineas05.setFlags(orolineas.flags() | Qt.ItemIsUserCheckable)
            hidrolineas05.setText(0, "Hidrografia lineal CV05")
            hidrolineas05.setCheckState(0, Qt.Unchecked)
            construcciones05 = QTreeWidgetItem(basecartografica05)
            construcciones05.setFlags(construcciones05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            construcciones05.setText(0, "Edificacions i construccions")
            construcciones05.setCheckState(0, Qt.Unchecked)
            construpuntos05 = QTreeWidgetItem(construcciones05)
            construpuntos05.setFlags(construpuntos05.flags() | Qt.ItemIsUserCheckable)
            construpuntos05.setText(0, "Construccions puntuals CV05")
            construpuntos05.setCheckState(0, Qt.Unchecked)
            construservi05 = QTreeWidgetItem(construcciones05)
            construservi05.setFlags(construservi05.flags() | Qt.ItemIsUserCheckable)
            construservi05.setText(0, "Serveis i instal·lacions CV05")
            construservi05.setCheckState(0, Qt.Unchecked)
            construlinea05 = QTreeWidgetItem(construcciones05)
            construlinea05.setFlags(construlinea05.flags() | Qt.ItemIsUserCheckable)
            construlinea05.setText(0, "Construccions lineals CV05")
            construlinea05.setCheckState(0, Qt.Unchecked)
            construedifi05 = QTreeWidgetItem(construcciones05)
            construedifi05.setFlags(construedifi05.flags() | Qt.ItemIsUserCheckable)
            construedifi05.setText(0, "Edificacions CV05")
            construedifi05.setCheckState(0, Qt.Unchecked)
            construcons05 = QTreeWidgetItem(construcciones05)
            construcons05.setFlags(construcons05.flags() | Qt.ItemIsUserCheckable)
            construcons05.setText(0, "Construccions CV05")
            construcons05.setCheckState(0, Qt.Unchecked)
            usos05 = QTreeWidgetItem(basecartografica05)
            usos05.setFlags(usos05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            usos05.setText(0, "Usos del sòl")
            usos05.setCheckState(0, Qt.Unchecked)
            usoshidro05 = QTreeWidgetItem(usos05)
            usoshidro05.setFlags(usoshidro05.flags() | Qt.ItemIsUserCheckable)
            usoshidro05.setText(0, "Hidrografia CV05")
            usoshidro05.setCheckState(0, Qt.Unchecked)
            usosarboles05 = QTreeWidgetItem(usos05)
            usosarboles05.setFlags(usosarboles05.flags() | Qt.ItemIsUserCheckable)
            usosarboles05.setText(0, "Zones amb arbres CV05")
            usosarboles05.setCheckState(0, Qt.Unchecked)
            usosinfra05 = QTreeWidgetItem(usos05)
            usosinfra05.setFlags(usosinfra05.flags() | Qt.ItemIsUserCheckable)
            usosinfra05.setText(0, "Infraestructures viàries CV05")
            usosinfra05.setCheckState(0, Qt.Unchecked)
            usosserv05 = QTreeWidgetItem(usos05)
            usosserv05.setFlags(usosserv05.flags() | Qt.ItemIsUserCheckable)
            usosserv05.setText(0, "Serveis i instal·lacions CV05")
            usosserv05.setCheckState(0, Qt.Unchecked)
            usoscultiv05 = QTreeWidgetItem(usos05)
            usoscultiv05.setFlags(usoscultiv05.flags() | Qt.ItemIsUserCheckable)
            usoscultiv05.setText(0, "Cultius CV05")
            usoscultiv05.setCheckState(0, Qt.Unchecked)
            usosentorn05 = QTreeWidgetItem(usos05)
            usosentorn05.setFlags(usosentorn05.flags() | Qt.ItemIsUserCheckable)
            usosentorn05.setText(0, "Entorns urbans CV05")
            usosentorn05.setCheckState(0, Qt.Unchecked)
            vias05 = QTreeWidgetItem(basecartografica05)
            vias05.setFlags(vias05.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            vias05.setText(0, "Vies de Comunicació")
            vias05.setCheckState(0, Qt.Unchecked)
            viasnomen05 = QTreeWidgetItem(vias05)
            viasnomen05.setFlags(viasnomen05.flags() | Qt.ItemIsUserCheckable)
            viasnomen05.setText(0, "Nomenclatura infraestructura viària CV05")
            viasnomen05.setCheckState(0, Qt.Unchecked)
            viasferro05 = QTreeWidgetItem(vias05)
            viasferro05.setFlags(viasferro05.flags() | Qt.ItemIsUserCheckable)
            viasferro05.setText(0, "Xarxa de ferrocarrils CV05")
            viasferro05.setCheckState(0, Qt.Unchecked)
            viascomu05 = QTreeWidgetItem(vias05)
            viascomu05.setFlags(viascomu05.flags() | Qt.ItemIsUserCheckable)
            viascomu05.setText(0, "Xarxa de comunicacions CV05")
            viascomu05.setCheckState(0, Qt.Unchecked)
            basecartografica50 = QTreeWidgetItem(carto)
            basecartografica50.setText(0, "Base Cartogràfica CV50")
            orografia50 = QTreeWidgetItem(basecartografica50)
            orografia50.setFlags(orografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia50.setText(0, "Orografia  ")
            orografia50.setCheckState(0, Qt.Unchecked)
            orografiacosta50 = QTreeWidgetItem(orografia50)
            orografiacosta50.setFlags(orografiacosta50.flags() | Qt.ItemIsUserCheckable)
            orografiacosta50.setText(0, "Línia de costa CV50")
            orografiacosta50.setCheckState(0, Qt.Unchecked)
            orografiacurva50 = QTreeWidgetItem(orografia50)
            orografiacurva50.setFlags(orografiacurva50.flags() | Qt.ItemIsUserCheckable)
            orografiacurva50.setText(0, "Corbes de nivell CV50")
            orografiacurva50.setCheckState(0, Qt.Unchecked)
            hidrografia50 = QTreeWidgetItem(basecartografica50)
            hidrografia50.setFlags(hidrografia50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia50.setText(0, "Hidrografia")
            hidrografia50.setCheckState(0, Qt.Unchecked)
            hidrocursoa50 = QTreeWidgetItem(hidrografia50)
            hidrocursoa50.setFlags(hidrocursoa50.flags() | Qt.ItemIsUserCheckable)
            hidrocursoa50.setText(0, "Curs natural CV50")
            hidrocursoa50.setCheckState(0, Qt.Unchecked)
            hidrocurson50 = QTreeWidgetItem(hidrografia50)
            hidrocurson50.setFlags(hidrocurson50.flags() | Qt.ItemIsUserCheckable)
            hidrocurson50.setText(0, "Curs artificial CV50")
            hidrocurson50.setCheckState(0, Qt.Unchecked)
            hidrolecho50 = QTreeWidgetItem(hidrografia50)
            hidrolecho50.setFlags(hidrolecho50.flags() | Qt.ItemIsUserCheckable)
            hidrolecho50.setText(0, "Llit natural CV50")
            hidrolecho50.setCheckState(0, Qt.Unchecked)
            hidroembal50 = QTreeWidgetItem(hidrografia50)
            hidroembal50.setFlags(hidroembal50.flags() | Qt.ItemIsUserCheckable)
            hidroembal50.setText(0, "Embassament CV50")
            hidroembal50.setCheckState(0, Qt.Unchecked)
            hidrolago50 = QTreeWidgetItem(hidrografia50)
            hidrolago50.setFlags(hidrolago50.flags() | Qt.ItemIsUserCheckable)
            hidrolago50.setText(0, "Llac CV50")
            hidrolago50.setCheckState(0, Qt.Unchecked)
            hidroisla50 = QTreeWidgetItem(hidrografia50)
            hidroisla50.setFlags(hidroisla50.flags() | Qt.ItemIsUserCheckable)
            hidroisla50.setText(0, "Illa CV50")
            hidroisla50.setCheckState(0, Qt.Unchecked)
            edificacion50 = QTreeWidgetItem(basecartografica50)
            edificacion50.setFlags(edificacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edificacion50.setText(0, "Edificacions i construccions")
            edificacion50.setCheckState(0, Qt.Unchecked)
            edifiedi50 = QTreeWidgetItem(edificacion50)
            edifiedi50.setFlags(edifiedi50.flags() | Qt.ItemIsUserCheckable)
            edifiedi50.setText(0, "Edificacions CV50")
            edifiedi50.setCheckState(0, Qt.Unchecked)
            edifiedip50 = QTreeWidgetItem(edificacion50)
            edifiedip50.setFlags(edifiedip50.flags() | Qt.ItemIsUserCheckable)
            edifiedip50.setText(0, "Edificacions puntuals CV50")
            edifiedip50.setCheckState(0, Qt.Unchecked)
            edifipisci50 = QTreeWidgetItem(edificacion50)
            edifipisci50.setFlags(edifipisci50.flags() | Qt.ItemIsUserCheckable)
            edifipisci50.setText(0, "Piscina / Bassa CV50")
            edifipisci50.setCheckState(0, Qt.Unchecked)
            edifipiscip50 = QTreeWidgetItem(edificacion50)
            edifipiscip50.setFlags(edifipiscip50.flags() | Qt.ItemIsUserCheckable)
            edifipiscip50.setText(0, "Piscina / Bassa puntual CV50")
            edifipiscip50.setCheckState(0, Qt.Unchecked)
            edifiruina50 = QTreeWidgetItem(edificacion50)
            edifiruina50.setFlags(edifiruina50.flags() | Qt.ItemIsUserCheckable)
            edifiruina50.setText(0, "Edificació en ruïnes CV50")
            edifiruina50.setCheckState(0, Qt.Unchecked)
            edifiruinap50 = QTreeWidgetItem(edificacion50)
            edifiruinap50.setFlags(edifiruinap50.flags() | Qt.ItemIsUserCheckable)
            edifiruinap50.setText(0, "Edificació en ruïnes puntual CV50")
            edifiruinap50.setCheckState(0, Qt.Unchecked)
            edifextrac50 = QTreeWidgetItem(edificacion50)
            edifextrac50.setFlags(edifextrac50.flags() | Qt.ItemIsUserCheckable)
            edifextrac50.setText(0, "Activitat extractiva CV50")
            edifextrac50.setCheckState(0, Qt.Unchecked)
            edifextracp50 = QTreeWidgetItem(edificacion50)
            edifextracp50.setFlags(edifextracp50.flags() | Qt.ItemIsUserCheckable)
            edifextracp50.setText(0, "Activitat extractiva puntual CV50")
            edifextracp50.setCheckState(0, Qt.Unchecked)
            edifdeposit50 = QTreeWidgetItem(edificacion50)
            edifdeposit50.setFlags(edifdeposit50.flags() | Qt.ItemIsUserCheckable)
            edifdeposit50.setText(0, "Dipòsit")
            edifdeposit50.setCheckState(0, Qt.Unchecked)
            edifobrac50 = QTreeWidgetItem(edificacion50)
            edifobrac50.setFlags(edifobrac50.flags() | Qt.ItemIsUserCheckable)
            edifobrac50.setText(0, "Obra de contenció")
            edifobrac50.setCheckState(0, Qt.Unchecked)
            edifinverna50 = QTreeWidgetItem(edificacion50)
            edifinverna50.setFlags(edifinverna50.flags() | Qt.ItemIsUserCheckable)
            edifinverna50.setText(0, "Hivernacle")
            edifinverna50.setCheckState(0, Qt.Unchecked)
            edifpatio50 = QTreeWidgetItem(edificacion50)
            edifpatio50.setFlags(edifpatio50.flags() | Qt.ItemIsUserCheckable)
            edifpatio50.setText(0, "Pati")
            edifpatio50.setCheckState(0, Qt.Unchecked)
            edifmuralla50 = QTreeWidgetItem(edificacion50)
            edifmuralla50.setFlags(edifmuralla50.flags() | Qt.ItemIsUserCheckable)
            edifmuralla50.setText(0, "Muralla històrica")
            edifmuralla50.setCheckState(0, Qt.Unchecked)
            instalacion50 = QTreeWidgetItem(basecartografica50)
            instalacion50.setFlags(instalacion50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instalacion50.setText(0, "Instal·lacions i equipaments")
            instalacion50.setCheckState(0, Qt.Unchecked)
            instadota50 = QTreeWidgetItem(instalacion50)
            instadota50.setFlags(instadota50.flags() | Qt.ItemIsUserCheckable)
            instadota50.setText(0, "Espai dotacional")
            instadota50.setCheckState(0, Qt.Unchecked)
            instacircu50 = QTreeWidgetItem(instalacion50)
            instacircu50.setFlags(instacircu50.flags() | Qt.ItemIsUserCheckable)
            instacircu50.setText(0, "Circuit")
            instacircu50.setCheckState(0, Qt.Unchecked)
            instapoli50 = QTreeWidgetItem(instalacion50)
            instapoli50.setFlags(instapoli50.flags() | Qt.ItemIsUserCheckable)
            instapoli50.setText(0, "Instal·lació de transport poligonal")
            instapoli50.setCheckState(0, Qt.Unchecked)
            instalinea50 = QTreeWidgetItem(instalacion50)
            instalinea50.setFlags(instalinea50.flags() | Qt.ItemIsUserCheckable)
            instalinea50.setText(0, "Instal·lació de transport lineal")
            instalinea50.setCheckState(0, Qt.Unchecked)
            instapunt50 = QTreeWidgetItem(instalacion50)
            instapunt50.setFlags(instapunt50.flags() | Qt.ItemIsUserCheckable)
            instapunt50.setText(0, "Instal·lació de transport puntual")
            instapunt50.setCheckState(0, Qt.Unchecked)
            instadotpun50 = QTreeWidgetItem(instalacion50)
            instadotpun50.setFlags(instadotpun50.flags() | Qt.ItemIsUserCheckable)
            instadotpun50.setText(0, "Espai dotacional puntual")
            instadotpun50.setCheckState(0, Qt.Unchecked)
            instaelect50 = QTreeWidgetItem(instalacion50)
            instaelect50.setFlags(instaelect50.flags() | Qt.ItemIsUserCheckable)
            instaelect50.setText(0, "Línia elèctrica")
            instaelect50.setCheckState(0, Qt.Unchecked)
            instavertic50 = QTreeWidgetItem(instalacion50)
            instavertic50.setFlags(instavertic50.flags() | Qt.ItemIsUserCheckable)
            instavertic50.setText(0, "Vèrtexs geodèsics")
            instavertic50.setCheckState(0, Qt.Unchecked)
            viascomu50 = QTreeWidgetItem(basecartografica50)
            viascomu50.setFlags(viascomu50.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            viascomu50.setText(0, "Vies de Comunicació")
            viascomu50.setCheckState(0, Qt.Unchecked)
            instared50 = QTreeWidgetItem(viascomu50)
            instared50.setFlags(instared50.flags() | Qt.ItemIsUserCheckable)
            instared50.setText(0, "Xarxa de Comunicacions")
            instared50.setCheckState(0, Qt.Unchecked)
            instaferroc50 = QTreeWidgetItem(viascomu50)
            instaferroc50.setFlags(instaferroc50.flags() | Qt.ItemIsUserCheckable)
            instaferroc50.setText(0, "Ferrocarril")
            instaferroc50.setCheckState(0, Qt.Unchecked)
            instaportal0 = QTreeWidgetItem(viascomu50)
            instaportal0.setFlags(instaportal0.flags() | Qt.ItemIsUserCheckable)
            instaportal0.setText(0, "Portals/PKs")
            instaportal0.setCheckState(0, Qt.Unchecked)
            instabocat50 = QTreeWidgetItem(viascomu50)
            instabocat50.setFlags(instabocat50.flags() | Qt.ItemIsUserCheckable)
            instabocat50.setText(0, "Boca de túnel")
            instabocat50.setCheckState(0, Qt.Unchecked)
            instaredele50 = QTreeWidgetItem(viascomu50)
            instaredele50.setFlags(instaredele50.flags() | Qt.ItemIsUserCheckable)
            instaredele50.setText(0, "Xarxa viària elevada")
            instaredele50.setCheckState(0, Qt.Unchecked)
            instaferrel50 = QTreeWidgetItem(viascomu50)
            instaferrel50.setFlags(instaferrel50.flags() | Qt.ItemIsUserCheckable)
            instaferrel50.setText(0, "Ferrocarril elevat")
            instaferrel50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Xarxa viària subterrània")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            instaviarisub50 = QTreeWidgetItem(viascomu50)
            instaviarisub50.setFlags(instaviarisub50.flags() | Qt.ItemIsUserCheckable)
            instaviarisub50.setText(0, "Ferrocarril subterrani")
            instaviarisub50.setCheckState(0, Qt.Unchecked)
            basecartografica100 = QTreeWidgetItem(carto)
            basecartografica100.setText(0, "Base Cartogràfica CV100")
            orografia100 = QTreeWidgetItem(basecartografica100)
            orografia100.setFlags(orografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            orografia100.setText(0, "Orografia")
            orografia100.setCheckState(0, Qt.Unchecked)
            costa100 = QTreeWidgetItem(orografia100)
            costa100.setFlags(costa100.flags() | Qt.ItemIsUserCheckable)
            costa100.setText(0, "Línia de costa CV100")
            costa100.setCheckState(0, Qt.Unchecked)
            curvas100 = QTreeWidgetItem(orografia100)
            curvas100.setFlags(curvas100.flags() | Qt.ItemIsUserCheckable)
            curvas100.setText(0, "Corbes de nivell CV100")
            curvas100.setCheckState(0, Qt.Unchecked)
            cota100 = QTreeWidgetItem(orografia100)
            cota100.setFlags(cota100.flags() | Qt.ItemIsUserCheckable)
            cota100.setText(0, "Punts de cota CV100")
            cota100.setCheckState(0, Qt.Unchecked)
            hidrografia100 = QTreeWidgetItem(basecartografica100)
            hidrografia100.setFlags(hidrografia100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            hidrografia100.setText(0, "Hidrografia")
            hidrografia100.setCheckState(0, Qt.Unchecked)
            curson100 = QTreeWidgetItem(hidrografia100)
            curson100.setFlags(curson100.flags() | Qt.ItemIsUserCheckable)
            curson100.setText(0, "Curs natural CV100")
            curson100.setCheckState(0, Qt.Unchecked)
            lecho100 = QTreeWidgetItem(hidrografia100)
            lecho100.setFlags(lecho100.flags() | Qt.ItemIsUserCheckable)
            lecho100.setText(0, "Llit natural CV100")
            lecho100.setCheckState(0, Qt.Unchecked)
            lago100 = QTreeWidgetItem(hidrografia100)
            lago100.setFlags(lago100.flags() | Qt.ItemIsUserCheckable)
            lago100.setText(0, "Llac CV100")
            lago100.setCheckState(0, Qt.Unchecked)
            embalse100 = QTreeWidgetItem(hidrografia100)
            embalse100.setFlags(embalse100.flags() | Qt.ItemIsUserCheckable)
            embalse100.setText(0, "Embassament CV100")
            embalse100.setCheckState(0, Qt.Unchecked)
            isla100 = QTreeWidgetItem(hidrografia100)
            isla100.setFlags(isla100.flags() | Qt.ItemIsUserCheckable)
            isla100.setText(0, "Illa CV100")
            isla100.setCheckState(0, Qt.Unchecked)
            edifica100 = QTreeWidgetItem(basecartografica100)
            edifica100.setFlags(edifica100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            edifica100.setText(0, "Edificacions i construccions")
            edifica100.setCheckState(0, Qt.Unchecked)
            edificaed100 = QTreeWidgetItem(edifica100)
            edificaed100.setFlags(edificaed100.flags() | Qt.ItemIsUserCheckable)
            edificaed100.setText(0, "Edificació CV100")
            edificaed100.setCheckState(0, Qt.Unchecked)
            edificaedp100 = QTreeWidgetItem(edifica100)
            edificaedp100.setFlags(edificaedp100.flags() | Qt.ItemIsUserCheckable)
            edificaedp100.setText(0, "Edificació puntual CV100")
            edificaedp100.setCheckState(0, Qt.Unchecked)
            piscina100 = QTreeWidgetItem(edifica100)
            piscina100.setFlags(piscina100.flags() | Qt.ItemIsUserCheckable)
            piscina100.setText(0, "Piscina/Bassa CV100")
            piscina100.setCheckState(0, Qt.Unchecked)
            piscinap100 = QTreeWidgetItem(edifica100)
            piscinap100.setFlags(piscinap100.flags() | Qt.ItemIsUserCheckable)
            piscinap100.setText(0, "Piscina/Bassa puntual CV100")
            piscinap100.setCheckState(0, Qt.Unchecked)
            edificaedr100 = QTreeWidgetItem(edifica100)
            edificaedr100.setFlags(edificaedr100.flags() | Qt.ItemIsUserCheckable)
            edificaedr100.setText(0, "Edificació en ruïnes CV100")
            edificaedr100.setCheckState(0, Qt.Unchecked)
            edificaedrp100 = QTreeWidgetItem(edifica100)
            edificaedrp100.setFlags(edificaedrp100.flags() | Qt.ItemIsUserCheckable)
            edificaedrp100.setText(0, "Edificació en ruïnes puntual CV100")
            edificaedrp100.setCheckState(0, Qt.Unchecked)
            actext100 = QTreeWidgetItem(edifica100)
            actext100.setFlags(actext100.flags() | Qt.ItemIsUserCheckable)
            actext100.setText(0, "Activitat extractiva CV100")
            actext100.setCheckState(0, Qt.Unchecked)
            actextp100 = QTreeWidgetItem(edifica100)
            actextp100.setFlags(actextp100.flags() | Qt.ItemIsUserCheckable)
            actextp100.setText(0, "Activitat extractiva puntual CV100")
            actextp100.setCheckState(0, Qt.Unchecked)
            obracon100 = QTreeWidgetItem(edifica100)
            obracon100.setFlags(obracon100.flags() | Qt.ItemIsUserCheckable)
            obracon100.setText(0, "Obra de contenció CV100")
            obracon100.setCheckState(0, Qt.Unchecked)
            inverna100 = QTreeWidgetItem(edifica100)
            inverna100.setFlags(inverna100.flags() | Qt.ItemIsUserCheckable)
            inverna100.setText(0, "Hivernacle CV100")
            inverna100.setCheckState(0, Qt.Unchecked)
            patio100 = QTreeWidgetItem(edifica100)
            patio100.setFlags(patio100.flags() | Qt.ItemIsUserCheckable)
            patio100.setText(0, "Pati CV100")
            patio100.setCheckState(0, Qt.Unchecked)
            muralla100 = QTreeWidgetItem(edifica100)
            muralla100.setFlags(muralla100.flags() | Qt.ItemIsUserCheckable)
            muralla100.setText(0, "Muralla històrica CV100")
            muralla100.setCheckState(0, Qt.Unchecked)
            instala100 = QTreeWidgetItem(basecartografica100)
            instala100.setFlags(instala100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            instala100.setText(0, "Instal·lacions y equipaments")
            instala100.setCheckState(0, Qt.Unchecked)
            instalinea100 = QTreeWidgetItem(instala100)
            instalinea100.setFlags(instalinea100.flags() | Qt.ItemIsUserCheckable)
            instalinea100.setText(0, "Línia elèctrica CV100")
            instalinea100.setCheckState(0, Qt.Unchecked)
            vertices100 = QTreeWidgetItem(instala100)
            vertices100.setFlags(vertices100.flags() | Qt.ItemIsUserCheckable)
            vertices100.setText(0, "Vèrtexs geodèsics CV100")
            vertices100.setCheckState(0, Qt.Unchecked)
            dotapunt100 = QTreeWidgetItem(instala100)
            dotapunt100.setFlags(dotapunt100.flags() | Qt.ItemIsUserCheckable)
            dotapunt100.setText(0, "Espai dotacional puntual CV100")
            dotapunt100.setCheckState(0, Qt.Unchecked)
            transpunt100 = QTreeWidgetItem(instala100)
            transpunt100.setFlags(transpunt100.flags() | Qt.ItemIsUserCheckable)
            transpunt100.setText(0, "Instal·lació de transport puntual CV100")
            transpunt100.setCheckState(0, Qt.Unchecked)
            deposito100 = QTreeWidgetItem(instala100)
            deposito100.setFlags(deposito100.flags() | Qt.ItemIsUserCheckable)
            deposito100.setText(0, "Depòsit CV100")
            deposito100.setCheckState(0, Qt.Unchecked)
            translin100 = QTreeWidgetItem(instala100)
            translin100.setFlags(translin100.flags() | Qt.ItemIsUserCheckable)
            translin100.setText(0, "Instal·lació de transport lineal CV100")
            translin100.setCheckState(0, Qt.Unchecked)
            transpol100 = QTreeWidgetItem(instala100)
            transpol100.setFlags(transpol100.flags() | Qt.ItemIsUserCheckable)
            transpol100.setText(0, "Instal·lació de transport poligonal CV100")
            transpol100.setCheckState(0, Qt.Unchecked)
            espadot100 = QTreeWidgetItem(instala100)
            espadot100.setFlags(espadot100.flags() | Qt.ItemIsUserCheckable)
            espadot100.setText(0, "Espai dotacional CV100")
            espadot100.setCheckState(0, Qt.Unchecked)
            comunicacion100 = QTreeWidgetItem(basecartografica100)
            comunicacion100.setFlags(comunicacion100.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            comunicacion100.setText(0, "Vies de comunicació")
            comunicacion100.setCheckState(0, Qt.Unchecked)
            comured100 = QTreeWidgetItem(comunicacion100)
            comured100.setFlags(comured100.flags() | Qt.ItemIsUserCheckable)
            comured100.setText(0, "Xarxa viària CV100")
            comured100.setCheckState(0, Qt.Unchecked)
            ferro100 = QTreeWidgetItem(comunicacion100)
            ferro100.setFlags(ferro100.flags() | Qt.ItemIsUserCheckable)
            ferro100.setText(0, "Ferrocarril CV100")
            ferro100.setCheckState(0, Qt.Unchecked)
            tunel100 = QTreeWidgetItem(comunicacion100)
            tunel100.setFlags(tunel100.flags() | Qt.ItemIsUserCheckable)
            tunel100.setText(0, "Boca de túnel CV100")
            tunel100.setCheckState(0, Qt.Unchecked)
            comurede100 = QTreeWidgetItem(comunicacion100)
            comurede100.setFlags(comurede100.flags() | Qt.ItemIsUserCheckable)
            comurede100.setText(0, "Xarxa viària elevada CV100")
            comurede100.setCheckState(0, Qt.Unchecked)
            ferroe100 = QTreeWidgetItem(comunicacion100)
            ferroe100.setFlags(ferroe100.flags() | Qt.ItemIsUserCheckable)
            ferroe100.setText(0, "Ferrocarril elevat CV100")
            ferroe100.setCheckState(0, Qt.Unchecked)
            comureds100 = QTreeWidgetItem(comunicacion100)
            comureds100.setFlags(comureds100.flags() | Qt.ItemIsUserCheckable)
            comureds100.setText(0, "Xarxa viària subterrània CV100")
            comureds100.setCheckState(0, Qt.Unchecked)
            ferros100 = QTreeWidgetItem(comunicacion100)
            ferros100.setFlags(ferros100.flags() | Qt.ItemIsUserCheckable)
            ferros100.setText(0, "Ferrocarril subterrani CV100")
            ferros100.setCheckState(0, Qt.Unchecked)
            fechasbases = QTreeWidgetItem(carto)
            fechasbases.setText(0, "Dates Bases cartogràfiques")
            fechasvuelos = QTreeWidgetItem(fechasbases)
            fechasvuelos.setFlags(fechasvuelos.flags() | Qt.ItemIsUserCheckable)
            fechasvuelos.setText(0, "Dates de vol")
            fechasvuelos.setCheckState(0, Qt.Unchecked)
            redtransp = QTreeWidgetItem(carto)
            redtransp.setText(0, "Xarxa de Transports")
            redcarretera = QTreeWidgetItem(redtransp)
            redcarretera.setFlags(redcarretera.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            redcarretera.setText(0, "Transport Carretera")
            redcarretera.setCheckState(0, Qt.Unchecked)
            sistviari = QTreeWidgetItem(redcarretera)
            sistviari.setFlags(sistviari.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            sistviari.setText(0, "Sistema Viari")
            sistviari.setCheckState(0, Qt.Unchecked)
            cataviario = QTreeWidgetItem(sistviari)
            cataviario.setFlags(cataviario.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            cataviario.setText(0, "Catàleg Viari")
            cataviario.setCheckState(0, Qt.Unchecked)
            cataviario1 = QTreeWidgetItem(cataviario)
            cataviario1.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario1.setText(0, "Catàleg viari escala 1")
            cataviario1.setCheckState(0, Qt.Unchecked)
            cataviario2 = QTreeWidgetItem(cataviario)
            cataviario2.setFlags(cataviario1.flags() | Qt.ItemIsUserCheckable)
            cataviario2.setText(0, "Catàleg viari escala 2")
            cataviario2.setCheckState(0, Qt.Unchecked)
            cataviario3 = QTreeWidgetItem(cataviario)
            cataviario3.setFlags(cataviario3.flags() | Qt.ItemIsUserCheckable)
            cataviario3.setText(0, "Catàleg viari escala 3")
            cataviario3.setCheckState(0, Qt.Unchecked)
            cataviario4 = QTreeWidgetItem(cataviario)
            cataviario4.setFlags(cataviario4.flags() | Qt.ItemIsUserCheckable)
            cataviario4.setText(0, "Catàleg viari escala 4")
            cataviario4.setCheckState(0, Qt.Unchecked)
            puntokil = QTreeWidgetItem(sistviari)
            puntokil.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            puntokil.setText(0, "Punts quilomètrics")
            puntokil.setCheckState(0, Qt.Unchecked)
            caminos = QTreeWidgetItem(sistviari)
            caminos.setFlags(puntokil.flags() | Qt.ItemIsUserCheckable)
            caminos.setText(0, "Camins")
            caminos.setCheckState(0, Qt.Unchecked)
            urbana = QTreeWidgetItem(sistviari)
            urbana.setFlags(urbana.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            urbana.setText(0, "Urbana")
            urbana.setCheckState(0, Qt.Unchecked)
            portal = QTreeWidgetItem(urbana)
            portal.setFlags(portal.flags() | Qt.ItemIsUserCheckable)
            portal.setText(0, "Portal")
            portal.setCheckState(0, Qt.Unchecked)
            listacalles = QTreeWidgetItem(urbana)
            listacalles.setFlags(listacalles.flags() | Qt.ItemIsUserCheckable)
            listacalles.setText(0, "Llistat de carrers")
            listacalles.setCheckState(0, Qt.Unchecked)
            infraestruc = QTreeWidgetItem(redcarretera)
            infraestruc.setFlags(infraestruc.flags() | Qt.ItemIsTristate | Qt.ItemIsUserCheckable)
            infraestruc.setText(0, "Infraestructures e instal·lacions")
            infraestruc.setCheckState(0, Qt.Unchecked)
            estautob = QTreeWidgetItem(infraestruc)
            estautob.setFlags(estautob.flags() | Qt.ItemIsUserCheckable)
            estautob.setText(0, "Estació d'autobusos")
            estautob.setCheckState(0, Qt.Unchecked)
            peaje = QTreeWidgetItem(infraestruc)
            peaje.setFlags(peaje.flags() | Qt.ItemIsUserCheckable)
            peaje.setText(0, "Peatge")
            peaje.setCheckState(0, Qt.Unchecked)
            areaserv = QTreeWidgetItem(infraestruc)
            areaserv.setFlags(areaserv.flags() | Qt.ItemIsUserCheckable)
            areaserv.setText(0, "Àrees de servei")
            areaserv.setCheckState(0, Qt.Unchecked)
            areaservin = QTreeWidgetItem(infraestruc)
            areaservin.setFlags(areaservin.flags() | Qt.ItemIsUserCheckable)
            areaservin.setText(0, "Aparcament de servicis viaris hivernal")
            areaservin.setCheckState(0, Qt.Unchecked)
            puente = QTreeWidgetItem(infraestruc)
            puente.setFlags(puente.flags() | Qt.ItemIsUserCheckable)
            puente.setText(0, "Pont")
            puente.setCheckState(0, Qt.Unchecked)


        self.tree_toc.expandToDepth(1)  # Tree level in which it is presented when loaded

    """ Layer search function in the QtreeWidget """

    def searchLayer(self):
        if self.txt_busca_capa.text() == 'Busca capa...': # Help text
            pass
        else:  # Start the search if the text is not the help text
            text_capa = self.txt_busca_capa.text()  # Assign the search text to the variable
            self.list_capa.clear()
            if len(text_capa) > 2:  # Star the search if the text lenght is bigger than 3 characters
                self.list_capa.show()
                if self.rdb_cas.isChecked() == True: # Search in spanish
                    i = 0
                    for item in capasIDEV:  # We go through all the layers
                            if text_capa.lower() in capasIDEV[i]['nombre_cas'].lower():
                                self.list_capa.addItem(capasIDEV[i]['nombre_cas']) # If a layer matches the search pattern it is added to the listWisget
                            i = i + 1
                if self.rdb_val.isChecked() == True:  # Search in valencian
                    i = 0
                    for item in capasIDEV: # We go through all the layers
                        if text_capa.lower() in capasIDEV[i]['nombre_val'].lower():
                            self.list_capa.addItem(capasIDEV[i]['nombre_val']) # If a layer matches the search pattern it is added to the listWisget
                        i = i + 1
            else:
                self.list_capa.hide() # Hide the listWidget of the results of the layers search

    """ Function that when selecting a layer of the QTreeWidget activates the link button with the catalog """

    #@QtCore.pyqtSlot(QtWidgets.QTreeWidgetItem, int)
    def selectTreeLayer(self):
        self.tree_toc.clearSelection() # Clear the actual layers selection
        nom_capa = self.list_capa.currentItem().text() # We assign to the variable the selected layer of the QTreeWidget
        for item in self.tree_toc.findItems(nom_capa, Qt.MatchContains | Qt.MatchRecursive):
            self.tree_toc.setCurrentItem(item) # Capture of the selected item by clicking
            item.setSelected(True) # Select the item in the QTreeWidget
            item.setExpanded(True) # Expand the QtreeWidget at the item level
        if self.rdb_cas.isChecked() == True:
            self.txt_busca_capa.setText("Busca capa...")
        if self.rdb_val.isChecked() == True:
            self.txt_busca_capa.setText("Busca capa...")
        self.list_capa.hide()

    """ Function that closes the plugin """

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

""" We define the dictionary of layers outside the functions so that it is accessible in all """

path_capas_json = os.path.dirname(os.path.realpath(__file__)) + '/params.json' # Path of the JSON file with the definition of each layer
with open(path_capas_json, "r") as read_file:  # Read the JSON file
    capasIDEV = json.load(read_file)  # Store in a dictionary the JSON file, each element is a layer


""" We define the layer data structure as a class """

class capaIDEV:
    def __init__(self, nombre_cas, nombre_val, aviso_cas, aviso_val, metadato, url):
        self.nombre = nombre_cas
        self.tipo = nombre_val
        self.aviso = aviso_cas
        self.aviso = aviso_val
        self.metadato = metadato
        self.url = url

    def __str__(self):
        cadena = 'Nombre castellano: \n'.format(self.nombre_cas)
        cadena = 'Nombre valenciano: \n'.format(self.nombre_val)
        cadena = cadena + 'Aviso castellano: \n'.format(self.aviso_cas)
        cadena = cadena + 'Aviso valenciano: \n'.format(self.aviso_val)
        cadena = cadena + 'Metadato UIDD: \n'.format(self.metadato)
        cadena = cadena + 'URL conexión: \n'.format(self.url)
        return cadena
