# -*- coding: utf-8 -*-
"""
/***************************************************************************
 IbgeBaseContinua
                                 A QGIS plugin
 Consumir o geoserviço do IBGE e adicionar ao projeto
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-11-03
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Matheus Oliveira de Freitas
        email                : matheus18.1@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon,QFont
from qgis.PyQt.QtWidgets import *
from qgis.core import *
from qgis.PyQt.QtCore import QVariant, QSettings, QTranslator, qVersion, QCoreApplication,QFile,Qt
from datetime import datetime, timedelta
from qgis.PyQt import uic
from qgis.core import QgsMessageLog, Qgis
import traceback
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .IBGE_Base_Continua_dialog import IbgeBaseContinuaDialog
import os.path
import processing
import sys, os
from osgeo import ogr
from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtWidgets import QFileDialog
from qgis.PyQt.QtXml import QDomDocument
import webbrowser
from datetime import datetime
import urllib.request

class CarregarFeicoesTask(QgsTask):
    def __init__(self, descricao,camada,diretorio):
        super().__init__(descricao, QgsTask.CanCancel)  # permite cancelar
        self.descricao = descricao
        self.categoria=camada
        #self.OLA=tipo
        #self.c=simbologia

        self.diretorio=diretorio
        self.caminho_valido=0
        self.uri = None
        self.camada_gerada = None # Inicializa como None
        self.uri_salva=None
        self.vlayer=None
        self.Tem=[]
    def simbologia(self,camada):
    
        
        if camada.startswith(('BC250_2023_', 'BC250_2021_', 'BC250_2019_', 'BC250_2017_')):
            return camada[11:]
                            
        elif camada.startswith(('BC100_AC_2023_','BC100_AL_2022_','BC100_RS_2021_','BC100_SE_2019_')):
            return camada[14:]
                            
        elif camada.startswith(('BC100_ES_2018_EDGV_3.0_')):
            return camada[23:]
                            
        elif camada.startswith(('BC25_RJ_2018_EDGV_3.0_')):
            return camada[22:]
        elif camada.startswith(('BC100_ES_')):
            return camada[9:]
            
        if camada.startswith(('BC250_2025_')):
            return camada[15:]
        else:
            return camada[17:]
    def run(self):
        """Aqui roda em background (não trava o QGIS)."""
        feedback = QgsProcessingFeedback()
       
        cont=0

        for categoria in self.categoria:   
            if self.isCanceled():
                return False  # encerra task inteira
             

                    


            camada_entrada=categoria

                        
            # Criar a camada em memória para todas as capitais
            nome=camada_entrada
                    
                        
                            
            # Construção da URL
            try:
                #url_wfs = "pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:4674' typename='CCAR:BC25_Ponte_P' url='https://geoservicos.ibge.gov.br/geoserver/ows?layers=CCAR:BC250_2023_Trecho_Hidroviario_L&styles=&bbox=-71.8711471557617,-33.4139556884766,-34.6535301208496,5.14186811447144&width=237&height=245&tiled=true&srs=EPSG:4326&transparent=true' url='https://geoservicos.ibge.gov.br/geoserver/ows?version=1.1.0&layers=CCAR:BC250_2023_Trecho_Hidroviario_L&styles=&bbox=-71.8711471557617,-33.4139556884766,-34.6535301208496,5.14186811447144&width=237&height=245&tiled=true&srs=EPSG:4326&transparent=true' version='auto'"
                # url_wfs = f"pagingEnabled='true'preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:4674' typename='{camada_entrada}' url='https://geoservicos.ibge.gov.br/geoserver/ows' url='https://geoservicos.ibge.gov.br/geoserver/ows?version=2.0.0' version='auto'" 
                url_wfs = f"pagingEnabled='true' preferCoordinatesForWfsT11='false' restrictToRequestBBOX='1' srsname='EPSG:4674' typename='{camada_entrada}' url='https://geoservicos.ibge.gov.br/geoserverCCAR/ows?width=20&height=20&layer=CCAR%3A{camada_entrada}' version='auto'"             
                self.vlayer = QgsVectorLayer(url_wfs, f"{camada_entrada}", "WFS")
            except:
                QgsMessageLog.logMessage(
                    f"Erro ao carregar {self.error_message}",
                    "Ibge_Base_Continua",
                    Qgis.Critical
                )
                break
            
            #QgsProject.instance().addMapLayer(vlayer)
            if not self.vlayer.isValid():                      
                self.error_message = 'GeoServiço fora do ar '
                break

            else:
                #features_origem = list(vlayer.getFeatures())
                #Ler o diretorio e usa o os.path.isdir para ver se é valido ou não
                self.caminho_valido=0
                if self.diretorio:
                    diretorio = os.path.dirname(self.diretorio)
                    if os.path.isdir(diretorio):
                        self.caminho_valido = 1

                #Se o diretorio é valido vai gerar o GeoPack
                if self.caminho_valido==1:
                    try:
                        #Parametros para salvar o Vetor no Geopack
                        options = QgsVectorFileWriter.SaveVectorOptions()
                        options.driverName = "GPKG"
                        options.layerName = categoria
                        #Se for o primeiro vetor vai presisa criar o GeoPack, depois disso com o GeoPack criado e so adicionar os vetores
                        if cont!=0:
                            #Esse parametor cria o Geopack
                            options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                            
                        #Criar de fato o Geopack
                        QgsVectorFileWriter.writeAsVectorFormatV3(
                            layer=self.vlayer,
                            fileName=self.diretorio,
                            transformContext=QgsProject.instance().transformContext(),
                            options=options)
                    #Se der erro na criacao GeoPack ou na hora de adcionar a camada ao GeoPack mostrar mensagem de erro
                    except Exception as e:
                        self.error_message = f'Um erro inesperado ocorreu: {str(e)}'
                        QgsMessageLog.logMessage(self.error_message, "Ibge_Base_Continua", Qgis.Critical)
                        
                        #self.uri = f"{self.diretorio}|layername={categoria}"
                #Se o diretorio foi invalido ou que usuario nao preencheu nada na saida gerar arquivos temporarios
                else:
                
                    #Vai criar uma lista com as camadas WFS
                    self.Tem.append(self.vlayer)
                    #Se gerar a um arquivo temporario dentro do run do tsk vai vir com um problema. Mesmo sendo menos eficiente e da uma pequena travada do QGIS e melhor que o arquivo venha com problema
            #So um contador para saber se gera ou nao o GeoPack
            cont+=1
            
        #Precisa colocar
        return True

    def finished(self, result):
        """Aqui roda na thread principal (pode mexer na interface)."""
                                                  
        # Se e Geopacj
        if self.caminho_valido==1:
            #Como eu sei que as camadas dentro do GeoPack sempre vao ser as mesmas camadas do self.categoria vai percorrer as camadas self.categoria
            for adicionar in self.categoria:
                #Saber onde esta salvo o GeoPack e o nome da camada
                self.uri_salva = f"{self.diretorio}|layername={adicionar}"
                #Delimitar a camada
                camada_salva = QgsVectorLayer(self.uri_salva, adicionar, "ogr")
                
                #Dar um upade(recarregar) nas colunas
                camada_salva.updateFields()

                #Aplicar a Simbologia. Caso nao tenha a simbologia ou nao encontre nao vai dar erro
                c=self.simbologia(adicionar)  #Saber o nome da camada sem BC... Apenas o nome        
                local=os.path.dirname(__file__) #Local onde esta salvo o complemento                
                cami=os.path.join(local, 'Simbologia', f'{c}.qml') #Mesclar o local + Simbologia + nome da camada +qml                
                camada_salva.loadNamedStyle(f"{cami}") #Adicionar a Simbologia
                
                #Dar uma recarregada na camada para certificar a aplicacao da simbologia
                camada_salva.triggerRepaint()                           
                camada_salva.updateExtents()
                
                #Adicionar a camada ao projeto
                QgsProject.instance().addMapLayer(camada_salva)
                
        #Se e arquivo temporario
        else:
            #Percorre as camadas salvas na lista
            for cam_tem in self.Tem:
                nome_t=cam_tem.name()
                
                tipo_wkb_da_camada = cam_tem.wkbType()
                nome_geometria = QgsWkbTypes.displayString(tipo_wkb_da_camada)
                    
                
                self.camada_gerada = QgsVectorLayer(f"{nome_geometria}?crs=EPSG:4674", nome_t, "memory")
                prov = self.camada_gerada.dataProvider()

                #Adicionando as feiçoes                       
                prov.addAttributes(cam_tem.fields())
                self.camada_gerada.updateFields() # Importante fazer antes de adicionar feições
                        
                # Pega todas as feições da camada de origem

                features_origem = list(cam_tem.getFeatures())
                c=self.simbologia(nome_t)
                c.title()
                # Adiciona todas de uma vez
                prov.addFeatures(features_origem)

                # Aplicar a simbologia
                self.camada_gerada.updateFields()

                local = os.path.dirname(__file__)
                caminho_simbologia = os.path.join(local, 'Simbologia', f'{c}.qml')
                # E depois use a variável:
                self.camada_gerada.loadNamedStyle(caminho_simbologia)
                            
                self.camada_gerada.updateExtents()

                #Adicionar ao projeto
                QgsProject.instance().addMapLayer(self.camada_gerada)

        

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'IBGE_Base_Continua_dialog_base.ui'))

class IbgeBaseContinuaDialog(QDialog, FORM_CLASS):
    """
    A classe do seu diálogo.
    """
    def __init__(self, plugin, parent=None):
        """
        Construtor.

        :param plugin: Uma referência à instância da classe principal do plugin (IbgeBaseContinuaDialog).
        :param parent: O widget pai.
        """
        super(IbgeBaseContinuaDialog, self).__init__(parent)
        self.setupUi(self)

        # --- AQUI É A MÁGICA ---
        # Conectamos os sinais dos widgets (botões, etc.) aos métodos
        # da classe principal do plugin, que recebemos como argumento.
        # Estas conexões são feitas APENAS UMA VEZ, quando o diálogo é criado.

        self.toolButton.clicked.connect(plugin.carregar_Classe)
        #self.toolButton_2.clicked.connect(plugin.carregar_Estado)
        self.pushButton_selecio.clicked.connect(plugin.selecionar_todos)
        self.pushButton_S_C.clicked.connect(plugin.selecionar_todos_C)
        self.pushButton_Dessel.clicked.connect(plugin.desmarcar)
        self.pushButton_D_C.clicked.connect(plugin.desmarcar_Camadas)
        self.toolButton_4.clicked.connect(plugin.limpar)
        self.toolButton_5.clicked.connect(plugin.remover_selecionados)            
        self.toolButton_saida.clicked.connect(plugin.definirSaida)
        self.toolButton_Manual.clicked.connect(plugin.abre_manual)
        
class IbgeBaseContinua:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'IbgeBaseContinua_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&IBGE Base Cartográfica Contínua')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('IbgeBaseContinua', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.webMenu().addAction(action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/IBGE_Base_Continua/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'IBGE Base Cartográfica Contínua'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            # Remove a ação do menu 'Web'
            self.iface.webMenu().removeAction(action)
            self.iface.removeToolBarIcon(action)
        

    def carregar_Classe(self, textEdit):
        
        self.dlg.list_widget.clear()
        #dialog = QDialog()
        #dialog.setWindowTitle("Classes Disponiveis:")
        #layout = QVBoxLayout(dialog)
     
        # Adiciona um label e a lista de opções
        #label = QLabel("Classes Disponiveis:")
        #layout.addWidget(label)
        # URL do serviço WMS (exemplo: IBGE)
        try:
            
            url = "https://geoservicos.ibge.gov.br/"
            urllib.request.urlopen(url, timeout=30)
            internet=1
        except:                                              

            internet=2
            
        if internet==1:      
        
            # Baixar o XML de capabilities
            #response='C:/Users/Usuário/AppData/Roaming/QGIS/QGIS3/profiles/default/python/plugins/exbyat/getcapabilities.xml'
            
            local_GET=os.path.dirname(__file__)      
            GET = os.path.join(local_GET).replace("\\", "/")
            cami=str(f"{GET}\getcapabilities.xml")
            
            precisa_baixar = True
            if os.path.exists(cami):
                # Data da última modificação
                ultima_mod = datetime.fromtimestamp(os.path.getmtime(cami))
                if datetime.now() - ultima_mod < timedelta(days=7):
                    precisa_baixar = False

            if precisa_baixar:
                    try:
                        url_wfs = "https://geoservicos.ibge.gov.br/geoserver/CCAR/ows?service=WMS&request=GetCapabilities"
                        urllib.request.urlretrieve(url_wfs, cami)
                        QgsMessageLog.logMessage("Novo getcapabilities baixado", "IbgeBaseContinua", Qgis.Info)
                    except Exception as e:
                        QgsMessageLog.logMessage(f"Erro ao baixar getcapabilities: {str(e)}", "IbgeBaseContinua", Qgis.Critical)


            file = QFile(cami)
             
            # Parse do XML
            doc = QDomDocument()
            doc.setContent(file)
             
            # Acessar todas as camadas
            layers = doc.elementsByTagName("Layer")
             
            prefixo=self.dlg.comboBox.currentText()

            Categoria=[]
            
            for i in range(1, layers.count()):
                layer = layers.item(i).toElement()
                title = layer.firstChildElement("Title").text()
                name = layer.firstChildElement("Name").text()
                
                if title.startswith(prefixo):  # <-- filtro
                    Categoria.append(name)
            
            #Categoria=['CCAR:BC250_2023_Aglomerado_Rural_Isolado_P', 'CCAR:BC250_2023_Aglomerado_Rural_P', 'CCAR:BC250_2023_Alteracao_Fisiografica_Antropica_A', 'CCAR:BC250_2023_Alteracao_Fisiografica_Antropica_L', 'CCAR:BC250_2023_Alteracao_Fisiografica_Antropica_P', 'CCAR:BC250_2023_Area_Densamente_Edificada_A', 'CCAR:BC250_2023_Area_Politico_Administrativa_A', 'CCAR:BC250_2023_Atracadouro_Terminal_L', 'CCAR:BC250_2023_Banco_Areia_A', 'CCAR:BC250_2023_Barragem_L', 'CCAR:BC250_2023_Barragem_P', 'CCAR:BC250_2023_Canal_Vala_A', 'CCAR:BC250_2023_Canal_Vala_L', 'CCAR:BC250_2023_Capital_P', 'CCAR:BC250_2023_Cemiterio_P', 'CCAR:BC250_2023_Cidade_P', 'CCAR:BC250_2023_Complexo_Aeroportuario_P', 'CCAR:BC250_2023_Complexo_Desportivo_Lazer_P', 'CCAR:BC250_2023_Complexo_Portuario_P', 'CCAR:BC250_2023_Eclusa_P', 'CCAR:BC250_2023_Elemento_Fisiografico_Natural_A', 'CCAR:BC250_2023_Elemento_Fisiografico_Natural_L', 'CCAR:BC250_2023_Elemento_Fisiografico_Natural_P', 'CCAR:BC250_2023_Est_Gerad_Energia_Eletrica_P', 'CCAR:BC250_2023_Estrut_Transporte_P', 'CCAR:BC250_2023_Ext_Mineral_A', 'CCAR:BC250_2023_Ext_Mineral_P', 'CCAR:BC250_2023_Foz_Maritima_A', 'CCAR:BC250_2023_Foz_Maritima_L', 'CCAR:BC250_2023_Foz_Maritima_P', 'CCAR:BC250_2023_Hidreletrica_P', 'CCAR:BC250_2023_Ilha_A', 'CCAR:BC250_2023_Indice_dos_Nomes', 'CCAR:BC250_2023_Massa_Dagua_A', 'CCAR:BC250_2023_Municipio_A', 'CCAR:BC250_2023_Obra_De_Arte_Viaria_L', 'CCAR:BC250_2023_Obra_De_Arte_Viaria_P', 'CCAR:BC250_2023_Outros_Limites_Oficiais_L', 'CCAR:BC250_2023_Pais_A', 'CCAR:BC250_2023_Passagem_Elevada_Viaduto_L', 'CCAR:BC250_2023_Passagem_Elevada_Viaduto_P', 'CCAR:BC250_2023_Passagem_Nivel_P', 'CCAR:BC250_2023_Pico_P', 'CCAR:BC250_2023_Pista_Ponto_Pouso_L', 'CCAR:BC250_2023_Pista_Ponto_Pouso_P', 'CCAR:BC250_2023_Ponte_L', 'CCAR:BC250_2023_Ponte_P', 'CCAR:BC250_2023_Ponto_Cotado_Altimetrico_P', 'CCAR:BC250_2023_Ponto_Hipsometrico_P', 'CCAR:BC250_2023_Posic_Geo_Localidade_P', 'CCAR:BC250_2023_Recife_A', 'CCAR:BC250_2023_Sinalizacao_P', 'CCAR:BC250_2023_Subest_Transm_Distrib_Energia_Eletrica_P', 'CCAR:BC250_2023_Termeletrica_P', 'CCAR:BC250_2023_Terreno_Sujeito_Inundacao_A', 'CCAR:BC250_2023_Travessia_L', 'CCAR:BC250_2023_Travessia_P', 'CCAR:BC250_2023_Trecho_Drenagem_L', 'CCAR:BC250_2023_Trecho_Duto_L', 'CCAR:BC250_2023_Trecho_Energia_L', 'CCAR:BC250_2023_Trecho_Ferroviario_L', 'CCAR:BC250_2023_Trecho_Hidroviario_L', 'CCAR:BC250_2023_Trecho_Rodoviario_L', 'CCAR:BC250_2023_Tunel_L', 'CCAR:BC250_2023_Tunel_P', 'CCAR:BC250_2023_Unidade_Federacao_A', 'CCAR:BC250_2023_Via_Deslocamento_L', 'CCAR:BC250_2023_Vila_P']
            
            self.dlg.list_widget.addItems(Categoria)
         

            self.dlg.list_widget.setSelectionMode(QAbstractItemView.MultiSelection)

            
            
            def processar_selecao():
                self.dlg.listWidget_camadas.setSelectionMode(QAbstractItemView.MultiSelection)
                
                itens_selecionados = self.dlg.list_widget.selectedItems()
                selected_items = [item.text() for item in itens_selecionados]

                # Verifica quais já existem no listWidget_camadas
                existentes = [self.dlg.listWidget_camadas.item(i).text()
                              for i in range(self.dlg.listWidget_camadas.count())]

                for item in selected_items:
                    if item not in existentes:
                        self.dlg.listWidget_camadas.addItem(item)
            self.dlg.toolButton_3.clicked.connect(processar_selecao)
        else:
            mensagem = QMessageBox()
            mensagem.setWindowTitle("Falha ao conectar ao serviço")
            texto = 'Sem internet\n\nTente:\n*Verificar os cabos de rede, modem e roteador.\n*Fechar e abrir Qgis.'   
            mensagem.setText(texto)


            mensagem.exec_()  
            pass
        #dialog.setLayout(layout)
        #dialog.exec_()
        
    def configurarComboBox(self):
        # Lista de escalas
        escalas = ['BC250_2025','BC250_2023','BC250_2021','BC250_2019','BC250_2017','BC100_SE','BC100_GO_DF','BC100_RS','BC100_ES','BC100_AL','BC100_AC', 'BC25_RJ']     
        # Limpa qualquer item pré-existente no comboBox
        self.dlg.comboBox.clear()        
        # Adiciona os itens ao comboBox
        self.dlg.comboBox.addItems(escalas)
        # Retorna o texto do item atualmente selecionado
        escala_selecionada = self.dlg.comboBox.currentText()
        return escala_selecionada     
        # Conectar o botão OK para processar os dados e fechar o diálogo
        
    def limpar(self):
        self.dlg.listWidget_camadas.clear()

    def remover_selecionados(self):
        for item in self.dlg.listWidget_camadas.selectedItems():
            self.dlg.listWidget_camadas.takeItem(self.dlg.listWidget_camadas.row(item))

    def selecionar_todos(self):
        for i in range(self.dlg.list_widget.count()):
            item = self.dlg.list_widget.item(i)
            item.setSelected(True)
            
    def abre_manual(self):
        path =  'file:///'+self.plugin_dir+u'/Manual.pdf'
        webbrowser.open_new_tab(path)
        
    def desmarcar(self):
        for i in range(self.dlg.list_widget.count()):
            item = self.dlg.list_widget.item(i)
            item.setSelected(False)

    def desmarcar_Camadas(self):
        for i in range(self.dlg.listWidget_camadas.count()):
            item = self.dlg.listWidget_camadas.item(i)
            item.setSelected(False)          

    def selecionar_todos_C(self):
        for i in range(self.dlg.listWidget_camadas.count()):
            item = self.dlg.listWidget_camadas.item(i)
            item.setSelected(True)

    def definirSaida(self):
        """SALVAR A SAIDA"""
        #Traduzir///Select Output Folder
        camada_salvar=str(QFileDialog.getSaveFileName(caption="Select Output Folder, ......",
                                                            filter="GeoPackage (*.gpkg)")[0])
        if camada_salvar: # Se o usuário não cancelou
            self.dlg.lineEdit.setText(camada_salvar)
        return camada_salvar # <-- CORREÇÃO: Retorne o caminho

    '''def carregar_Estado(self, textEdit):
        dialog = QDialog()
        dialog.setWindowTitle("Fitro por Estado (opcional):")
        Estados_disponiveis = QVBoxLayout(dialog)
     
        # Adiciona um label e a lista de opções
        label = QLabel("Fitro por Estado (opcional):")
        Estados_disponiveis.addWidget(label)
     
        # Lista de estados


        estados = ['AC', 'AL', 'AM', 'AP', 'BA', 'CE','DF','ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO']

         
        list_widget = QListWidget()
        list_widget.addItems(estados)
     
        # Permite selecionar múltiplos itens
        list_widget.setSelectionMode(QAbstractItemView.MultiSelection)
        Estados_disponiveis.addWidget(list_widget)
     
        # Botão para confirmar
        btn_ok = QPushButton("OK")
        Estados_disponiveis.addWidget(btn_ok)
     
        # Conectar o botão OK para processar os dados e fechar o diálogo
        def Selecionar_Estado():
            selected_items = [item.text() for item in list_widget.selectedItems()]
            if selected_items:
                estados_selecionados = ", ".join(selected_items)
                self.dlg.lineEdit_2.setText(estados_selecionados)
                
            else:
                self.dlg.lineEdit_2.setText("NULL")
            dialog.accept()  # Fecha o diálogo
     
        btn_ok.clicked.connect(Selecionar_Estado)
        

        dialog.setLayout(Estados_disponiveis)
        dialog.exec_()'''
        

       
                    
        
        
    def obter_todas_camadas(self):
        itens = []
        for i in range(self.dlg.listWidget_camadas.count()):
            itens.append(self.dlg.listWidget_camadas.item(i).text())
        return itens

        
    def variais(self):
        self.Classe=self.obter_todas_camadas()
        self.caminho = self.dlg.lineEdit.text() 
        #self.Estado=self.dlg.lineEdit_2.text().split(", ")
        
        self.ESC=self.dlg.comboBox.currentText()

            
        '''e=self.dlg.lineEdit_2.text()
            
        for a in self.Estado:
            self.ESTA=a'''
        


        self.ESCALA=f"Base={self.ESC}"
            
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = IbgeBaseContinuaDialog(plugin=self)

        self.dlg.list_widget.clear()
        self.dlg.listWidget_camadas.clear()
        

        self.configurarComboBox()
        # adicionando as funções criadas
        result = self.dlg.exec_()


        # See if OK was pressed
        if result:
            self.variais()
            camadas_selecionadas=[]
            

            #e=self.dlg.lineEdit_2.text()
            
            
                # Cria UMA tarefa para CADA camada
            descricao_task = f"Adicionando Camada: "
            self.task = CarregarFeicoesTask(descricao_task, self.Classe, self.caminho)

            QgsApplication.taskManager().addTask(self.task)
            #task.finished.connect(lambda r, t=task: checar_status(t))

                        
            self.dlg.lineEdit.clear()
            #self.dlg.lineEdit_2.clear()    
                    

            '''mensagem = QMessageBox()
            mensagem.setWindowTitle("Finishing")
                    
            texto = str(Chamado)
                    
            mensagem.setText(texto)

            mensagem.exec_()
            self.dlg.list_widget.clear()
            self.dlg.listWidget_camadas.clear()'''
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass