# iNaturalist Import (EN)

(EN) :
QGIS plugin enabling:
- extraction of iNaturalist data from a circular area, with filtering of both input and output data.
- optionally and independently, taxonomic enrichment of observations (7 levels).

(FR) :
Plugin QGIS permettant :
- l’extraction de données iNaturalist à partir d’une zone circulaire, et avec filtrage des données d'entrée ET de sortie.
- facultativement et indépendamment, l’enrichissement taxonomique des observations (7 niveaux).

## Version
1.0.0

## Compatibility (EN) / Compatibilité (FR)
- QGIS 3.28+
- Tested under QGIS 3.40 (Bratislava) (EN) / Testé sous QGIS 3.40 (Bratislava) (FR)

## Features (EN)
	* First module:
	- Interactive selection of a circular area
	- Input filtering (period, observer, taxon, etc.)
	- Output filtering (which fields to retrieve)
	- Import of iNaturalist observations
	- Saving in GeoPackage format.

	* Second module:
	- Upon selection of the layer (ACTIVE layer), automatic addition of the 7-level taxonomy:
		- kingdom
		- phylum
		- class
		- order
		- family
		- genus
		- species

## Fonctionnalités (FR)
   * Premier module :
	- Sélection interactive d’une zone circulaire
	- Filtrage d'entrée (période, observateur, taxon, ...)
	- Filtrage de sortie (quelschampsb on veut récupérer)
	- Import des observations iNaturalist
	- Sauvegarde au format GeoPackage.
	
   * Second module :	
	- Sur choix de la couche (couche ACTIVE, ajout automatique de la taxonomie à 7 niveaux :
		- kingdom
		- phylum
		- class
		- order
		- family
		- genus
		- species

## Dependencies (EN)
- This plugin requires the Python library **pyinaturalist**.
  If it is not installed, the plugin displays a dialog box
  explaining the precise installation procedure.

## Dépendances (FR)
- Ce plugin nécessite la bibliothèque Python **pyinaturalist**. 
  Si elle n’est pas installée, le plugin affiche une boîte de dialogue
  expliquant la procédure précise d’installation.

## Utilisation (EN)
1. Click the iNaturalist import button,
2. Define the circular area on the map (center and radius, the latter graphically or numerically),
3. Choose the input filter data,
4. Choose the output filter data,
5. Let the script run until the layer is created,
6. (Optional) After making the newly created layer ACTIVE, launch the taxonomic enrichment tool.
  
## Utilisation (FR)
1. Cliquer sur le bouton d’import iNaturalist,
2. Définir la zone circulaire sur la carte (centre et rayon, ce dernier graphiquement ou numériquement),
3. Choisir les données de filtrage d'entrée,
4. Choisir les données de filtrage de sortie,
5. Laisser le script s’exécuter jusqu’à la création de la couche
6. (Optionnel) Après avoir rendue ACTIVE la couche nouvellement créée, Lancer l’outil d’enrichissement taxonomique.

## Notes (EN)
- This plugin is independent of the existing "iNaturalist Extract" plugin.
- All internal names are prefixed with `yd_`

## Notes (FR)
- Ce plugin est indépendant du plugin « iNaturalist Extract » existant
- Tous les noms internes sont préfixés par `yd_`

## Author (EN) / Auteur (FR)
Yves DURIVAULT

## Contact
yves.durivault@gmail.com 

## Licence
GPL v3

