# -*- coding: utf-8 -*-
"""
/***************************************************************************
 HVLSPMergePackagesDialog
                                 A QGIS plugin
 This plugin merges HVLSP Geopackage files
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-10-30
        git sha              : $Format:%H$
        copyright            : (C) 2024 by IGN
        email                : guillaume.valtat@ign.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from PyQt5.QtWidgets import QFileDialog
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject, QgsVectorLayer
from .ProgressBar import ProgressBar

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'HVLSP_merge_packages_dialog_base.ui'))


class HVLSPMergePackagesDialog(QtWidgets.QDialog, FORM_CLASS):

    def __init__(self, parent=None) -> None:
        """Constructor."""
        super(HVLSPMergePackagesDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.__gpkgFilesPath = []
        self.listWidget.clear()
        self.toolButton.clicked.connect(self.openGpkgFiles)

    # Opening the browse dialog box
    def openGpkgFiles(self) -> None:
        self.__gpkgFilesPath.clear()
        dlgBrowsne = QFileDialog(self)
        dlgBrowsne.setFileMode(QFileDialog.FileMode.ExistingFiles)
        dlgBrowsne.selectNameFilter('GeoPackage')
        dlgBrowsne.setNameFilters(['*.gpkg', '*.GPKG'])
        dlgBrowsne.setHistory(self.__gpkgFilesPath)
        result = dlgBrowsne.exec_()
        if result:
            self.__gpkgFilesPath = dlgBrowsne.selectedFiles()
            self.listWidget.addItems(self.__gpkgFilesPath)
        else:
            return

    def getGeoPackageFiles(self) -> {}:
        return self.__gpkgFilesPath

    def setGeoPackageFiles(self) -> None:
        self.__gpkgFilesPath.clear()
