[日本語版 README ](/README-ja.md)

# H-RISK with NoiseModelling

[![DOI](https://joss.theoj.org/papers/10.21105/joss.06023/status.svg)](https://doi.org/10.21105/joss.06023)


> [!NOTE]  
> There were critical errors in the versions before 0.4.0, where diffraction effects were not considered. Please update to the latest version.


## About

This is a QGIS plugin, which implements NoiseModelling (https://github.com/Universite-Gustave-Eiffel/NoiseModelling) and helps estimate the health risks posed by (road traffic) noise.

*The author has also made an application to estimate the risk posed by noise from wind turbines. See https://gitlab.com/jtagusari/hrisk-wtn.*

![](readme/sample.png)

Figure: Sound levels along a road in Sapporo city (see the Tutorial).

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For an overview, see the video: [NoiseModelling in QGIS](https://www.youtube.com/watch?v=BUOT0zVAu3Q&t=1s).

## Features

This plugin can

- Fetch geometries from databases such as OpenStreetMap and Shuttle Radar Topography Mission.
- Predict sound levels by executing NoiseModelling, by executing the Java (specified Java implementation is required).
- Estimate health risks based on the predicted sound levels and exposure-response relationships shown in the Environmental Noise Guidelines in European Region (WHO Regional Office for Europe).

The scripts of NoiseModelling are not translated: this plugin executes them using shell command and you can replace it with a newer version.

- NoiseModelling v4.0.4 is supported since H-RISK v0.1.0.
- NoiseModelling v4.0.5 is supported since H-RISK v0.1.4.
- NoiseModelling v5.0.0 is NOT supported because of its error.
- NoiseModelling v5.0.1 is supported since H-RISK v0.6.1.

There are plugins that extend the functionality of this plugin:

- Japan Extension <https://gitlab.com/jtagusari/hrisk-ext-ja>: It provides access to the databases in Japan. It was separated from this plugin to reduce the size of the plugin.
- Tile Extension <https://gitlab.com/jtagusari/hrisk-ext-tile>: It helps draw extensive noise maps by creating tiles to divide the area.

## How to install

This plugin has the following pre-installation requirements

- QGIS (version 3.22 or higher)
- Quick OSM plugin (can be installed via QGIS)
- Noisemodelling
- Java

The following sections describe how to install this plugin and these elements.

### Step 1: Install QGIS

Sound level calculation is implemented on QGIS, which is a free-and-open-source GIS software.
QGIS is required before installing this plugin.

You can find the work flow to install QGIS at [QGIS website](https://qgis.org/). 
Note that the version must be greater than 3.22.0.

### Step 2: Install this plugin

You can install this plugin on QGIS as it is uploaded to the QGIS repository.

1. Run QGIS and open Plugin Manager by selecting `Plugins` -> `Manage and Install Plugins` (see the image below).<br />
  ![install H-RISK on QGIS 1](readme/install-hrisk-1.png)
1. Find this plugin in the list of plugins displayed in the Plugin Manager (see the image below).
Select this plugin and click `Install Plugin` to install it in QGIS.<br />
  ![install H-RISK on QGIS 2](readme/install-hrisk-2.png)
1. Confirm that `H-RISK` algorithms in the `Processing Toolbox` (see the image below), which indicates that the installation was successfully done.<br />
  ![install H-RISK on QGIS 3](readme/install-hrisk-3.png)
1. Install QuickOSM plugin, in the same manner as the above procedure.

If there are any troubles or the latest version that is not yet uploaded to the QGIS repository is required, install using zip archive is also available: (1) download all of this project from the repository (<https://gitlab.com/jtagusari/hrisk-noisemodelling>), (2) open plugin manager by selecting `Plugins` -> `Manage and Install Plugins`, (3) select `Install from ZIP` menu, and (4) specify the downloaded zip archive.

### Step 3: Install NoiseModelling and Java environment

To make use of the full functionality of this plugin, installation of NoiseModelling and Java environment is required.
They are automatically installed using an algorithm implemented in this plugin.

> [!NOTE]  
> Although an executable installer was implemented before version 0.1.6, it was removed because it may be identified as malware.


1. Open `Install required components` algorithm, which is in `Configurations` group of this plugin (see the below image) <br />
  ![install H-RISK on QGIS 3](readme/install-hrisk-3.png)
1. The dialog box is shown. Change the installation parameters if necessary, and run it <br />
  ![install H-RISK on QGIS 4](readme/install-hrisk-4.png)
1. NoiseModelling and Java are downloaded automatically. They are extracted into the local paths, and the environmental variables of `NOISEMODELLING_HOME` and `JAVA_FOR_NOISEMODELLING` are set.
1. Restart QGIS to make the installation valid.

> [!NOTE]  
> Installation of these components will be valid after restarting QGIS. So, please restart QGIS after the installation.
> For Linux users: Start QGIS from the terminal to ensure it inherits the shell environment, especially when launched from a desktop environment like GNOME or KDE. 

If there were any problems, try manual installation, described in the following sections.

#### Manual install of NoiseModelling (Optional)

First, download a zip archive of NoiseModelling (No-GUI version) (see <https://github.com/Universite-Gustave-Eiffel/NoiseModelling/releases>)

##### For Windows

1. Extract the zip archive in your PC (e.g. `%APPDATA%\H-RISK\NoiseModelling\4.0.5`)
1. Set environmental variable of `NOISEMODELLING_HOME` to the folder where `lib` folder is located (e.g. `%APPDATA%\H-RISK\NoiseModelling\4.0.5\scriptrunner`). Note that there are `.jar` files in `%NOISEMODELLING_HOME%\lib`.
1. Restart QGIS

##### For Mac/Linux

1. Extract the zip archive in your PC (e.g. `~Applications/H-RISK/NoiseModelling/4.0.5`)
1. Append the path as `NOISEMODELLING_HOME` to `~/.bash_profile`, such as `export NOISEMODELLING_HOME ~Applications/H-RISK/NoiseModelling/4.0.5/scriptrunner`. Note that there are `.jar` files in `%NOISEMODELLING_HOME\lib`.
1. Restart QGIS　

> [!NOTE]  
> The environmental variables are written in `.bashrc`.
> To load `.bashrc` and reflect changes of environmental variables, QGIS should be restarted from the console (but not from the launcher) on Linux.


#### Manual install of Java environment (Optional)

Follow the instruction of NoiseModelling for Java environment (<https://noisemodelling.readthedocs.io/en/latest/Requirements.html>), except for setting an environmental variable of `JAVA_FOR_NOISEMODELLING` (NOT `JAVA_HOME`) to the path where bin folder locates.

Restarting QGIS is required to make the installation valid.


## Tutorial

Here is a tutorial of this plugin.
In this tutorial, the sound levels and health risks in 1km2 area in Sapporo City Suburb (141.295,141.305,43.158,43.168 [EPSG:4326]) are predicted and estimated.
The results are also stored in the `geom/tutorial` directory of this repository.

For testing algorithms, use `testalgorithms` algorithm (see the next section) instead of running this tutorial.

> [!NOTE]  
> In the tutorial below, program-defined parameter names are used, which are different from the names displayed in the UI. To show the program-define names, put the mouse cursor on the input form of the parameter.


### Step 1: Fetch the geometries

With following procedures, roads, buildings, elevation points, and a raster containing population information are fetched.
If the parameters are unspecified, use the default values.

- Run the `Road centerline (OSM)` algorithm (in the `Fetch geometries` group) using following parameters. Note that `QuickOSM` plugin is needed before the execution.
  - `FETCH_EXTENT`: 141.295,141.305,43.158,43.168 [EPSG:4326]
  - `TARGET_CRS`: EPSG: 32654
  - `BUFFER`: 500.0 (m)
- Run `Building (OSM)` algorithm using following parameters:
  - `FETCH_EXTENT`: 141.295,141.305,43.158,43.168 [EPSG:4326]
  - `TARGET_CRS`: EPSG: 32654
  - `BUFFER`: 500.0
- Run the `Elevation points (SRTM)` algorithm using following parameters. Note that user id and password of Earthdata Login (https://urs.earthdata.nasa.gov/users/new) is needed before the execution.
  - `FETCH_EXTENT`: 141.295,141.305,43.158,43.168 [EPSG:4326]
  - `TARGET_CRS`: EPSG: 32654
  - `BUFFER`: 500.0
  - `USERNAME`: (registered user name)
  - `PASSWORD`: (registered password)
- Run the `Population (GHS)` algorithm using following parameters. 
  - `FETCH_EXTENT`: 141.295,141.305,43.158,43.168 [EPSG:4326]
  - `TARGET_CRS`: EPSG: 32654
  - `BUFFER`: 500.0

The fetched geometries are shown as geospatial layers on QGIS, as follows:<br />
![Fetched geometries](readme/tutorial-fetch.png)

>If you want to obtain the information on roads and buildings and set them as sound sources and obstacles without this plugin, following procedures are necessary (quite complex!). 
>   1. Execute `native:extenttolayer` using the above `FETCH_EXTENT` as `INPUT` 
>   2. Execute `native:reprojectlayer` using the output of the previous procedure as `INPUT` and the above `TARGET_CRS` as `TARGET_CRS`
>   3. Execute `native:buffer` using the output of the previous procedure as `INPUT` and the above `BUFFER` as `DISTANCE`
>   1. Execute `quickosm:downloadosmdataextentquery` using highway as `KEY` (if for buildings, building as `KEY`) and the extent of the obtained rectangle as the `EXTENT`
>   2. Execute `native:reprojectlayer` using the output of the previous procedure as `INPUT` and the above `TARGET_CRS` as `TARGET_CRS`
>   3. Execute `native:dissolve` using the output of the previous procedure as `INPUT` and the all the fields as `FIELD`
>   4. Execute `native:multiparttosingleparts` using the output of the previous procedure as `INPUT`
>   1. Add required fields to the road layer (`PK`,`LV_d`, `LV_e`, `LV_n`, `MV_d`, `MV_e`, `MV_n`, `HV_d`, `HV_e`, `HV_n`, `LV_spd_d`, `LV_spd_e`, `LV_spd_n`, `MV_spd_d`, `MV_spd_e`, `MV_spd_n`, `HV_spd_d`, `HV_spd_e`, `HV_spd_n`, `LWd63`, `LWd125`, `LWd250`, `LWd500`, `LWd1000`, `LWd2000`, `LWd4000`, `LWd8000`, `LWe63`, `LWe125`, `LWe250`, `LWe500`, `LWe1000`, `LWe2000`, `LWe4000`, `LWe8000`, `LWn63`, `LWn125`, `LWn250`, `LWn500`, `LWn1000`, `LWn2000`, `LWn4000`, `LWn8000`, `pvmt`, `temp_d`, `temp_e`, `temp_n`, `ts_stud`, `pm_stud`, `junc_dist`, `slope`, `way`)
>   2. Add required fields to the building layer (`PK`,`height`)


### Step 2: Set traffic volume

To compute sound levels, this plugin employs the traffic properties (such as traffic volume and speed) or the sound-source level can be directly specified.
In this example, set traffic volumes to the road layer, on QGIS. 

1. Open an attribute table of `Road` layer (right click on the layer and select `Open Attribute Table`)
1. Find the roads roads of which `osm_id` are `202548600` and `1128470753`. 
1. Change to the editing mode (click the pencil button at the upper left corner of the attribute table)<br />
  ![Toggle editing mode](readme/tutorial-edit-1.png)
1. Change the attributes of the roads to following figures:<br />
  ![Toggle editing mode](readme/tutorial-edit-2.png)
    - `LV_d`: 1000
    - `LV_e`: 400
    - `LV_n`: 120
    - `HGV_d`: 140
    - `HGV_e`: 20
    - `HGV_n`: 20
1. Finish the editing mode and save the changes (click the pencil button at the upper left corner of the attribute table)

Regarding the traffic volumes, please find the definition in the NoiseModelling Documentation. (`LV` and `HGV` mean Light and Heavy Vehicle; `_d`, `_e` and `_n` mean day-, evening- and night-time traffic volumes.)

### Step 3: Set populations

This step is for estimating affected population.

- Run `Estimate populations of buildings using Raster` algorithm in `Evaluate health risk` group using following parameters.
  - `BUILDING`: (buildings fetched in the previous procedure)
  - `POPULATION`: (population fetched in the previous procedure)

After you finished this step, you can find `pop` field in the attribute table of the newly created building layer, `Building with population`.
The population information plays a pivotal role in estimating health risks.

### Step 4: Set receivers (at building facade)

Setting receiver points at building facade is the first step to evaluate health risks due to environmental noise: computing sound levels and comparing them with existing epidemiological studies, probabilities of health effects such as annoyance, sleep disturbance and ischemic heart disease are estimated.

- Execute `Building facade` algorithm in `Set receiver` group using following parameters. Receiver points in front of the buildings are created using algorithms implemented in `NoiseModelling`. 
  - `BUILDING`: (buildings fetched in the previous procedure)
  - `SOURCE`: (roads fetched in the previous procedure)
  - `FENCE_EXTENT`: 141.295,141.305,43.158,43.168 [EPSG:4326]

Both `Building` and `Building with population` layers are acceptable in this processing since population information is NOT used.

The locations of the receivers are shown in the image below.
These receivers are used to estimate health risks posed by noise exposure.<br />
![receivers at building facade](/readme/tutorial-rcv-1.png)

### Step 5: Set receivers (at Delaunay grid)

Setting receiver points at Delaunay triangulation grid points is required for drawing equal-level contour lines: geospatial distribution of sound levels can be obtained using triangles and sound levels at the vertices and thus the contour lines are created.

- Execute `Delaunay grid` algorithm in `Set receiver` group using following parameters.
  - `BUILDING`: (buildings fetched in the previous procedure)
  - `SOURCE`: (roads fetched in the previous procedure)
  - `FENCE_EXTENT`: 141.295,141.305,43.158,43.168 [EPSG:4326]
  - `MAX_AREA`: 100.0

Both `Building` and `Building with population` layers are acceptable in this processing since population information is NOT used.

The locations of the receivers are shown in the image below.
The Delaunay triangular polygons, which is one of the outputs of the procedure, are also needed for creating sound-level contour.<br />
![receivers at delaunay](/readme/tutorial-rcv-2.png)

### Step 6: Calculate the sound levels

- Execute `Prediction from traffic` algorithm in `Predict sound level` group using following parameters. The sound levels are computed using algorithms implemented in `NoiseModelling`.
  - `ROAD`: (roads fetched in the previous procedure)
  - `BUILDING`: (buildings fetched in the previous procedure)
  - `RECEIVER`: (receiver points created in the previous procedure)
  - `DEM`: (elevation points fetched in the previous procedure)
  - `MAX_SRC_DIST`: 500

`Building with population` layer should be used here since health risks of each building is estimated in this process.

As 2 types of the receivers (at Delaunay triangulation and at buildings facade), 2 calculations can be carried out and 2 results are obtained.

The output layers are, `Lday` (day-time sound level), `Levening` (evening-time sound level), `Lnight` (night-time sound level), `Lden` (day-evening-night sound level), and `Building with facade level` (only when receivers at facade are employed).
Please find the definition of `Lx` (x-time sound level) in a textbook of acoustics and website (e.g. <https://en.wikipedia.org/wiki/Day%E2%80%93evening%E2%80%93night_noise_level>). 

### Step 7: Create sound-level contour (Delaunay-grid receivers)

The results of the receivers at Delaunay triangulation are used to create sound level contour.

- Execute `Isosurface` algorithm in `Predict sound level` group using following parameters. The sound-level counters are computed using algorithms implemented in `NoiseModelling`. As an example, Lden contour is created.
  - `LEVEL_RESULT`: (Lden computed in the previous procedure, using Delaunay grid)
  - `LEVEL_RID`: IDRECEIVER
  - `LEVEL_LID`: LAEQ
  - `TRIANGLES`: (delaunay triangles obtained in the previous procedure)

The following image is an example:<br />
![contour example](/readme/tutorial-contour.png)

### Step 8: Estimate health risks (building-facade receivers)

The results of the receivers at buildings facade are used to evaluate the health risks.
While the health risks for each building are already estimated in `Building with facade level`, obtained in the Step 5 (See the attribute table), the procedure to estimate the health risks is shown here:

- Assign the population to the buildings by `Estimate populations of buildings using Raster` algorithm
- Assign the sound levels to the buildings by `Assign calculated levels to buildings` algorithm (`Lden` and `Lnight` fields are required)
- Estimate the health risks by `Estimate health risks of buildings` algorithm


Note that when the sound levels are assigned to each building, reflection effects (approx 3 dB) were cancelled by subtracting this value.

The following data is an example of health risks estimation, which displays attributes of a building.
In this building of which area is 153 m2, estimated population (`pop`) was 3.4.
The maximum and minimum sound levels (`LDAY`: daytime, `LEVENING`: evening, `LNIGHT`: nighttime, `LDEN`: day-evening-night) are listed (note that the large negative values indicates sufficiently low sound levels). The relative risk of ischaemic heart disease (`relRiskIHD`) was 1.073, which means the risk of ischaemic heart disease is 7.3% higher than quiet buildings.
The probability of High Annoyance (`ProbHA`) was 17.3% and the estimated number of people highly annoyed was 0.60.
The probability of High Sleep Disturbance (`ProbHSD`) was 5.3% and the estimated number of people highly annoyed was 0.18.
These health risks were estimated using the facade sound levels, according to the Environmental Noise Guidelines in European Region (<https://www.who.int/europe/publications/i/item/9789289053563>)<br />
![health risk example](/readme/tutorial-risk.png)


### Step extra: Change color theme

Results of the sound levels are displayed in the QGIS using a color theme proposed by Weninger in 2015.
It is easy to change the color theme by using `Draw noise color` algorithm in `Predict sound level` group.
In addition, this algorithm allows you to set a customized color theme by preparing and specifying a `json` file where a color map is provided.

Here is a sample `json` code to set a customized color theme. Save it as a `json` file and specify it in the `Draw noise color` algorithm.

```json
{
  "theme_ref": "Weninger color scheme: Weninger, B. (2015). A Color Scheme for the Presentation of Sound Immission in Maps: Requirements and Principles for Design. EuroNoise 2015, Maastricht.",
  "range_map":{
    "< 35 dB":    {"lower": -999, "upper":  35, "color": [255, 255, 255]},
    "35 - 40 dB": {"lower":   35, "upper":  40, "color": [160, 186, 191]},
    "40 - 45 dB": {"lower":   40, "upper":  45, "color": [184, 214, 209]},
    "45 - 50 dB": {"lower":   45, "upper":  50, "color": [206, 228, 204]},
    "50 - 55 dB": {"lower":   50, "upper":  55, "color": [226, 242, 191]},
    "55 - 60 dB": {"lower":   55, "upper":  60, "color": [243, 198, 131]},
    "60 - 65 dB": {"lower":   60, "upper":  65, "color": [232, 126,  77]},
    "65 - 70 dB": {"lower":   65, "upper":  70, "color": [205,  70,  62]},
    "70 - 75 dB": {"lower":   70, "upper":  75, "color": [161,  26,  77]},
    "75 - 80 dB": {"lower":   75, "upper":  80, "color": [117,   8,  92]},
    "> 80 dB":    {"lower":   80, "upper": 999, "color": [ 67,  10,  74]}
  }
}
```

### Tutorial Complete

The tutorial is finished.
Noise maps displaying day, evening and night sound levels were obtained, and moreover, health risks were estimated.

Although most fields of the layers employed in this plugin are based on NoiseModelling project (https://github.com/Universite-Gustave-Eiffel/NoiseModelling) and detailed information would be obtained from this project, there are also a few fields additionally employed in this plugin to estimate health risks and/or clarify the computation procedures.
The fields are listed, as follows:

- All layers
  - `HISTORY`: the name of the algorithm, the version of the plugin (and NoiseModelling, if used), and the time of running the algorithm. 
- Buildings
  - `pop`: the population of the building
  - `relRiskIHD`: relative risk of ischemic heart disease, estimated according to the Environmental Noise Guidelines in the European Region (<https://www.who.int/europe/publications/i/item/9789289053563>)
  - `probHA`: the probability of high annoyance, estimated according to the Environmental Noise Guidelines in the European Region (<https://www.who.int/europe/publications/i/item/9789289053563>)
  - `probHSD`: the probability of high sleep disturbance, estimated according to the Environmental Noise Guidelines in the European Region (<https://www.who.int/europe/publications/i/item/9789289053563>)
  - `nHA`: the number of residents highly annoyed, estimated according to the Environmental Noise Guidelines in the European Region (<https://www.who.int/europe/publications/i/item/9789289053563>)
  - `nHSD`: the number of residents highly sleep disturbed, estimated according to the Environmental Noise Guidelines in the European Region (<https://www.who.int/europe/publications/i/item/9789289053563>)
  - only when the population is estimated using a raster
    - `meshIdx`: a serial number of the population mesh
    - `meshCode`: the name of the mesh, named using `worldmesh.py` (<https://www.fttsus.org/worldgrids/ja/top-ja/>)
    - `nBldgMesh`: the number of buildings in the mesh
    - `wgtBldg`: the weight for assigning the population of the mesh to each building. if not specified, the areas of the buildings are used.
    - `wgtBldgMesh`: sum of the `wgtBldg` in the mesh
    - `popMesh`: population of the mesh
  - only when the population is estimated using polygons
    - `pkPlg`: a serial number of the population polygon
    - `nBldgPlg`: the number of buildings in the polygon
    - `wgtBldg`: the weight for assigning the population of the polygon to each building. if not specified, the areas of the buildings are used.
    - `wgtBldgMesh`: sum of the `wgtBldg` in the polygon
    - `popPlg`: population of the polygon

### Tutorial Videos

You can also follow the following videos -

Installing the H-RISK plugin on QGIS.
- [Installing H-RISK Plugin on QGIS](https://www.youtube.com/watch?v=IoDwDXulqVc)

There are two more videos explaining Noise Maps creation using QGIS with H-RISK plugin utilizing NoiseModelling. The videos use Geneva and Tokyo Regions.
- [Geneva Noise Mapping in QGIS with H-RISK & Noise Modelling](https://www.youtube.com/watch?v=ibxcbnt9H-Q)
- [Tokyo Noise Mapping in QGIS with H-RISK & Noise Modelling](https://www.youtube.com/watch?v=9jbXvAqdPRI)

## Test algorithms

Successful operation of the algorithms is verified by the `testalgorithms` algorithm, in the `Configurations` group.
Several test cases encompassing the implemented algorithms are prepared and the outputs of the algorithms are confirmed through these cases.

For each output of the test case, coincidence of the hash value is confirmed.
`Hash check PASSED` is displayed if the hash value was the same as the expected one; `Hash check FAILED` is displayed if it was not.
However, it should be noted that algorithms for fetching geometries may throw `Hash check FAILED` even though they are working fine. 
Since these algorithms fetch data from remote servers, the outputs may not be an exact match (e.g. the order of the geometries may be different).
It is important to confirm that all algorithms except for fetching algorithms pass the tests.

By default, only the confirmation of the hash values is done.
Output layers are added in the project, if you directed to output them.

The descriptions of the test cases are shown in the following sections.
Note that all the parameters are specified in `algconfig/test-scenarios.json` and geometries stored in `geom/test` are used for the computation, if required.


Note that running many algorithms may cause a crash of QGIS. If you encounter this problem, try to run the algorithms one by one.

### Initialize geometries

Test for initializing layers (which have required fields) for computing sound levels. 

Output layers are:

- `Road`: Roads with required fields (no geometries)
- `Building`: Buildings layer with required fields (no geometries)
- `Elevation points`: Elevation points with required fields (no geometries)
- `Ground absorption`: Ground-absorption polygons with required fields (no geometries)
- `Source`: Sound sources with required fields (no geometries)
- `Receiver`: Receivers with required fields (no geometries)
- `Road`: Roads, of which sound power levels (LWs) are computed using traffic properties
- `Elevation points`: Elevation points, which was created along a line 

### Merge geometries

Test for merging layers. For example, two building layers are merged as one, with required fields and a consistent primary key field.

Output layers are:

- `Road`: Roads, which was created by merging 2 roads layers
- `Building`: Buildings, which was created by merging 2 buildings layers
- `Elevation points`: Elevation-points, which was created by merging 2 elevation-points layers


### Fetch geometries

Test for fetching geometries from Japanese databases. As noted above, hash test may fail even though there are no problems in the procedure. Check whether appropriate geometries are found in the outputs.

Note that it does not include the fetch algorithm using SRTM database (`hrisk:fetchdemrastersrtm`) since it requires private user name and password.

Output layers are:

- `Road`: retrieved from the OpenStreetMap
- `Building`: retrieved from the OpenStreetMap
- `Population`: retrieved from the Global Human Settlement database

### Assign population to buildings

Test for assigning population to buildings.

Output layers are:

- `Building with population`: buildings, where the population is assigned to each building using a population raster
- `Building with population`: buildings, where the population is assigned to each building using population polygons


### Set receivers

Test for setting receivers.
Several layers are created using algorithms implemented in NoiseModelling.

Output layers are:

- `Receivers at facade`: Receivers at buildings facade, created by NoiseModelling
- `Receivers of Delaunay`: Receivers at Delaunay triangle grid, created by NoiseModelling
- `Triangles of Delaunay`: Polygons of Delaunay triangulation, created by NoiseModelling
- `Receivers at regular grid`: Receivers at regular grid, created by NoiseModelling
- `Receivers of crosssection`: Receivers on a vertical crosssection

### Compute SPL at building facade and estimate health risks

Test for computing sound levels and estimating health risks at each building.
Acoustic characteristics of the sound sources are computed using traffic properties.
An algorithm in NoiseModelling is used.

Output layers are:

- `Lday`: Day-time sound level
- `Levening`: Evening-time sound level
- `Lnight`: Night-time sound level
- `Lden`: Day-evening-night sound level
- `Building with facade level`: Buildings with facade sound levels and health risks

### Compute SPL at Delaunay grid using emission level

Test for computing sound levels at each Delaunay grid point.
Acoustic characteristics of the sound sources are directly specified in the input features.
An algorithm in NoiseModelling is used.

Output layers are:

- `Lday`: Day-time sound level
- `Levening`: Evening-time sound level
- `Lnight`: Night-time sound level
- `Lden`: Day-evening-night sound level

### Create contour lines

Test for creating contour lines.
An algorithm in NoiseModelling is used.

Output layer is:

- `Isosurface`: Sound-level contour lines

## Implemented algorithms

### Fetch geometries

The user can fetch geometries of roads and buildings using algorithms in `Fetch geometries` group.

Implemented algorithms are:

- `Fetch geometries` group
  - Road centerline (OSM) (`fetchroadosm.py`): fetch road geometries from OpenStreetMap. `QuickOSM` is needed.
  - Building (OSM) (`fetchbuildingosm.py`): fetch building geometries from OpenStreetMap. `QuickOSM` is needed.
  - Elevation points (SRTM) (`fetchdemrastersrtm.py`): fetch elevation-points geometries from Shuttle Radar Topography Mission dataset. User id and password of Earthdata Login (https://urs.earthdata.nasa.gov/users/new) is needed.
  - Population (GHS) (`fetchpopghs.py`): fetch 100m-mesh population from Global Human Settlement dataset (https://ghsl.jrc.ec.europa.eu/). 


Note that `QuickOSM` plugin (https://docs.3liz.org/QuickOSM/) is needed to fetch geometries from OpenStreetMap.
To fetch geometries from Shuttle Radar Topography Mission, user id and password of Earthdata Login (https://urs.earthdata.nasa.gov/users/new) is needed.

### Initialize geometries

The following algorithms that initialize geometries (set required fields) are in `Initialize features` group.

Algorithms in `Initialize features` group are:

- Road with acoustic information (`initroad.py`): initialize linestrings as roads
- Arbitrary sound source with acoustic information (`initsource.py`): initialize points as sound sources
- Road emission calculated from traffic (`initroademissionfromtraffic.py`): calculate the emission level (sound power level) using the traffic volume
- Building (`initbuilding.py`): initialize polygons as buildings
- Elevation point (`initelevationpoint.py`): initialize points as elevation points
- ~~Elevation point (`heightsalonglines.py`): initialize points using line geometries (points along the lines)~~ (Obsolete from v. 0.3.0)
- Ground absorption (`initgroundabsorption.py`): initialize polygons as ground absorption
- Receivers (`initreceiver.py`): initialize points as receivers

### Merge geometries

- Merge roads (`mergeroad.py`): merge multiple road geometries
- Merge buildings (`mergebuildings.py`): merge multiple building geometries
- Merge elevation points (`mergeelevationpoints.py`): merge multiple elevation points geometries


### Set receiver points

To set receiver points, algorithms in `Set receivers` group are available.
They execute `NoiseModelling` algorithms and set receiver points such as at building facades and at Delaunay grid points.


Algorithms in `Set receiver` group are:

- At building facade (`receiverfacade.py`): create receivers at building facades
- Delaunay grid (`receiverdelaunaygrid.py`): create receivers at Delaunay grid points and triangles
- Regular grid (`receiverregulargrid.py`): create receivers at regular grid points
- On crosssections (`receivercrosssection.py`): create receivers at crosssection lines, with different heights

### Calculate sound levels

Sound levels at the receiver points can be calculated using algorithms in `Predict sound level` group, which employ `NoiseModelling`.

Algorithms in `Predict sound level` group are:

- Prediction from traffic (`noisefromtraffic.py`): calculate the sound levels from traffic volume
- Prediction from emission (`noisefromemission.py`): calculate the sound levels from the sound power level
- Isosurface (`isosurface.py`): create isosurface lines from the calculated sound levels and Delaunay triangles

### Estimate health risks

The user can assign the number of residents of each building and estimate health risks posed by the noise, using algorithms in `Evaluate health risk` group.

Algorithms in `Evaluate health risk` group are:

- Estimate populations of buildings using Raster (`estimatepopulationofbuilding.py`): estimate the number of residents for each building using a raster representing the population
- Estimate populations of buildings using Polygon (`estimatepopulationofbuildingplg.py`): estimate the number of residents for each building using polygons representing the population
- Assign calculated levels to buildings (`estimatelevelofbuilding.py`): estimate the sound level for each building
- Estimate health risks of buildings (`estimateriskofbuilding.py`): estimate the health risks for each building
- Summarize the health risks estimation (`summarizerisk.py`): summarize the estimated risks using 5dB-step exposure levels

### Others

- Draw noise color (`drawnoisecolor.py`): draw noise color using prepared color themes or a custom `json` file

## How to uninstall

Uninstall this plugin on QGIS using Plugin Manager.
And moreover, delete the files and folders in `JAVA_FOR_NOISEMODELLING` and `NOISEMODELLING_HOME` paths and delete the environmental variables.

## Contributing

Any contributions are welcomed. Please see [CONTRIBUTIONS.md](CONTRIBUTIONS.md) for the details.

## License

This plug-in complies with the GPL v3 license. Please see the LICENSE file for details.

License of the external program used by this plug-in:

- NoiseModelling: GPL v3
- OpenJDK: GPL v2 (Classpath Exception)
- worldmesh (`https://www.fttsus.org/worldgrids/`) 


Note: The `worldmesh` library, which is provided by the World Mesh Institute, is a product of JST PRESTO "Research on Infrastructure for Sustainability Assessment of Global Systems" (JPMJPR1504) and JST Future Society Creation Project "Design and Demonstration of Autonomous Distributed World Mesh Statistical Infrastructure Architecture" (JPMJMI20B6). 