---
title: 'H-RISK with NoiseModelling: a QGIS plugin to predict environmental noise and estimate health risks'
tags:
  - QGIS
  - Python
  - Java
  - environmental noise
  - health risk
authors:
  - name: Junta Tagusari
    orcid: 0000-0002-3321-4473
    equal-contrib: true
    affiliation: "1" # (Multiple affiliations must be quoted)
affiliations:
 - name: Faculty of Engineering, Hokkaido University, Japan
   index: 1
date: 9 Jan 2024
bibliography: paper.bib

---

# Summary

Exposure to environmental noise can have significant health effects, including environmental sleep disorders, hypertension, ischemic heart disease, and stroke.
Accurately predicting sound levels and estimating health risks is critical to studying the exposure-response relationships and formulating effective policies at the local community level. 
However, such predictions typically require specialized knowledge, expensive commercial software, and extensive computational resources.
To address this issue, the author has developed a solution that integrates publicly available vector tile maps, open source environmental noise modeling modules called "NoiseModelling", and user interfaces implemented in QGIS through a dedicated QGIS plugin.
This plugin allows for direct execution of the calculation modules implemented in NoiseModelling, ensuring compatibility with future updates to NoiseModelling.
Users can easily access and manipulate geographic features, define receiver points, predict sound levels, and estimate health risks for any desired area using the plugin.
For a relatively small computational domain, such as 1 km2, the volume of calculations is manageable and can be performed on a local computer.
This plugin is invaluable for conducting epidemiological research on the health effects of environmental noise and for noise policy planning.
It facilitates the maintenance of a quiet environment, helps to mitigate noise problems, and aids in estimating the noise generated by new sources.

# Statement of need

The significance of addressing health risks associated with environmental noise cannot be overstated. 
Nighttime noise exposure can disturb sleep, disrupt homeostasis by altering blood flow, and serve as a risk factor for serious outcomes, including cardiovascular and metabolic diseases. 
For instance, recent studies have estimated that road traffic noise, the most prevalent source, contributes to approximately 10,000 deaths in Europe [@eea:2020] and 2,000 deaths in Japan [@tagusari:2021] due to ischemic heart disease.

To investigate the relationship between environmental noise and health effects, and to develop effective noise mitigation policies at the local community level, accurate prediction of sound levels is critical. 
In Europe, sound level prediction is mandated by the European Union Directive (2002/49/EC), which requires the use of a noise propagation model called CNOSSOS-EU [@kephalopoulos:2012].
However, achieving accurate predictions often requires specialized knowledge, expensive commercial software, and significant computational resources due to the extensive information required, such as sound source and obstacle geometries, traffic volumes, travel speeds, atmospheric conditions, and computational configurations.

To address these challenges, an open-source module called "NoiseModelling" [@bocher:2019] has been developed.
It allows transparent calculations and customization by the public differentiating it from existing commercial software [@meller:2023].
To the best of my knowledge, it stands as the sole open-source project facilitating the prediction of sound levels using the CNOSSOS-EU model, with no other projects successfully implementing similar modern noise prediction models that appropriately predicts the effects of physical phenomena such as reflection, diffraction, and refraction.
Nevertheless, even with this progress, preparing the necessary information and extracting results for further analysis still requires additional software.

To overcome these limitations, the author has developed a solution that integrates NoiseModelling into QGIS (The Open Source Geospatial Foundation, Oregon) through a dedicated QGIS plugin called "H-RISK with NoiseModelling". 
This marks the first attempt to incorporate the functionality of NoiseModelling in GIS software and, more broadly, the initial endeavor to integrate environmental noise predictions within GIS software.
Beyond merely incorporating the capabilities of NoiseModelling, this plugin streamlines the retrieval and manipulation of geospatial features, the initialization of input data for NoiseModelling, and the estimation of health risks and affected populations using established exposure-response relationships [@whoeu:2018]. 
As a result, users can easily access and manipulate geographic features, define receiver points, predict sound levels, and estimate health risks for any desired area, including the impact of new sound sources.

# Functionality

The plugin has three main functionalities: (1) acquisition of the geospatial data, (2) calculation of sound levels using the modules of NoiseModelling, and (3) estimation of health risks and affected population.

## Acquisition of the geospatial data

Calculating road traffic noise requires geospatial data on roads, buildings and terrain.
This plugin facilitates the retrieval of geospatial data from various sources, including OpenStreetMap (OpenStreetMap Foundation, Cambridge), the Shuttle Rader Topography Mission (National Aeronautics and Space Admission, Washington, D.C.) and the vector-tile map of Japan (Geospatial Information Authority of Japan, Tokyo).

Additionally, geospatial data on the population is needed to estimate the affected population.
The plugin can retrieve 100-meter-meshed global population data from the Global Human Settlement Layer (European Commission), and 250-meter-meshed local population data for Japan (Ministry of Internal Affairs and Communications of Japan).

The plugin automatically adds the attributes needed to calculate sound levels and ensures a seamless transition to the subsequent calculation process.

## Calculation of the sound levels

The creation of receivers and calculation of the sound levels are carried out using the NoiseModelling modules.
Receivers are placed at Delaunay grid points to generate sound-level contours and at building facades to estimate health risks.
Receivers can also be placed on a vertical plane, which illustrates vertical attenuation of the sound level.

The sound levels at the receivers are computed based on the traffic volumes or the power levels of sound sources, where the fetched geometries are employed and there are a lot of parameters for the prediction, such as the maximum number of the reflections.
The predicted results are also displayed using equal-level contours.

To run the Java-based modules, the plugin requires a Java implementation as well as NoiseModelling.


## Estimation of health risks and affected population

By integrating geospatial information on population, buildings, receivers and sound levels, the plugin allows estimation of health risks and affected population for each building.
The estimation method meets the requirements of CNOSSOS-EU, employing exposure-response relationships presented by the World Health Organization Regional Office for Europe [@whoeu:2018].
Presenting health risks instead of sound levels is essential for effective risk communication [@selamat:2021].

# References