from qgis.PyQt.QtCore import QCoreApplication, QTranslator, QSettings
from qgis.core import Qgis, QgsApplication
import os
from .hrisk_provider import hrisk_provider


class hrisk_plugin(object):
	def __init__(self, iface):
		self.iface = iface
		self.searchDialog = None

		# Initialize the plugin path directory
		self.plugin_dir = os.path.dirname(__file__)

		# initialize locale
		try:
			locale = QSettings().value("locale/userLocale", "en", type=str)[0:2]
		except Exception as e:
			self.iface.messageBar().pushMessage(str(e), "Error in setting the locale. English (en) will be used.", level=Qgis.Info)
			locale = "en"

		try:
			locale_path = os.path.join(self.plugin_dir, "i18n", f"hrisk_{locale}.qm")
			self.translator = QTranslator()
			self.translator.load(locale_path)
			QCoreApplication.installTranslator(self.translator)
		except Exception:
			self.iface.messageBar().pushMessage(str(e), "Translation file was not found at " + locale_path + ". Messages will not be translated.", level=Qgis.Info)
   
		self.checkEnv()

	def checkEnv(self) -> None:   
		# try to get environment variables
		try:
			_ = os.environ["NOISEMODELLING_HOME"]
			_ = os.environ["JAVA_FOR_NOISEMODELLING"]
		except:
			self.iface.messageBar().pushMessage(
				"[H-RISK] Environment variables are not set. Set NOISEMODELLING_HOME and JAVA_FOR_NOISEMODELLING.", level=Qgis.Info
			)
  
	def initGui(self):
		self.initProcessing()
  
	def initProcessing(self):
		self.provider = hrisk_provider()
		QgsApplication.processingRegistry().addProvider(self.provider)

	def unload(self):
		QgsApplication.processingRegistry().removeProvider(self.provider)
